/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Macro;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class MacroFactory {
    private static final MultiMap<String, Macro> myMacroTable = MacroFactory.init();

    public static Macro createMacro(@NonNls String name) {
        return ContainerUtil.getFirstItem(myMacroTable.get(name));
    }

    public static List<Macro> getMacros(@NonNls String name) {
        return (List)myMacroTable.get(name);
    }

    public static Macro[] getMacros() {
        Collection<Macro> values = myMacroTable.values();
        return values.toArray(new Macro[0]);
    }

    private static MultiMap<String, Macro> init() {
        MultiMap<String, Macro> result2 = MultiMap.create();
        for (Macro macro : Macro.EP_NAME.getExtensionList()) {
            result2.putValue(macro.getName(), macro);
        }
        Macro.EP_NAME.addExtensionPointListener(new ExtensionPointListener<Macro>(){

            @Override
            public void extensionAdded(@NotNull Macro extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                myMacroTable.putValue(extension2.getName(), extension2);
            }

            @Override
            public void extensionRemoved(@NotNull Macro extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                myMacroTable.remove(extension2.getName(), extension2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/template/macro/MacroFactory$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, ApplicationManager.getApplication());
        return result2;
    }
}

