/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.BundleBase;
import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemsHolder {
    private static final Logger LOG = Logger.getInstance(ProblemsHolder.class);
    private final InspectionManager myManager;
    private final PsiFile myFile;
    private final boolean myOnTheFly;
    private final List<ProblemDescriptor> myProblems;

    public ProblemsHolder(@NotNull InspectionManager manager, @NotNull PsiFile file2, boolean onTheFly) {
        if (manager == null) {
            ProblemsHolder.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ProblemsHolder.$$$reportNull$$$0(1);
        }
        this.myProblems = new ArrayList<ProblemDescriptor>();
        this.myManager = manager;
        this.myFile = file2;
        this.myOnTheFly = onTheFly;
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull @InspectionMessage String descriptionTemplate, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            ProblemsHolder.$$$reportNull$$$0(2);
        }
        if (descriptionTemplate == null) {
            ProblemsHolder.$$$reportNull$$$0(3);
        }
        this.registerProblem(psiElement, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull @InspectionMessage String descriptionTemplate, @NotNull ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            ProblemsHolder.$$$reportNull$$$0(4);
        }
        if (descriptionTemplate == null) {
            ProblemsHolder.$$$reportNull$$$0(5);
        }
        if (highlightType == null) {
            ProblemsHolder.$$$reportNull$$$0(6);
        }
        this.registerProblem(this.myManager.createProblemDescriptor(psiElement, descriptionTemplate, this.myOnTheFly, fixes, highlightType));
    }

    public void registerProblem(@NotNull ProblemDescriptor problemDescriptor) {
        PsiElement newTarget;
        ExternallyDefinedPsiElement external;
        PsiElement element;
        if (problemDescriptor == null) {
            ProblemsHolder.$$$reportNull$$$0(7);
        }
        if ((element = problemDescriptor.getPsiElement()) != null && !this.isInPsiFile(element) && (external = PsiTreeUtil.getParentOfType(element, ExternallyDefinedPsiElement.class, false)) != null && (newTarget = external.getProblemTarget()) != null) {
            this.redirectProblem(problemDescriptor, newTarget);
            return;
        }
        this.myProblems.add(problemDescriptor);
    }

    private boolean isInPsiFile(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            ProblemsHolder.$$$reportNull$$$0(8);
        }
        return (file2 = element.getContainingFile()) != null && this.myFile.getViewProvider() == file2.getViewProvider();
    }

    private void redirectProblem(@NotNull ProblemDescriptor problem, @NotNull PsiElement target) {
        if (problem == null) {
            ProblemsHolder.$$$reportNull$$$0(9);
        }
        if (target == null) {
            ProblemsHolder.$$$reportNull$$$0(10);
        }
        PsiElement original = problem.getPsiElement();
        VirtualFile vFile = original.getContainingFile().getVirtualFile();
        assert (vFile != null);
        String path = FileUtil.toSystemIndependentName(vFile.getPath());
        String description = XmlStringUtil.stripHtml(problem.getDescriptionTemplate());
        String template = AnalysisBundle.message("inspection.redirect.template", description, path, original.getTextRange().getStartOffset(), vFile.getName());
        InspectionManager manager = InspectionManager.getInstance(original.getProject());
        ProblemDescriptor newProblem = manager.createProblemDescriptor(target, template, (LocalQuickFix)null, problem.getHighlightType(), this.isOnTheFly());
        this.registerProblem(newProblem);
    }

    public void registerProblem(@NotNull PsiReference reference, @InspectionMessage String descriptionTemplate, ProblemHighlightType highlightType) {
        if (reference == null) {
            ProblemsHolder.$$$reportNull$$$0(11);
        }
        LocalQuickFix[] fixes = null;
        if (reference instanceof LocalQuickFixProvider) {
            fixes = ((LocalQuickFixProvider)((Object)reference)).getQuickFixes();
        }
        this.registerProblemForReference(reference, highlightType, descriptionTemplate, fixes);
    }

    public void registerProblemForReference(@NotNull PsiReference reference, @NotNull ProblemHighlightType highlightType, @NotNull @InspectionMessage String descriptionTemplate, LocalQuickFix ... fixes) {
        if (reference == null) {
            ProblemsHolder.$$$reportNull$$$0(12);
        }
        if (highlightType == null) {
            ProblemsHolder.$$$reportNull$$$0(13);
        }
        if (descriptionTemplate == null) {
            ProblemsHolder.$$$reportNull$$$0(14);
        }
        ProblemDescriptor descriptor = this.myManager.createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), descriptionTemplate, highlightType, this.myOnTheFly, fixes);
        this.registerProblem(descriptor);
    }

    public void registerProblem(@NotNull PsiReference reference) {
        if (reference == null) {
            ProblemsHolder.$$$reportNull$$$0(15);
        }
        this.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage(reference), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    public void registerProblem(@NotNull PsiReference reference, @NotNull ProblemHighlightType highlightType) {
        if (reference == null) {
            ProblemsHolder.$$$reportNull$$$0(16);
        }
        if (highlightType == null) {
            ProblemsHolder.$$$reportNull$$$0(17);
        }
        this.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage(reference), highlightType);
    }

    public void registerPossibleProblem(PsiElement identifier) {
        this.registerProblem(identifier, "possible problem", ProblemHighlightType.POSSIBLE_PROBLEM, new LocalQuickFix[0]);
    }

    @NotNull
    @InspectionMessage
    public static String unresolvedReferenceMessage(@NotNull PsiReference reference) {
        String message2;
        if (reference == null) {
            ProblemsHolder.$$$reportNull$$$0(18);
        }
        if (reference instanceof EmptyResolveMessageProvider) {
            String pattern = ((EmptyResolveMessageProvider)((Object)reference)).getUnresolvedMessagePattern();
            try {
                message2 = BundleBase.format(pattern, reference.getCanonicalText());
            }
            catch (IllegalArgumentException ex) {
                message2 = pattern;
                LOG.info(pattern);
            }
        } else {
            message2 = AnalysisBundle.message("error.cannot.resolve.default.message", reference.getCanonicalText());
        }
        String string2 = message2;
        if (string2 == null) {
            ProblemsHolder.$$$reportNull$$$0(19);
        }
        return string2;
    }

    public void registerProblem(@NotNull PsiElement psiElement, @Nullable TextRange rangeInElement, @NotNull @InspectionMessage String descriptionTemplate, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            ProblemsHolder.$$$reportNull$$$0(20);
        }
        if (descriptionTemplate == null) {
            ProblemsHolder.$$$reportNull$$$0(21);
        }
        this.registerProblem(psiElement, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, rangeInElement, fixes);
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull @InspectionMessage String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @Nullable TextRange rangeInElement, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            ProblemsHolder.$$$reportNull$$$0(22);
        }
        if (descriptionTemplate == null) {
            ProblemsHolder.$$$reportNull$$$0(23);
        }
        if (highlightType == null) {
            ProblemsHolder.$$$reportNull$$$0(24);
        }
        this.registerProblem(this.myManager.createProblemDescriptor(psiElement, rangeInElement, descriptionTemplate, highlightType, this.myOnTheFly, fixes));
    }

    @NotNull
    public List<ProblemDescriptor> getResults() {
        List<ProblemDescriptor> list = this.myProblems;
        if (list == null) {
            ProblemsHolder.$$$reportNull$$$0(25);
        }
        return list;
    }

    public ProblemDescriptor @NotNull [] getResultsArray() {
        List<ProblemDescriptor> problems = this.getResults();
        ProblemDescriptor[] problemDescriptorArray = problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
        if (problemDescriptorArray == null) {
            ProblemsHolder.$$$reportNull$$$0(26);
        }
        return problemDescriptorArray;
    }

    @NotNull
    public final InspectionManager getManager() {
        InspectionManager inspectionManager = this.myManager;
        if (inspectionManager == null) {
            ProblemsHolder.$$$reportNull$$$0(27);
        }
        return inspectionManager;
    }

    public boolean hasResults() {
        return !this.myProblems.isEmpty();
    }

    public int getResultCount() {
        return this.myProblems.size();
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            ProblemsHolder.$$$reportNull$$$0(28);
        }
        return psiFile;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            ProblemsHolder.$$$reportNull$$$0(29);
        }
        return project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: 
            case 5: 
            case 14: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionTemplate";
                break;
            }
            case 6: 
            case 13: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemsHolder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "unresolvedReferenceMessage";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsArray";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "registerProblem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInPsiFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "redirectProblem";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerProblemForReference";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unresolvedReferenceMessage";
                break;
            }
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

