/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.interpreter;

import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.lang.ir.Instruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class StateQueue {
    private static final int FORCE_MERGE_THRESHOLD = 100;
    private boolean myWasForciblyMerged;
    private final PriorityQueue<DfaInstructionState> myQueue = new PriorityQueue();
    private final Map<DfaInstructionState, DfaInstructionState> myMap = new HashMap<DfaInstructionState, DfaInstructionState>();

    public void offer(DfaInstructionState state) {
        DfaInstructionState otherState = this.myMap.putIfAbsent(state, state);
        if (otherState == null) {
            this.myQueue.offer(state);
        } else {
            otherState.getMemoryState().afterMerge(state.getMemoryState());
        }
    }

    public boolean isEmpty() {
        return this.myQueue.isEmpty();
    }

    public boolean processAll(@NotNull Processor<? super DfaInstructionState> processor) {
        if (processor == null) {
            StateQueue.$$$reportNull$$$0(0);
        }
        for (DfaInstructionState state : this.myQueue) {
            if (processor.process(state)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<DfaInstructionState> getNextInstructionStates(Set<Instruction> joinInstructions) {
        DfaInstructionState state = (DfaInstructionState)this.myQueue.remove();
        Instruction instruction = state.getInstruction();
        this.myMap.remove(state);
        DfaInstructionState next = this.myQueue.peek();
        if (next == null || next.compareTo(state) != 0) {
            List<DfaInstructionState> list = Collections.singletonList(state);
            if (list == null) {
                StateQueue.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<DfaMemoryState> memoryStates = new ArrayList<DfaMemoryState>();
        memoryStates.add(state.getMemoryState());
        while (!this.myQueue.isEmpty() && this.myQueue.peek().compareTo(state) == 0) {
            DfaInstructionState anotherInstructionState = this.myQueue.poll();
            this.myMap.remove(anotherInstructionState);
            memoryStates.add(anotherInstructionState.getMemoryState());
        }
        if ((memoryStates = this.forceMerge(memoryStates)).size() > 1 && joinInstructions.contains(instruction)) {
            StateQueue.squash(memoryStates);
        }
        List<DfaInstructionState> list = ContainerUtil.map(memoryStates, state1 -> new DfaInstructionState(instruction, (DfaMemoryState)state1));
        if (list == null) {
            StateQueue.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<DfaMemoryState> squash(List<DfaMemoryState> states) {
        block0: for (int i = 1; i < states.size(); ++i) {
            DfaMemoryState left = states.get(i);
            if (left == null) continue;
            for (int j = 0; j < i; ++j) {
                ProgressManager.checkCanceled();
                DfaMemoryState right = states.get(j);
                if (right == null) continue;
                DfaMemoryState result2 = left.tryJoinExactly(right);
                if (result2 == left) {
                    states.set(j, null);
                    continue;
                }
                if (result2 == right) {
                    states.set(i, null);
                    continue block0;
                }
                if (result2 == null) continue;
                states.set(i, null);
                states.set(j, null);
                states.add(result2);
                continue block0;
            }
        }
        states.removeIf(Objects::isNull);
        List<DfaMemoryState> list = states;
        if (list == null) {
            StateQueue.$$$reportNull$$$0(3);
        }
        return list;
    }

    private List<DfaMemoryState> forceMerge(List<DfaMemoryState> states) {
        if (states.size() < 100) {
            return states;
        }
        this.myWasForciblyMerged = true;
        Collection groups = StreamEx.of(states).groupingBy(DfaMemoryState::getMergeabilityKey).values();
        return (List)((StreamEx)StreamEx.of(groups).flatMap(group -> StreamEx.ofSubLists((List)group, (int)2).map(pair -> {
            if (pair.size() == 2) {
                ((DfaMemoryState)pair.get(0)).merge((DfaMemoryState)pair.get(1));
            }
            return (DfaMemoryState)pair.get(0);
        })).distinct()).toListAndThen(StateQueue::squash);
    }

    public boolean wasForciblyMerged() {
        return this.myWasForciblyMerged;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/interpreter/StateQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/interpreter/StateQueue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextInstructionStates";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "squash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

