/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XSLTReportConverter
implements InspectionsReportConverter {
    private final String myXSLTSchemePath;

    public XSLTReportConverter(@NotNull String xsltSchemePath) {
        if (xsltSchemePath == null) {
            XSLTReportConverter.$$$reportNull$$$0(0);
        }
        this.myXSLTSchemePath = xsltSchemePath;
    }

    @Override
    public String getFormatName() {
        return "xslt";
    }

    @Override
    public boolean useTmpDirForRawData() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void convert(@NotNull String rawDataDirectoryPath, @Nullable String outputPath, @NotNull Map<String, Tools> tools, @NotNull List<? extends File> inspectionsResults) throws InspectionsReportConverter.ConversionException {
        FileWriter w;
        Transformer transformer;
        if (rawDataDirectoryPath == null) {
            XSLTReportConverter.$$$reportNull$$$0(1);
        }
        if (tools == null) {
            XSLTReportConverter.$$$reportNull$$$0(2);
        }
        if (inspectionsResults == null) {
            XSLTReportConverter.$$$reportNull$$$0(3);
        }
        if (outputPath == null) {
            throw new InspectionsReportConverter.ConversionException("Output path isn't specified.");
        }
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        try {
            File xsltSchemeFile = new File(this.myXSLTSchemePath);
            if (!xsltSchemeFile.exists()) {
                throw new InspectionsReportConverter.ConversionException("Cannot find XSLT scheme: " + this.myXSLTSchemePath);
            }
            StreamSource xslSource = new StreamSource(xsltSchemeFile);
            transformer = transformerFactory.newTransformer(xslSource);
        }
        catch (TransformerConfigurationException e) {
            throw new InspectionsReportConverter.ConversionException("Fail to load XSLT scheme.");
        }
        File outputFile = new File(outputPath);
        try {
            w = new FileWriter(outputFile);
        }
        catch (IOException e) {
            throw new InspectionsReportConverter.ConversionException("Cannot edit file: " + outputFile.getPath());
        }
        try {
            for (File file2 : inspectionsResults) {
                if (file2.isDirectory()) {
                    this.warn("Folder isn't expected here: " + file2.getName());
                    continue;
                }
                String fileNameWithoutExt = FileUtilRt.getNameWithoutExtension(file2.getName());
                if (".descriptions".equals(fileNameWithoutExt) || fileNameWithoutExt.endsWith("_aggregate")) continue;
                try {
                    transformer.transform(new StreamSource(file2), new StreamResult(w));
                }
                catch (TransformerException e) {
                    throw new InspectionsReportConverter.ConversionException("Cannot apply XSL transformation: " + e.getMessage());
                    return;
                }
            }
        }
        finally {
            try {
                ((Writer)w).close();
            }
            catch (IOException e) {
                this.warn("Cannot save inspection results: " + e.getMessage());
            }
        }
    }

    private void warn(@NotNull String msg) {
        if (msg == null) {
            XSLTReportConverter.$$$reportNull$$$0(4);
        }
        System.err.println(msg);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xsltSchemePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawDataDirectoryPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ex/XSLTReportConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "convert";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "warn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

