/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindInProjectSettingsBase
implements PersistentStateComponent<FindInProjectSettingsBase> {
    private static final int MAX_RECENT_SIZE = 30;
    @XCollection(style=XCollection.Style.v2, elementName="find", valueAttributeName="")
    private final List<String> findStrings = new ArrayList<String>();
    @XCollection(style=XCollection.Style.v2, elementName="replace", valueAttributeName="")
    private final List<String> replaceStrings = new ArrayList<String>();
    @XCollection(style=XCollection.Style.v2, elementName="dir", valueAttributeName="")
    private final List<String> dirStrings = new ArrayList<String>();

    @Override
    public final void loadState(@NotNull FindInProjectSettingsBase state) {
        if (state == null) {
            FindInProjectSettingsBase.$$$reportNull$$$0(0);
        }
        XmlSerializerUtil.copyBean(state, this);
    }

    @Override
    public final void initializeComponent() {
        LinkedHashSet<String> tmp = new LinkedHashSet<String>(this.findStrings);
        this.findStrings.clear();
        this.findStrings.addAll(tmp);
        tmp.clear();
        tmp.addAll(this.replaceStrings);
        this.replaceStrings.clear();
        this.replaceStrings.addAll(tmp);
        tmp.clear();
        tmp.addAll(this.dirStrings);
        this.dirStrings.clear();
        this.dirStrings.addAll(tmp);
    }

    @Override
    public FindInProjectSettingsBase getState() {
        return this;
    }

    public void addDirectory(@NotNull @NlsSafe String s) {
        if (s == null) {
            FindInProjectSettingsBase.$$$reportNull$$$0(1);
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.dirStrings);
    }

    @NotNull
    public List<String> getRecentDirectories() {
        return new ArrayList<String>(this.dirStrings);
    }

    public void addStringToFind(@NotNull @NlsSafe String s) {
        if (s == null) {
            FindInProjectSettingsBase.$$$reportNull$$$0(2);
        }
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.findStrings);
    }

    public void addStringToReplace(@NotNull @NlsSafe String s) {
        if (s == null) {
            FindInProjectSettingsBase.$$$reportNull$$$0(3);
        }
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.replaceStrings);
    }

    public @NlsSafe String @NotNull [] getRecentFindStrings() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.findStrings);
        if (stringArray == null) {
            FindInProjectSettingsBase.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    public @NlsSafe String @NotNull [] getRecentReplaceStrings() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.replaceStrings);
        if (stringArray == null) {
            FindInProjectSettingsBase.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    static void addRecentStringToList(@Nullable @NlsSafe String str, @NotNull List<? super String> list) {
        if (list == null) {
            FindInProjectSettingsBase.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmptyOrSpaces(str)) {
            return;
        }
        list.remove(str);
        list.add(str);
        while (list.size() > 30) {
            list.remove(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindInProjectSettingsBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindInProjectSettingsBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentFindStrings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentReplaceStrings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addStringToFind";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addStringToReplace";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addRecentStringToList";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class FindInProjectPathMacroFilter
    extends PathMacroFilter {
        FindInProjectPathMacroFilter() {
        }

        public boolean skipPathMacros(@NotNull Element element) {
            String tag;
            if (element == null) {
                FindInProjectPathMacroFilter.$$$reportNull$$$0(0);
            }
            if ((tag = element.getName()).equals("findStrings") || tag.equals("replaceStrings")) {
                String component = FileStorageCoreUtil.findComponentName(element);
                return component != null && (component.equals("FindSettings") || component.equals("FindInProjectRecents"));
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/impl/FindInProjectSettingsBase$FindInProjectPathMacroFilter", "skipPathMacros"));
        }
    }
}

