/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.EventWatcher;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class FlushQueue {
    private static final Logger LOG = Logger.getInstance(FlushQueue.class);
    private final Object LOCK = ObjectUtils.sentinel("FlushQueue");
    private List<RunnableInfo> mySkippedItems = new ArrayList<RunnableInfo>();
    private final Deque<RunnableInfo> myQueue = new ArrayDeque<RunnableInfo>();
    private boolean FLUSHER_SCHEDULED;
    private final Runnable FLUSH_NOW = this::flushNow;

    FlushQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushNow() {
        RunnableInfo info;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.LOCK;
        synchronized (object) {
            this.FLUSHER_SCHEDULED = false;
        }
        long startTime = System.currentTimeMillis();
        while ((info = this.pollNextEvent()) != null) {
            FlushQueue.runNextEvent(info);
            if (System.currentTimeMillis() - startTime <= 5L) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void push(@NotNull RunnableInfo runnableInfo) {
        if (runnableInfo == null) {
            FlushQueue.$$$reportNull$$$0(0);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myQueue.offer(runnableInfo);
            this.requestFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @TestOnly
    @NotNull
    Collection<RunnableInfo> getQueue() {
        Object object = this.LOCK;
        // MONITORENTER : object
        Collection<RunnableInfo> collection = Collections.unmodifiableCollection(this.myQueue);
        // MONITOREXIT : object
        if (collection != null) return collection;
        FlushQueue.$$$reportNull$$$0(1);
        return collection;
    }

    private static void doRun(@Async.Execute @NotNull RunnableInfo info) {
        if (info == null) {
            FlushQueue.$$$reportNull$$$0(2);
        }
        try (AccessToken ignored = ClientId.withClientId(info.clientId);){
            info.runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.LOCK;
        synchronized (object) {
            return "LaterInvocator.FlushQueue size=" + this.myQueue.size() + "; FLUSHER_SCHEDULED=" + this.FLUSHER_SCHEDULED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RunnableInfo pollNextEvent() {
        Object object = this.LOCK;
        synchronized (object) {
            RunnableInfo info;
            ModalityStateEx currentModality = LaterInvocator.getCurrentModalityState();
            while ((info = this.myQueue.pollFirst()) != null) {
                if (info.expired.value(null)) continue;
                if (!((ModalityState)currentModality).dominates(info.modalityState)) {
                    this.requestFlush();
                    break;
                }
                this.mySkippedItems.add(info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runNextEvent(@NotNull RunnableInfo info) {
        if (info == null) {
            FlushQueue.$$$reportNull$$$0(3);
        }
        EventWatcher watcher = EventWatcher.getInstanceOrNull();
        Runnable runnable = info.runnable;
        if (watcher != null) {
            watcher.runnableStarted(runnable, System.currentTimeMillis());
        }
        try {
            FlushQueue.doRun(info);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Throwable t) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ExceptionUtil.rethrow(t);
            }
            LOG.error(t);
        }
        finally {
            if (watcher != null) {
                watcher.runnableFinished(runnable, System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reincludeSkippedItems() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.LOCK;
        synchronized (object) {
            int size = this.mySkippedItems.size();
            for (int i = size - 1; i >= 0; --i) {
                RunnableInfo item = this.mySkippedItems.get(i);
                this.myQueue.addFirst(item);
            }
            if (size < 20) {
                this.mySkippedItems.clear();
            } else {
                this.mySkippedItems = new ArrayList<RunnableInfo>();
            }
            this.requestFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void purgeExpiredItems() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Object object = this.LOCK;
        synchronized (object) {
            this.reincludeSkippedItems();
            ArrayList<RunnableInfo> alive = new ArrayList<RunnableInfo>(this.myQueue.size());
            for (RunnableInfo info : this.myQueue) {
                if (info.expired.value(null)) continue;
                alive.add(info);
            }
            if (alive.size() < this.myQueue.size()) {
                this.myQueue.clear();
                this.myQueue.addAll(alive);
            }
            this.requestFlush();
        }
    }

    private void requestFlush() {
        boolean shouldSchedule;
        boolean bl = shouldSchedule = !this.FLUSHER_SCHEDULED && !this.myQueue.isEmpty();
        if (shouldSchedule) {
            this.FLUSHER_SCHEDULED = true;
            SwingUtilities.invokeLater(this.FLUSH_NOW);
        }
    }

    boolean isFlushNow(@NotNull Runnable runnable) {
        if (runnable == null) {
            FlushQueue.$$$reportNull$$$0(4);
        }
        return runnable == this.FLUSH_NOW;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnableInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/application/impl/FlushQueue";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/application/impl/FlushQueue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runNextEvent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFlushNow";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RunnableInfo {
        @NotNull
        private final Runnable runnable;
        @NotNull
        private final ModalityState modalityState;
        @NotNull
        private final Condition<?> expired;
        @NotNull
        private final String clientId;

        @Async.Schedule
        RunnableInfo(@NotNull Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition<?> expired) {
            if (runnable == null) {
                RunnableInfo.$$$reportNull$$$0(0);
            }
            if (modalityState == null) {
                RunnableInfo.$$$reportNull$$$0(1);
            }
            if (expired == null) {
                RunnableInfo.$$$reportNull$$$0(2);
            }
            this.runnable = runnable;
            this.modalityState = modalityState;
            this.expired = expired;
            this.clientId = ClientId.getCurrentValue();
        }

        @NonNls
        public String toString() {
            return "[runnable: " + this.runnable + "; state=" + this.modalityState + (this.expired.value(null) ? "; expired" : "") + "] ";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "runnable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "modalityState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expired";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/application/impl/FlushQueue$RunnableInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

