/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ServiceBean
implements PluginAware {
    private static final Logger LOG = Logger.getInstance(ServiceBean.class);
    @Attribute
    public String serviceInterface;
    private PluginDescriptor myPluginDescriptor;

    public static <T> List<T> loadServicesFromBeans(@NotNull ExtensionPointName<ServiceBean> epName, @NotNull Class<T> componentClass) {
        if (epName == null) {
            ServiceBean.$$$reportNull$$$0(0);
        }
        if (componentClass == null) {
            ServiceBean.$$$reportNull$$$0(1);
        }
        ArrayList components = new ArrayList();
        for (ServiceBean exportableBean : epName.getExtensionList()) {
            String serviceClass = exportableBean.serviceInterface;
            if (serviceClass == null) {
                LOG.error("Service interface not specified in " + epName);
                continue;
            }
            try {
                Class<?> aClass = Class.forName(serviceClass, true, exportableBean.getPluginDescriptor().getPluginClassLoader());
                Object service = ApplicationManager.getApplication().getService(aClass);
                if (service == null) {
                    LOG.error("Can't find service: " + serviceClass);
                    continue;
                }
                if (!componentClass.isInstance(service)) {
                    LOG.error("Service " + serviceClass + " is registered in " + epName.getName() + " EP, but doesn't implement " + componentClass.getName());
                    continue;
                }
                components.add(service);
            }
            catch (ClassNotFoundException e) {
                LOG.error(e);
            }
        }
        return components;
    }

    @Transient
    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }

    @Override
    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            ServiceBean.$$$reportNull$$$0(2);
        }
        this.myPluginDescriptor = pluginDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "epName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/components/ServiceBean";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadServicesFromBeans";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setPluginDescriptor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

