/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.ui.Splittable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Splitter
extends JPanel
implements Splittable {
    private static final Icon SplitGlueH = EmptyIcon.create(6, 17);
    private static final Icon SplitGlueV = EmptyIcon.create(17, 6);
    private static final Logger LOG = Logger.getInstance(Splitter.class);
    @NonNls
    public static final String PROP_PROPORTION = "proportion";
    @NonNls
    public static final String PROP_ORIENTATION = "orientation";
    private int myDividerWidth;
    private boolean myVerticalSplit;
    private boolean myHonorMinimumSize;
    private boolean myHonorPreferredSize;
    private boolean myUseViewportViewSizes;
    private final float myMinProp;
    private final float myMaxProp;
    protected float myProportion;
    private Float myLagProportion;
    protected final Divider myDivider;
    private JComponent mySecondComponent;
    private JComponent myFirstComponent;
    private boolean myShowDividerIcon;
    private boolean myShowDividerControls;
    private boolean mySkipNextLayout;
    private static final Rectangle myNullBounds = new Rectangle();
    @NotNull
    private LackOfSpaceStrategy myLackOfSpaceStrategy = LackOfSpaceStrategy.SIMPLE_RATIO;
    @NotNull
    private DividerPositionStrategy myDividerPositionStrategy = DividerPositionStrategy.KEEP_PROPORTION;

    public Splitter() {
        this(false);
    }

    public Splitter(boolean vertical) {
        this(vertical, 0.5f);
    }

    public Splitter(boolean vertical, float proportion) {
        this(vertical, proportion, 0.0f, 1.0f);
    }

    public Splitter(boolean vertical, float proportion, float minProp, float maxProp) {
        this.myMinProp = minProp;
        this.myMaxProp = maxProp;
        LOG.assertTrue(minProp >= 0.0f);
        LOG.assertTrue(maxProp <= 1.0f);
        LOG.assertTrue(minProp <= maxProp);
        this.myVerticalSplit = vertical;
        this.myShowDividerControls = false;
        this.myShowDividerIcon = true;
        this.myHonorMinimumSize = true;
        this.myHonorPreferredSize = false;
        this.myDivider = this.createDivider();
        this.setProportion(proportion);
        this.myDividerWidth = 7;
        super.add(this.myDivider);
        this.setOpaque(false);
    }

    public void setShowDividerControls(boolean showDividerControls) {
        this.myShowDividerControls = showDividerControls;
        this.setOrientation(this.myVerticalSplit);
    }

    public void setShowDividerIcon(boolean showDividerIcon) {
        this.myShowDividerIcon = showDividerIcon;
        this.setOrientation(this.myVerticalSplit);
    }

    public void setResizeEnabled(boolean value) {
        this.myDivider.setResizeEnabled(value);
    }

    public void setAllowSwitchOrientationByMouseClick(boolean enabled) {
        this.myDivider.setSwitchOrientationEnabled(enabled);
    }

    public boolean isShowDividerIcon() {
        return this.myShowDividerIcon;
    }

    public boolean isShowDividerControls() {
        return this.myShowDividerControls;
    }

    public boolean isHonorMinimumSize() {
        return this.myHonorMinimumSize;
    }

    public void setHonorComponentsMinimumSize(boolean honorMinimumSize) {
        this.myHonorMinimumSize = honorMinimumSize;
    }

    public boolean isHonorPreferredSize() {
        return this.myHonorPreferredSize;
    }

    public boolean isUseViewportViewSizes() {
        return this.myUseViewportViewSizes;
    }

    public void setUseViewportViewSizes(boolean useViewportViewSizes) {
        this.myUseViewportViewSizes = useViewportViewSizes;
    }

    public void setHonorComponentsPreferredSize(boolean honorPreferredSize) {
        this.myHonorPreferredSize = honorPreferredSize;
    }

    public void setLackOfSpaceStrategy(@NotNull LackOfSpaceStrategy strategy) {
        if (strategy == null) {
            Splitter.$$$reportNull$$$0(0);
        }
        this.myLackOfSpaceStrategy = strategy;
    }

    @NotNull
    public LackOfSpaceStrategy getLackOfSpaceStrategy() {
        LackOfSpaceStrategy lackOfSpaceStrategy = this.myLackOfSpaceStrategy;
        if (lackOfSpaceStrategy == null) {
            Splitter.$$$reportNull$$$0(1);
        }
        return lackOfSpaceStrategy;
    }

    public void setDividerPositionStrategy(@NotNull DividerPositionStrategy dividerPositionStrategy) {
        if (dividerPositionStrategy == null) {
            Splitter.$$$reportNull$$$0(2);
        }
        this.myDividerPositionStrategy = dividerPositionStrategy;
    }

    @NotNull
    public DividerPositionStrategy getDividerPositionStrategy() {
        DividerPositionStrategy dividerPositionStrategy = this.myDividerPositionStrategy;
        if (dividerPositionStrategy == null) {
            Splitter.$$$reportNull$$$0(3);
        }
        return dividerPositionStrategy;
    }

    @Override
    @Deprecated
    public Component add(Component comp) {
        int childCount = this.getComponentCount();
        LOG.assertTrue(childCount >= 1);
        if (childCount > 3) {
            throw new IllegalStateException(String.valueOf(childCount));
        }
        if (childCount == 1) {
            this.setFirstComponent((JComponent)comp);
        } else {
            this.setSecondComponent((JComponent)comp);
        }
        return comp;
    }

    public void dispose() {
    }

    protected Divider createDivider() {
        return new DividerImpl();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && (this.myFirstComponent != null && this.myFirstComponent.isVisible() || this.mySecondComponent != null && this.mySecondComponent.isVisible());
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        int dividerWidth = this.getDividerWidth();
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible() && this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            Dimension firstMinSize = this.myFirstComponent.getMinimumSize();
            Dimension secondMinSize = this.mySecondComponent.getMinimumSize();
            return this.isVertical() ? new Dimension(Math.max(firstMinSize.width, secondMinSize.width), firstMinSize.height + dividerWidth + secondMinSize.height) : new Dimension(firstMinSize.width + dividerWidth + secondMinSize.width, Math.max(firstMinSize.height, secondMinSize.height));
        }
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible()) {
            return this.myFirstComponent.getMinimumSize();
        }
        if (this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            return this.mySecondComponent.getMinimumSize();
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        int dividerWidth = this.getDividerWidth();
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible() && this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            Dimension firstPrefSize = this.unwrap(this.myFirstComponent).getPreferredSize();
            Dimension secondPrefSize = this.unwrap(this.mySecondComponent).getPreferredSize();
            if (this.myDividerPositionStrategy == DividerPositionStrategy.DISTRIBUTE) {
                Dimension firstMinSize = this.unwrap(this.myFirstComponent).getMinimumSize();
                Dimension secondMinSize = this.unwrap(this.mySecondComponent).getMinimumSize();
                firstPrefSize.width = Math.max(firstMinSize.width, firstPrefSize.width);
                firstPrefSize.height = Math.max(firstMinSize.height, firstPrefSize.height);
                secondPrefSize.width = Math.max(secondMinSize.width, secondPrefSize.width);
                secondPrefSize.height = Math.max(secondMinSize.height, secondPrefSize.height);
            }
            return this.isVertical() ? new Dimension(Math.max(firstPrefSize.width, secondPrefSize.width), firstPrefSize.height + dividerWidth + secondPrefSize.height) : new Dimension(firstPrefSize.width + dividerWidth + secondPrefSize.width, Math.max(firstPrefSize.height, secondPrefSize.height));
        }
        if (this.myFirstComponent != null && this.myFirstComponent.isVisible()) {
            return this.myFirstComponent.getPreferredSize();
        }
        if (this.mySecondComponent != null && this.mySecondComponent.isVisible()) {
            return this.mySecondComponent.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    public void skipNextLayout() {
        this.mySkipNextLayout = true;
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        int total;
        int n = total = this.myVerticalSplit ? h : w;
        if (w > 0 && h > 0 && this.myDividerPositionStrategy != DividerPositionStrategy.KEEP_PROPORTION && Splitter.isComponentVisible(this.myFirstComponent) && Splitter.isComponentVisible(this.mySecondComponent) && total > 2 * this.getDividerWidth() && (double)total != this.getDimension(this.getSize())) {
            if (this.myDividerPositionStrategy == DividerPositionStrategy.KEEP_FIRST_SIZE) {
                this.myProportion = this.getProportionForFirstSize((int)this.getDimension(this.myFirstComponent.getSize()), total);
            } else if (this.myDividerPositionStrategy == DividerPositionStrategy.KEEP_SECOND_SIZE) {
                this.myProportion = this.getProportionForSecondSize((int)this.getDimension(this.mySecondComponent.getSize()), total);
            } else if (this.myDividerPositionStrategy == DividerPositionStrategy.DISTRIBUTE) {
                if (this.myLagProportion == null) {
                    this.myLagProportion = Float.valueOf(this.myProportion);
                }
                Component first = this.unwrap(this.myFirstComponent);
                Component second = this.unwrap(this.mySecondComponent);
                this.myProportion = Splitter.getDistributeSizeChange((int)this.getDimension(this.myFirstComponent.getSize()), (int)this.getDimension(first.getMinimumSize()), (int)this.getDimension(first.getPreferredSize()), (int)this.getDimension(first.getMaximumSize()), (int)this.getDimension(this.mySecondComponent.getSize()), (int)this.getDimension(second.getMinimumSize()), (int)this.getDimension(second.getPreferredSize()), (int)this.getDimension(second.getMaximumSize()), total - this.getDividerWidth(), this.myLagProportion.floatValue(), this.myLackOfSpaceStrategy == LackOfSpaceStrategy.SIMPLE_RATIO ? null : Boolean.valueOf(this.myLackOfSpaceStrategy == LackOfSpaceStrategy.HONOR_THE_SECOND_MIN_SIZE));
            }
        }
        super.reshape(x, y, w, h);
    }

    private static boolean isComponentVisible(JComponent component) {
        return !Splitter.isNull(component) && component.isVisible() && !component.getBounds().isEmpty();
    }

    private static float getDistributeSizeChange(int size1, int mSize1, int pSize1, int mxSize1, int size2, int mSize2, int pSize2, int mxSize2, int totalSize, float oldProportion, @Nullable Boolean stretchFirst) {
        mSize1 = Math.min(mSize1, mxSize1);
        mSize2 = Math.min(mSize2, mxSize2);
        pSize1 = MathUtil.clamp(pSize1, mSize1, mxSize1);
        pSize2 = MathUtil.clamp(pSize2, mSize2, mxSize2);
        int delta = totalSize - (size1 + size2);
        int[] size = new int[]{size1, size2};
        if (delta >= 0) {
            delta = Splitter.stretchTo(size, mSize1, mSize2, delta, oldProportion);
            delta = Splitter.stretchTo(size, pSize1, pSize2, delta, oldProportion);
            delta = Splitter.stretchTo(size, mxSize1, mxSize2, delta, oldProportion);
        } else {
            delta = Splitter.stretchTo(size, mxSize1, mxSize2, delta, oldProportion);
            delta = Splitter.stretchTo(size, pSize1, pSize2, delta, oldProportion);
            delta = Splitter.stretchTo(size, mSize1, mSize2, delta, oldProportion);
        }
        if (delta != 0) {
            if (stretchFirst == null) {
                int p0 = Splitter.computePortion(size, delta, oldProportion);
                size[0] = size[0] + p0;
                size[1] = size[1] + (delta - p0);
            } else {
                int n = stretchFirst != false ? 0 : 1;
                size[n] = size[n] + delta;
            }
        }
        return (float)size[0] / (float)totalSize;
    }

    private static int stretchTo(int[] size, int tgt0, int tgt1, int delta, double oldProportion) {
        int d1;
        int d0 = tgt0 - size[0];
        if (d0 >= 0 != delta >= 0) {
            d0 = 0;
        }
        if ((d1 = tgt1 - size[1]) >= 0 != delta >= 0) {
            d1 = 0;
        }
        if (Math.abs(d0 + d1) > Math.abs(delta)) {
            int p0 = Splitter.computePortion(size, delta, oldProportion);
            int p1 = delta - p0;
            if (Math.abs(p0) > Math.abs(d0)) {
                p0 = d0;
                p1 = delta - d0;
            } else if (Math.abs(p1) > Math.abs(d1)) {
                p0 = delta - d1;
                p1 = d1;
            }
            size[0] = size[0] + p0;
            size[1] = size[1] + p1;
            return 0;
        }
        size[0] = size[0] + d0;
        size[1] = size[1] + d1;
        return delta - (d0 + d1);
    }

    private static int computePortion(int[] size, int delta, double oldProportion) {
        int offset = (int)Math.round((double)(size[0] + size[1] + delta) * oldProportion - (double)size[0]);
        if (offset < 0 != delta < 0) {
            return 0;
        }
        return Math.abs(offset) > Math.abs(delta) ? delta : offset;
    }

    @ApiStatus.Internal
    protected final float getProportionForFirstSize(int firstSize, int totalSize) {
        Splitter.checkSize(firstSize);
        this.checkTotalSize(totalSize);
        return (float)firstSize / (float)(totalSize - this.getDividerWidth());
    }

    @ApiStatus.Internal
    protected final float getProportionForSecondSize(int secondSize, int totalSize) {
        Splitter.checkSize(secondSize);
        this.checkTotalSize(totalSize);
        return (float)(totalSize - this.getDividerWidth() - secondSize) / (float)(totalSize - this.getDividerWidth());
    }

    private static void checkSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size is negative: " + size);
        }
    }

    private void checkTotalSize(int totalSize) {
        int d = this.getDividerWidth();
        if (totalSize <= d) {
            throw new IllegalArgumentException("divider width >= total size: " + d + " >= " + totalSize);
        }
    }

    @Override
    public void doLayout() {
        int total;
        if (this.mySkipNextLayout) {
            this.mySkipNextLayout = false;
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int n = total = this.isVertical() ? height : width;
        if (total <= 0) {
            return;
        }
        if (!Splitter.isNull(this.myFirstComponent) && this.myFirstComponent.isVisible() && !Splitter.isNull(this.mySecondComponent) && this.mySecondComponent.isVisible()) {
            double size1;
            Rectangle firstRect = new Rectangle();
            Rectangle dividerRect = new Rectangle();
            Rectangle secondRect = new Rectangle();
            int d = this.getDividerWidth();
            if (total <= d) {
                size1 = 0.0;
                d = total;
            } else {
                size1 = this.computeFirstComponentSize(total - d);
            }
            int iSize1 = Math.max(0, (int)Math.round(size1));
            int iSize2 = Math.max(0, total - iSize1 - d);
            if (this.isVertical()) {
                firstRect.setBounds(0, 0, width, iSize1);
                dividerRect.setBounds(0, iSize1, width, d);
                secondRect.setBounds(0, iSize1 + d, width, iSize2);
            } else {
                firstRect.setBounds(0, 0, iSize1, height);
                dividerRect.setBounds(iSize1, 0, d, height);
                secondRect.setBounds(iSize1 + d, 0, iSize2, height);
            }
            this.myDivider.setVisible(true);
            this.myFirstComponent.setBounds(firstRect);
            this.myDivider.setBounds(dividerRect);
            this.mySecondComponent.setBounds(secondRect);
        } else if (!Splitter.isNull(this.myFirstComponent) && this.myFirstComponent.isVisible()) {
            Splitter.hideNull(this.mySecondComponent);
            this.myDivider.setVisible(false);
            this.myFirstComponent.setBounds(0, 0, width, height);
        } else if (!Splitter.isNull(this.mySecondComponent) && this.mySecondComponent.isVisible()) {
            Splitter.hideNull(this.myFirstComponent);
            this.myDivider.setVisible(false);
            this.mySecondComponent.setBounds(0, 0, width, height);
        } else {
            this.myDivider.setVisible(false);
            if (this.myFirstComponent != null) {
                this.myFirstComponent.setBounds(0, 0, 0, 0);
            } else {
                Splitter.hideNull(this.myFirstComponent);
            }
            if (this.mySecondComponent != null) {
                this.mySecondComponent.setBounds(0, 0, 0, 0);
            } else {
                Splitter.hideNull(this.mySecondComponent);
            }
        }
    }

    private double computeFirstComponentSize(int total) {
        double size1 = this.myProportion * (float)total;
        double size2 = (double)total - size1;
        if (!this.isHonorMinimumSize()) {
            return size1;
        }
        double mSize1 = this.getDimension(this.myFirstComponent.getMinimumSize());
        double mSize2 = this.getDimension(this.mySecondComponent.getMinimumSize());
        if (this.myHonorPreferredSize && size1 > mSize1 && size2 > mSize2) {
            mSize1 = this.getDimension(this.myFirstComponent.getPreferredSize());
            mSize2 = this.getDimension(this.mySecondComponent.getPreferredSize());
        }
        if ((double)total < mSize1 + mSize2) {
            switch (this.myLackOfSpaceStrategy) {
                case SIMPLE_RATIO: {
                    double proportion = mSize1 / (mSize1 + mSize2);
                    size1 = proportion * (double)total;
                    break;
                }
                case HONOR_THE_FIRST_MIN_SIZE: {
                    size1 = mSize1;
                    break;
                }
                case HONOR_THE_SECOND_MIN_SIZE: {
                    size1 = (double)total - mSize2;
                }
            }
        } else if (size1 < mSize1) {
            size1 = mSize1;
        } else if (size2 < mSize2) {
            size2 = mSize2;
            size1 = (double)total - size2;
        }
        return size1;
    }

    private double getDimension(Dimension size) {
        return this.isVertical() ? size.getHeight() : size.getWidth();
    }

    static boolean isNull(Component component) {
        return NullableComponent.Check.isNull(component);
    }

    static void hideNull(Component component) {
        if (component instanceof NullableComponent && !component.getBounds().equals(myNullBounds)) {
            component.setBounds(myNullBounds);
            component.validate();
        }
    }

    public int getDividerWidth() {
        return this.myDividerWidth;
    }

    public void setDividerWidth(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Wrong divider width: " + width);
        }
        if (this.myDividerWidth != width) {
            this.myDividerWidth = width;
            this.revalidate();
            this.repaint();
        }
    }

    public float getProportion() {
        return this.myProportion;
    }

    public float getMinimumProportion() {
        return this.myMinProp;
    }

    public float getMaximumProportion() {
        return this.myMaxProp;
    }

    public void setDefaultProportion() {
        Component first = this.unwrap(this.myFirstComponent);
        Component second = this.unwrap(this.mySecondComponent);
        if (first != null && second != null) {
            double p1 = Math.max(this.getDimension(first.getPreferredSize()), this.getDimension(first.getMinimumSize()));
            double p2 = Math.max(this.getDimension(second.getPreferredSize()), this.getDimension(second.getMinimumSize()));
            this.setProportion((float)(p1 / (p1 + p2)));
        }
    }

    @Override
    public void setProportion(float proportion) {
        this.myLagProportion = null;
        if (this.myProportion == proportion) {
            return;
        }
        if (proportion < 0.0f || proportion > 1.0f) {
            LOG.warn("Wrong proportion: " + proportion);
        }
        proportion = MathUtil.clamp(proportion, this.myMinProp, this.myMaxProp);
        float oldProportion = this.myProportion;
        this.myProportion = proportion;
        this.firePropertyChange(PROP_PROPORTION, new Float(oldProportion), new Float(this.myProportion));
        this.revalidate();
        this.repaint();
    }

    public void swapComponents() {
        JComponent tmp = this.myFirstComponent;
        this.myFirstComponent = this.mySecondComponent;
        this.mySecondComponent = tmp;
        this.revalidate();
        this.repaint();
    }

    @Override
    public boolean getOrientation() {
        return this.myVerticalSplit;
    }

    public boolean isVertical() {
        return this.myVerticalSplit;
    }

    @Override
    public void setOrientation(boolean verticalSplit) {
        boolean changed2 = this.myVerticalSplit != verticalSplit;
        this.myVerticalSplit = verticalSplit;
        this.myDivider.setOrientation(verticalSplit);
        if (changed2) {
            this.firePropertyChange(PROP_ORIENTATION, !this.myVerticalSplit, this.myVerticalSplit);
        }
        this.revalidate();
        this.repaint();
    }

    public JComponent getFirstComponent() {
        return this.myFirstComponent;
    }

    public void setFirstComponent(@Nullable JComponent component) {
        if (this.myFirstComponent != component) {
            if (this.myFirstComponent != null) {
                this.remove(this.myFirstComponent);
            }
            this.myFirstComponent = component;
            if (this.myFirstComponent != null) {
                super.add(this.myFirstComponent);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public JComponent getSecondComponent() {
        return this.mySecondComponent;
    }

    public JComponent getOtherComponent(Component comp) {
        if (comp.equals(this.getFirstComponent())) {
            return this.getSecondComponent();
        }
        if (comp.equals(this.getSecondComponent())) {
            return this.getFirstComponent();
        }
        LOG.error("invalid component");
        return this.getFirstComponent();
    }

    public void setSecondComponent(@Nullable JComponent component) {
        if (this.mySecondComponent != component) {
            if (this.mySecondComponent != null) {
                this.remove(this.mySecondComponent);
            }
            this.mySecondComponent = component;
            if (this.mySecondComponent != null) {
                super.add(this.mySecondComponent);
            }
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public float getMinProportion(boolean first) {
        Component other;
        Component component = first ? this.myFirstComponent : this.mySecondComponent;
        Component component2 = other = first ? this.mySecondComponent : this.myFirstComponent;
        if (this.isHonorMinimumSize()) {
            boolean bothVisible;
            boolean bl = bothVisible = component != null && component.isVisible() && other != null && other.isVisible();
            if (bothVisible) {
                double size = this.getDimension(component.getSize());
                component = this.unwrap(component);
                other = this.unwrap(other);
                double min = this.getDimension(component.getMinimumSize());
                double oMax = this.getDimension(other.getMaximumSize());
                double total = this.getDimension(this.getSize()) - (double)this.getDividerWidth();
                double oMaxP = (total - oMax) / total;
                double minP = size < min ? 0.0 : min / total;
                return (float)Math.max(oMaxP, minP);
            }
        }
        return 0.0f;
    }

    private Component unwrap(Component c) {
        if (!this.myUseViewportViewSizes) {
            return c;
        }
        JScrollPane scrollPane = ObjectUtils.tryCast(c, JScrollPane.class);
        JViewport viewport = scrollPane == null ? null : scrollPane.getViewport();
        Component view = viewport == null ? null : viewport.getView();
        return view == null ? c : view;
    }

    @Override
    @NotNull
    public Component asComponent() {
        Splitter splitter = this;
        if (splitter == null) {
            Splitter.$$$reportNull$$$0(4);
        }
        return splitter;
    }

    @Override
    public void setDragging(boolean dragging) {
    }

    public JPanel getDivider() {
        return this.myDivider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/Splitter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dividerPositionStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/Splitter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLackOfSpaceStrategy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDividerPositionStrategy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "asComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setLackOfSpaceStrategy";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setDividerPositionStrategy";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public class DividerImpl
    extends Divider {
        private boolean myResizeEnabled;
        private boolean mySwitchOrientationEnabled;
        protected Point myPoint;

        public DividerImpl() {
            super(new GridBagLayout());
            this.myResizeEnabled = true;
            this.mySwitchOrientationEnabled = false;
            this.setFocusable(false);
            this.enableEvents(48L);
            this.setOrientation(Splitter.this.myVerticalSplit);
        }

        @Override
        public void setOrientation(boolean isVerticalSplit) {
            this.removeAll();
            this.setCursor(Splitter.this.isVertical() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(10));
            if (!Splitter.this.myShowDividerControls && !Splitter.this.myShowDividerIcon) {
                return;
            }
            Icon glueIcon = isVerticalSplit ? SplitGlueV : SplitGlueH;
            this.add((Component)new JLabel(glueIcon), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, JBInsets.emptyInsets(), 0, 0));
            this.revalidate();
            this.repaint();
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (!this.myResizeEnabled) {
                return;
            }
            if (506 == e.getID()) {
                this.myPoint = SwingUtilities.convertPoint(this, e.getPoint(), Splitter.this);
                if (Splitter.this.isVertical()) {
                    if (this.getHeight() > 0) {
                        float min = Splitter.this.getMinProportion(true);
                        float max = 1.0f - Splitter.this.getMinProportion(false);
                        float proportion = MathUtil.clamp(Math.min(max, Math.max((float)this.myPoint.y / (float)Splitter.this.getHeight(), min)), 0.0f, 1.0f);
                        Splitter.this.setProportion(proportion);
                    }
                } else if (this.getWidth() > 0) {
                    float min = Splitter.this.getMinProportion(true);
                    float max = 1.0f - Splitter.this.getMinProportion(false);
                    float proportion = MathUtil.clamp(Math.min(max, Math.max((float)this.myPoint.x / (float)Splitter.this.getWidth(), min)), 0.0f, 1.0f);
                    Splitter.this.setProportion(proportion);
                }
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.getID() == 500) {
                if (this.mySwitchOrientationEnabled && e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e) && (SystemInfo.isMac ? e.isMetaDown() : e.isControlDown())) {
                    Splitter.this.setOrientation(!Splitter.this.getOrientation());
                }
                if (this.myResizeEnabled && e.getClickCount() == 2) {
                    Splitter.this.setProportion(0.5f);
                }
            }
        }

        @Override
        public void setResizeEnabled(boolean resizeEnabled) {
            this.myResizeEnabled = resizeEnabled;
            if (!this.myResizeEnabled) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                this.setCursor(Splitter.this.isVertical() ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(10));
            }
        }

        @Override
        public void setSwitchOrientationEnabled(boolean switchOrientationEnabled) {
            this.mySwitchOrientationEnabled = switchOrientationEnabled;
        }
    }

    public static enum DividerPositionStrategy {
        KEEP_PROPORTION,
        KEEP_FIRST_SIZE,
        KEEP_SECOND_SIZE,
        DISTRIBUTE;

    }

    public static enum LackOfSpaceStrategy {
        SIMPLE_RATIO,
        HONOR_THE_FIRST_MIN_SIZE,
        HONOR_THE_SECOND_MIN_SIZE;

    }
}

