/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.ui.ImageDataByPathLoader;
import com.intellij.openapi.util.DeprecatedDuplicatesIconPathPatcher;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.ImageDataByUrlLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.reference.SoftReference;
import com.intellij.ui.Gray;
import com.intellij.ui.IconManager;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.RetrievableIcon;
import com.intellij.ui.icons.CompositeIcon;
import com.intellij.ui.icons.CopyableIcon;
import com.intellij.ui.icons.DarkIconProvider;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.MenuBarIconProvider;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextSupport;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ImageLoader;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.SVGLoader;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.MultiResolutionImageProvider;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance(IconLoader.class);
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final Map<@NotNull Pair<String, ClassLoader>, @NotNull CachedImageIcon> iconCache = new ConcurrentHashMap<Pair<String, ClassLoader>, CachedImageIcon>(100, 0.9f, 2);
    private static final Map<@NotNull Icon, @NotNull Icon> iconToDisabledIcon = CollectionFactory.createConcurrentWeakMap();
    private static volatile boolean STRICT_GLOBAL;
    private static final ThreadLocal<Boolean> STRICT_LOCAL;
    private static final AtomicReference<IconTransform> pathTransform;
    private static final AtomicInteger pathTransformGlobalModCount;
    private static boolean isActivated;

    private IconLoader() {
    }

    @ApiStatus.Internal
    @Nullable
    public static Icon loadCustomVersion(@NotNull CachedImageIcon icon2, int width, int height) {
        String path;
        ImageDataLoader resolver;
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(0);
        }
        URL url = (resolver = icon2.resolver) == null ? null : resolver.getURL();
        String string2 = path = url == null ? null : url.toString();
        if (path != null && path.endsWith(".svg")) {
            String modified = path.substring(0, path.length() - 4) + "@" + width + "x" + height + ".svg";
            try {
                Icon foundIcon = IconLoader.findIcon(new URL(modified));
                if (foundIcon instanceof CachedImageIcon && foundIcon.getIconWidth() == width && foundIcon.getIconHeight() == height) {
                    return foundIcon;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @ApiStatus.Internal
    public static Icon loadCustomVersionOrScale(@NotNull ScalableIcon icon2, float size) {
        Icon version;
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(1);
        }
        if ((float)icon2.getIconWidth() == size) {
            return icon2;
        }
        ScalableIcon cachedIcon = icon2;
        if (cachedIcon instanceof CachedImageIcon && (version = IconLoader.loadCustomVersion((CachedImageIcon)cachedIcon, (int)size, (int)size)) != null) {
            return version;
        }
        return icon2.scale(size / (float)icon2.getIconWidth());
    }

    @TestOnly
    public static <T> T performStrictly(@NotNull Supplier<? extends T> computable) {
        if (computable == null) {
            IconLoader.$$$reportNull$$$0(2);
        }
        STRICT_LOCAL.set(true);
        try {
            T t = computable.get();
            return t;
        }
        finally {
            STRICT_LOCAL.set(false);
        }
    }

    public static void setStrictGlobally(boolean strict) {
        STRICT_GLOBAL = strict;
    }

    private static void updateTransform(@NotNull @NotNull Function<? super IconTransform, @NotNull IconTransform> updater) {
        IconTransform next;
        IconTransform prev;
        if (updater == null) {
            IconLoader.$$$reportNull$$$0(3);
        }
        while (!pathTransform.compareAndSet(prev = pathTransform.get(), next = updater.apply(prev))) {
        }
        pathTransformGlobalModCount.incrementAndGet();
        if (prev != next) {
            iconToDisabledIcon.clear();
            ImageLoader.ImageCache.INSTANCE.clearCache();
        }
    }

    public static void installPathPatcher(@NotNull IconPathPatcher patcher) {
        if (patcher == null) {
            IconLoader.$$$reportNull$$$0(4);
        }
        IconLoader.updateTransform(transform2 -> transform2.withPathPatcher(patcher));
    }

    public static void removePathPatcher(@NotNull IconPathPatcher patcher) {
        if (patcher == null) {
            IconLoader.$$$reportNull$$$0(5);
        }
        IconLoader.updateTransform(transform2 -> transform2.withoutPathPatcher(patcher));
    }

    public static void setUseDarkIcons(boolean useDarkIcons) {
        IconLoader.updateTransform(transform2 -> transform2.withDark(useDarkIcons));
    }

    public static void setFilter(ImageFilter filter2) {
        IconLoader.updateTransform(transform2 -> transform2.withFilter(filter2));
    }

    public static void clearCache() {
        IconLoader.updateTransform(IconTransform::copy);
    }

    @TestOnly
    public static void clearCacheInTests() {
        iconCache.clear();
        iconToDisabledIcon.clear();
        ImageLoader.ImageCache.INSTANCE.clearCache();
        pathTransformGlobalModCount.incrementAndGet();
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(6);
        }
        Class<?> callerClass = ReflectionUtil.getGrandCallerClass();
        assert (callerClass != null) : path;
        return IconLoader.getIcon(path, callerClass);
    }

    @Nullable
    public static Icon getReflectiveIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(7);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(8);
        }
        try {
            int dotIndex = path.lastIndexOf(46);
            String fieldName = path.substring(dotIndex + 1);
            StringBuilder builder = new StringBuilder(path.length() + 20);
            builder.append(path, 0, dotIndex);
            int separatorIndex = -1;
            while ((dotIndex = path.lastIndexOf(46, dotIndex - 1)) != -1 && !Character.isLowerCase(path.charAt(dotIndex + 1))) {
                if (separatorIndex != -1) {
                    builder.setCharAt(separatorIndex, '$');
                }
                separatorIndex = dotIndex;
            }
            if (!Character.isLowerCase(builder.charAt(0))) {
                if (separatorIndex != -1) {
                    builder.setCharAt(separatorIndex, '$');
                }
                builder.insert(0, path.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.");
            }
            Class<?> aClass = classLoader.loadClass(builder.toString());
            return LOOKUP.findStaticGetter(aClass, fieldName, Icon.class).invoke();
        }
        catch (Throwable e) {
            LOG.warn("Cannot get reflective icon (path=" + path + ")", e);
            return null;
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path) {
        Class<?> callerClass;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(9);
        }
        return (callerClass = ReflectionUtil.getGrandCallerClass()) == null ? null : IconLoader.findIcon(path, callerClass.getClassLoader());
    }

    @NotNull
    public static Icon getIcon(@NotNull String path, @NotNull Class<?> aClass) {
        Icon icon2;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(10);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(11);
        }
        if ((icon2 = IconLoader.findIcon(path, aClass, aClass.getClassLoader(), null, true)) == null) {
            throw new IllegalStateException("Icon cannot be found in '" + path + "', class='" + aClass.getName() + "'");
        }
        Icon icon3 = icon2;
        if (icon3 == null) {
            IconLoader.$$$reportNull$$$0(12);
        }
        return icon3;
    }

    @NotNull
    public static Icon getIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        Icon icon2;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(13);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(14);
        }
        if ((icon2 = IconLoader.findIcon(path, classLoader)) == null) {
            throw new IllegalStateException("Icon cannot be found in '" + path + "', classLoader='" + classLoader + "'");
        }
        Icon icon3 = icon2;
        if (icon3 == null) {
            IconLoader.$$$reportNull$$$0(15);
        }
        return icon3;
    }

    @Nullable
    public static ImageDataLoader createNewResolverIfNeeded(@Nullable ClassLoader originalClassLoader, @NotNull String originalPath, @NotNull IconTransform transform2) {
        Pair<String, ClassLoader> patchedPath;
        if (originalPath == null) {
            IconLoader.$$$reportNull$$$0(16);
        }
        if (transform2 == null) {
            IconLoader.$$$reportNull$$$0(17);
        }
        if ((patchedPath = transform2.patchPath(originalPath, originalClassLoader)) == null) {
            return null;
        }
        ClassLoader classLoader = patchedPath.second == null ? originalClassLoader : (ClassLoader)patchedPath.second;
        String path = (String)patchedPath.first;
        if (path != null && path.startsWith("/")) {
            return new FinalImageDataLoader(path.substring(1), classLoader == null ? transform2.getClass().getClassLoader() : classLoader);
        }
        if (path != null && path.startsWith("file:/")) {
            try {
                ImageDataByUrlLoader resolver = new ImageDataByUrlLoader(new URL(path), path, classLoader, false);
                resolver.resolve();
                return resolver;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @TestOnly
    public static void activate() {
        isActivated = true;
    }

    @TestOnly
    public static void deactivate() {
        isActivated = false;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static Icon findLafIcon(@NotNull String key, @NotNull Class<?> aClass, boolean strict) {
        if (key == null) {
            IconLoader.$$$reportNull$$$0(18);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(19);
        }
        return IconLoader.findIcon(key + ".png", aClass, aClass.getClassLoader(), strict ? HandleNotFound.THROW_EXCEPTION : HandleNotFound.IGNORE, true);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class<?> aClass) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(20);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(21);
        }
        return ImageDataByPathLoader.findIcon(path, aClass.getClassLoader(), iconCache);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull Class<?> aClass, boolean deferUrlResolve, boolean strict) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(22);
        }
        if (aClass == null) {
            IconLoader.$$$reportNull$$$0(23);
        }
        return IconLoader.findIcon(path, aClass, aClass.getClassLoader(), strict ? HandleNotFound.THROW_EXCEPTION : HandleNotFound.IGNORE, deferUrlResolve);
    }

    public static boolean isReflectivePath(@NotNull String path) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(24);
        }
        return !path.isEmpty() && path.charAt(0) != '/' && path.contains("Icons.");
    }

    @Nullable
    public static Icon findIcon(@Nullable URL url) {
        return IconLoader.findIcon(url, true);
    }

    @Nullable
    public static Icon findIcon(@Nullable URL url, boolean storeToCache) {
        if (url == null) {
            return null;
        }
        Pair<String, Object> key = new Pair<String, Object>(url.toString(), null);
        if (storeToCache) {
            return iconCache.computeIfAbsent(key, __ -> new CachedImageIcon(url, true));
        }
        CachedImageIcon icon2 = iconCache.get(key);
        return icon2 == null ? new CachedImageIcon(url, false) : icon2;
    }

    @Nullable
    private static Icon findIcon(@NotNull String originalPath, @Nullable Class<?> aClass, @NotNull ClassLoader classLoader, @Nullable HandleNotFound handleNotFound, boolean deferUrlResolve) {
        Icon icon2;
        String path;
        if (originalPath == null) {
            IconLoader.$$$reportNull$$$0(25);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(26);
        }
        if (!deferUrlResolve) {
            return ImageDataByPathLoader.findIcon(originalPath, classLoader, iconCache);
        }
        long startTime = StartUpMeasurer.getCurrentTimeIfEnabled();
        Pair<String, ClassLoader> patchedPath = IconLoader.patchPath(originalPath, classLoader);
        String string2 = path = patchedPath == null ? originalPath : (String)patchedPath.first;
        if (patchedPath != null && patchedPath.second != null) {
            classLoader = (ClassLoader)patchedPath.second;
        }
        if (IconLoader.isReflectivePath(path)) {
            icon2 = IconLoader.getReflectiveIcon(path, classLoader);
        } else {
            Pair<String, ClassLoader> key = new Pair<String, ClassLoader>(originalPath, classLoader);
            CachedImageIcon cachedIcon = iconCache.get(key);
            if (cachedIcon == null) {
                cachedIcon = iconCache.computeIfAbsent(key, k -> {
                    ClassLoader classLoader1 = (ClassLoader)k.getSecond();
                    HandleNotFound effectiveHandleNotFound = handleNotFound;
                    if (effectiveHandleNotFound == null) {
                        effectiveHandleNotFound = STRICT_LOCAL.get() != false ? HandleNotFound.THROW_EXCEPTION : HandleNotFound.IGNORE;
                    }
                    ImageDataByUrlLoader resolver = new ImageDataByUrlLoader(path, aClass, classLoader1, effectiveHandleNotFound, true);
                    return new CachedImageIcon(originalPath, resolver, null, null);
                });
            } else {
                ScaleContext scaleContext = ScaleContext.create();
                if (!((ScaleContext)cachedIcon.getScaleContext()).equals(scaleContext)) {
                    cachedIcon = cachedIcon.copy();
                    cachedIcon.updateScaleContext(scaleContext);
                }
            }
            icon2 = cachedIcon;
        }
        if (startTime != -1L) {
            IconLoadMeasurer.findIcon.end(startTime);
        }
        return icon2;
    }

    @Nullable
    public static Pair<String, ClassLoader> patchPath(@NotNull String originalPath, @NotNull ClassLoader classLoader) {
        if (originalPath == null) {
            IconLoader.$$$reportNull$$$0(27);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(28);
        }
        return pathTransform.get().patchPath(originalPath, classLoader);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        if (path == null) {
            IconLoader.$$$reportNull$$$0(29);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(30);
        }
        return ImageDataByPathLoader.findIcon(path, classLoader, iconCache);
    }

    @Nullable
    public static Icon findResolvedIcon(@NotNull String path, @NotNull ClassLoader classLoader) {
        Icon icon2;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(31);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(32);
        }
        if ((icon2 = ImageDataByPathLoader.findIcon(path, classLoader, iconCache)) instanceof CachedImageIcon && ((CachedImageIcon)icon2).getRealIcon() == CachedImageIcon.EMPTY_ICON) {
            return null;
        }
        return icon2;
    }

    @Nullable
    public static Image toImage(@NotNull Icon icon2) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(33);
        }
        return IconLoader.toImage(icon2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Image toImage(@NotNull Icon icon2, @Nullable ScaleContext ctx) {
        BufferedImage image;
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(34);
        }
        if (icon2 instanceof RetrievableIcon) {
            icon2 = IconLoader.getOrigin((RetrievableIcon)icon2);
        }
        if (icon2 instanceof CachedImageIcon) {
            icon2 = ((CachedImageIcon)icon2).getRealIcon(ctx);
        }
        if (icon2 instanceof ImageIcon) {
            return ((ImageIcon)icon2).getImage();
        }
        if (icon2.getIconWidth() <= 0 || icon2.getIconHeight() <= 0) {
            return null;
        }
        if (GraphicsEnvironment.isHeadless()) {
            image = ImageUtil.createImage(ctx, (double)icon2.getIconWidth(), (double)icon2.getIconHeight(), 2, PaintUtil.RoundingMode.ROUND);
        } else {
            if (ctx == null) {
                ctx = ScaleContext.create();
            }
            image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(PaintUtil.RoundingMode.ROUND.round(ctx.apply((double)icon2.getIconWidth(), DerivedScaleType.DEV_SCALE)), PaintUtil.RoundingMode.ROUND.round(ctx.apply((double)icon2.getIconHeight(), DerivedScaleType.DEV_SCALE)), 3);
            if (StartupUiUtil.isJreHiDPI(ctx)) {
                image = (BufferedImage)ImageUtil.ensureHiDPI(image, ctx, icon2.getIconWidth(), icon2.getIconHeight());
            }
        }
        Graphics2D g = image.createGraphics();
        try {
            icon2.paintIcon(null, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Icon copy(final @NotNull Icon icon2, @Nullable Component ancestor, boolean deepCopy) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(35);
        }
        if (icon2 instanceof CopyableIcon) {
            Icon icon3 = deepCopy ? ((CopyableIcon)icon2).deepCopy() : ((CopyableIcon)icon2).copy();
            if (icon3 == null) {
                IconLoader.$$$reportNull$$$0(36);
            }
            return icon3;
        }
        BufferedImage image = ImageUtil.createImage(ancestor == null ? null : ancestor.getGraphicsConfiguration(), icon2.getIconWidth(), icon2.getIconHeight(), 2);
        Graphics2D g = image.createGraphics();
        try {
            icon2.paintIcon(ancestor, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return new JBImageIcon((Image)image){
            final int originalWidth;
            final int originalHeight;
            {
                super(image);
                this.originalWidth = icon2.getIconWidth();
                this.originalHeight = icon2.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return this.originalWidth;
            }

            @Override
            public int getIconHeight() {
                return this.originalHeight;
            }
        };
    }

    @Nullable
    private static ImageIcon checkIcon(@NotNull Image image, @NotNull CachedImageIcon cii) {
        if (image == null) {
            IconLoader.$$$reportNull$$$0(37);
        }
        if (cii == null) {
            IconLoader.$$$reportNull$$$0(38);
        }
        if (image.getHeight(null) < 1) {
            return null;
        }
        JBImageIcon icon2 = new JBImageIcon(image);
        if (!IconLoader.isGoodSize(icon2)) {
            LOG.error("Invalid icon: " + cii);
            return CachedImageIcon.EMPTY_ICON;
        }
        return icon2;
    }

    public static boolean isGoodSize(@NotNull Icon icon2) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(39);
        }
        return icon2.getIconWidth() > 0 && icon2.getIconHeight() > 0;
    }

    @NotNull
    public static Icon getDisabledIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(40);
        }
        return IconLoader.getDisabledIcon(icon2, null);
    }

    @NotNull
    public static Icon getDisabledIcon(@NotNull Icon icon2, @Nullable Component ancestor) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(41);
        }
        if (!isActivated) {
            Icon icon3 = icon2;
            if (icon3 == null) {
                IconLoader.$$$reportNull$$$0(42);
            }
            return icon3;
        }
        if (icon2 instanceof LazyIcon) {
            icon2 = ((LazyIcon)icon2).getOrComputeIcon();
        }
        if (icon2 instanceof RetrievableIcon) {
            icon2 = IconLoader.getOrigin((RetrievableIcon)icon2);
        }
        Icon icon4 = iconToDisabledIcon.computeIfAbsent(icon2, existingIcon -> IconLoader.filterIcon(existingIcon, UIUtil::getGrayFilter, ancestor));
        if (icon4 == null) {
            IconLoader.$$$reportNull$$$0(43);
        }
        return icon4;
    }

    @NotNull
    public static Icon filterIcon(@NotNull Icon icon2, @NotNull Supplier<? extends RGBImageFilter> filterSupplier, @Nullable Component ancestor) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(44);
        }
        if (filterSupplier == null) {
            IconLoader.$$$reportNull$$$0(45);
        }
        if (icon2 instanceof LazyIcon) {
            icon2 = ((LazyIcon)icon2).getOrComputeIcon();
        }
        if (!IconLoader.isGoodSize(icon2)) {
            LOG.error(icon2);
            ImageIcon imageIcon = CachedImageIcon.EMPTY_ICON;
            if (imageIcon == null) {
                IconLoader.$$$reportNull$$$0(46);
            }
            return imageIcon;
        }
        if (icon2 instanceof CachedImageIcon) {
            Icon icon3 = ((CachedImageIcon)icon2).createWithFilter(filterSupplier);
            if (icon3 == null) {
                IconLoader.$$$reportNull$$$0(47);
            }
            return icon3;
        }
        ScaleContextSupport ctxSupport = IconLoader.getScaleContextSupport(icon2);
        double scale = ctxSupport == null ? (JreHiDpiUtil.isJreHiDPI((GraphicsConfiguration)null) ? (double)JBUIScale.sysScale(ancestor) : 1.0) : (JreHiDpiUtil.isJreHiDPI((GraphicsConfiguration)null) ? ctxSupport.getScale(ScaleType.SYS_SCALE) : 1.0);
        BufferedImage image = new BufferedImage((int)(scale * (double)icon2.getIconWidth()), (int)(scale * (double)icon2.getIconHeight()), 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(Gray.TRANSPARENT);
        graphics.fillRect(0, 0, icon2.getIconWidth(), icon2.getIconHeight());
        graphics.scale(scale, scale);
        icon2.paintIcon(LabelHolder.fakeComponent, graphics, 0, 0);
        graphics.dispose();
        Image img = ImageUtil.filter(image, filterSupplier.get());
        if (StartupUiUtil.isJreHiDPI(ancestor)) {
            img = RetinaImage.createFrom(img, scale, null);
        }
        return new JBImageIcon(img);
    }

    @NotNull
    public static Icon getTransparentIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(48);
        }
        return IconLoader.getTransparentIcon(icon2, 0.5f);
    }

    @NotNull
    public static Icon getTransparentIcon(final @NotNull Icon icon2, final float alpha) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(49);
        }
        return new RetrievableIcon(){

            @Override
            @NotNull
            public Icon retrieveIcon() {
                Icon icon22 = icon2;
                if (icon22 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return icon22;
            }

            @Override
            public int getIconHeight() {
                return icon2.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return icon2.getIconWidth();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, alpha));
                icon2.paintIcon(c, g2, x, y);
                g2.setComposite(saveComposite);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader$3", "retrieveIcon"));
            }
        };
    }

    @NotNull
    public static Icon getIconSnapshot(@NotNull Icon icon2) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(50);
        }
        if (icon2 instanceof CachedImageIcon) {
            ImageIcon imageIcon = ((CachedImageIcon)icon2).getRealIcon();
            if (imageIcon == null) {
                IconLoader.$$$reportNull$$$0(51);
            }
            return imageIcon;
        }
        Icon icon3 = icon2;
        if (icon3 == null) {
            IconLoader.$$$reportNull$$$0(52);
        }
        return icon3;
    }

    @ApiStatus.Internal
    @NotNull
    public static Icon getMenuBarIcon(@NotNull Icon icon2, boolean dark) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(53);
        }
        if (icon2 instanceof RetrievableIcon) {
            icon2 = IconLoader.getOrigin((RetrievableIcon)icon2);
        }
        if (icon2 instanceof MenuBarIconProvider) {
            Icon icon3 = ((MenuBarIconProvider)((Object)icon2)).getMenuBarIcon(dark);
            if (icon3 == null) {
                IconLoader.$$$reportNull$$$0(54);
            }
            return icon3;
        }
        Icon icon4 = icon2;
        if (icon4 == null) {
            IconLoader.$$$reportNull$$$0(55);
        }
        return icon4;
    }

    @NotNull
    public static Icon getDarkIcon(@NotNull Icon icon2, boolean dark) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(56);
        }
        if (icon2 instanceof RetrievableIcon) {
            icon2 = IconLoader.getOrigin((RetrievableIcon)icon2);
        }
        if (icon2 instanceof DarkIconProvider) {
            Icon icon3 = ((DarkIconProvider)((Object)icon2)).getDarkIcon(dark);
            if (icon3 == null) {
                IconLoader.$$$reportNull$$$0(57);
            }
            return icon3;
        }
        Icon icon4 = icon2;
        if (icon4 == null) {
            IconLoader.$$$reportNull$$$0(58);
        }
        return icon4;
    }

    public static void detachClassLoader(@NotNull ClassLoader classLoader) {
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(59);
        }
        iconCache.entrySet().removeIf(entry -> {
            CachedImageIcon icon2 = (CachedImageIcon)entry.getValue();
            return icon2.detachClassLoader(classLoader) || ((Pair)entry.getKey()).second == classLoader;
        });
        iconToDisabledIcon.keySet().removeIf(icon2 -> icon2 instanceof CachedImageIcon && ((CachedImageIcon)icon2).detachClassLoader(classLoader));
    }

    @Nullable
    static URL doResolve(@Nullable String path, @Nullable ClassLoader classLoader, @Nullable Class<?> ownerClass, @NotNull HandleNotFound handleNotFound) {
        if (handleNotFound == null) {
            IconLoader.$$$reportNull$$$0(60);
        }
        URL url = null;
        if (path != null) {
            if (classLoader != null) {
                path = path.charAt(0) == '/' ? path.substring(1) : path;
                url = IconLoader.findUrl(path, classLoader::getResource);
            }
            if (url == null && ownerClass != null) {
                url = IconLoader.findUrl(path, ownerClass::getResource);
            }
        }
        if (url == null) {
            handleNotFound.handle("Can't find icon in '" + path + "' near " + classLoader);
        }
        return url;
    }

    @Nullable
    private static URL findUrl(@NotNull String path, @NotNull Function<? super String, URL> urlProvider) {
        URL url;
        if (path == null) {
            IconLoader.$$$reportNull$$$0(61);
        }
        if (urlProvider == null) {
            IconLoader.$$$reportNull$$$0(62);
        }
        if ((url = urlProvider.apply((String)path)) != null) {
            return url;
        }
        if (((String)path).endsWith(".png")) {
            path = ((String)path).substring(0, ((String)path).length() - 4) + ".svg";
        } else if (((String)path).endsWith(".svg")) {
            path = ((String)path).substring(0, ((String)path).length() - 4) + ".png";
        } else {
            LOG.debug("unexpected path: ", path);
        }
        return urlProvider.apply((String)path);
    }

    @NotNull
    public static Icon createLazy(final @NotNull @NotNull Supplier<? extends @NotNull Icon> producer) {
        if (producer == null) {
            IconLoader.$$$reportNull$$$0(63);
        }
        return new LazyIcon(){

            @Override
            @NotNull
            protected Icon compute() {
                Icon icon2 = (Icon)producer.get();
                if (icon2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                return icon2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/IconLoader$4", "compute"));
            }
        };
    }

    @NotNull
    private static Icon getOrigin(@NotNull RetrievableIcon icon2) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(64);
        }
        int maxDeep = 10;
        Icon origin = icon2.retrieveIcon();
        for (int level = 0; origin instanceof RetrievableIcon && level < 10; ++level) {
            origin = ((RetrievableIcon)origin).retrieveIcon();
        }
        if (origin instanceof RetrievableIcon) {
            LOG.error("can't calculate origin icon (too deep in hierarchy), src: " + icon2);
        }
        Icon icon3 = origin;
        if (icon3 == null) {
            IconLoader.$$$reportNull$$$0(65);
        }
        return icon3;
    }

    @Nullable
    private static ScaleContextSupport getScaleContextSupport(@NotNull Icon icon2) {
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(66);
        }
        if (icon2 instanceof ScaleContextSupport) {
            return (ScaleContextSupport)((Object)icon2);
        }
        if (icon2 instanceof RetrievableIcon) {
            return IconLoader.getScaleContextSupport(((RetrievableIcon)icon2).retrieveIcon());
        }
        if (icon2 instanceof CompositeIcon) {
            CompositeIcon compositeIcon = (CompositeIcon)icon2;
            if (compositeIcon.getIconCount() == 0) {
                return null;
            }
            Icon innerIcon = compositeIcon.getIcon(0);
            return innerIcon == null ? null : IconLoader.getScaleContextSupport(innerIcon);
        }
        return null;
    }

    static {
        STRICT_LOCAL = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }

            @Override
            public Boolean get() {
                return STRICT_GLOBAL || (Boolean)super.get() != false;
            }
        };
        pathTransform = new AtomicReference<IconTransform>(new IconTransform(StartupUiUtil.isUnderDarcula(), new IconPathPatcher[]{new DeprecatedDuplicatesIconPathPatcher()}, null));
        pathTransformGlobalModCount = new AtomicInteger();
        isActivated = !GraphicsEnvironment.isHeadless();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: 
            case 36: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 65: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: 
            case 36: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patcher";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 20: 
            case 22: 
            case 24: 
            case 29: 
            case 31: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: 
            case 14: 
            case 26: 
            case 28: 
            case 30: 
            case 32: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 11: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 12: 
            case 15: 
            case 36: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/IconLoader";
                break;
            }
            case 16: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cii";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterSupplier";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handleNotFound";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlProvider";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/IconLoader";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIcon";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconSnapshot";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getMenuBarIcon";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getDarkIcon";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrigin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCustomVersion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadCustomVersionOrScale";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performStrictly";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateTransform";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installPathPatcher";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePathPatcher";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReflectiveIcon";
                break;
            }
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findIcon";
                break;
            }
            case 12: 
            case 15: 
            case 36: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 65: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createNewResolverIfNeeded";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findLafIcon";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isReflectivePath";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "patchPath";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findResolvedIcon";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "toImage";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkIcon";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isGoodSize";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDisabledIcon";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "filterIcon";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getTransparentIcon";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getIconSnapshot";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getMenuBarIcon";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getDarkIcon";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "detachClassLoader";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "doResolve";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "findUrl";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createLazy";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getOrigin";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getScaleContextSupport";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 12: 
            case 15: 
            case 36: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: 
            case 65: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LabelHolder {
        private static final JComponent fakeComponent = new JComponent(){};

        private LabelHolder() {
        }
    }

    @ApiStatus.Internal
    public static abstract class LazyIcon
    extends ScaleContextSupport
    implements CopyableIcon,
    RetrievableIcon {
        private boolean myWasComputed;
        private volatile Icon myIcon;
        private int myTransformModCount = pathTransformGlobalModCount.get();

        @Deprecated
        public LazyIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.updateScaleContext(ScaleContext.create((Graphics2D)g))) {
                this.myIcon = null;
            }
            Icon icon2 = this.getOrComputeIcon();
            icon2.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            Icon icon2 = this.getOrComputeIcon();
            return icon2.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            Icon icon2 = this.getOrComputeIcon();
            return icon2.getIconHeight();
        }

        @NotNull
        final synchronized Icon getOrComputeIcon() {
            Icon icon2 = this.myIcon;
            int newTransformModCount = pathTransformGlobalModCount.get();
            if (icon2 == null || !this.myWasComputed || this.myTransformModCount != newTransformModCount) {
                this.myTransformModCount = newTransformModCount;
                this.myWasComputed = true;
                try {
                    icon2 = this.compute();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Cannot compute icon", e);
                    icon2 = IconManager.getInstance().getStubIcon();
                }
                this.myIcon = icon2;
            }
            Icon icon3 = icon2;
            if (icon3 == null) {
                LazyIcon.$$$reportNull$$$0(0);
            }
            return icon3;
        }

        public final void load() {
            this.getIconWidth();
        }

        @NotNull
        protected abstract Icon compute();

        @Override
        @NotNull
        public Icon retrieveIcon() {
            return this.getOrComputeIcon();
        }

        @Override
        @NotNull
        public Icon copy() {
            Icon icon2 = IconLoader.copy(this.getOrComputeIcon(), null, false);
            if (icon2 == null) {
                LazyIcon.$$$reportNull$$$0(1);
            }
            return icon2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/util/IconLoader$LazyIcon";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrComputeIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    @ApiStatus.Internal
    static enum HandleNotFound {
        THROW_EXCEPTION{

            @Override
            void handle(@NotNull String msg) {
                if (msg == null) {
                    1.$$$reportNull$$$0(0);
                }
                throw new RuntimeException(msg);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/openapi/util/IconLoader$HandleNotFound$1", "handle"));
            }
        }
        ,
        LOG_ERROR{

            @Override
            void handle(@NotNull String msg) {
                if (msg == null) {
                    2.$$$reportNull$$$0(0);
                }
                LOG.error(msg);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/openapi/util/IconLoader$HandleNotFound$2", "handle"));
            }
        }
        ,
        IGNORE;


        void handle(@NotNull String msg) throws RuntimeException {
            if (msg == null) {
                HandleNotFound.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "com/intellij/openapi/util/IconLoader$HandleNotFound", "handle"));
        }
    }

    private static final class ScaledIconCache {
        private static final int SCALED_ICONS_CACHE_LIMIT = 5;
        private final CachedImageIcon host;
        private final Map<Long, SoftReference<ImageIcon>> cache;

        private ScaledIconCache(@NotNull CachedImageIcon host) {
            if (host == null) {
                ScaledIconCache.$$$reportNull$$$0(0);
            }
            this.cache = Collections.synchronizedMap(new FixedHashMap(5));
            this.host = host;
        }

        private static long key(@NotNull ScaleContext context2) {
            if (context2 == null) {
                ScaledIconCache.$$$reportNull$$$0(1);
            }
            return (long)Float.floatToIntBits((float)context2.getScale(DerivedScaleType.EFF_USR_SCALE)) << 32 | (long)Float.floatToIntBits((float)context2.getScale(ScaleType.SYS_SCALE)) & 0xFFFFFFFFL;
        }

        ImageIcon getOrScaleIcon(float scale) {
            long cacheKey;
            ImageIcon icon2;
            ScaleContext scaleContext = (ScaleContext)this.host.getScaleContext();
            if (scale != 1.0f) {
                scaleContext = (ScaleContext)scaleContext.copy();
                scaleContext.setScale(ScaleType.OBJ_SCALE.of(scale));
            }
            if ((icon2 = (ImageIcon)SoftReference.dereference(this.cache.get(cacheKey = ScaledIconCache.key(scaleContext)))) != null && !SVGLoader.isColorRedefinitionContext()) {
                return icon2;
            }
            Image image = this.host.loadImage(scaleContext, this.host.isDark());
            if (image == null) {
                return null;
            }
            icon2 = IconLoader.checkIcon(image, this.host);
            if (icon2 != null && !ImageLoader.ImageCache.isIconTooLargeForCache(icon2)) {
                this.cache.put(cacheKey, new SoftReference<ImageIcon>(icon2));
            }
            return icon2;
        }

        public void clear() {
            this.cache.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/IconLoader$ScaledIconCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "key";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class CachedImageIcon
    extends ScaleContextSupport
    implements CopyableIcon,
    ScalableIcon,
    DarkIconProvider,
    MenuBarIconProvider {
        public static final ImageIcon EMPTY_ICON = new ImageIcon(new BufferedImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
        @Nullable
        private final String originalPath;
        @Nullable
        private volatile ImageDataLoader resolver;
        @Nullable
        private final ImageDataLoader originalResolver;
        @Nullable(value="when not overridden")
        private final @Nullable(value="when not overridden") Boolean isDarkOverridden;
        private int pathTransformModCount;
        @Nullable
        private final Supplier<? extends RGBImageFilter> localFilterSupplier;
        private final ScaledIconCache scaledIconCache;
        private volatile CachedImageIcon darkVariant;
        private final Object lock;
        @Nullable
        private volatile Object realIcon;

        public CachedImageIcon(@NotNull URL url, boolean useCacheOnLoad) {
            if (url == null) {
                CachedImageIcon.$$$reportNull$$$0(0);
            }
            this(null, new ImageDataByUrlLoader(url, null, useCacheOnLoad), null, null);
            this.pathTransformModCount = pathTransformGlobalModCount.get();
        }

        public CachedImageIcon(@Nullable String originalPath, @Nullable ImageDataLoader resolver, @Nullable Boolean darkOverridden, @Nullable Supplier<? extends RGBImageFilter> localFilterSupplier) {
            this.pathTransformModCount = -1;
            this.scaledIconCache = new ScaledIconCache(this);
            this.lock = new Object();
            this.originalPath = originalPath;
            this.resolver = resolver;
            this.originalResolver = resolver;
            this.isDarkOverridden = darkOverridden;
            this.localFilterSupplier = localFilterSupplier;
            ((ScaleContext)this.getScaleContext()).addUpdateListener(() -> {
                this.realIcon = null;
            });
        }

        @Nullable
        private static ImageIcon unwrapIcon(Object icon2) {
            if (icon2 == null) {
                return null;
            }
            if (icon2 instanceof Reference) {
                return (ImageIcon)((Reference)icon2).get();
            }
            return (ImageIcon)icon2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = g instanceof Graphics2D ? (Graphics2D)g : null;
            ScaleContext scaleContext = ScaleContext.create(g2d);
            if (SVGLoader.isColorRedefinitionContext()) {
                ImageIcon result2 = null;
                Object object = this.lock;
                synchronized (object) {
                    ImageIcon icon2 = this.scaledIconCache.getOrScaleIcon(1.0f);
                    if (icon2 != null) {
                        result2 = icon2;
                    }
                }
                if (result2 == null) {
                    result2 = EMPTY_ICON;
                }
                result2.paintIcon(c, g, x, y);
                this.scaledIconCache.clear();
            } else {
                this.getRealIcon(scaleContext).paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon(null).getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon(null).getIconHeight();
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @ApiStatus.Internal
        @NotNull
        public final ImageIcon getRealIcon() {
            return this.getRealIcon(null);
        }

        @TestOnly
        @Nullable
        public final ImageIcon doGetRealIcon() {
            return CachedImageIcon.unwrapIcon(this.realIcon);
        }

        @Nullable
        public final String getOriginalPath() {
            return this.originalPath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        private ImageIcon getRealIcon(@Nullable ScaleContext context2) {
            Object object;
            Object realIcon;
            ImageDataLoader resolver = this.resolver;
            if (resolver == null || !isActivated) {
                ImageIcon imageIcon = EMPTY_ICON;
                if (imageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(1);
                }
                return imageIcon;
            }
            if (pathTransformGlobalModCount.get() == this.pathTransformModCount) {
                realIcon = this.realIcon;
            } else {
                object = this.lock;
                synchronized (object) {
                    resolver = this.resolver = this.originalResolver;
                    if (resolver == null) {
                        ImageIcon imageIcon = EMPTY_ICON;
                        // MONITOREXIT @DISABLED, blocks:[18, 19, 5] lbl15 : MonitorExitStatement: MONITOREXIT : var4_4
                        if (imageIcon == null) {
                            CachedImageIcon.$$$reportNull$$$0(2);
                        }
                        return imageIcon;
                    }
                    if (pathTransformGlobalModCount.get() == this.pathTransformModCount) {
                        realIcon = this.realIcon;
                    } else {
                        this.pathTransformModCount = pathTransformGlobalModCount.get();
                        realIcon = null;
                        this.realIcon = null;
                        this.scaledIconCache.clear();
                        if (this.originalPath != null && (resolver = resolver.patch(this.originalPath, pathTransform.get())) != null) {
                            this.resolver = resolver;
                        }
                    }
                }
            }
            object = this.lock;
            synchronized (object) {
                ImageIcon icon2;
                if (!this.updateScaleContext(context2) && realIcon != null && (icon2 = CachedImageIcon.unwrapIcon(realIcon)) != null) {
                    ImageIcon imageIcon = icon2;
                    // MONITOREXIT @DISABLED, blocks:[6, 13] lbl33 : MonitorExitStatement: MONITOREXIT : var4_4
                    if (imageIcon == null) {
                        CachedImageIcon.$$$reportNull$$$0(3);
                    }
                    return imageIcon;
                }
                icon2 = this.scaledIconCache.getOrScaleIcon(1.0f);
                if (icon2 != null) {
                    if (!SVGLoader.isColorRedefinitionContext()) {
                        this.realIcon = icon2.getIconWidth() < 50 && icon2.getIconHeight() < 50 ? icon2 : new SoftReference<ImageIcon>(icon2);
                    } else {
                        this.scaledIconCache.clear();
                    }
                    ImageIcon imageIcon = icon2;
                    // MONITOREXIT @DISABLED, blocks:[6, 11] lbl44 : MonitorExitStatement: MONITOREXIT : var4_4
                    if (imageIcon == null) {
                        CachedImageIcon.$$$reportNull$$$0(4);
                    }
                    return imageIcon;
                }
            }
            ImageIcon imageIcon = EMPTY_ICON;
            if (imageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(5);
            }
            return imageIcon;
        }

        public final String toString() {
            ImageDataLoader resolver = this.resolver;
            if (resolver != null) {
                return resolver.toString();
            }
            return this.originalPath != null ? this.originalPath : "unknown path";
        }

        @Override
        @NotNull
        public final Icon scale(float scale) {
            if (scale == 1.0f) {
                CachedImageIcon cachedImageIcon = this;
                if (cachedImageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(6);
                }
                return cachedImageIcon;
            }
            this.getRealIcon();
            ImageIcon icon2 = this.scaledIconCache.getOrScaleIcon(scale);
            Icon icon3 = icon2 == null ? this : icon2;
            if (icon3 == null) {
                CachedImageIcon.$$$reportNull$$$0(7);
            }
            return icon3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public final Icon getDarkIcon(boolean isDark) {
            ImageDataLoader resolver = this.resolver;
            if (resolver == null) {
                ImageIcon imageIcon = EMPTY_ICON;
                if (imageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(8);
                }
                return imageIcon;
            }
            CachedImageIcon result2 = this.darkVariant;
            if (result2 == null) {
                Object object = this.lock;
                synchronized (object) {
                    result2 = this.darkVariant;
                    if (result2 == null) {
                        this.darkVariant = result2 = new CachedImageIcon(this.originalPath, resolver, isDark, this.localFilterSupplier);
                    }
                }
            }
            CachedImageIcon cachedImageIcon = result2;
            if (cachedImageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(9);
            }
            return cachedImageIcon;
        }

        @Override
        @NotNull
        public final Icon getMenuBarIcon(boolean isDark) {
            boolean useMRI = SystemInfoRt.isMac;
            ScaleContext ctx = useMRI ? ScaleContext.create() : ScaleContext.createIdentity();
            ctx.setScale(ScaleType.USR_SCALE.of(1.0));
            Image img = this.loadImage(ctx, isDark);
            if (useMRI) {
                img = MultiResolutionImageProvider.convertFromJBImage(img);
            }
            return img == null ? this : new ImageIcon(img);
        }

        @Override
        @NotNull
        public final CachedImageIcon copy() {
            CachedImageIcon result2 = new CachedImageIcon(this.originalPath, this.resolver, this.isDarkOverridden, this.localFilterSupplier);
            result2.pathTransformModCount = this.pathTransformModCount;
            CachedImageIcon cachedImageIcon = result2;
            if (cachedImageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(10);
            }
            return cachedImageIcon;
        }

        @NotNull
        private Icon createWithFilter(@NotNull Supplier<? extends RGBImageFilter> filterSupplier) {
            ImageDataLoader resolver;
            if (filterSupplier == null) {
                CachedImageIcon.$$$reportNull$$$0(11);
            }
            if ((resolver = this.resolver) == null) {
                ImageIcon imageIcon = EMPTY_ICON;
                if (imageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(12);
                }
                return imageIcon;
            }
            return new CachedImageIcon(this.originalPath, resolver, this.isDarkOverridden, filterSupplier);
        }

        private boolean isDark() {
            return this.isDarkOverridden == null ? pathTransform.get().isDark() : this.isDarkOverridden.booleanValue();
        }

        @NotNull
        private List<ImageFilter> getFilters() {
            ImageFilter local;
            ImageFilter global = pathTransform.get().getFilter();
            ImageFilter imageFilter = local = this.localFilterSupplier == null ? null : (ImageFilter)this.localFilterSupplier.get();
            if (global != null && local != null) {
                List<ImageFilter> list = Arrays.asList(global, local);
                if (list == null) {
                    CachedImageIcon.$$$reportNull$$$0(13);
                }
                return list;
            }
            if (global != null) {
                List<ImageFilter> list = Collections.singletonList(global);
                if (list == null) {
                    CachedImageIcon.$$$reportNull$$$0(14);
                }
                return list;
            }
            List<Object> list = local == null ? Collections.emptyList() : Collections.singletonList(local);
            if (list == null) {
                CachedImageIcon.$$$reportNull$$$0(15);
            }
            return list;
        }

        @Nullable
        public final URL getURL() {
            ImageDataLoader resolver = this.resolver;
            return resolver == null ? null : resolver.getURL();
        }

        @Nullable
        public Image loadImage(@NotNull ScaleContext scaleContext, boolean isDark) {
            if (scaleContext == null) {
                CachedImageIcon.$$$reportNull$$$0(16);
            }
            long start = StartUpMeasurer.getCurrentTimeIfEnabled();
            ImageDataLoader resolver = this.resolver;
            if (resolver == null) {
                return null;
            }
            Image image = resolver.loadImage(this.getFilters(), scaleContext, isDark);
            if (start != -1L) {
                IconLoadMeasurer.findIconLoad.end(start);
            }
            return image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean detachClassLoader(@NotNull ClassLoader loader) {
            ImageDataLoader resolver;
            if (loader == null) {
                CachedImageIcon.$$$reportNull$$$0(17);
            }
            if ((resolver = this.resolver) == null) {
                return true;
            }
            Object object = this.lock;
            synchronized (object) {
                resolver = this.resolver;
                if (resolver == null) {
                    return true;
                }
                if (!resolver.isMyClassLoader(loader)) {
                    return false;
                }
                this.resolver = null;
                this.scaledIconCache.clear();
                CachedImageIcon darkVariant = this.darkVariant;
                if (darkVariant != null) {
                    this.darkVariant = null;
                    darkVariant.detachClassLoader(loader);
                }
                return true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/IconLoader$CachedImageIcon";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filterSupplier";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scaleContext";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/IconLoader$CachedImageIcon";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRealIcon";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "scale";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDarkIcon";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createWithFilter";
                    break;
                }
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createWithFilter";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "loadImage";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "detachClassLoader";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class FinalImageDataLoader
    implements ImageDataLoader {
        private final WeakReference<ClassLoader> classLoaderRef;
        private final String path;

        FinalImageDataLoader(@NotNull String path, @NotNull ClassLoader classLoader) {
            if (path == null) {
                FinalImageDataLoader.$$$reportNull$$$0(0);
            }
            if (classLoader == null) {
                FinalImageDataLoader.$$$reportNull$$$0(1);
            }
            this.path = path;
            this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
        }

        @Override
        @Nullable
        public Image loadImage(@NotNull List<? extends ImageFilter> filters, @NotNull ScaleContext scaleContext, boolean isDark) {
            ClassLoader classLoader;
            if (filters == null) {
                FinalImageDataLoader.$$$reportNull$$$0(2);
            }
            if (scaleContext == null) {
                FinalImageDataLoader.$$$reportNull$$$0(3);
            }
            int flags = 1;
            if (isDark) {
                flags |= 4;
            }
            if ((classLoader = (ClassLoader)this.classLoaderRef.get()) == null) {
                return null;
            }
            return ImageLoader.loadImage(this.path, filters, null, classLoader, flags, scaleContext, !this.path.endsWith(".svg"));
        }

        @Override
        @Nullable
        public URL getURL() {
            ClassLoader classLoader = (ClassLoader)this.classLoaderRef.get();
            return classLoader == null ? null : classLoader.getResource(this.path);
        }

        @Override
        @Nullable
        public ImageDataLoader patch(@NotNull String originalPath, @NotNull IconTransform transform2) {
            if (originalPath == null) {
                FinalImageDataLoader.$$$reportNull$$$0(4);
            }
            if (transform2 == null) {
                FinalImageDataLoader.$$$reportNull$$$0(5);
            }
            return null;
        }

        @Override
        public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
            if (classLoader == null) {
                FinalImageDataLoader.$$$reportNull$$$0(6);
            }
            return this.classLoaderRef.get() == classLoader;
        }

        public String toString() {
            return "FinalImageDataLoader(, classLoader=" + this.classLoaderRef.get() + ", path='" + this.path + "')";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classLoader";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scaleContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalPath";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transform";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/util/IconLoader$FinalImageDataLoader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadImage";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "patch";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMyClassLoader";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

