/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SimpleTimerTask;
import javax.swing.SwingUtilities;

public class TimedOutCallback
extends ActionCallback
implements Runnable {
    private static final Logger LOG = Logger.getInstance(TimedOutCallback.class);
    private Throwable myAllocation;
    private String myMessage;
    private SimpleTimerTask myTask;
    private boolean myShouldDumpError;

    public TimedOutCallback(long timeOut, String message2, Throwable allocation, boolean isEdt) {
        this.scheduleCheck(timeOut, message2, allocation, isEdt);
    }

    public TimedOutCallback(int countToDone, long timeOut, String message2, Throwable allocation, boolean isEdt) {
        super(countToDone);
        this.scheduleCheck(timeOut, message2, allocation, isEdt);
    }

    private void scheduleCheck(long timeOut, String message2, Throwable allocation, boolean isEdt) {
        this.myMessage = message2;
        this.myAllocation = allocation;
        long current2 = System.currentTimeMillis();
        this.myTask = SimpleTimer.getInstance().setUp(() -> {
            boolean bl = this.myShouldDumpError = System.currentTimeMillis() - current2 > timeOut;
            if (isEdt) {
                SwingUtilities.invokeLater(this);
            } else {
                this.run();
            }
        }, timeOut);
    }

    @Override
    public final void run() {
        if (!this.isProcessed()) {
            this.setRejected();
            if (this.myShouldDumpError) {
                this.dumpError();
            }
            this.onTimeout();
        }
    }

    protected void dumpError() {
        if (this.myAllocation != null) {
            LOG.error(this.myMessage, this.myAllocation);
        } else {
            LOG.error(this.myMessage);
        }
    }

    public String getMessage() {
        return this.myMessage;
    }

    public Throwable getAllocation() {
        return this.myAllocation;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myTask.cancel();
    }

    protected void onTimeout() {
    }
}

