/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependenciesBuilder;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForwardDependenciesBuilder
extends DependenciesBuilder {
    private final Map<PsiFile, Set<PsiFile>> myDirectDependencies;
    private final int myTransitive;
    @Nullable
    private final GlobalSearchScope myTargetScope;
    private final Set<VirtualFile> myStarted;

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(1);
        }
        super(project, scope);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myStarted = new HashSet<VirtualFile>();
        this.myTransitive = 0;
        this.myTargetScope = null;
    }

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope, @Nullable GlobalSearchScope targetScope) {
        if (project == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(3);
        }
        super(project, scope);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myStarted = new HashSet<VirtualFile>();
        this.myTargetScope = targetScope;
        this.myTransitive = 0;
    }

    public ForwardDependenciesBuilder(@NotNull Project project, @NotNull AnalysisScope scope, int transitive) {
        if (project == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(5);
        }
        super(project, scope);
        this.myDirectDependencies = new HashMap<PsiFile, Set<PsiFile>>();
        this.myStarted = new HashSet<VirtualFile>();
        this.myTransitive = transitive;
        this.myTargetScope = null;
    }

    @Override
    public String getRootNodeNameInUsageView() {
        return AnalysisBundle.message("forward.dependencies.usage.view.root.node.text", new Object[0]);
    }

    @Override
    public String getInitialUsagesPosition() {
        return AnalysisBundle.message("forward.dependencies.usage.view.initial.text", new Object[0]);
    }

    @Override
    public boolean isBackward() {
        return false;
    }

    @Override
    public void analyze() {
        final PsiManager psiManager = PsiManager.getInstance(this.getProject());
        psiManager.runInBatchFilesMode(() -> {
            final ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.getProject()).getFileIndex();
            this.getScope().acceptIdempotentVisitor(new PsiRecursiveElementVisitor(){

                @Override
                public void visitFile(@NotNull PsiFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ForwardDependenciesBuilder.this.visit(file2, fileIndex, psiManager);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/packageDependencies/ForwardDependenciesBuilder$1", "visitFile"));
                }
            });
            return null;
        });
    }

    private void visit(@NotNull PsiFile file2, @NotNull ProjectFileIndex fileIndex, @NotNull PsiManager psiManager) {
        FileViewProvider viewProvider;
        if (file2 == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(6);
        }
        if (fileIndex == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(7);
        }
        if (psiManager == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(8);
        }
        if ((viewProvider = file2.getViewProvider()).getBaseLanguage() != file2.getLanguage()) {
            return;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (indicator != null) {
            if (indicator.isCanceled()) {
                throw new ProcessCanceledException();
            }
            indicator.setText(AnalysisBundle.message("package.dependencies.progress.text", new Object[0]));
            if (virtualFile != null) {
                indicator.setText2(this.getRelativeToProjectPath(virtualFile));
            }
            if (this.myTotalFileCount > 0 && this.myStarted.add(virtualFile)) {
                indicator.setFraction((double)(++this.myFileCount) / (double)this.myTotalFileCount);
            }
        }
        boolean isInLibrary = virtualFile == null || fileIndex.isInLibrary(virtualFile);
        HashSet<PsiFile> collectedDeps = new HashSet<PsiFile>();
        collectedDeps.add(file2);
        int depth = 0;
        HashSet<PsiFile> processed = new HashSet<PsiFile>();
        do {
            if (depth++ > this.getTransitiveBorder()) {
                return;
            }
            for (PsiFile psiFile : new HashSet(collectedDeps)) {
                VirtualFile vFile = psiFile.getVirtualFile();
                if (vFile != null) {
                    if (indicator != null) {
                        indicator.setText2(this.getRelativeToProjectPath(vFile));
                    }
                    if (!isInLibrary && fileIndex.isInLibrary(vFile)) {
                        processed.add(psiFile);
                    }
                }
                if (!processed.add(psiFile)) continue;
                HashSet found = new HashSet();
                ForwardDependenciesBuilder.analyzeFileDependencies(psiFile, (place, dependency) -> {
                    PsiFile dependencyFile = dependency.getContainingFile();
                    if (dependencyFile != null) {
                        VirtualFile depFile;
                        if (viewProvider == dependencyFile.getViewProvider()) {
                            return;
                        }
                        if (dependencyFile.isPhysical() && (depFile = dependencyFile.getVirtualFile()) != null && (fileIndex.isInContent(depFile) || fileIndex.isInLibrary(depFile)) && (this.myTargetScope == null || this.myTargetScope.contains(depFile))) {
                            PsiElement navigationElement = dependencyFile.getNavigationElement();
                            found.add(navigationElement instanceof PsiFile ? (PsiFile)navigationElement : dependencyFile);
                        }
                    }
                });
                Set deps = this.getDependencies().computeIfAbsent(file2, __ -> new HashSet());
                deps.addAll(found);
                this.getDirectDependencies().put(psiFile, new HashSet(found));
                collectedDeps.addAll(found);
                psiManager.dropResolveCaches();
                InjectedLanguageManager.getInstance(file2.getProject()).dropFileCaches(psiFile);
            }
            collectedDeps.removeAll(processed);
        } while (this.isTransitive() && !collectedDeps.isEmpty());
    }

    @Override
    @NotNull
    public Map<PsiFile, Set<PsiFile>> getDirectDependencies() {
        Map<PsiFile, Set<PsiFile>> map2 = this.myDirectDependencies;
        if (map2 == null) {
            ForwardDependenciesBuilder.$$$reportNull$$$0(9);
        }
        return map2;
    }

    private boolean isTransitive() {
        return this.myTransitive > 0;
    }

    public int getTransitiveBorder() {
        return this.myTransitive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileIndex";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packageDependencies/ForwardDependenciesBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packageDependencies/ForwardDependenciesBuilder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 9: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

