/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.ide.highlighter.custom.CustomFileTypeLexer;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.lang.Language;
import com.intellij.lang.cacheBuilder.CacheBuilderRegistry;
import com.intellij.lang.cacheBuilder.DefaultWordsScanner;
import com.intellij.lang.cacheBuilder.SimpleWordsScanner;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdIndexers;
import com.intellij.psi.impl.cache.impl.id.ScanningIdIndexer;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdTableBuilding {
    private IdTableBuilding() {
    }

    @Nullable
    public static IdIndexer getFileTypeIndexer(final FileType fileType) {
        IdIndexer extIndexer = IdTableBuilding.getIndexer(fileType);
        if (extIndexer != null) {
            return extIndexer;
        }
        WordsScanner customWordsScanner = CacheBuilderRegistry.getInstance().getCacheBuilder(fileType);
        if (customWordsScanner != null) {
            return IdTableBuilding.createDefaultIndexer(customWordsScanner);
        }
        if (fileType instanceof LanguageFileType) {
            Language lang = ((LanguageFileType)fileType).getLanguage();
            WordsScanner scanner = LanguageFindUsages.getWordsScanner(lang);
            if (scanner == null) {
                scanner = new SimpleWordsScanner();
            }
            return IdTableBuilding.createDefaultIndexer(scanner);
        }
        if (fileType instanceof CustomSyntaxTableFileType) {
            return new ScanningIdIndexer(){

                @Override
                protected WordsScanner createScanner() {
                    return IdTableBuilding.createCustomFileTypeScanner(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
                }
            };
        }
        return null;
    }

    private static IdIndexer getIndexer(@NotNull FileType fileType) {
        if (fileType == null) {
            IdTableBuilding.$$$reportNull$$$0(0);
        }
        if (fileType == PlainTextFileType.INSTANCE && FileBasedIndex.IGNORE_PLAIN_TEXT_FILES) {
            return null;
        }
        return (IdIndexer)IdIndexers.INSTANCE.forFileType(fileType);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static IdIndexer createDefaultIndexer(final @NotNull WordsScanner scanner) {
        if (scanner == null) {
            IdTableBuilding.$$$reportNull$$$0(1);
        }
        return new ScanningIdIndexer(){

            @Override
            protected WordsScanner createScanner() {
                return scanner;
            }
        };
    }

    @Contract(value="_ -> new")
    @NotNull
    public static WordsScanner createCustomFileTypeScanner(@NotNull SyntaxTable syntaxTable) {
        if (syntaxTable == null) {
            IdTableBuilding.$$$reportNull$$$0(2);
        }
        return new DefaultWordsScanner(new CustomFileTypeLexer(syntaxTable, true), TokenSet.create(CustomHighlighterTokenType.IDENTIFIER), TokenSet.create(CustomHighlighterTokenType.LINE_COMMENT, CustomHighlighterTokenType.MULTI_LINE_COMMENT), TokenSet.create(CustomHighlighterTokenType.STRING, CustomHighlighterTokenType.SINGLE_QUOTED_STRING));
    }

    public static void scanWords(ScanWordProcessor processor, CharSequence chars, int startOffset, int endOffset) {
        IdTableBuilding.scanWords(processor, chars, CharArrayUtil.fromSequenceWithoutCopying(chars), startOffset, endOffset, false);
    }

    public static void scanWords(ScanWordProcessor processor, CharSequence chars, char @Nullable [] charArray, int startOffset, int endOffset, boolean mayHaveEscapes) {
        boolean hasArray;
        int index2 = startOffset;
        boolean bl = hasArray = charArray != null;
        while (index2 < endOffset) {
            char c;
            char c2 = c = hasArray ? charArray[index2] : chars.charAt(index2);
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || Character.isJavaIdentifierStart(c) && c != '$')) {
                ++index2;
                if (!mayHaveEscapes || c != '\\') continue;
                ++index2;
                continue;
            }
            int index1 = index2;
            while (++index2 < endOffset) {
                char c3;
                char c4 = c3 = hasArray ? charArray[index2] : chars.charAt(index2);
                if (c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z' || c3 >= '0' && c3 <= '9' || Character.isJavaIdentifierPart(c3) && c3 != '$') continue;
                break;
            }
            if (index2 - index1 > 100) continue;
            processor.run(chars, charArray, index1, index2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scanner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxTable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdTableBuilding";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createDefaultIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomFileTypeScanner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ScanWordProcessor {
        public void run(CharSequence var1, char @Nullable [] var2, int var3, int var4);
    }
}

