/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file.impl;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileResolveScopeProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveScopeEnlarger;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ResolveScopeManagerImpl
extends ResolveScopeManager
implements Disposable {
    private final Project myProject;
    private final ProjectRootManager myProjectRootManager;
    private final PsiManager myManager;
    private final Map<VirtualFile, GlobalSearchScope> myDefaultResolveScopesCache;
    private final AdditionalIndexableFileSet myAdditionalIndexableFileSet;

    public ResolveScopeManagerImpl(Project project) {
        this.myProject = project;
        this.myProjectRootManager = ProjectRootManager.getInstance(project);
        this.myManager = PsiManager.getInstance(project);
        this.myAdditionalIndexableFileSet = new AdditionalIndexableFileSet(project);
        this.myDefaultResolveScopesCache = ConcurrentFactoryMap.create(this::createScopeByFile, ContainerUtil::createConcurrentWeakKeySoftValueMap);
        this.myProject.getMessageBus().connect(this).subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                if (isPhysical) {
                    ResolveScopeManagerImpl.this.myDefaultResolveScopesCache.clear();
                }
            }
        });
        ResolveScopeProvider.EP_NAME.addChangeListener(() -> this.myDefaultResolveScopesCache.clear(), this);
        ResolveScopeEnlarger.EP_NAME.addChangeListener(() -> this.myDefaultResolveScopesCache.clear(), this);
    }

    @NotNull
    private GlobalSearchScope createScopeByFile(@NotNull VirtualFile key) {
        ResolveScopeProvider resolveScopeProvider;
        VirtualFile original;
        if (key == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(0);
        }
        VirtualFile file2 = key;
        VirtualFile virtualFile = original = key instanceof LightVirtualFile ? ((LightVirtualFile)key).getOriginalFile() : null;
        if (original != null) {
            file2 = original;
        }
        GlobalSearchScope scope = null;
        ResolveScopeEnlarger[] resolveScopeEnlargerArray = ResolveScopeProvider.EP_NAME.getExtensionList().iterator();
        while (resolveScopeEnlargerArray.hasNext() && (scope = (resolveScopeProvider = resolveScopeEnlargerArray.next()).getResolveScope(file2, this.myProject)) == null) {
        }
        if (scope == null) {
            scope = this.getInherentResolveScope(file2);
        }
        for (ResolveScopeEnlarger enlarger : ResolveScopeEnlarger.EP_NAME.getExtensions()) {
            SearchScope extra = enlarger.getAdditionalResolveScope(file2, this.myProject);
            if (extra == null) continue;
            scope = scope.union(extra);
        }
        if (original != null && !scope.contains(key)) {
            scope = scope.union(GlobalSearchScope.fileScope(this.myProject, key));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope getResolveScopeFromProviders(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(2);
        }
        GlobalSearchScope globalSearchScope = this.myDefaultResolveScopesCache.get(vFile);
        if (globalSearchScope == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope getInherentResolveScope(@NotNull VirtualFile vFile) {
        ProjectFileIndex projectFileIndex;
        Module module;
        if (vFile == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(4);
        }
        if ((module = (projectFileIndex = this.myProjectRootManager.getFileIndex()).getModuleForFile(vFile)) != null) {
            boolean includeTests = TestSourcesFilter.isTestSources(vFile, this.myProject);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module, includeTests);
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }
        if (!projectFileIndex.isInLibrary(vFile)) {
            GlobalSearchScope allScope = GlobalSearchScope.allScope(this.myProject);
            if (!allScope.contains(vFile)) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope(this.myProject, vFile).uniteWith(allScope);
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(6);
                }
                return globalSearchScope;
            }
            GlobalSearchScope globalSearchScope = allScope;
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(7);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = LibraryScopeCache.getInstance(this.myProject).getLibraryScope(projectFileIndex.getOrderEntriesForFile(vFile));
        if (globalSearchScope == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(8);
        }
        return globalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        PsiElement context2;
        GlobalSearchScope forcedScope;
        if (element == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(9);
        }
        ProgressIndicatorProvider.checkCanceled();
        if (element instanceof PsiDirectory) {
            return this.getResolveScopeFromProviders(((PsiDirectory)element).getVirtualFile());
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof PsiCodeFragment && (forcedScope = ((PsiCodeFragment)containingFile).getForcedResolveScope()) != null) {
            GlobalSearchScope globalSearchScope = forcedScope;
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(10);
            }
            return globalSearchScope;
        }
        if (containingFile != null && (context2 = containingFile.getContext()) != null) {
            GlobalSearchScope globalSearchScope = this.withFile(containingFile, this.getResolveScope(context2));
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(11);
            }
            return globalSearchScope;
        }
        if (containingFile == null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.myProject);
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(12);
            }
            return globalSearchScope;
        }
        GlobalSearchScope scope = this.getPsiFileResolveScope(containingFile);
        ModelBranch branch = ModelBranch.getPsiBranch(containingFile);
        GlobalSearchScope globalSearchScope = branch != null ? ((ModelBranchImpl)branch).modifyScope(scope) : scope;
        if (globalSearchScope == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope getPsiFileResolveScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(14);
        }
        if (psiFile instanceof FileResolveScopeProvider) {
            GlobalSearchScope globalSearchScope = ((FileResolveScopeProvider)((Object)psiFile)).getFileResolveScope();
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(15);
            }
            return globalSearchScope;
        }
        if (!psiFile.getOriginalFile().isPhysical() && !psiFile.getViewProvider().isPhysical()) {
            GlobalSearchScope globalSearchScope = this.withFile(psiFile, GlobalSearchScope.allScope(this.myProject));
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(16);
            }
            return globalSearchScope;
        }
        return this.getResolveScopeFromProviders(psiFile.getViewProvider().getVirtualFile());
    }

    private GlobalSearchScope withFile(PsiFile containingFile, GlobalSearchScope scope) {
        return PsiSearchScopeUtil.isInScope(scope, (PsiElement)containingFile) ? scope : scope.uniteWith(GlobalSearchScope.fileScope(this.myProject, containingFile.getViewProvider().getVirtualFile()));
    }

    @Override
    @NotNull
    public GlobalSearchScope getDefaultResolveScope(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(17);
        }
        PsiFile psiFile = this.myManager.findFile(vFile);
        assert (psiFile != null) : "directory=" + vFile.isDirectory() + "; " + this.myProject + "; vFile=" + vFile + "; type=" + vFile.getFileType();
        return this.getResolveScopeFromProviders(vFile);
    }

    @Override
    @NotNull
    public GlobalSearchScope getUseScope(@NotNull PsiElement element) {
        VirtualFile notNullVFile;
        PsiFile containingFile;
        VirtualFile virtualFile;
        VirtualFile vDirectory;
        if (element == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(18);
        }
        GlobalSearchScope allScope = GlobalSearchScope.allScope(this.myManager.getProject());
        if (element instanceof PsiDirectory) {
            vDirectory = ((PsiDirectory)element).getVirtualFile();
            virtualFile = null;
            containingFile = null;
        } else {
            containingFile = element.getContainingFile();
            if (containingFile == null) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(19);
                }
                return globalSearchScope;
            }
            virtualFile = containingFile.getVirtualFile();
            if (virtualFile == null) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(20);
                }
                return globalSearchScope;
            }
            if (virtualFile instanceof VirtualFileWindow) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope(this.myProject, ((VirtualFileWindow)((Object)virtualFile)).getDelegate());
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(21);
                }
                return globalSearchScope;
            }
            if (ScratchUtil.isScratch(virtualFile)) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope(this.myProject, virtualFile);
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(22);
                }
                return globalSearchScope;
            }
            vDirectory = virtualFile.getParent();
        }
        if (vDirectory == null) {
            GlobalSearchScope globalSearchScope = allScope;
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(23);
            }
            return globalSearchScope;
        }
        ProjectFileIndex projectFileIndex = this.myProjectRootManager.getFileIndex();
        Module module = projectFileIndex.getModuleForFile(notNullVFile = virtualFile != null ? virtualFile : vDirectory);
        if (module == null) {
            List<OrderEntry> entries = projectFileIndex.getOrderEntriesForFile(notNullVFile);
            if (entries.isEmpty() && (this.myAdditionalIndexableFileSet.isInSet(notNullVFile) || this.isFromAdditionalLibraries(notNullVFile))) {
                GlobalSearchScope globalSearchScope = allScope;
                if (globalSearchScope == null) {
                    ResolveScopeManagerImpl.$$$reportNull$$$0(24);
                }
                return globalSearchScope;
            }
            GlobalSearchScope result2 = LibraryScopeCache.getInstance(this.myProject).getLibraryUseScope(entries);
            GlobalSearchScope globalSearchScope = containingFile == null || virtualFile.isDirectory() || result2.contains(virtualFile) ? result2 : GlobalSearchScope.fileScope(containingFile).uniteWith(result2);
            if (globalSearchScope == null) {
                ResolveScopeManagerImpl.$$$reportNull$$$0(25);
            }
            return globalSearchScope;
        }
        boolean isTest = TestSourcesFilter.isTestSources(vDirectory, this.myProject);
        GlobalSearchScope globalSearchScope = isTest ? GlobalSearchScope.moduleTestsWithDependentsScope(module) : GlobalSearchScope.moduleWithDependentsScope(module);
        if (globalSearchScope == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(26);
        }
        return globalSearchScope;
    }

    private boolean isFromAdditionalLibraries(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ResolveScopeManagerImpl.$$$reportNull$$$0(27);
        }
        for (AdditionalLibraryRootsProvider provider : AdditionalLibraryRootsProvider.EP_NAME.getExtensionList()) {
            for (SyntheticLibrary library2 : provider.getAdditionalProjectLibraries(this.myProject)) {
                if (!library2.contains(file2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl";
                break;
            }
            case 2: 
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/file/impl/ResolveScopeManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeByFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScopeFromProviders";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInherentResolveScope";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFileResolveScope";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createScopeByFile";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScopeFromProviders";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInherentResolveScope";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFileResolveScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResolveScope";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isFromAdditionalLibraries";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

