/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IdempotenceChecker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import com.intellij.util.messages.MessageBus;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveCache
implements Disposable {
    private final AtomicReferenceArray<Map<?, ?>> myPhysicalMaps;
    private final AtomicReferenceArray<Map<?, ?>> myNonPhysicalMaps;
    private static final Object NULL_RESULT = ObjectUtils.sentinel("ResolveCache.NULL_RESULT");
    private static final StrongValueReference<?, ?> NULL_VALUE_REFERENCE = new StrongValueReference(NULL_RESULT);
    private static final StrongValueReference<?, ?> EMPTY_RESOLVE_RESULT = new StrongValueReference(ResolveResult.EMPTY_ARRAY);

    public static ResolveCache getInstance(@NotNull Project project) {
        if (project == null) {
            ResolveCache.$$$reportNull$$$0(0);
        }
        ProgressIndicatorProvider.checkCanceled();
        return project.getService(ResolveCache.class);
    }

    public ResolveCache(@NotNull Project project) {
        if (project == null) {
            ResolveCache.$$$reportNull$$$0(1);
        }
        this.myPhysicalMaps = new AtomicReferenceArray(4);
        this.myNonPhysicalMaps = new AtomicReferenceArray(4);
        this.clearCacheOnPsiChange(project.getMessageBus());
        LowMemoryWatcher.register(() -> this.onLowMemory(), this);
    }

    private void clearCacheOnPsiChange(@NotNull MessageBus bus) {
        if (bus == null) {
            ResolveCache.$$$reportNull$$$0(2);
        }
        bus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ResolveCache.this.clearCache(isPhysical);
            }
        });
    }

    private void onLowMemory() {
        ResolveCache.clearArray(this.myPhysicalMaps);
        ResolveCache.clearArray(this.myNonPhysicalMaps);
    }

    @Override
    public void dispose() {
    }

    @NotNull
    private static <K, V> Map<K, V> createWeakMap() {
        return new ConcurrentWeakKeySoftValueHashMap<K, V>(100, 0.75f, Runtime.getRuntime().availableProcessors()){

            @Override
            @NotNull
            protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(@NotNull V value, @NotNull ReferenceQueue<? super V> queue) {
                if (value == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (queue == null) {
                    2.$$$reportNull$$$0(1);
                }
                ConcurrentWeakKeySoftValueHashMap.ValueReference result2 = value == NULL_RESULT || value instanceof Object[] && ((Object[])value).length == 0 ? ResolveCache.createStrongReference(value) : super.createValueReference(value, queue);
                StrongValueReference strongValueReference = result2;
                if (strongValueReference == null) {
                    2.$$$reportNull$$$0(2);
                }
                return strongValueReference;
            }

            @Override
            public V get(@NotNull Object key) {
                Object v;
                if (key == null) {
                    2.$$$reportNull$$$0(3);
                }
                return (v = super.get(key)) == NULL_RESULT ? null : (Object)v;
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }

            @Override
            public int hashCode() {
                return System.identityHashCode(this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "queue";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/impl/source/resolve/ResolveCache$2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/impl/source/resolve/ResolveCache$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createValueReference";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createValueReference";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "get";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public void clearCache(boolean isPhysical) {
        if (isPhysical) {
            ResolveCache.clearArray(this.myPhysicalMaps);
        }
        ResolveCache.clearArray(this.myNonPhysicalMaps);
    }

    private static void clearArray(@NotNull AtomicReferenceArray<?> array2) {
        if (array2 == null) {
            ResolveCache.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < array2.length(); ++i) {
            array2.set(i, null);
        }
    }

    @Nullable
    private <TRef extends PsiReference, TResult> TResult resolve(@NotNull TRef ref, @NotNull AbstractResolver<? super TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode, boolean isPoly, boolean isPhysical) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(4);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(5);
        }
        ProgressIndicatorProvider.checkCanceled();
        if (isPhysical) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        int index2 = ResolveCache.getIndex(incompleteCode, isPoly);
        return (TResult)ResolveCache.resolve(ref, this.getMap(isPhysical, index2), needToPreventRecursion, () -> resolver.resolve((Object)ref, incompleteCode));
    }

    public <T extends PsiPolyVariantReference> ResolveResult @NotNull [] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(6);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(7);
        }
        ResolveResult[] resolveResultArray = this.resolveWithCaching(ref, resolver, needToPreventRecursion, incompleteCode, ref.getElement().getContainingFile());
        if (resolveResultArray == null) {
            ResolveCache.$$$reportNull$$$0(8);
        }
        return resolveResultArray;
    }

    public <T extends PsiPolyVariantReference> ResolveResult @NotNull [] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        ResolveResult[] result2;
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(9);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(10);
        }
        if (containingFile == null) {
            ResolveCache.$$$reportNull$$$0(11);
        }
        ResolveResult[] resolveResultArray = (result2 = (ResolveResult[])this.resolve(ref, resolver, needToPreventRecursion, incompleteCode, true, containingFile.isPhysical())) == null ? ResolveResult.EMPTY_ARRAY : result2;
        if (resolveResultArray == null) {
            ResolveCache.$$$reportNull$$$0(12);
        }
        return resolveResultArray;
    }

    public <T extends PsiPolyVariantReference> ResolveResult @NotNull [] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantContextResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(13);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(14);
        }
        if (containingFile == null) {
            ResolveCache.$$$reportNull$$$0(15);
        }
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean physical = containingFile.isPhysical();
        int index2 = ResolveCache.getIndex(incompleteCode, true);
        Map map2 = this.getMap(physical, index2);
        ResolveResult[] results = ResolveCache.resolve(ref, map2, needToPreventRecursion, () -> resolver.resolve(ref, containingFile, incompleteCode));
        ResolveResult[] resolveResultArray = results == null ? ResolveResult.EMPTY_ARRAY : results;
        if (resolveResultArray == null) {
            ResolveCache.$$$reportNull$$$0(16);
        }
        return resolveResultArray;
    }

    @ApiStatus.Experimental
    @NotNull
    public <R extends PsiSymbolReference> @NotNull Collection<? extends @NotNull Symbol> resolveWithCaching(R ref, @NotNull PsiSymbolReferenceResolver<? super R> resolver) {
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(17);
        }
        Collection<Symbol> collection = this.resolveWithCaching(ref, true, resolver);
        if (collection == null) {
            ResolveCache.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @ApiStatus.Experimental
    @NotNull
    public <R extends PsiSymbolReference> @NotNull Collection<? extends @NotNull Symbol> resolveWithCaching(R ref, boolean preventRecursion, @NotNull PsiSymbolReferenceResolver<? super R> resolver) {
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(19);
        }
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean physical = ref.getElement().isPhysical();
        int index2 = ResolveCache.getIndex(false, true);
        Collection results = ResolveCache.resolve(ref, this.getMap(physical, index2), preventRecursion, () -> resolver.resolve((Object)ref));
        Collection<Object> collection = results == null ? Collections.emptyList() : results;
        if (collection == null) {
            ResolveCache.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @Nullable
    private static <TRef, TResult> TResult resolve(@NotNull TRef ref, @NotNull Map<TRef, TResult> cache, boolean preventRecursion, @NotNull Computable<? extends TResult> resolver) {
        TResult result2;
        TResult cachedResult;
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(21);
        }
        if (cache == null) {
            ResolveCache.$$$reportNull$$$0(22);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(23);
        }
        if ((cachedResult = cache.get(ref)) != null) {
            if (IdempotenceChecker.areRandomChecksEnabled()) {
                IdempotenceChecker.applyForRandomCheck(cachedResult, ref, ResolveCache.loggingResolver(ref, resolver));
            }
            return cachedResult;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Computable<TResult> loggingResolver = ResolveCache.loggingResolver(ref, resolver);
        TResult TResult = result2 = preventRecursion ? RecursionManager.doPreventingRecursion(Pair.create(ref, cache), true, loggingResolver) : loggingResolver.get();
        if (result2 instanceof ResolveResult) {
            ResolveCache.ensureValidPsi((ResolveResult)result2);
        } else if (result2 instanceof ResolveResult[]) {
            ResolveCache.ensureValidResults((ResolveResult[])result2);
        } else if (result2 instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)result2);
        }
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, cache, result2, loggingResolver);
        }
        return result2;
    }

    @NotNull
    private static <R> Computable<R> loggingResolver(@NotNull Object ref, @NotNull Computable<? extends R> resolver) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(24);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(25);
        }
        Computable<Object> computable = () -> {
            if (IdempotenceChecker.isLoggingEnabled()) {
                IdempotenceChecker.logTrace("Resolving " + ref + " of " + ref.getClass());
            }
            return resolver.get();
        };
        if (computable == null) {
            ResolveCache.$$$reportNull$$$0(26);
        }
        return computable;
    }

    private static void ensureValidResults(ResolveResult @NotNull [] result2) {
        if (result2 == null) {
            ResolveCache.$$$reportNull$$$0(27);
        }
        for (ResolveResult resolveResult : result2) {
            ResolveCache.ensureValidPsi(resolveResult);
        }
    }

    private static void ensureValidPsi(@NotNull ResolveResult resolveResult) {
        PsiElement element;
        if (resolveResult == null) {
            ResolveCache.$$$reportNull$$$0(28);
        }
        if ((element = resolveResult.getElement()) != null) {
            PsiUtilCore.ensureValid(element);
        }
    }

    public <T extends PsiPolyVariantReference> ResolveResult @Nullable [] getCachedResults(@NotNull T ref, boolean physical, boolean incompleteCode, boolean isPoly) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(29);
        }
        Map map2 = this.getMap(physical, ResolveCache.getIndex(incompleteCode, isPoly));
        return (ResolveResult[])map2.get(ref);
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(30);
        }
        if (resolver == null) {
            ResolveCache.$$$reportNull$$$0(31);
        }
        return this.resolve(ref, resolver, needToPreventRecursion, incompleteCode, false, ref.getElement().isPhysical());
    }

    @NotNull
    private <TRef, TResult> Map<TRef, TResult> getMap(boolean physical, int index2) {
        AtomicReferenceArray<Map<?, ?>> array2 = physical ? this.myPhysicalMaps : this.myNonPhysicalMaps;
        Map<Object, Object> map2 = array2.get(index2);
        while (map2 == null) {
            Map newMap = ResolveCache.createWeakMap();
            map2 = array2.compareAndSet(index2, null, newMap) ? newMap : array2.get(index2);
        }
        Map<?, ?> map3 = map2;
        if (map3 == null) {
            ResolveCache.$$$reportNull$$$0(32);
        }
        return map3;
    }

    private static int getIndex(boolean incompleteCode, boolean isPoly) {
        return (incompleteCode ? 0 : 1) * 2 + (isPoly ? 0 : 1);
    }

    private static <TRef, TResult> void cache(@NotNull TRef ref, @NotNull Map<? super TRef, TResult> map2, TResult result2, @NotNull Computable<TResult> doResolve) {
        Object cached;
        if (ref == null) {
            ResolveCache.$$$reportNull$$$0(33);
        }
        if (map2 == null) {
            ResolveCache.$$$reportNull$$$0(34);
        }
        if (doResolve == null) {
            ResolveCache.$$$reportNull$$$0(35);
        }
        if ((cached = map2.get(ref)) != null) {
            if (cached == result2) {
                return;
            }
            IdempotenceChecker.checkEquivalence(cached, result2, ref.getClass(), doResolve);
        }
        cached = result2 == null ? NULL_RESULT : result2;
        map2.put(ref, cached);
    }

    @NotNull
    private static <K, V> StrongValueReference<K, V> createStrongReference(@NotNull V value) {
        if (value == null) {
            ResolveCache.$$$reportNull$$$0(36);
        }
        return value == NULL_RESULT ? NULL_VALUE_REFERENCE : (value == ResolveResult.EMPTY_ARRAY ? EMPTY_RESOLVE_RESULT : new StrongValueReference(value));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 26: 
            case 32: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 26: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 13: 
            case 21: 
            case 24: 
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 19: 
            case 23: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/ResolveCache";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doResolve";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/ResolveCache";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveWithCaching";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "loggingResolver";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearCacheOnPsiChange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "clearArray";
                break;
            }
            case 4: 
            case 5: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithCaching";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 26: 
            case 32: {
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loggingResolver";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidResults";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ensureValidPsi";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCachedResults";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createStrongReference";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 26: 
            case 32: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StrongValueReference<K, V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        private final V myValue;

        StrongValueReference(@NotNull V value) {
            if (value == null) {
                StrongValueReference.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        @NotNull
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/psi/impl/source/resolve/ResolveCache$StrongValueReference", "<init>"));
        }
    }

    @ApiStatus.Experimental
    public static interface PsiSymbolReferenceResolver<@NotNull R extends PsiSymbolReference> {
        @NotNull
        public @NotNull Collection<? extends @NotNull Symbol> resolve(R var1);
    }

    @FunctionalInterface
    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    @FunctionalInterface
    public static interface PolyVariantContextResolver<T extends PsiPolyVariantReference> {
        public ResolveResult @NotNull [] resolve(@NotNull T var1, @NotNull PsiFile var2, boolean var3);
    }

    @FunctionalInterface
    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
        @Override
        public ResolveResult @NotNull [] resolve(@NotNull T var1, boolean var2);
    }

    @FunctionalInterface
    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(@NotNull TRef var1, boolean var2);
    }
}

