/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceCompletion;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceResolver;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileReferenceCompletionImpl
extends FileReferenceCompletion {
    private static final HashingStrategy<PsiElement> VARIANTS_HASHING_STRATEGY = new HashingStrategy<PsiElement>(){

        @Override
        public int hashCode(@Nullable PsiElement object) {
            String name;
            if (object instanceof PsiNamedElement && (name = ((PsiNamedElement)object).getName()) != null) {
                return name.hashCode();
            }
            return Objects.hashCode(object);
        }

        @Override
        public boolean equals(@Nullable PsiElement o1, @Nullable PsiElement o2) {
            if (o1 instanceof PsiNamedElement && o2 instanceof PsiNamedElement) {
                return Objects.equals(((PsiNamedElement)o1).getName(), ((PsiNamedElement)o2).getName());
            }
            return Objects.equals(o1, o2);
        }
    };

    @Override
    public Object @NotNull [] getFileReferenceCompletionVariants(final FileReference reference) {
        int i;
        String s = reference.getText();
        if (s != null && s.equals("/")) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                FileReferenceCompletionImpl.$$$reportNull$$$0(0);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        final CommonProcessors.CollectUniquesProcessor collector = new CommonProcessors.CollectUniquesProcessor();
        PsiElementProcessor<PsiFileSystemItem> processor = new PsiElementProcessor<PsiFileSystemItem>(){

            @Override
            public boolean execute(@NotNull PsiFileSystemItem fileSystemItem) {
                if (fileSystemItem == null) {
                    2.$$$reportNull$$$0(0);
                }
                return new FilteringProcessor<PsiFileSystemItem>(reference.getFileReferenceSet().getReferenceCompletionFilter(), collector).process(FileReference.getOriginalFile(fileSystemItem));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSystemItem", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceCompletionImpl$2", "execute"));
            }
        };
        ArrayList<Object> additionalItems = new ArrayList<Object>();
        for (PsiFileSystemItem context2 : reference.getContexts()) {
            for (PsiElement child : context2.getChildren()) {
                if (!(child instanceof PsiFileSystemItem)) continue;
                processor.execute((PsiFileSystemItem)child);
            }
            if (!(context2 instanceof FileReferenceResolver)) continue;
            additionalItems.addAll(((FileReferenceResolver)((Object)context2)).getVariants(reference));
        }
        FileType[] types = reference.getFileReferenceSet().getSuitableFileTypes();
        Set<PsiElement> set = CollectionFactory.createCustomHashingStrategySet(VARIANTS_HASHING_STRATEGY);
        set.addAll(collector.getResults());
        PsiElement[] candidates = PsiUtilCore.toPsiElementArray(set);
        Object[] variants = new Object[candidates.length + additionalItems.size()];
        for (i = 0; i < candidates.length; ++i) {
            PsiElement candidate = candidates[i];
            Object item = reference.createLookupItem(candidate);
            if (item == null) {
                item = FileInfoManager.getFileLookupItem(candidate);
            }
            if (candidate instanceof PsiFile && item instanceof LookupElement && types.length > 0 && ArrayUtil.contains(((PsiFile)candidate).getFileType(), types)) {
                item = PrioritizedLookupElement.withPriority((LookupElement)item, Double.MAX_VALUE);
            }
            variants[i] = item;
        }
        for (i = 0; i < additionalItems.size(); ++i) {
            variants[i + candidates.length] = additionalItems.get(i);
        }
        if (!reference.getFileReferenceSet().isUrlEncoded()) {
            if (variants == null) {
                FileReferenceCompletionImpl.$$$reportNull$$$0(1);
            }
            return variants;
        }
        ArrayList<Object> encodedVariants = new ArrayList<Object>(variants.length + additionalItems.size());
        for (int i2 = 0; i2 < candidates.length; ++i2) {
            PsiNamedElement psiElement;
            String name;
            String encoded;
            PsiElement element = candidates[i2];
            if (!(element instanceof PsiNamedElement) || (encoded = reference.encode(name = (psiElement = (PsiNamedElement)element).getName(), psiElement)) == null) continue;
            if (!encoded.equals(name)) {
                Icon icon2 = psiElement.getIcon(3);
                LookupElementBuilder item = FileInfoManager.getFileLookupItem(candidates[i2], encoded, icon2);
                encodedVariants.add(item.withTailText(" (" + name + ")"));
                continue;
            }
            encodedVariants.add(variants[i2]);
        }
        encodedVariants.addAll(additionalItems);
        Object[] objectArray = ArrayUtil.toObjectArray(encodedVariants);
        if (objectArray == null) {
            FileReferenceCompletionImpl.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceCompletionImpl", "getFileReferenceCompletionVariants"));
    }
}

