/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.IndexPatternOptimizer;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexPattern {
    public static final IndexPattern[] EMPTY_ARRAY = new IndexPattern[0];
    @NotNull
    private String myPatternString;
    private Pattern myOptimizedIndexingPattern;
    private boolean myCaseSensitive;
    private Pattern myPattern;
    @NotNull
    private List<String> myStringsToFindFirst;

    public IndexPattern(@NotNull String patternString, boolean caseSensitive) {
        if (patternString == null) {
            IndexPattern.$$$reportNull$$$0(0);
        }
        this.myStringsToFindFirst = Collections.emptyList();
        this.myPatternString = patternString;
        this.myCaseSensitive = caseSensitive;
        this.compilePattern();
    }

    @NotNull
    @NlsSafe
    public String getPatternString() {
        String string2 = this.myPatternString;
        if (string2 == null) {
            IndexPattern.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Nullable
    public Pattern getPattern() {
        return this.myPattern;
    }

    @Nullable
    public Pattern getOptimizedIndexingPattern() {
        return this.myOptimizedIndexingPattern;
    }

    @NotNull
    public List<String> getWordsToFindFirst() {
        List<String> list = this.myStringsToFindFirst;
        if (list == null) {
            IndexPattern.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public void setPatternString(@NotNull String patternString) {
        if (patternString == null) {
            IndexPattern.$$$reportNull$$$0(3);
        }
        this.myPatternString = patternString;
        this.compilePattern();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.myCaseSensitive = caseSensitive;
        this.compilePattern();
    }

    private void compilePattern() {
        try {
            int flags = 0;
            if (!this.myCaseSensitive) {
                flags = 2;
                if (StringUtil.findFirst(this.myPatternString, c -> c >= '\u0080') >= 0) {
                    flags |= 0x40;
                }
            }
            this.myPattern = Pattern.compile(this.myPatternString, flags);
            String optimizedPattern = this.myPatternString;
            optimizedPattern = StringUtil.trimStart(optimizedPattern, ".*");
            this.myOptimizedIndexingPattern = Pattern.compile(optimizedPattern, flags);
            this.myStringsToFindFirst = IndexPatternOptimizer.getInstance().extractStringsToFind(this.myPatternString);
        }
        catch (PatternSyntaxException e) {
            this.myPattern = null;
            this.myOptimizedIndexingPattern = null;
            this.myStringsToFindFirst = Collections.emptyList();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexPattern that = (IndexPattern)o;
        if (this.myCaseSensitive != that.myCaseSensitive) {
            return false;
        }
        return this.myPatternString.equals(that.myPatternString);
    }

    public int hashCode() {
        int result2 = this.myPatternString.hashCode();
        result2 = 29 * result2 + (this.myCaseSensitive ? 1 : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternString";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/IndexPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/IndexPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsToFindFirst";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPatternString";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

