/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.model.ModelBranch;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiCacheKey<T, H extends PsiElement>
extends Key<SoftReference<Pair<Long, T>>> {
    private final Function<? super H, ? extends T> myFunction;

    private PsiCacheKey(@NonNls @NotNull String name, @NotNull Function<? super H, ? extends T> function) {
        if (name == null) {
            PsiCacheKey.$$$reportNull$$$0(0);
        }
        if (function == null) {
            PsiCacheKey.$$$reportNull$$$0(1);
        }
        super(name);
        this.myFunction = function;
    }

    public T getValue(@NotNull H h) {
        T result2;
        if (h == null) {
            PsiCacheKey.$$$reportNull$$$0(2);
        }
        if ((result2 = this.getCachedValueOrNull(h)) != null) {
            return result2;
        }
        result2 = this.myFunction.fun(h);
        long count = PsiCacheKey.getModificationCount(h);
        h.putUserData(this, new SoftReference<Pair<Long, T>>(new Pair<Long, T>(count, result2)));
        return result2;
    }

    @Nullable
    public T getCachedValueOrNull(@NotNull H h) {
        SoftReference ref;
        Pair data;
        if (h == null) {
            PsiCacheKey.$$$reportNull$$$0(3);
        }
        if ((data = (Pair)SoftReference.dereference(ref = (SoftReference)h.getUserData(this))) == null || (Long)data.getFirst() != PsiCacheKey.getModificationCount(h)) {
            return null;
        }
        return (T)data.getSecond();
    }

    private static long getModificationCount(@NotNull PsiElement element) {
        ModelBranch branch;
        PsiFile file2;
        if (element == null) {
            PsiCacheKey.$$$reportNull$$$0(4);
        }
        long nonPhysicalStamp = (file2 = element.getContainingFile()) == null || file2.isPhysical() ? 0L : file2.getModificationStamp();
        ModelBranch modelBranch = branch = file2 == null ? null : ModelBranch.getPsiBranch(file2);
        if (branch != null) {
            nonPhysicalStamp += branch.getBranchedPsiModificationCount();
        }
        PsiElement root = file2 != null ? file2 : element;
        return nonPhysicalStamp + root.getManager().getModificationTracker().getModificationCount();
    }

    public static <T, H extends PsiElement> PsiCacheKey<T, H> create(@NonNls @NotNull String name, @NotNull Function<? super H, ? extends T> function) {
        if (name == null) {
            PsiCacheKey.$$$reportNull$$$0(5);
        }
        if (function == null) {
            PsiCacheKey.$$$reportNull$$$0(6);
        }
        return new PsiCacheKey<T, H>(name, function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/util/PsiCacheKey";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getCachedValueOrNull";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getModificationCount";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

