/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class TextOccurrencesUtilBase {
    private TextOccurrencesUtilBase() {
    }

    public static void addTextOccurrences(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Collection<? super UsageInfo> results, @NotNull UsageInfoFactory factory2) {
        if (element == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(0);
        }
        if (stringToSearch == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(2);
        }
        if (results == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(3);
        }
        if (factory2 == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(4);
        }
        FindUsagesHelper.processTextOccurrences(element, stringToSearch, searchScope, factory2, t -> {
            results.add((UsageInfo)t);
            return true;
        });
    }

    public static boolean processUsagesInStringsAndComments(@NotNull Processor<? super UsageInfo> processor, @NotNull PsiElement element, @NotNull SearchScope searchScope, @NotNull String stringToSearch, @NotNull UsageInfoFactory factory2) {
        if (processor == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(5);
        }
        if (element == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(7);
        }
        if (stringToSearch == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(8);
        }
        if (factory2 == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(9);
        }
        return TextOccurrencesUtilBase.processUsagesInStringsAndComments(element, searchScope, stringToSearch, false, (? super PsiElement commentOrLiteral, ? super TextRange textRange) -> {
            UsageInfo usageInfo = factory2.createUsageInfo((PsiElement)commentOrLiteral, textRange.getStartOffset(), textRange.getEndOffset());
            return usageInfo == null || processor.process(usageInfo);
        });
    }

    public static boolean processUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull SearchScope searchScope, @NotNull String stringToSearch, boolean includeReferences, @NotNull PairProcessor<? super PsiElement, ? super TextRange> processor) {
        Processor<PsiElement> commentOrLiteralProcessor;
        if (element == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(11);
        }
        if (stringToSearch == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(13);
        }
        PsiSearchHelper helper = PsiSearchHelper.getInstance(element.getProject());
        SearchScope scope = helper.getUseScope(element);
        return TextOccurrencesUtilBase.processStringLiteralsContainingIdentifier(stringToSearch, scope = scope.intersectWith(searchScope), helper, commentOrLiteralProcessor = literal -> TextOccurrencesUtilBase.processTextIn(literal, stringToSearch, includeReferences, processor)) && helper.processCommentsContainingIdentifier(stringToSearch, scope, commentOrLiteralProcessor);
    }

    private static boolean processStringLiteralsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, PsiSearchHelper helper, Processor<? super PsiElement> processor) {
        if (identifier == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(14);
        }
        if (searchScope == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(15);
        }
        TextOccurenceProcessor occurenceProcessor = (element, offsetInElement) -> {
            if (TextOccurrencesUtilBase.isStringLiteralElement(element)) {
                return processor.process(element);
            }
            return true;
        };
        return helper.processElementsWithWord(occurenceProcessor, searchScope, identifier, (short)4, true);
    }

    public static boolean isStringLiteralElement(@NotNull PsiElement element) {
        ParserDefinition definition;
        if (element == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(16);
        }
        if ((definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage())) == null) {
            return false;
        }
        ASTNode node = element.getNode();
        return node != null && definition.getStringLiteralElements().contains(node.getElementType());
    }

    private static boolean processTextIn(PsiElement scope, String stringToSearch, boolean allowReferences, PairProcessor<? super PsiElement, ? super TextRange> processor) {
        String text = scope.getText();
        for (int offset = 0; offset < text.length() && (offset = text.indexOf(stringToSearch, offset)) >= 0; ++offset) {
            char c;
            PsiReference referenceAt = scope.findReferenceAt(offset);
            if (!allowReferences && referenceAt != null && (referenceAt.resolve() != null || referenceAt instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)referenceAt).multiResolve(true).length > 0) || offset > 0 && Character.isJavaIdentifierPart(c = text.charAt(offset - 1)) && c != '$' && (offset < 2 || text.charAt(offset - 2) != '\\') || offset + stringToSearch.length() < text.length() && Character.isJavaIdentifierPart(c = text.charAt(offset + stringToSearch.length())) && c != '$') continue;
            TextRange textRange = new TextRange(offset, offset + stringToSearch.length());
            if (!processor.process(scope, textRange)) {
                return false;
            }
            offset += stringToSearch.length();
        }
        return true;
    }

    public static void addUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull SearchScope searchScope, @NotNull String stringToSearch, @NotNull Collection<? super UsageInfo> results, @NotNull UsageInfoFactory factory2) {
        if (element == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(18);
        }
        if (stringToSearch == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(19);
        }
        if (results == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(20);
        }
        if (factory2 == null) {
            TextOccurrencesUtilBase.$$$reportNull$$$0(21);
        }
        Object lock = new Object();
        TextOccurrencesUtilBase.processUsagesInStringsAndComments(element, searchScope, stringToSearch, false, (? super PsiElement commentOrLiteral, ? super TextRange textRange) -> {
            UsageInfo usageInfo = factory2.createUsageInfo((PsiElement)commentOrLiteral, textRange.getStartOffset(), textRange.getEndOffset());
            if (usageInfo != null) {
                Object object = lock;
                synchronized (object) {
                    results.add(usageInfo);
                }
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToSearch";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 4: 
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/util/TextOccurrencesUtilBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addTextOccurrences";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "processUsagesInStringsAndComments";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "processStringLiteralsContainingIdentifier";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringLiteralElement";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "addUsagesInStringsAndComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

