/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.BadgeShapeProvider;
import java.awt.geom.RoundRectangle2D;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u000f\u001a\u00020\u000bH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ui/BadgeRectProvider;", "Lcom/intellij/ui/BadgeShapeProvider;", "()V", "createShape", "Ljava/awt/geom/RoundRectangle2D;", "width", "", "height", "hole", "", "getArc", "", "getBottom", "getLeft", "getRight", "getTop", "intellij.platform.core.ui"})
@ApiStatus.Internal
@ApiStatus.Experimental
public class BadgeRectProvider
extends BadgeShapeProvider {
    protected double getArc() {
        return 0.5;
    }

    protected double getTop() {
        return 0.0;
    }

    protected double getLeft() {
        return 0.4;
    }

    protected double getRight() {
        return 0.0;
    }

    protected double getBottom() {
        return 0.7;
    }

    @Override
    @Nullable
    public RoundRectangle2D createShape(int width, int height, boolean hole) {
        int size = RangesKt.coerceAtMost((int)width, (int)height);
        if (size <= 0) {
            return null;
        }
        double top = (double)height * this.getTop();
        if (top >= (double)height) {
            return null;
        }
        double left = (double)width * this.getLeft();
        if (left >= (double)width) {
            return null;
        }
        double right = (double)width - (double)width * this.getRight();
        if (right <= 0.0 || right <= left) {
            return null;
        }
        double bottom = (double)height - (double)height * this.getBottom();
        if (bottom <= 0.0 || bottom <= top) {
            return null;
        }
        double border = hole ? (double)size * this.getBorder() : 0.0;
        double x = left - border;
        double y = top - border;
        double w = right + border - x;
        double h = bottom + border - y;
        double arc = RangesKt.coerceAtMost((double)w, (double)h) * RangesKt.coerceIn((double)this.getArc(), (double)0.0, (double)1.0);
        return new RoundRectangle2D.Double(x, y, w, h, arc, arc);
    }
}

