/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.icons.DarkIconProvider;
import com.intellij.util.IconUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class RoundedIcon
extends JBScalableIcon
implements DarkIconProvider,
IconWithToolTip {
    private final Icon mySourceIcon;
    private final double myArcRatio;
    private final boolean mySuperEllipse;
    private Shape myLastShape;
    private int myLastShapeHash;

    public RoundedIcon(@NotNull Image source, double arcRatio) {
        if (source == null) {
            RoundedIcon.$$$reportNull$$$0(0);
        }
        this(source, arcRatio, false);
    }

    public RoundedIcon(@NotNull Icon source, double arcRatio) {
        if (source == null) {
            RoundedIcon.$$$reportNull$$$0(1);
        }
        this(source, arcRatio, false);
    }

    /*
     * WARNING - void declaration
     */
    public RoundedIcon(@NotNull Image source, double arcRatio, boolean bl) {
        void superEllipse;
        if (source == null) {
            RoundedIcon.$$$reportNull$$$0(2);
        }
        this(IconUtil.createImageIcon(source), arcRatio, (boolean)superEllipse);
    }

    /*
     * WARNING - void declaration
     */
    public RoundedIcon(@NotNull Icon source, double arcRatio, boolean bl) {
        void superEllipse;
        if (source == null) {
            RoundedIcon.$$$reportNull$$$0(3);
        }
        this.myLastShape = null;
        this.myLastShapeHash = 0;
        this.mySourceIcon = source;
        this.myArcRatio = MathUtil.clamp(arcRatio, 0.0, 1.0);
        this.mySuperEllipse = superEllipse;
    }

    @Override
    @Nullable
    public String getToolTip(boolean composite) {
        return ObjectUtils.doIfCast(this.mySourceIcon, IconWithToolTip.class, icon2 -> icon2.getToolTip(composite));
    }

    @Override
    @NotNull
    public Icon getDarkIcon(boolean isDark) {
        return new RoundedIcon(IconLoader.getDarkIcon(this.mySourceIcon, isDark), this.myArcRatio, this.mySuperEllipse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics graphics, int x, int y) {
        Graphics2D g = (Graphics2D)graphics.create();
        try {
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int width = this.mySourceIcon.getIconWidth();
            int height = this.mySourceIcon.getIconHeight();
            Image image = IconLoader.toImage(this.mySourceIcon);
            if (image == null) {
                return;
            }
            BufferedImage bufferedImage = ImageUtil.toBufferedImage(image);
            double scale = (double)bufferedImage.getWidth() / (double)width;
            AffineTransform transform2 = g.getTransform();
            transform2.concatenate(AffineTransform.getScaleInstance(1.0 / scale, 1.0 / scale));
            transform2.concatenate(AffineTransform.getTranslateInstance((double)x * scale, (double)y * scale));
            g.setTransform(transform2);
            g.setPaint(new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight())));
            int hash = Objects.hash(x, y, this.getIconWidth(), this.getIconHeight(), scale, this.myArcRatio);
            if (this.myLastShapeHash != hash) {
                if (this.mySuperEllipse) {
                    this.myLastShape = RoundedIcon.getSuperEllipse(0.0, 0.0, (double)this.getIconWidth() * scale, (double)this.getIconHeight() * scale, this.myArcRatio);
                } else {
                    double actualArc = this.myArcRatio * (double)Math.min(width, height) * scale;
                    this.myLastShape = new RoundRectangle2D.Double(0.0, 0.0, (double)this.getIconWidth() * scale, (double)this.getIconHeight() * scale, actualArc, actualArc);
                }
                this.myLastShapeHash = hash;
            }
            g.fill(this.myLastShape);
            if (this.mySuperEllipse && Boolean.getBoolean("idea.debug.rounded.icon.mode")) {
                this.printDebugMessage(g, x, y, "n=" + String.format("%.2f", RoundedIcon.getPower(this.myArcRatio)), scale);
            }
        }
        finally {
            g.dispose();
        }
    }

    private void printDebugMessage(Graphics2D g, int x, int y, String s, double scale) {
        g.setFont(JBUI.Fonts.label().biggerOn(20.0f));
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(s, g);
        g.setColor(Color.WHITE);
        float xx = (float)((double)this.getIconWidth() - bounds.getWidth()) / 2.0f;
        float yy = (float)((double)this.getIconHeight() - bounds.getHeight());
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                g.drawString(s, (float)x + (float)scale * xx + (float)dx, (float)y + (float)scale * yy + (float)dy);
            }
        }
        g.setColor(Color.BLACK);
        g.drawString(s, (float)x + (float)scale * xx, (float)y + (float)scale * yy);
    }

    private static Shape getSuperEllipse(double x, double y, double width, double height, double arcRatio) {
        GeneralPath path = new GeneralPath();
        path.moveTo(1.0f, 0.0f);
        double step = Math.PI / 360;
        double n = RoundedIcon.getPower(arcRatio);
        for (double theta = step; theta <= Math.PI * 2; theta += step) {
            path.lineTo(Math.pow(Math.abs(Math.cos(theta)), 2.0 / n) * Math.signum(Math.cos(theta)), Math.pow(Math.abs(Math.sin(theta)), 2.0 / n) * Math.signum(Math.sin(theta)));
        }
        path.lineTo(1.0f, 0.0f);
        path.closePath();
        AffineTransform transform2 = AffineTransform.getScaleInstance(width / 2.0, height / 2.0);
        transform2.preConcatenate(AffineTransform.getTranslateInstance(x + width / 2.0, y + height / 2.0));
        path.transform(transform2);
        return path;
    }

    private static double getPower(double arcRatio) {
        return 100.0 - 98.0 * Math.pow(arcRatio, 0.1);
    }

    @Override
    public int getIconWidth() {
        return this.mySourceIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.mySourceIcon.getIconHeight();
    }

    public int hashCode() {
        return Objects.hash(this.mySourceIcon, this.myArcRatio);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoundedIcon icon2 = (RoundedIcon)o;
        return this.myArcRatio == icon2.myArcRatio && this.mySourceIcon.equals(icon2.mySourceIcon);
    }

    @Override
    public String toString() {
        return "RoundedIcon(" + this.mySourceIcon + ", r=" + this.myArcRatio + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/ui/RoundedIcon", "<init>"));
    }
}

