/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.integratedBinaryPacking.IntBitPacker;
import org.jetbrains.mvstore.DataUtil;
import org.jetbrains.mvstore.type.DataType;

public final class ImageValue {
    final int[] data;
    final int w;
    final int h;

    ImageValue(int[] data, int w, int h) {
        this.data = data;
        this.w = w;
        this.h = h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageValue value = (ImageValue)o;
        return this.w == value.w && this.h == value.h && Arrays.equals(this.data, value.data);
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.data);
        result2 = 31 * result2 + this.w;
        result2 = 31 * result2 + this.h;
        return result2;
    }

    public static final class ImageValueSerializer
    implements DataType<ImageValue> {
        public ImageValue[] createStorage(int size) {
            return new ImageValue[size];
        }

        public int getMemory(ImageValue obj) {
            return 10 + obj.data.length * 4 + 1;
        }

        public int getFixedMemory() {
            return -1;
        }

        public void write(ByteBuf buf, ImageValue obj) {
            if (obj.w == obj.h) {
                if (obj.w < 254) {
                    buf.writeByte(obj.w);
                } else {
                    buf.writeByte(255);
                    IntBitPacker.writeVar((ByteBuf)buf, (int)obj.w);
                }
            } else {
                buf.writeByte(254);
                IntBitPacker.writeVar((ByteBuf)buf, (int)obj.w);
                IntBitPacker.writeVar((ByteBuf)buf, (int)obj.h);
            }
            for (int i : obj.data) {
                buf.writeInt(i);
            }
        }

        public ImageValue read(ByteBuf buf) {
            int actualHeight;
            int actualWidth;
            int format = buf.readUnsignedByte();
            if (format < 254) {
                actualWidth = format;
                actualHeight = format;
            } else if (format == 255) {
                actualHeight = actualWidth = IntBitPacker.readVar((ByteBuf)buf);
            } else {
                actualWidth = IntBitPacker.readVar((ByteBuf)buf);
                actualHeight = IntBitPacker.readVar((ByteBuf)buf);
            }
            int length = actualWidth * actualHeight;
            int[] data = new int[length];
            int lengthInBytes = length << 2;
            ByteBuffer nioBuf = DataUtil.getNioBuffer((ByteBuf)buf, (int)buf.readerIndex(), (int)lengthInBytes);
            nioBuf.asIntBuffer().get(data, 0, length);
            buf.readerIndex(buf.readerIndex() + lengthInBytes);
            return new ImageValue(data, actualWidth, actualHeight);
        }
    }
}

