/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.svg.SvgCacheManager;
import com.intellij.ui.svg.SvgPrebuiltCacheManagerKt;
import com.intellij.util.ImageLoader;
import java.awt.Image;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ikv.Ikv;
import org.jetbrains.ikv.UniversalHash;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ui/svg/SvgPrebuiltCacheManager;", "", "dbDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "darkStores", "Lcom/intellij/ui/svg/SvgPrebuiltCacheManager$Stores;", "lightStores", "loadFromCache", "Ljava/awt/Image;", "key", "", "scale", "", "isDark", "", "docSize", "Lcom/intellij/util/ImageLoader$Dimension2DDouble;", "StoreContainer", "Stores", "intellij.platform.util.ui"})
@ApiStatus.Internal
public final class SvgPrebuiltCacheManager {
    private final Stores lightStores;
    private final Stores darkStores;
    private final Path dbDir;

    @Nullable
    public final Image loadFromCache(int key, float scale, boolean isDark, @NotNull ImageLoader.Dimension2DDouble docSize) {
        Ikv.SizeUnawareIkv<Integer> sizeUnawareIkv;
        Intrinsics.checkNotNullParameter((Object)docSize, (String)"docSize");
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        Stores list = isDark ? this.darkStores : this.lightStores;
        float f = scale;
        if (f == 1.0f) {
            sizeUnawareIkv = list.getS1().getOrCreate();
        } else if (f == 1.25f) {
            sizeUnawareIkv = list.getS1_25().getOrCreate();
        } else if (f == 1.5f) {
            sizeUnawareIkv = list.getS1_5().getOrCreate();
        } else if (f == 2.0f) {
            sizeUnawareIkv = list.getS2().getOrCreate();
        } else if (f == 2.5f) {
            sizeUnawareIkv = list.getS2_5().getOrCreate();
        } else {
            return null;
        }
        Ikv.SizeUnawareIkv<Integer> store = sizeUnawareIkv;
        ByteBuffer byteBuffer = store.getUnboundedValue((Object)key);
        if (byteBuffer == null) {
            return null;
        }
        ByteBuffer data = byteBuffer;
        int actualWidth = 0;
        int actualHeight = 0;
        int format = data.get() & 0xFF;
        if (format < 254) {
            actualWidth = format;
            actualHeight = format;
        } else if (format == 255) {
            actualHeight = actualWidth = SvgPrebuiltCacheManagerKt.access$readVar(data);
        } else {
            actualWidth = SvgPrebuiltCacheManagerKt.access$readVar(data);
            actualHeight = SvgPrebuiltCacheManagerKt.access$readVar(data);
        }
        docSize.setSize((float)actualWidth / scale, (float)actualHeight / scale);
        Image image = SvgCacheManager.Companion.readImage(data, actualWidth, actualHeight);
        IconLoadMeasurer.svgPreBuiltLoad.end(start);
        return image;
    }

    public SvgPrebuiltCacheManager(@NotNull Path dbDir) {
        Intrinsics.checkNotNullParameter((Object)dbDir, (String)"dbDir");
        this.dbDir = dbDir;
        this.lightStores = new Stores("");
        this.darkStores = new Stores("-d");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0015\u0010\u0005\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0015\u0010\f\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0015\u0010\u000e\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0015\u0010\u0010\u001a\u00060\u0006R\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ui/svg/SvgPrebuiltCacheManager$Stores;", "", "classifier", "", "(Lcom/intellij/ui/svg/SvgPrebuiltCacheManager;Ljava/lang/String;)V", "s1", "Lcom/intellij/ui/svg/SvgPrebuiltCacheManager$StoreContainer;", "Lcom/intellij/ui/svg/SvgPrebuiltCacheManager;", "getS1", "()Lcom/intellij/ui/svg/SvgPrebuiltCacheManager$StoreContainer;", "s1_25", "getS1_25", "s1_5", "getS1_5", "s2", "getS2", "s2_5", "getS2_5", "intellij.platform.util.ui"})
    private final class Stores {
        @NotNull
        private final StoreContainer s1;
        @NotNull
        private final StoreContainer s1_25;
        @NotNull
        private final StoreContainer s1_5;
        @NotNull
        private final StoreContainer s2;
        @NotNull
        private final StoreContainer s2_5;

        @NotNull
        public final StoreContainer getS1() {
            return this.s1;
        }

        @NotNull
        public final StoreContainer getS1_25() {
            return this.s1_25;
        }

        @NotNull
        public final StoreContainer getS1_5() {
            return this.s1_5;
        }

        @NotNull
        public final StoreContainer getS2() {
            return this.s2;
        }

        @NotNull
        public final StoreContainer getS2_5() {
            return this.s2_5;
        }

        public Stores(String classifier) {
            Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
            this.s1 = new StoreContainer(1.0f, classifier);
            this.s1_25 = new StoreContainer(1.25f, classifier);
            this.s1_5 = new StoreContainer(1.5f, classifier);
            this.s2 = new StoreContainer(2.0f, classifier);
            this.s2_5 = new StoreContainer(2.5f, classifier);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ui/svg/SvgPrebuiltCacheManager$StoreContainer;", "", "scale", "", "classifier", "", "(Lcom/intellij/ui/svg/SvgPrebuiltCacheManager;FLjava/lang/String;)V", "store", "Lorg/jetbrains/ikv/Ikv$SizeUnawareIkv;", "", "getOrCreate", "getSynchronized", "intellij.platform.util.ui"})
    private final class StoreContainer {
        private volatile Ikv.SizeUnawareIkv<Integer> store;
        private final float scale;
        private final String classifier;

        @NotNull
        public final Ikv.SizeUnawareIkv<Integer> getOrCreate() {
            Ikv.SizeUnawareIkv<Integer> sizeUnawareIkv = this.store;
            if (sizeUnawareIkv == null) {
                sizeUnawareIkv = this.getSynchronized();
            }
            return sizeUnawareIkv;
        }

        private final synchronized Ikv.SizeUnawareIkv<Integer> getSynchronized() {
            Ikv.SizeUnawareIkv store = this.store;
            if (store == null) {
                this.store = store = Ikv.loadSizeUnawareIkv((Path)SvgPrebuiltCacheManager.this.dbDir.resolve("icons-v1-" + this.scale + this.classifier + ".db"), (UniversalHash)((UniversalHash)SvgPrebuiltCacheManagerKt.access$getIntKeyHash$p()));
            }
            return store;
        }

        public StoreContainer(@NotNull float scale, String classifier) {
            Intrinsics.checkNotNullParameter((Object)classifier, (String)"classifier");
            this.scale = scale;
            this.classifier = classifier;
        }
    }
}

