/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexUpToDateCheckIn;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.diagnostic.IndexAccessValidator;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.indexing.roots.IndexableFilesContributor;
import com.intellij.util.indexing.roots.IndexableFilesDeduplicateFilter;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class FileBasedIndexEx
extends FileBasedIndex {
    public static final boolean DO_TRACE_STUB_INDEX_UPDATE = Boolean.getBoolean("idea.trace.stub.index.update");
    private static final ThreadLocal<Stack<DumbModeAccessType>> ourDumbModeAccessTypeStack = ThreadLocal.withInitial(() -> new Stack());
    private static final RecursionGuard<Object> ourIgnoranceGuard = RecursionManager.createGuard("ignoreDumbMode");
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();
    private volatile boolean myTraceIndexUpdates;
    private volatile boolean myTraceStubIndexUpdates;
    private volatile boolean myTraceSharedIndexUpdates;

    @ApiStatus.Internal
    boolean doTraceIndexUpdates() {
        return this.myTraceIndexUpdates;
    }

    @ApiStatus.Internal
    public boolean doTraceStubUpdates(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(0);
        }
        return this.myTraceStubIndexUpdates && indexId.equals(StubUpdatingIndex.INDEX_ID);
    }

    @ApiStatus.Internal
    boolean doTraceSharedIndexUpdates() {
        return this.myTraceSharedIndexUpdates;
    }

    @ApiStatus.Internal
    public void loadIndexes() {
        this.myTraceIndexUpdates = SystemProperties.getBooleanProperty("trace.file.based.index.update", false);
        this.myTraceStubIndexUpdates = SystemProperties.getBooleanProperty("trace.stub.index.update", false);
        this.myTraceSharedIndexUpdates = SystemProperties.getBooleanProperty("trace.shared.index.update", false);
    }

    @ApiStatus.Internal
    @NotNull
    public abstract IntPredicate getAccessibleFileIdFilter(@Nullable Project var1);

    @Nullable
    @ApiStatus.Internal
    public abstract IdFilter extractIdFilter(@Nullable GlobalSearchScope var1, @Nullable Project var2);

    @Nullable
    @ApiStatus.Internal
    public abstract IdFilter projectIndexableFiles(@Nullable Project var1);

    @NotNull
    @ApiStatus.Internal
    public abstract <K, V> UpdatableIndex<K, V, FileContent, ?> getIndex(ID<K, V> var1);

    @ApiStatus.Internal
    public abstract void waitUntilIndicesAreInitialized();

    @ApiStatus.Internal
    public abstract <K> boolean ensureUpToDate(@NotNull ID<K, ?> var1, @Nullable Project var2, @Nullable GlobalSearchScope var3, @Nullable VirtualFile var4);

    @Override
    @NotNull
    public <K, V> List<V> getValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter2) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(1);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(2);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(3);
        }
        VirtualFile restrictToFile = FileBasedIndexEx.getTheOnlyFileInScope(filter2);
        SmartList values = new SmartList();
        FileBasedIndex.ValueProcessor<Object> processor = (file2, value) -> {
            values.add(value);
            return true;
        };
        if (restrictToFile != null) {
            this.processValuesInOneFile(indexId, dataKey, restrictToFile, filter2, processor);
        } else {
            this.processValuesInScope(indexId, dataKey, true, filter2, null, processor);
        }
        SmartList smartList = values;
        if (smartList == null) {
            FileBasedIndexEx.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @Nullable
    private static VirtualFile getTheOnlyFileInScope(@NotNull GlobalSearchScope filter2) {
        VirtualFileEnumeration files2;
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(5);
        }
        if ((files2 = VirtualFileEnumeration.extract(filter2)) == null) {
            return null;
        }
        Iterator<VirtualFile> iterator = files2.asIterable().iterator();
        if (iterator.hasNext()) {
            VirtualFile first = iterator.next();
            if (!iterator.hasNext()) {
                return first;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull ID<K, ?> indexId, @NotNull Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(6);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(7);
        }
        HashSet allKeys = new HashSet();
        this.processAllKeys(indexId, Processors.cancelableCollectProcessor(allKeys), project);
        HashSet hashSet = allKeys;
        if (hashSet == null) {
            FileBasedIndexEx.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @Override
    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor, @Nullable Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(10);
        }
        return this.processAllKeys(indexId, processor, project == null ? new EverythingGlobalScope() : GlobalSearchScope.everythingScope(project), null);
    }

    @Override
    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(13);
        }
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex index2 = this.getIndex(indexId);
            if (!this.ensureUpToDate(indexId, scope.getProject(), scope, null)) {
                return true;
            }
            IdFilter idFilterAdjusted = idFilter == null ? this.extractIdFilter(scope, scope.getProject()) : idFilter;
            return this.myAccessValidator.validate(indexId, () -> index2.processAllKeys(processor, scope, idFilterAdjusted));
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return false;
    }

    @Override
    @NotNull
    public <K, V> Map<K, V> getFileData(@NotNull ID<K, V> id, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (id == null) {
            FileBasedIndexEx.$$$reportNull$$$0(14);
        }
        if (virtualFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(15);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(16);
        }
        if (!(virtualFile instanceof VirtualFileWithId)) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(17);
            }
            return map2;
        }
        int fileId = FileBasedIndexEx.getFileId(virtualFile);
        if (this.getAccessibleFileIdFilter(project).test(fileId)) {
            Map map3 = this.processExceptions(id, virtualFile, GlobalSearchScope.fileScope(project, virtualFile), index2 -> {
                if (IndexDebugProperties.DEBUG && !ApplicationManager.getApplication().isUnitTestMode() && !((FileBasedIndexExtension)index2.getExtension()).needsForwardIndexWhenSharing()) {
                    this.getLogger().error("Index extension " + id + " doesn't require forward index but accesses it");
                }
                return index2.getIndexedFileData(fileId);
            });
            Map map4 = ContainerUtil.notNullize(map3);
            if (map4 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(18);
            }
            return map4;
        }
        Map map5 = Collections.emptyMap();
        if (map5 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(19);
        }
        return map5;
    }

    @Override
    @Nullable
    public <V> V getSingleEntryIndexData(@NotNull ID<Integer, V> id, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (id == null) {
            FileBasedIndexEx.$$$reportNull$$$0(20);
        }
        if (virtualFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(21);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(22);
        }
        if (!(this.getIndex(id).getExtension() instanceof SingleEntryFileBasedIndexExtension)) {
            throw new IllegalArgumentException("'" + id + "' index is not a SingleEntryFileBasedIndex");
        }
        Map<Integer, V> data = this.getFileData(id, virtualFile, project);
        if (data.isEmpty()) {
            return null;
        }
        if (data.size() == 1) {
            return data.values().iterator().next();
        }
        throw new IllegalStateException("Invalid single entry index data '" + id + "'");
    }

    @Override
    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter2) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(23);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(24);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(25);
        }
        HashSet<VirtualFile> hashSet = ContainerUtil.newHashSet(this.getContainingFilesIterator(indexId, dataKey, filter2));
        if (hashSet == null) {
            FileBasedIndexEx.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public <K, V> Iterator<VirtualFile> getContainingFilesIterator(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope scope) {
        Project project;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(27);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(28);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(29);
        }
        if ((project = scope.getProject()) instanceof LightEditCompatible) {
            Iterator<VirtualFile> iterator = Collections.emptyIterator();
            if (iterator == null) {
                FileBasedIndexEx.$$$reportNull$$$0(30);
            }
            return iterator;
        }
        VirtualFile restrictToFile = FileBasedIndexEx.getTheOnlyFileInScope(scope);
        if (restrictToFile != null) {
            Iterator<VirtualFile> iterator = !this.processValuesInOneFile(indexId, dataKey, restrictToFile, scope, (f, v) -> false) ? Collections.singleton(restrictToFile).iterator() : Collections.emptyIterator();
            if (iterator == null) {
                FileBasedIndexEx.$$$reportNull$$$0(31);
            }
            return iterator;
        }
        IdFilter filter2 = this.extractIdFilter(scope, project);
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(project);
        IntSet fileIds = this.processExceptions(indexId, null, scope, index2 -> {
            IntOpenHashSet fileIdsInner = new IntOpenHashSet();
            index2.getData(dataKey).forEach((id, value) -> {
                if (!accessibleFileFilter.test(id) || filter2 != null && !filter2.containsFileId(id)) {
                    return true;
                }
                fileIdsInner.add(id);
                return true;
            });
            return fileIdsInner;
        });
        return FileBasedIndexEx.createLazyFileIterator(fileIds, scope);
    }

    @Override
    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor, @NotNull GlobalSearchScope filter2) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(32);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(34);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(35);
        }
        return this.processValues(indexId, dataKey, inFile, processor, filter2, null);
    }

    @Override
    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor, @NotNull GlobalSearchScope filter2, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(36);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(37);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(38);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(39);
        }
        return inFile != null ? this.processValuesInOneFile(indexId, dataKey, inFile, filter2, processor) : this.processValuesInScope(indexId, dataKey, false, filter2, idFilter, processor);
    }

    @Override
    public <K, V> long getIndexModificationStamp(@NotNull ID<K, V> indexId, @NotNull Project project) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(40);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(41);
        }
        this.waitUntilIndicesAreInitialized();
        UpdatableIndex<K, V, FileContent, ?> index2 = this.getIndex(indexId);
        this.ensureUpToDate(indexId, project, GlobalSearchScope.allScope(project));
        return index2.getModificationStamp();
    }

    @Nullable
    private <K, V, R> R processExceptions(@NotNull ID<K, V> indexId, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope filter2, @NotNull ThrowableConvertor<? super UpdatableIndex<K, V, FileContent, ?>, ? extends R, StorageException> computable) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(42);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(43);
        }
        if (computable == null) {
            FileBasedIndexEx.$$$reportNull$$$0(44);
        }
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex index2 = this.getIndex(indexId);
            Project project = filter2.getProject();
            if (!this.ensureUpToDate(indexId, project, filter2, restrictToFile)) {
                return null;
            }
            return (R)this.myAccessValidator.validate(indexId, () -> ConcurrencyUtil.withLock(index2.getLock().readLock(), () -> computable.convert(index2)));
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexEx.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return null;
    }

    protected <K, V> boolean processValuesInOneFile(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull FileBasedIndex.ValueProcessor<? super V> processor) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(45);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(46);
        }
        if (restrictToFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(47);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(48);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(49);
        }
        Project project = scope.getProject();
        if (!(restrictToFile instanceof VirtualFileWithId)) {
            return project == null || ModelBranch.getFileBranch(restrictToFile) == null || this.processInMemoryFileData(indexId, dataKey, project, restrictToFile, processor);
        }
        int restrictedFileId = FileBasedIndexEx.getFileId(restrictToFile);
        if (!this.getAccessibleFileIdFilter(project).test(restrictedFileId)) {
            return true;
        }
        return this.processValueIterator(indexId, dataKey, restrictToFile, scope, valueIt -> {
            while (valueIt.hasNext()) {
                Object value = valueIt.next();
                if (valueIt.getValueAssociationPredicate().test(restrictedFileId) && !processor.process(restrictToFile, (Object)value)) {
                    return false;
                }
                ProgressManager.checkCanceled();
            }
            return true;
        });
    }

    private <K, V> boolean processInMemoryFileData(ID<K, V> indexId, K dataKey, Project project, VirtualFile file2, FileBasedIndex.ValueProcessor<? super V> processor) {
        Map<K, V> data = this.getFileData(indexId, file2, project);
        return !data.containsKey(dataKey) || processor.process(file2, data.get(dataKey));
    }

    protected <K, V> boolean processValuesInScope(@NotNull ID<K, V> indexId, @NotNull K dataKey, boolean ensureValueProcessedOnce, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull FileBasedIndex.ValueProcessor<? super V> processor) {
        Project project;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(50);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(51);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(52);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(53);
        }
        if ((project = scope.getProject()) != null && !ModelBranchImpl.processModifiedFilesInScope(scope, file2 -> this.processInMemoryFileData(indexId, dataKey, project, (VirtualFile)file2, processor))) {
            return false;
        }
        IdFilter filter2 = idFilter != null ? idFilter : this.extractIdFilter(scope, project);
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(project);
        return this.processValueIterator(indexId, dataKey, null, scope, valueIt -> {
            while (valueIt.hasNext()) {
                Object value = valueIt.next();
                ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                while (inputIdsIterator.hasNext()) {
                    int id = inputIdsIterator.next();
                    if (!accessibleFileFilter.test(id) || filter2 != null && !filter2.containsFileId(id)) continue;
                    VirtualFile file2 = this.findFileById(id);
                    if (file2 != null) {
                        for (VirtualFile eachFile : FileBasedIndexEx.filesInScopeWithBranches(scope, file2)) {
                            if (!processor.process(eachFile, (Object)value)) {
                                return false;
                            }
                            if (!ensureValueProcessedOnce) continue;
                            ProgressManager.checkCanceled();
                            break;
                        }
                    }
                    ProgressManager.checkCanceled();
                }
            }
            return true;
        });
    }

    private <K, V> boolean processValueIterator(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull Processor<? super InvertedIndexValueIterator<V>> valueProcessor) {
        Boolean result2;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(54);
        }
        if (dataKey == null) {
            FileBasedIndexEx.$$$reportNull$$$0(55);
        }
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(56);
        }
        if (valueProcessor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(57);
        }
        return (result2 = this.processExceptions(indexId, restrictToFile, scope, index2 -> valueProcessor.process((InvertedIndexValueIterator)index2.getData(dataKey).getValueIterator()))) == null || result2 != false;
    }

    @Override
    public <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor) {
        IdFilter filesSet;
        IntSet set;
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(58);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(59);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(60);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(61);
        }
        return (set = this.collectFileIdsContainingAllKeys(indexId, dataKeys, filter2, valueChecker, filesSet = this.extractIdFilter(filter2, filter2.getProject()), null)) != null && this.processVirtualFiles(set, filter2, processor);
    }

    @Override
    public <K, V> boolean processFilesContainingAnyKey(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable IdFilter idFilter, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(62);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(63);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(64);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(65);
        }
        IdFilter idFilterAdjusted = idFilter != null ? idFilter : this.extractIdFilter(filter2, filter2.getProject());
        IntSet set = this.collectFileIdsContainingAnyKey(indexId, dataKeys, filter2, valueChecker, idFilterAdjusted);
        return set != null && this.processVirtualFiles(set, filter2, processor);
    }

    private boolean processFilesContainingAllKeysInPhysicalFiles(@NotNull Collection<? extends FileBasedIndex.AllKeysQuery<?, ?>> queries, @NotNull GlobalSearchScope filter2, Processor<? super VirtualFile> processor, IdFilter filesSet) {
        if (queries == null) {
            FileBasedIndexEx.$$$reportNull$$$0(66);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(67);
        }
        IntSet set = null;
        if (filter2 instanceof GlobalSearchScope.FilesScope) {
            set = new IntOpenHashSet();
            VirtualFileEnumeration hint = VirtualFileEnumeration.extract(filter2);
            if (hint != null) {
                for (VirtualFile file2 : hint.asIterable()) {
                    if (!(file2 instanceof VirtualFileWithId)) continue;
                    set.add(((VirtualFileWithId)((Object)file2)).getId());
                }
            }
        }
        for (FileBasedIndex.AllKeysQuery<?, ?> query : queries) {
            IntSet queryResult = this.collectFileIdsContainingAllKeys(query.getIndexId(), query.getDataKeys(), filter2, query.getValueChecker(), filesSet, set);
            if (queryResult == null) {
                return false;
            }
            if (queryResult.isEmpty()) {
                return true;
            }
            if (set == null) {
                set = new IntOpenHashSet(queryResult);
                continue;
            }
            set = queryResult;
        }
        return set != null && this.processVirtualFiles(set, filter2, processor);
    }

    @Override
    public boolean processFilesContainingAllKeys(@NotNull Collection<? extends FileBasedIndex.AllKeysQuery<?, ?>> queries, @NotNull GlobalSearchScope filter2, @NotNull Processor<? super VirtualFile> processor) {
        if (queries == null) {
            FileBasedIndexEx.$$$reportNull$$$0(68);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(69);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(70);
        }
        Project project = filter2.getProject();
        IdFilter filesSet = this.extractIdFilter(filter2, filter2.getProject());
        if (!this.processFilesContainingAllKeysInPhysicalFiles(queries, filter2, processor, filesSet)) {
            return false;
        }
        if (project == null) {
            return true;
        }
        return ModelBranchImpl.processModifiedFilesInScope(filter2, file2 -> {
            for (FileBasedIndex.AllKeysQuery query : queries) {
                ID id = query.getIndexId();
                Map data = this.getFileData(id, (VirtualFile)file2, project);
                if (data.keySet().containsAll(query.getDataKeys())) continue;
                return true;
            }
            return processor.process((VirtualFile)file2);
        });
    }

    @Override
    public <K, V> boolean getFilesWithKey(@NotNull ID<K, V> indexId, @NotNull Set<? extends K> dataKeys, @NotNull Processor<? super VirtualFile> processor, @NotNull GlobalSearchScope filter2) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(71);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(72);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(73);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(74);
        }
        return this.processFilesContainingAllKeys(indexId, dataKeys, filter2, null, processor);
    }

    @Override
    public <K> void scheduleRebuild(@NotNull ID<K, ?> indexId, @NotNull Throwable e) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(75);
        }
        if (e == null) {
            FileBasedIndexEx.$$$reportNull$$$0(76);
        }
        this.requestRebuild(indexId, e);
    }

    @Override
    public <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter2) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(77);
        }
        this.waitUntilIndicesAreInitialized();
        this.ensureUpToDate(indexId, project, filter2, null);
    }

    @Override
    public void iterateIndexableFiles(@NotNull ContentIterator processor, @NotNull Project project, @Nullable ProgressIndicator indicator) {
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(78);
        }
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(79);
        }
        List<IndexableFilesIterator> providers = this.getIndexableFilesProviders(project);
        IndexableFilesDeduplicateFilter indexableFilesDeduplicateFilter = IndexableFilesDeduplicateFilter.create();
        for (IndexableFilesIterator provider : providers) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            if (provider.iterateFiles(project, processor, indexableFilesDeduplicateFilter)) continue;
            break;
        }
    }

    @NotNull
    public List<IndexableFilesIterator> getIndexableFilesProviders(@NotNull Project project) {
        if (project == null) {
            FileBasedIndexEx.$$$reportNull$$$0(80);
        }
        List<String> allowedIteratorPatterns = StringUtil.split(System.getProperty("idea.test.files.allowed.iterators", ""), ";");
        if (project instanceof LightEditCompatible) {
            List<IndexableFilesIterator> list = Collections.emptyList();
            if (list == null) {
                FileBasedIndexEx.$$$reportNull$$$0(81);
            }
            return list;
        }
        List<IndexableFilesIterator> providers = IndexableFilesContributor.EP_NAME.getExtensionList().stream().flatMap(c -> ReadAction.nonBlocking(() -> c.getIndexableFiles(project)).expireWith(project).executeSynchronously().stream()).collect(Collectors.toList());
        if (!allowedIteratorPatterns.isEmpty()) {
            providers = ContainerUtil.filter(providers, p -> allowedIteratorPatterns.stream().anyMatch(pattern -> p.getDebugName().contains((CharSequence)pattern)));
        }
        List<IndexableFilesIterator> list = providers;
        if (list == null) {
            FileBasedIndexEx.$$$reportNull$$$0(82);
        }
        return list;
    }

    @Nullable
    private <K, V> IntSet collectFileIdsContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable Condition<? super V> valueChecker, @Nullable IdFilter projectFilesFilter, @Nullable IntSet restrictedIds) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(83);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(84);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(85);
        }
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(filter2.getProject());
        IntPredicate idChecker = id -> !(projectFilesFilter != null && !projectFilesFilter.containsFileId(id) || !accessibleFileFilter.test(id) || restrictedIds != null && !restrictedIds.contains(id));
        ThrowableConvertor convertor = index2 -> {
            IndexDebugProperties.DEBUG_INDEX_ID.set(indexId);
            try {
                IntSet intSet = InvertedIndexUtil.collectInputIdsContainingAllKeys(index2, dataKeys, valueChecker, idChecker);
                return intSet;
            }
            finally {
                IndexDebugProperties.DEBUG_INDEX_ID.remove();
            }
        };
        return this.processExceptions(indexId, null, filter2, convertor);
    }

    @Nullable
    private <K, V> IntSet collectFileIdsContainingAnyKey(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable Condition<? super V> valueChecker, @Nullable IdFilter projectFilesFilter) {
        if (indexId == null) {
            FileBasedIndexEx.$$$reportNull$$$0(86);
        }
        if (dataKeys == null) {
            FileBasedIndexEx.$$$reportNull$$$0(87);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(88);
        }
        IntPredicate accessibleFileFilter = this.getAccessibleFileIdFilter(filter2.getProject());
        IntPredicate idChecker = id -> (projectFilesFilter == null || projectFilesFilter.containsFileId(id)) && accessibleFileFilter.test(id);
        ThrowableConvertor convertor = index2 -> {
            IndexDebugProperties.DEBUG_INDEX_ID.set(indexId);
            try {
                IntSet intSet = InvertedIndexUtil.collectInputIdsContainingAnyKey(index2, dataKeys, valueChecker, idChecker);
                return intSet;
            }
            finally {
                IndexDebugProperties.DEBUG_INDEX_ID.remove();
            }
        };
        return this.processExceptions(indexId, null, filter2, convertor);
    }

    private boolean processVirtualFiles(@NotNull IntCollection ids, @NotNull GlobalSearchScope filter2, @NotNull Processor<? super VirtualFile> processor) {
        if (ids == null) {
            FileBasedIndexEx.$$$reportNull$$$0(89);
        }
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(90);
        }
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(91);
        }
        IntArrayList sortedIds = new IntArrayList(ids);
        sortedIds.sort((IntComparator)null);
        IntListIterator iterator = sortedIds.iterator();
        while (iterator.hasNext()) {
            ProgressManager.checkCanceled();
            int id = iterator.nextInt();
            VirtualFile file2 = this.findFileById(id);
            if (file2 == null) continue;
            for (VirtualFile fileInBranch : FileBasedIndexEx.filesInScopeWithBranches(filter2, file2)) {
                boolean processNext = processor.process(fileInBranch);
                ProgressManager.checkCanceled();
                if (processNext) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nullable
    public DumbModeAccessType getCurrentDumbModeAccessType() {
        DumbModeAccessType result2 = this.getCurrentDumbModeAccessType_NoDumbChecks();
        if (result2 != null) {
            this.getLogger().assertTrue(ContainerUtil.exists(ProjectManager.getInstance().getOpenProjects(), p -> DumbService.isDumb(p)), "getCurrentDumbModeAccessType may only be called during indexing");
        }
        return result2;
    }

    @Nullable
    DumbModeAccessType getCurrentDumbModeAccessType_NoDumbChecks() {
        Stack<DumbModeAccessType> dumbModeAccessTypeStack = ourDumbModeAccessTypeStack.get();
        if (dumbModeAccessTypeStack.isEmpty()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ourIgnoranceGuard.prohibitResultCaching(dumbModeAccessTypeStack.get(0));
        return dumbModeAccessTypeStack.peek();
    }

    @Override
    @ApiStatus.Internal
    @NotNull
    public <T> Processor<? super T> inheritCurrentDumbAccessType(@NotNull Processor<? super T> processor) {
        Stack<DumbModeAccessType> stack;
        if (processor == null) {
            FileBasedIndexEx.$$$reportNull$$$0(92);
        }
        if ((stack = ourDumbModeAccessTypeStack.get()).isEmpty()) {
            Processor processor2 = processor;
            if (processor2 == null) {
                FileBasedIndexEx.$$$reportNull$$$0(93);
            }
            return processor2;
        }
        DumbModeAccessType access = stack.peek();
        Processor<Object> processor3 = t -> this.ignoreDumbMode(access, () -> processor.process(t));
        if (processor3 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(94);
        }
        return processor3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ApiStatus.Internal
    @ApiStatus.Experimental
    public <T, E extends Throwable> T ignoreDumbMode(@NotNull DumbModeAccessType dumbModeAccessType, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (dumbModeAccessType == null) {
            FileBasedIndexEx.$$$reportNull$$$0(95);
        }
        if (computable == null) {
            FileBasedIndexEx.$$$reportNull$$$0(96);
        }
        Application app = ApplicationManager.getApplication();
        app.assertReadAccessAllowed();
        if (FileBasedIndex.isIndexAccessDuringDumbModeEnabled()) {
            Stack<DumbModeAccessType> dumbModeAccessTypeStack = ourDumbModeAccessTypeStack.get();
            boolean preventCaching = dumbModeAccessTypeStack.empty();
            dumbModeAccessTypeStack.push(dumbModeAccessType);
            Disposable disposable = Disposer.newDisposable();
            if (app.isWriteThread()) {
                app.getMessageBus().connect(disposable).subscribe(PsiModificationTracker.TOPIC, () -> RecursionManager.dropCurrentMemoizationCache());
            }
            try {
                T t = preventCaching ? ourIgnoranceGuard.computePreventingRecursion((Object)dumbModeAccessType, false, computable) : computable.compute();
                return t;
            }
            finally {
                Disposer.dispose(disposable);
                DumbModeAccessType type = dumbModeAccessTypeStack.pop();
                assert (dumbModeAccessType == type);
            }
        }
        return computable.compute();
    }

    @Nullable
    @ApiStatus.Internal
    public abstract VirtualFile findFileById(int var1);

    @NotNull
    @ApiStatus.Internal
    public abstract Logger getLogger();

    @NotNull
    @ApiStatus.Internal
    public static List<VirtualFile> filesInScopeWithBranches(@NotNull GlobalSearchScope scope, @NotNull VirtualFile file2) {
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(97);
        }
        if (file2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(98);
        }
        SmartList<VirtualFile> filesInScope = new SmartList<VirtualFile>();
        if (scope.contains(file2)) {
            filesInScope.add(file2);
        }
        ProgressManager.checkCanceled();
        for (ModelBranch branch : scope.getModelBranchesAffectingScope()) {
            VirtualFile copy2;
            if (!((ModelBranchImpl)branch).hasModifications(copy2 = branch.findFileCopy(file2)) && scope.contains(copy2)) {
                filesInScope.add(copy2);
            }
            ProgressManager.checkCanceled();
        }
        SmartList<VirtualFile> smartList = filesInScope;
        if (smartList == null) {
            FileBasedIndexEx.$$$reportNull$$$0(99);
        }
        return smartList;
    }

    @Nullable
    public static Throwable getCauseToRebuildIndex(@NotNull RuntimeException e) {
        if (e == null) {
            FileBasedIndexEx.$$$reportNull$$$0(100);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (e instanceof ProcessCanceledException) {
            return null;
        }
        if (e instanceof MapReduceIndexMappingException) {
            if (e.getCause() instanceof SnapshotInputMappingException) {
                return e.getCause();
            }
            return null;
        }
        if (e instanceof IndexOutOfBoundsException) {
            return e;
        }
        Throwable cause = e.getCause();
        if (cause instanceof StorageException || cause instanceof IOException || cause instanceof IllegalArgumentException) {
            return cause;
        }
        return null;
    }

    @ApiStatus.Internal
    public static boolean isTooLarge(@NotNull VirtualFile file2, @Nullable(value="if content size should be retrieved from a file") @Nullable(value="if content size should be retrieved from a file") Long contentSize, @NotNull Set<FileType> noLimitFileTypes) {
        if (file2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(101);
        }
        if (noLimitFileTypes == null) {
            FileBasedIndexEx.$$$reportNull$$$0(102);
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2, contentSize)) {
            return !noLimitFileTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2, contentSize);
        }
        return false;
    }

    public static boolean acceptsInput(@NotNull FileBasedIndex.InputFilter filter2, @NotNull IndexedFile indexedFile) {
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(103);
        }
        if (indexedFile == null) {
            FileBasedIndexEx.$$$reportNull$$$0(104);
        }
        if (filter2 instanceof FileBasedIndex.ProjectSpecificInputFilter) {
            if (indexedFile.getProject() == null) {
                Project project = ProjectLocator.getInstance().guessProjectForFile(indexedFile.getFile());
                ((IndexedFileImpl)indexedFile).setProject(project);
            }
            return ((FileBasedIndex.ProjectSpecificInputFilter)filter2).acceptInput(indexedFile);
        }
        return filter2.acceptInput(indexedFile.getFile());
    }

    @NotNull
    public static FileBasedIndex.InputFilter composeInputFilter(final @NotNull FileBasedIndex.InputFilter filter2, final @NotNull BiPredicate<? super VirtualFile, ? super Project> condition) {
        if (filter2 == null) {
            FileBasedIndexEx.$$$reportNull$$$0(105);
        }
        if (condition == null) {
            FileBasedIndexEx.$$$reportNull$$$0(106);
        }
        return new FileBasedIndex.ProjectSpecificInputFilter(){

            @Override
            public boolean acceptInput(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean doesMainFilterAccept = filter2 instanceof FileBasedIndex.ProjectSpecificInputFilter ? ((FileBasedIndex.ProjectSpecificInputFilter)filter2).acceptInput(file2) : filter2.acceptInput(file2.getFile());
                return doesMainFilterAccept && condition.test(file2.getFile(), file2.getProject());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexEx$1", "acceptInput"));
            }
        };
    }

    @ApiStatus.Internal
    public void runCleanupAction(@NotNull Runnable cleanupAction) {
        if (cleanupAction == null) {
            FileBasedIndexEx.$$$reportNull$$$0(107);
        }
    }

    @ApiStatus.Internal
    public static <T, E extends Throwable> T disableUpToDateCheckIn(@NotNull ThrowableComputable<T, E> runnable) throws E {
        if (runnable == null) {
            FileBasedIndexEx.$$$reportNull$$$0(108);
        }
        return IndexUpToDateCheckIn.disableUpToDateCheckIn(runnable);
    }

    @ApiStatus.Internal
    static boolean belongsToScope(@Nullable VirtualFile file2, @Nullable VirtualFile restrictedTo, @Nullable GlobalSearchScope filter2) {
        if (!(file2 instanceof VirtualFileWithId) || !file2.isValid()) {
            return false;
        }
        return !(restrictedTo != null && !Comparing.equal(file2, restrictedTo) || filter2 != null && restrictedTo == null && !filter2.accept(file2));
    }

    @ApiStatus.Internal
    @NotNull
    public static Iterator<VirtualFile> createLazyFileIterator(@Nullable IntSet result2, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            FileBasedIndexEx.$$$reportNull$$$0(109);
        }
        Set<VirtualFile> fileSet = new CompactVirtualFileSet(result2 == null ? ArrayUtil.EMPTY_INT_ARRAY : result2.toIntArray()).freezed();
        Iterator<VirtualFile> iterator = fileSet.stream().filter(scope::contains).iterator();
        if (iterator == null) {
            FileBasedIndexEx.$$$reportNull$$$0(110);
        }
        return iterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 30: 
            case 31: 
            case 81: 
            case 82: 
            case 93: 
            case 94: 
            case 99: 
            case 110: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 30: 
            case 31: 
            case 81: 
            case 82: 
            case 93: 
            case 94: 
            case 99: 
            case 110: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 2: 
            case 24: 
            case 28: 
            case 33: 
            case 37: 
            case 46: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 3: 
            case 5: 
            case 25: 
            case 35: 
            case 39: 
            case 43: 
            case 60: 
            case 64: 
            case 67: 
            case 69: 
            case 74: 
            case 85: 
            case 88: 
            case 90: 
            case 103: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 30: 
            case 31: 
            case 81: 
            case 82: 
            case 93: 
            case 94: 
            case 99: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexEx";
                break;
            }
            case 7: 
            case 16: 
            case 22: 
            case 41: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 12: 
            case 34: 
            case 38: 
            case 49: 
            case 53: 
            case 61: 
            case 65: 
            case 70: 
            case 73: 
            case 78: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 29: 
            case 48: 
            case 52: 
            case 56: 
            case 97: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 44: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictToFile";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueProcessor";
                break;
            }
            case 59: 
            case 63: 
            case 72: 
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKeys";
                break;
            }
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 76: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbModeAccessType";
                break;
            }
            case 98: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "noLimitFileTypes";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupAction";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexEx";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllKeys";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileData";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFiles";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFilesIterator";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableFilesProviders";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "inheritCurrentDumbAccessType";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "filesInScopeWithBranches";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "createLazyFileIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTraceStubUpdates";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 4: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 30: 
            case 31: 
            case 81: 
            case 82: 
            case 93: 
            case 94: 
            case 99: 
            case 110: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyFileInScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllKeys";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFileData";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSingleEntryIndexData";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFiles";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFilesIterator";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processValues";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getIndexModificationStamp";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processExceptions";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInOneFile";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInScope";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processValueIterator";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAnyKey";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeysInPhysicalFiles";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithKey";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRebuild";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpToDate";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "iterateIndexableFiles";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "getIndexableFilesProviders";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "collectFileIdsContainingAllKeys";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "collectFileIdsContainingAnyKey";
                break;
            }
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFiles";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "inheritCurrentDumbAccessType";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "ignoreDumbMode";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "filesInScopeWithBranches";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getCauseToRebuildIndex";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "isTooLarge";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInput";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "composeInputFilter";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "runCleanupAction";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "disableUpToDateCheckIn";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "createLazyFileIterator";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 30: 
            case 31: 
            case 81: 
            case 82: 
            case 93: 
            case 94: 
            case 99: 
            case 110: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

