/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.SplitByLetterPolicy;
import com.intellij.util.ui.SplitBySeparatorPolicy;
import java.awt.FontMetrics;
import java.io.File;
import javax.swing.JComponent;

public abstract class FilePathSplittingPolicy {
    public static final FilePathSplittingPolicy SPLIT_BY_LETTER = new SplitByLetterPolicy();
    public static final FilePathSplittingPolicy SPLIT_BY_SEPARATOR = new SplitBySeparatorPolicy();

    @NlsSafe
    public abstract String getPresentableName(File var1, int var2);

    @NlsSafe
    public String getOptimalTextForComponent(String staticPrefix, File file2, JComponent component, int width) {
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        String path = file2.getPath();
        for (int i = 1; i <= path.length(); ++i) {
            String text = this.getPresentableName(file2, i);
            if (fontMetrics.stringWidth(staticPrefix + text) <= width) continue;
            if (i == 1) {
                return text;
            }
            return this.getPresentableName(file2, i - 1);
        }
        return path;
    }

    @NlsSafe
    public String getOptimalTextForComponent(File file2, JComponent component, int width) {
        return this.getOptimalTextForComponent("", file2, component, width);
    }

    @NlsSafe
    public String getOptimalTextForComponent(File file2, JComponent component) {
        return this.getOptimalTextForComponent(file2, component, component.getWidth());
    }
}

