/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Image;
import java.awt.image.BaseMultiResolutionImage;
import java.awt.image.BufferedImage;
import java.awt.image.MultiResolutionImage;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class MultiResolutionImageProvider {
    public static Image convertFromJBImage(@Nullable Image jbImage) {
        if (jbImage == null) {
            return null;
        }
        if (!MultiResolutionImageProvider.checkSize(jbImage)) {
            new IllegalArgumentException("the image has illegal size 0x0").printStackTrace();
        }
        return Converter.convert(jbImage);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Icon convertFromJBIcon(@Nullable Icon jbIcon, @Nullable ScaleContext ctx) {
        if (jbIcon == null) {
            return null;
        }
        Image image = IconLoader.toImage(jbIcon, ctx);
        if (image == null) {
            return jbIcon;
        }
        Image newImage = MultiResolutionImageProvider.convertFromJBImage(image);
        return newImage == image ? jbIcon : new ImageIcon(newImage);
    }

    @Contract(value="null -> null; !null -> !null")
    public static Image getMaxSizeResolutionVariant(@Nullable Image mrImage) {
        if (!(mrImage instanceof MultiResolutionImage)) {
            return mrImage;
        }
        if (!MultiResolutionImageProvider.checkSize(mrImage)) {
            new IllegalArgumentException("the image has illegal size 0x0").printStackTrace();
        }
        int width = mrImage.getWidth(null);
        for (Image img : ((MultiResolutionImage)((Object)mrImage)).getResolutionVariants()) {
            if (img.getWidth(null) < width) continue;
            mrImage = img;
        }
        return mrImage;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Icon convertFromMRIcon(@Nullable Icon mrIcon, @Nullable ScaleContext scaleContext) {
        Image image;
        if (mrIcon == null) {
            return null;
        }
        if (scaleContext == null) {
            scaleContext = ScaleContext.create();
        }
        if (!((image = Objects.requireNonNull(IconLoader.toImage(mrIcon, scaleContext))) instanceof MultiResolutionImage)) {
            return mrIcon;
        }
        image = MultiResolutionImageProvider.getMaxSizeResolutionVariant(image);
        image = ImageUtil.ensureHiDPI(image, scaleContext);
        return new JBImageIcon(image);
    }

    private static boolean checkSize(Image image) {
        return image.getWidth(null) != 0 && image.getHeight(null) != 0;
    }

    private static final class Converter {
        private Converter() {
        }

        @Nullable
        public static Image convert(Image jbImage) {
            if (jbImage instanceof JBHiDPIScaledImage) {
                JBHiDPIScaledImage scaledImage = (JBHiDPIScaledImage)jbImage;
                BufferedImage lowResImage = ImageUtil.toBufferedImage(scaledImage, true);
                BufferedImage highResImage = ImageUtil.toBufferedImage(scaledImage);
                return new BaseMultiResolutionImage(lowResImage, highResImage);
            }
            return jbImage;
        }
    }
}

