/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.util.ArrayList;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u0006\u0010\f\u001a\u00020\nR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/ui/SingleTextSelectionHandler;", "Ljavax/swing/event/CaretListener;", "()V", "myComponents", "Ljava/util/ArrayList;", "Ljavax/swing/text/JTextComponent;", "Lkotlin/collections/ArrayList;", "myIgnoreEvents", "", "add", "", "component", "start", "caretUpdate", "e", "Ljavax/swing/event/CaretEvent;", "remove", "intellij.platform.util.ui"})
public final class SingleTextSelectionHandler
implements CaretListener {
    private final ArrayList<JTextComponent> myComponents = new ArrayList();
    private boolean myIgnoreEvents;

    public final void add(@NotNull JTextComponent component, boolean start) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.myComponents.add(component);
        if (start) {
            component.addCaretListener(this);
        }
    }

    public final void remove(@NotNull JTextComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.myComponents.remove(component);
        component.removeCaretListener(this);
    }

    public final void start() {
        if (this.myComponents.size() > 1) {
            for (JTextComponent component : this.myComponents) {
                component.addCaretListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.myIgnoreEvents) {
            this.myIgnoreEvents = true;
            try {
                Object source = e.getSource();
                for (JTextComponent component : this.myComponents) {
                    if (component == source) continue;
                    JTextComponent jTextComponent = component;
                    Intrinsics.checkNotNullExpressionValue((Object)jTextComponent, (String)"component");
                    if (jTextComponent.getSelectionStart() == component.getSelectionEnd()) continue;
                    component.select(0, 0);
                }
            }
            finally {
                this.myIgnoreEvents = false;
            }
        }
    }
}

