/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ui.ImageUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StartupUiUtil {
    @ApiStatus.Internal
    @NonNls
    public static final String[] ourPatchableFontResources = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "MenuItem.acceleratorFont", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "FormattedTextField.font", "Spinner.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};
    public static final String ARIAL_FONT_NAME = "Arial";

    public static boolean isUnderDarcula() {
        return UIManager.getLookAndFeel().getName().contains("Darcula");
    }

    @ApiStatus.Internal
    public static int doGetLcdContrastValueForSplash(boolean isUnderDarcula) {
        if (SystemInfoRt.isMac) {
            return isUnderDarcula ? 140 : 230;
        }
        Map map2 = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        if (map2 == null) {
            return 140;
        }
        Object o = map2.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
        if (o == null) {
            return 140;
        }
        int lcdContrastValue = (Integer)o;
        return StartupUiUtil.normalizeLcdContrastValue(lcdContrastValue);
    }

    static int normalizeLcdContrastValue(int lcdContrastValue) {
        return lcdContrastValue < 100 || lcdContrastValue > 250 ? 140 : lcdContrastValue;
    }

    public static boolean isJreHiDPI() {
        return JreHiDpiUtil.isJreHiDPI((GraphicsConfiguration)null);
    }

    public static boolean isJreHiDPI(@Nullable Component comp) {
        GraphicsConfiguration gc = comp != null ? comp.getGraphicsConfiguration() : null;
        return JreHiDpiUtil.isJreHiDPI(gc);
    }

    public static boolean isJreHiDPI(@Nullable ScaleContext ctx) {
        return JreHiDpiUtil.isJreHiDPIEnabled() && JBUIScale.isHiDPI(JBUIScale.sysScale(ctx));
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Dimension container, @NotNull Dimension child) {
        if (container == null) {
            StartupUiUtil.$$$reportNull$$$0(0);
        }
        if (child == null) {
            StartupUiUtil.$$$reportNull$$$0(1);
        }
        return StartupUiUtil.getCenterPoint(new Rectangle(container), child);
    }

    @NotNull
    public static Point getCenterPoint(@NotNull Rectangle container, @NotNull Dimension child) {
        if (container == null) {
            StartupUiUtil.$$$reportNull$$$0(2);
        }
        if (child == null) {
            StartupUiUtil.$$$reportNull$$$0(3);
        }
        return new Point(container.x + (container.width - child.width) / 2, container.y + (container.height - child.height) / 2);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, @Nullable ImageObserver observer) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(4);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(5);
        }
        StartupUiUtil.drawImage(g, image, new Rectangle(x, y, -1, -1), null, null, observer);
    }

    static void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, int width, int height, @Nullable BufferedImageOp op) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(6);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(7);
        }
        Rectangle srcBounds = width >= 0 && height >= 0 ? new Rectangle(x, y, width, height) : null;
        StartupUiUtil.drawImage(g, image, new Rectangle(x, y, width, height), srcBounds, op, null);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(8);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(9);
        }
        StartupUiUtil.drawImage(g, image, 0, 0, -1, -1, null);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable ImageObserver observer) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(10);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(11);
        }
        StartupUiUtil.drawImage(g, image, dstBounds, null, null, observer);
    }

    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable ImageObserver observer) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(12);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(13);
        }
        StartupUiUtil.drawImage(g, image, dstBounds, srcBounds, null, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable BufferedImageOp op, @Nullable ImageObserver observer) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(14);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(15);
        }
        int userWidth = ImageUtil.getUserWidth(image);
        int userHeight = ImageUtil.getUserHeight(image);
        int dx = 0;
        int dy = 0;
        int dw = -1;
        int dh = -1;
        if (dstBounds != null) {
            dx = dstBounds.x;
            dy = dstBounds.y;
            dw = dstBounds.width;
            dh = dstBounds.height;
        }
        boolean hasDstSize = dw >= 0 && dh >= 0;
        Graphics invG = null;
        double scale = 1.0;
        if (image instanceof JBHiDPIScaledImage) {
            AffineTransform tx;
            int maxSize;
            JBHiDPIScaledImage hidpiImage = (JBHiDPIScaledImage)image;
            Image delegate2 = hidpiImage.getDelegate();
            if (delegate2 != null) {
                image = delegate2;
            }
            scale = hidpiImage.getScale();
            double delta = 0.0;
            if (Boolean.parseBoolean(System.getProperty("ide.icon.scale.useAccuracyDelta", "true")) && (maxSize = Math.max(userWidth, userHeight)) < 0x3FFFFFFF) {
                double pow;
                int dotAccuracy = 1;
                while (true) {
                    double d;
                    pow = Math.pow(10.0, dotAccuracy);
                    if (!((double)maxSize > d)) break;
                    ++dotAccuracy;
                }
                delta = 1.0 / pow;
            }
            if (Math.abs(scale - (tx = ((Graphics2D)g).getTransform()).getScaleX()) <= delta) {
                scale = tx.getScaleX();
                double gScaleX = tx.getScaleX();
                double gScaleY = tx.getScaleY();
                tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
                tx.translate((double)dx * gScaleX, (double)dy * gScaleY);
                dy = 0;
                dx = 0;
                g = invG = (Graphics2D)g.create();
                ((Graphics2D)invG).setTransform(tx);
            }
        }
        double _scale = scale;
        Function<Integer, Integer> size = size1 -> (int)Math.round((double)size1.intValue() * _scale);
        try {
            if (op != null && image instanceof BufferedImage) {
                image = op.filter((BufferedImage)image, null);
            }
            if (invG != null && hasDstSize) {
                dw = size.apply(dw);
                dh = size.apply(dh);
            }
            if (srcBounds != null) {
                int sh;
                int sx = size.apply(srcBounds.x);
                int sy = size.apply(srcBounds.y);
                int sw = srcBounds.width >= 0 ? size.apply(srcBounds.width) : size.apply(userWidth) - sx;
                int n = sh = srcBounds.height >= 0 ? size.apply(srcBounds.height) : size.apply(userHeight) - sy;
                if (!hasDstSize) {
                    dw = size.apply(userWidth);
                    dh = size.apply(userHeight);
                }
                g.drawImage(image, dx, dy, dx + dw, dy + dh, sx, sy, sx + sw, sy + sh, observer);
            } else if (hasDstSize) {
                g.drawImage(image, dx, dy, dw, dh, observer);
            } else if (invG == null) {
                g.drawImage(image, dx, dy, userWidth, userHeight, observer);
            } else {
                g.drawImage(image, dx, dy, observer);
            }
        }
        finally {
            if (invG != null) {
                invG.dispose();
            }
        }
    }

    public static void drawImage(@NotNull Graphics g, @NotNull BufferedImage image, @Nullable BufferedImageOp op, int x, int y) {
        if (g == null) {
            StartupUiUtil.$$$reportNull$$$0(16);
        }
        if (image == null) {
            StartupUiUtil.$$$reportNull$$$0(17);
        }
        StartupUiUtil.drawImage(g, image, x, y, -1, -1, op);
    }

    public static Font getLabelFont() {
        return UIManager.getFont("Label.font");
    }

    public static boolean isDialogFont(@NotNull Font font) {
        if (font == null) {
            StartupUiUtil.$$$reportNull$$$0(18);
        }
        return "Dialog".equals(font.getFamily(Locale.US));
    }

    public static void initInputMapDefaults(UIDefaults defaults) {
        InputMap tableInputMap;
        InputMap passwordFieldInputMap;
        InputMap textFieldInputMap;
        InputMap textAreaInputMap;
        InputMap treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (treeInputMap != null) {
            treeInputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        if ((textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap")) != null) {
            StartupUiUtil.installCutCopyPasteShortcuts(textAreaInputMap, false);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            StartupUiUtil.installCutCopyPasteShortcuts(textFieldInputMap, false);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            StartupUiUtil.installCutCopyPasteShortcuts(passwordFieldInputMap, false);
        }
        if ((tableInputMap = (InputMap)defaults.get("Table.ancestorInputMap")) != null) {
            StartupUiUtil.installCutCopyPasteShortcuts(tableInputMap, true);
        }
    }

    private static void installCutCopyPasteShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String copyActionKey = useSimpleActionKeys ? "copy" : "copy-to-clipboard";
        String pasteActionKey = useSimpleActionKeys ? "paste" : "paste-from-clipboard";
        String cutActionKey = useSimpleActionKeys ? "cut" : "cut-to-clipboard";
        inputMap.put(KeyStroke.getKeyStroke(155, 128), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(155, 64), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(127, 64), cutActionKey);
        inputMap.put(KeyStroke.getKeyStroke(67, 128), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(86, 128), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(88, 128), "cut-to-clipboard");
    }

    public static void initFontDefaults(@NotNull UIDefaults defaults, @NotNull FontUIResource uiFont) {
        if (defaults == null) {
            StartupUiUtil.$$$reportNull$$$0(19);
        }
        if (uiFont == null) {
            StartupUiUtil.$$$reportNull$$$0(20);
        }
        defaults.put("Tree.ancestorInputMap", (Object)null);
        FontUIResource textFont = new FontUIResource(uiFont);
        FontUIResource monoFont = new FontUIResource("Monospaced", 0, uiFont.getSize());
        for (String fontResource : ourPatchableFontResources) {
            defaults.put(fontResource, uiFont);
        }
        if (!SystemInfoRt.isMac) {
            defaults.put("PasswordField.font", monoFont);
        }
        defaults.put("TextArea.font", monoFont);
        defaults.put("TextPane.font", textFont);
        defaults.put("EditorPane.font", textFont);
    }

    @NotNull
    public static FontUIResource getFontWithFallback(@Nullable String familyName, @JdkConstants.FontStyle int style, float size) {
        Font fontWithFallback = SystemInfoRt.isMac || GraphicsEnvironment.isHeadless() ? new Font(familyName, style, (int)size).deriveFont(size) : new StyleContext().getFont(familyName, style, (int)size).deriveFont(size);
        return fontWithFallback instanceof FontUIResource ? (FontUIResource)fontWithFallback : new FontUIResource(fontWithFallback);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaults";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiFont";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/StartupUiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCenterPoint";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "drawImage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isDialogFont";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "initFontDefaults";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

