/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.NotThisEntityId;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.ThisEntityId;
import com.intellij.workspaceModel.storage.UtilsKt;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.impl.ChangeEntry;
import com.intellij.workspaceModel.storage.impl.ChildEntityId;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckerKt;
import com.intellij.workspaceModel.storage.impl.ConsistencyCheckingMode;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.EntityStorageExtensionsKt;
import com.intellij.workspaceModel.storage.impl.ErrorReportingKt;
import com.intellij.workspaceModel.storage.impl.MutableRefsTable;
import com.intellij.workspaceModel.storage.impl.MutableStorageIndexes;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.RefsTableKt;
import com.intellij.workspaceModel.storage.impl.SoftLinkable;
import com.intellij.workspaceModel.storage.impl.WorkspaceBuilderChangeLogKt;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityBase;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageBuilderImpl;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityStorageImpl;
import com.intellij.workspaceModel.storage.impl.indices.EntityStorageInternalIndex;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 62\u00020\u0001:\u00016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J-\u0010\u001c\u001a\u00020\u00172\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e2\u000e\u0010 \u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000bH\u0002\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020#H\u0002J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0002J@\u0010(\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020)2\u0006\u0010 \u001a\u00020)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020#0+2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020#0+H\u0002J\u001c\u0010.\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\n\u0010 \u001a\u00060\nj\u0002`\u000bH\u0002J \u0010/\u001a\u00020\u00172\u000e\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e2\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u000205H\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u0016\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\f0\tj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0010\u001aB\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014 \u0013* \u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007\u00a8\u00067"}, d2={"Lcom/intellij/workspaceModel/storage/impl/AddDiffOperation;", "", "target", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "diff", "(Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;)V", "getDiff", "()Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageBuilderImpl;", "diffLog", "", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "Lcom/intellij/workspaceModel/storage/impl/ChangeEntry;", "Lcom/intellij/workspaceModel/storage/impl/ChangeLog;", "initialStorage", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityStorageImpl;", "replaceMap", "Lcom/google/common/collect/HashBiMap;", "Lcom/intellij/workspaceModel/storage/NotThisEntityId;", "kotlin.jvm.PlatformType", "Lcom/intellij/workspaceModel/storage/ThisEntityId;", "getTarget", "addDiff", "", "addRestoreChildren", "sourceEntityId", "targetEntityId", "addRestoreParents", "checkPersistentId", "entityData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "newEntityId", "(Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;Ljava/lang/Long;)V", "childrenMapper", "Lcom/intellij/workspaceModel/storage/impl/ChildEntityId;", "child", "replaceOperation", "change", "Lcom/intellij/workspaceModel/storage/impl/ChangeEntry$ReplaceEntity;", "replaceRestoreChildren", "Lcom/intellij/workspaceModel/storage/impl/ParentEntityId;", "addedChildrenMap", "Lcom/google/common/collect/HashMultimap;", "Lcom/intellij/workspaceModel/storage/impl/ConnectionId;", "removedChildrenMap", "replaceRestoreParents", "replaceSourceOperation", "data", "originalSource", "Lcom/intellij/workspaceModel/storage/EntitySource;", "serialize", "path", "", "Companion", "intellij.platform.workspaceModel.storage"})
public final class AddDiffOperation {
    private final HashBiMap<NotThisEntityId, ThisEntityId> replaceMap;
    private final Map<Long, ChangeEntry> diffLog;
    private final WorkspaceEntityStorageImpl initialStorage;
    @NotNull
    private final WorkspaceEntityStorageBuilderImpl target;
    @NotNull
    private final WorkspaceEntityStorageBuilderImpl diff;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void addDiff() {
        if (this.target == this.diff) {
            LOG.error("Trying to apply diff to itself");
        }
        if (LOG.isTraceEnabled()) {
            ConsistencyCheckerKt.assertConsistency(this.target);
            ConsistencyCheckerKt.assertConsistency(this.diff);
            LOG.trace("Before starting addDiff no consistency issues were found");
        }
        Map<Long, ChangeEntry> map2 = this.diffLog;
        for (Map.Entry<Long, ChangeEntry> entry : map2.entrySet()) {
            Object sourceEntityId;
            Object object;
            Logger logger;
            Logger $this$trace$iv;
            Object object2 = entry;
            ChangeEntry change = object2.getValue();
            if ((object2 = change) instanceof ChangeEntry.AddEntity) {
                $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    object = "addDiff: newEntity";
                    logger.trace((String)object);
                }
                this.checkPersistentId(((ChangeEntry.AddEntity)change).getEntityData(), null);
                sourceEntityId = UtilsKt.notThis(((ChangeEntry.AddEntity)change).getEntityData().createEntityId$intellij_platform_workspaceModel_storage());
                WorkspaceEntityData<? extends WorkspaceEntity> targetEntityData = null;
                ThisEntityId targetEntityId = null;
                ThisEntityId idFromReplaceMap = (ThisEntityId)this.replaceMap.get(sourceEntityId);
                if (idFromReplaceMap != null) {
                    targetEntityData = this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().cloneAndAddAt(((ChangeEntry.AddEntity)change).getEntityData(), idFromReplaceMap.getId());
                    targetEntityId = idFromReplaceMap;
                } else {
                    targetEntityData = this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().cloneAndAdd(((ChangeEntry.AddEntity)change).getEntityData(), ((ChangeEntry.AddEntity)change).getClazz());
                    targetEntityId = UtilsKt.asThis(targetEntityData.createEntityId$intellij_platform_workspaceModel_storage());
                    HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                    ((Map)hashBiMap).put(sourceEntityId, targetEntityId);
                }
                if (targetEntityData instanceof SoftLinkable) {
                    this.target.getIndexes$intellij_platform_workspaceModel_storage().updateSoftLinksIndex((SoftLinkable)((Object)targetEntityData));
                }
                this.addRestoreChildren((NotThisEntityId)sourceEntityId, targetEntityId);
                this.addRestoreParents((NotThisEntityId)sourceEntityId, targetEntityId);
                this.target.getIndexes$intellij_platform_workspaceModel_storage().updateIndices(((ChangeEntry.AddEntity)change).getEntityData().createEntityId$intellij_platform_workspaceModel_storage(), targetEntityData, this.diff);
                this.target.getChangeLog$intellij_platform_workspaceModel_storage().addAddEvent$intellij_platform_workspaceModel_storage(targetEntityId.getId(), targetEntityData);
                continue;
            }
            if (object2 instanceof ChangeEntry.RemoveEntity) {
                $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    object = "addDiff: remove entity. " + ((ChangeEntry.RemoveEntity)change).getId();
                    logger.trace((String)object);
                }
                if (this.replaceMap.containsValue(sourceEntityId = UtilsKt.asThis(((ChangeEntry.RemoveEntity)change).getId()))) continue;
                this.target.getIndexes$intellij_platform_workspaceModel_storage().entityRemoved(((ThisEntityId)sourceEntityId).getId());
                if (this.target.entityDataById$intellij_platform_workspaceModel_storage(((ThisEntityId)sourceEntityId).getId()) == null) continue;
                WorkspaceEntityStorageBuilderImpl.removeEntity$intellij_platform_workspaceModel_storage$default(this.target, ((ThisEntityId)sourceEntityId).getId(), null, 2, null);
                continue;
            }
            if (object2 instanceof ChangeEntry.ReplaceEntity) {
                $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    object = "addDiff: replace entity";
                    logger.trace((String)object);
                }
                this.replaceOperation((ChangeEntry.ReplaceEntity)change);
                continue;
            }
            if (object2 instanceof ChangeEntry.ChangeEntitySource) {
                $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    logger = $this$trace$iv;
                    boolean bl = false;
                    object = "addDiff: change entity source";
                    logger.trace((String)object);
                }
                this.replaceSourceOperation(((ChangeEntry.ChangeEntitySource)change).getNewData(), ((ChangeEntry.ChangeEntitySource)change).getOriginalSource());
                continue;
            }
            if (!(object2 instanceof ChangeEntry.ReplaceAndChangeSource)) continue;
            $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                logger = $this$trace$iv;
                boolean bl = false;
                object = "addDiff: replace and change source";
                logger.trace((String)object);
            }
            this.replaceOperation(((ChangeEntry.ReplaceAndChangeSource)change).getDataChange());
            this.replaceSourceOperation(((ChangeEntry.ReplaceAndChangeSource)change).getSourceChange().getNewData(), ((ChangeEntry.ReplaceAndChangeSource)change).getSourceChange().getOriginalSource());
        }
        MutableStorageIndexes mutableStorageIndexes = this.target.getIndexes$intellij_platform_workspaceModel_storage();
        HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
        Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
        mutableStorageIndexes.applyExternalMappingChanges(this.diff, hashBiMap, this.target);
        if (!this.target.getBrokenConsistency$intellij_platform_workspaceModel_storage() && !this.diff.getBrokenConsistency$intellij_platform_workspaceModel_storage()) {
            this.target.assertConsistencyInStrictMode$intellij_platform_workspaceModel_storage("Check after add Diff", null, this.initialStorage, this.diff);
        } else {
            this.target.setBrokenConsistency$intellij_platform_workspaceModel_storage(true);
        }
    }

    private final void replaceSourceOperation(WorkspaceEntityData<? extends WorkspaceEntity> data, EntitySource originalSource) {
        NotThisEntityId outdatedId = UtilsKt.notThis(data.createEntityId$intellij_platform_workspaceModel_storage());
        ThisEntityId usedPid = (ThisEntityId)this.replaceMap.getOrDefault((Object)outdatedId, (Object)UtilsKt.asThis(outdatedId.getId()));
        WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData = this.target.entityDataById$intellij_platform_workspaceModel_storage(usedPid.getId());
        if (existingEntityData != null) {
            EntitySource newEntitySource = data.getEntitySource();
            existingEntityData.setEntitySource(newEntitySource);
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.target.getIndexes$intellij_platform_workspaceModel_storage().getEntitySourceIndex$intellij_platform_workspaceModel_storage()).index$intellij_platform_workspaceModel_storage(usedPid.getId(), newEntitySource);
            this.target.getChangeLog$intellij_platform_workspaceModel_storage().addChangeSourceEvent$intellij_platform_workspaceModel_storage(usedPid.getId(), existingEntityData, originalSource);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addRestoreParents(NotThisEntityId sourceEntityId, ThisEntityId targetEntityId) {
        Map<ConnectionId, ParentEntityId> allParents = this.diff.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(sourceEntityId.getId()));
        Object object = allParents;
        Iterator<Map.Entry<ConnectionId, ParentEntityId>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            WorkspaceEntityBase obsoleteChild;
            ThisEntityId targetParentId;
            void connectionId;
            ThisEntityId thisEntityId;
            Map.Entry<ConnectionId, ParentEntityId> entry;
            Map.Entry<ConnectionId, ParentEntityId> entry2 = entry = iterator.next();
            object = entry2.getKey();
            entry2 = entry;
            ParentEntityId sourceParentId = entry2.getValue();
            if (this.diffLog.get(sourceParentId.getId()) instanceof ChangeEntry.AddEntity) {
                thisEntityId = (ThisEntityId)this.replaceMap.get((Object)UtilsKt.notThis(sourceParentId.getId()));
                if (thisEntityId == null) {
                    AddDiffOperation addDiffOperation;
                    AddDiffOperation $this$run = addDiffOperation = this;
                    boolean bl = false;
                    ThisEntityId placeholderId = UtilsKt.asThis($this$run.target.getEntitiesByType$intellij_platform_workspaceModel_storage().book(EntityIdKt.getClazz(sourceParentId.getId())));
                    HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = $this$run.replaceMap;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                    ((Map)hashBiMap).put(UtilsKt.notThis(sourceParentId.getId()), placeholderId);
                    thisEntityId = placeholderId;
                }
            } else if (this.target.entityDataById$intellij_platform_workspaceModel_storage(sourceParentId.getId()) != null) {
                thisEntityId = UtilsKt.asThis(sourceParentId.getId());
            } else {
                if (!connectionId.canRemoveParent()) {
                    this.target.addDiffAndReport$intellij_platform_workspaceModel_storage("Cannot restore dependency. " + (ConnectionId)connectionId + ", " + sourceParentId + ".id", this.initialStorage, this.diff);
                }
                thisEntityId = null;
            }
            if ((targetParentId = thisEntityId) == null) continue;
            if ((connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ONE || connectionId.getConnectionType() == ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE) && (obsoleteChild = (WorkspaceEntityBase)EntityStorageExtensionsKt.extractOneToOneChild(this.target, (ConnectionId)connectionId, targetParentId.getId())) != null && obsoleteChild.getId$intellij_platform_workspaceModel_storage() != targetEntityId.getId()) {
                this.target.removeEntity(obsoleteChild);
            }
            this.target.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, RefsTableKt.asChild(targetEntityId.getId()), RefsTableKt.asParent(targetParentId.getId()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addRestoreChildren(NotThisEntityId sourceEntityId, ThisEntityId targetEntityId) {
        Map<ConnectionId, List<ChildEntityId>> allSourceChildren = this.diff.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(sourceEntityId.getId()));
        Object object = allSourceChildren;
        Iterator<Map.Entry<ConnectionId, List<ChildEntityId>>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void connectionId;
            Map.Entry<ConnectionId, List<ChildEntityId>> entry;
            Map.Entry<ConnectionId, List<ChildEntityId>> entry2 = entry = iterator.next();
            object = entry2.getKey();
            entry2 = entry;
            List<ChildEntityId> sourceChildrenIds = entry2.getValue();
            List targetChildrenIds = new ArrayList();
            for (ChildEntityId sourceChildId : sourceChildrenIds) {
                if (this.diffLog.get(sourceChildId.getId()) instanceof ChangeEntry.AddEntity) {
                    Object object2;
                    ThisEntityId possibleTargetChildId = (ThisEntityId)this.replaceMap.get((Object)UtilsKt.notThis(sourceChildId.getId()));
                    if (possibleTargetChildId != null) {
                        Collection collection = targetChildrenIds;
                        object2 = RefsTableKt.asChild(possibleTargetChildId.getId());
                        collection.add(object2);
                        continue;
                    }
                    ThisEntityId placeholderId = UtilsKt.asThis(this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().book(EntityIdKt.getClazz(sourceChildId.getId())));
                    HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                    ((Map)hashBiMap).put(UtilsKt.notThis(sourceChildId.getId()), placeholderId);
                    object2 = targetChildrenIds;
                    ChildEntityId childEntityId = RefsTableKt.asChild(placeholderId.getId());
                    object2.add(childEntityId);
                    continue;
                }
                if (this.target.entityDataById$intellij_platform_workspaceModel_storage(sourceChildId.getId()) == null) continue;
                Collection collection = targetChildrenIds;
                collection.add(sourceChildId);
            }
            this.target.getRefs$intellij_platform_workspaceModel_storage().updateChildrenOfParent$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, RefsTableKt.asParent(targetEntityId.getId()), targetChildrenIds);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceOperation(ChangeEntry.ReplaceEntity change) {
        void $this$flatMapTo$iv$iv;
        NotThisEntityId sourceEntityId = UtilsKt.notThis(change.getNewData().createEntityId$intellij_platform_workspaceModel_storage());
        Map<ConnectionId, List<ChildEntityId>> $this$flatMap$iv = this.target.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(RefsTableKt.asParent(sourceEntityId.getId()));
        boolean $i$f$flatMap = false;
        Map<ConnectionId, List<ChildEntityId>> map2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry $dstr$key$value = element$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = $dstr$key$value;
            ConnectionId connectionId = (ConnectionId)entry.getKey();
            entry = $dstr$key$value;
            List value = (List)entry.getValue();
            Iterable $this$map$iv = value;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                void key;
                ChildEntityId childEntityId = (ChildEntityId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)key, (Object)it);
                collection.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List beforeChildren = (List)destination$iv$iv;
        Map<ConnectionId, ParentEntityId> beforeParents = this.target.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(RefsTableKt.asChild(sourceEntityId.getId()));
        ThisEntityId targetEntityId = (ThisEntityId)this.replaceMap.getOrDefault((Object)sourceEntityId, (Object)UtilsKt.asThis(sourceEntityId.getId()));
        Object newTargetEntityData = change.getNewData().clone();
        ((WorkspaceEntityData)newTargetEntityData).setId(EntityIdKt.getArrayId(targetEntityId.getId()));
        this.checkPersistentId(change.getNewData(), ((WorkspaceEntityData)newTargetEntityData).createEntityId$intellij_platform_workspaceModel_storage());
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.target.entityDataById$intellij_platform_workspaceModel_storage(targetEntityId.getId());
        if (workspaceEntityData == null) {
            return;
        }
        WorkspaceEntityData<? extends WorkspaceEntity> existingTargetEntityData = workspaceEntityData;
        WorkspaceEntityData<?> originalEntityData = WorkspaceBuilderChangeLogKt.getOriginalEntityData(this.target, targetEntityId.getId());
        Map<ConnectionId, ParentEntityId> originalParents = WorkspaceBuilderChangeLogKt.getOriginalParents(this.target, RefsTableKt.asChild(targetEntityId.getId()));
        ((WorkspaceEntityData)newTargetEntityData).setEntitySource(existingTargetEntityData.getEntitySource());
        this.target.getIndexes$intellij_platform_workspaceModel_storage().updateIndices(sourceEntityId.getId(), (WorkspaceEntityData<?>)newTargetEntityData, this.diff);
        long newEntityId = ((WorkspaceEntityData)newTargetEntityData).createEntityId$intellij_platform_workspaceModel_storage();
        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData2 = this.target.entityDataById$intellij_platform_workspaceModel_storage(newEntityId);
        PersistentEntityId<?> oldPersistentId = workspaceEntityData2 != null ? EntitiesKt.persistentId(workspaceEntityData2) : null;
        this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().replaceById(newTargetEntityData, EntityIdKt.getClazz(sourceEntityId.getId()));
        MutableStorageIndexes.updatePersistentIdIndexes$default(this.target.getIndexes$intellij_platform_workspaceModel_storage(), this.target, ((WorkspaceEntityData)newTargetEntityData).createEntity(this.target), oldPersistentId, (WorkspaceEntityData)newTargetEntityData, null, 16, null);
        HashMultimap addedChildrenMap = HashMultimap.create();
        Iterable $this$forEach$iv = change.getNewChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            addedChildrenMap.put(it.getFirst(), it.getSecond());
        }
        HashMultimap removedChildrenMap = HashMultimap.create();
        Iterable $this$forEach$iv2 = change.getRemovedChildren();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            removedChildrenMap.put(it.getFirst(), it.getSecond());
        }
        ParentEntityId parentEntityId = RefsTableKt.asParent(sourceEntityId.getId());
        ParentEntityId parentEntityId2 = RefsTableKt.asParent(newEntityId);
        HashMultimap hashMultimap = addedChildrenMap;
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"addedChildrenMap");
        HashMultimap hashMultimap2 = removedChildrenMap;
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap2, (String)"removedChildrenMap");
        this.replaceRestoreChildren(parentEntityId, parentEntityId2, (HashMultimap<ConnectionId, ChildEntityId>)hashMultimap, (HashMultimap<ConnectionId, ChildEntityId>)hashMultimap2);
        this.replaceRestoreParents(change, newEntityId);
        WorkspaceEntityStorageBuilderImpl.Companion.addReplaceEvent$intellij_platform_workspaceModel_storage(this.target, sourceEntityId.getId(), beforeChildren, beforeParents, (WorkspaceEntityData<? extends WorkspaceEntity>)newTargetEntityData, originalEntityData, originalParents);
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceRestoreChildren(ParentEntityId sourceEntityId, ParentEntityId newEntityId, HashMultimap<ConnectionId, ChildEntityId> addedChildrenMap, HashMultimap<ConnectionId, ChildEntityId> removedChildrenMap) {
        Object mutableChildren;
        List updatedChildren;
        ChildEntityId it$iv$iv;
        ChildEntityId childEntityId;
        ChildEntityId childEntityId2;
        ChildEntityId it;
        Iterator element$iv$iv;
        Iterator element$iv$iv$iv;
        Iterator iterator;
        boolean $i$f$forEach;
        void $this$forEach$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        boolean $i$f$mapNotNullTo;
        Iterable destination$iv$iv;
        boolean $i$f$mapNotNull;
        Iterable $this$mapNotNull$iv;
        Object connectionId;
        Map<ConnectionId, List<ChildEntityId>> existingChildren = this.target.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(newEntityId);
        Object object = existingChildren;
        Iterator<Map.Entry<ConnectionId, List<ChildEntityId>>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ConnectionId, List<ChildEntityId>> entry;
            Map.Entry<ConnectionId, List<ChildEntityId>> entry2 = entry = iterator2.next();
            object = entry2.getKey();
            entry2 = entry;
            List<ChildEntityId> children2 = entry2.getValue();
            if (((ConnectionId)connectionId).getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY) {
                List list = this.diff.getRefs$intellij_platform_workspaceModel_storage().getChildrenRefsOfParentBy(sourceEntityId).get(connectionId);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List sourceChildren = list;
                $this$mapNotNull$iv = sourceChildren;
                $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    it = (ChildEntityId)((Object)element$iv$iv);
                    boolean bl3 = false;
                    childEntityId2 = this.childrenMapper(it);
                    if (childEntityId2 == null) continue;
                    it$iv$iv = childEntityId = childEntityId2;
                    boolean bl = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                updatedChildren = (List)destination$iv$iv;
                if (Intrinsics.areEqual((Object)updatedChildren, children2) ^ true) {
                    this.target.getRefs$intellij_platform_workspaceModel_storage().updateChildrenOfParent$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, newEntityId, updatedChildren);
                }
            } else {
                Iterator $this$mapNotNullTo$iv$iv2;
                mutableChildren = CollectionsKt.toMutableList((Collection)children2);
                Set set = addedChildrenMap.get(connectionId);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set addedChildrenSet = set;
                Iterable $this$mapNotNull$iv2 = addedChildrenSet;
                boolean $i$f$mapNotNull2 = false;
                destination$iv$iv = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach2 = false;
                element$iv$iv$iv = $this$forEach$iv$iv$iv2.iterator();
                while (element$iv$iv$iv.hasNext()) {
                    Object element$iv$iv$iv2;
                    Object element$iv$iv2 = element$iv$iv$iv2 = element$iv$iv$iv.next();
                    boolean bl4 = false;
                    ChildEntityId it2 = (ChildEntityId)element$iv$iv2;
                    boolean bl5 = false;
                    ChildEntityId childEntityId3 = it2;
                    Intrinsics.checkNotNullExpressionValue((Object)childEntityId3, (String)"it");
                    childEntityId = this.childrenMapper(childEntityId3);
                    if (childEntityId == null) continue;
                    ChildEntityId it$iv$iv2 = it$iv$iv = childEntityId;
                    boolean bl6 = false;
                    destination$iv$iv2.add(it$iv$iv2);
                }
                List updatedAddedChildren = (List)destination$iv$iv2;
                mutableChildren.addAll(updatedAddedChildren);
                Set set2 = removedChildrenMap.get(connectionId);
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
                Set removedChildrenSet = set2;
                $this$mapNotNullTo$iv$iv2 = removedChildrenSet.iterator();
                while ($this$mapNotNullTo$iv$iv2.hasNext()) {
                    ChildEntityId removedChild = (ChildEntityId)$this$mapNotNullTo$iv$iv2.next();
                    mutableChildren.remove(removedChild);
                }
                if (Intrinsics.areEqual(children2, (Object)mutableChildren) ^ true) {
                    this.target.getRefs$intellij_platform_workspaceModel_storage().updateChildrenOfParent$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, newEntityId, (List<ChildEntityId>)mutableChildren);
                }
            }
            addedChildrenMap.removeAll(connectionId);
            removedChildrenMap.removeAll(connectionId);
        }
        Map map2 = addedChildrenMap.asMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"addedChildrenMap.asMap()");
        connectionId = map2;
        for (Map.Entry<ConnectionId, List<ChildEntityId>> entry : connectionId.entrySet()) {
            Collection children2;
            mutableChildren = entry;
            connectionId = mutableChildren.getKey();
            mutableChildren = entry;
            Collection collection = children2 = (Collection)mutableChildren.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"children");
            mutableChildren = CollectionsKt.toMutableList((Collection)collection);
            $this$mapNotNull$iv = children2;
            $i$f$mapNotNull = false;
            Iterable removedChild = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                it = (ChildEntityId)((Object)element$iv$iv);
                boolean bl7 = false;
                ChildEntityId childEntityId4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)childEntityId4, (String)"it");
                childEntityId2 = this.childrenMapper(childEntityId4);
                if (childEntityId2 == null) continue;
                it$iv$iv = childEntityId = childEntityId2;
                boolean bl2 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            updatedChildren = (List)destination$iv$iv;
            mutableChildren.addAll(updatedChildren);
            MutableRefsTable mutableRefsTable = this.target.getRefs$intellij_platform_workspaceModel_storage();
            Object object2 = connectionId;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"connectionId");
            mutableRefsTable.updateChildrenOfParent$intellij_platform_workspaceModel_storage((ConnectionId)object2, newEntityId, (List<ChildEntityId>)mutableChildren);
        }
    }

    private final ChildEntityId childrenMapper(ChildEntityId child) {
        ChildEntityId childEntityId;
        if (this.diffLog.get(child.getId()) instanceof ChangeEntry.AddEntity) {
            ThisEntityId possibleNewChildId = (ThisEntityId)this.replaceMap.get((Object)UtilsKt.notThis(child.getId()));
            if (possibleNewChildId != null) {
                childEntityId = RefsTableKt.asChild(possibleNewChildId.getId());
            } else {
                long bookedChildId = this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().book(EntityIdKt.getClazz(child.getId()));
                HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
                Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                ((Map)hashBiMap).put(UtilsKt.notThis(child.getId()), UtilsKt.asThis(bookedChildId));
                childEntityId = RefsTableKt.asChild(bookedChildId);
            }
        } else {
            childEntityId = this.target.entityDataById$intellij_platform_workspaceModel_storage(child.getId()) != null ? child : null;
        }
        return childEntityId;
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceRestoreParents(ChangeEntry.ReplaceEntity change, long newEntityId) {
        Map.Entry newParent;
        Object connectionId;
        Object element$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map<ConnectionId, ParentEntityId> $this$mapValues$iv = change.getModifiedParents();
        boolean $i$f$mapValues = false;
        Map<ConnectionId, ParentEntityId> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Object $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        Object object = $this$associateByTo$iv$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            void it$iv$iv;
            element$iv$iv$iv = object.next();
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map4 = map3;
            boolean bl2 = false;
            ParentEntityId parentEntityId = (ParentEntityId)it.getValue();
            map4.put(k2, parentEntityId);
        }
        Map updatedModifiedParents = destination$iv$iv;
        Map modifiedParentsMap = MapsKt.toMutableMap((Map)updatedModifiedParents);
        ChildEntityId newChildEntityId = RefsTableKt.asChild(newEntityId);
        Map<ConnectionId, ParentEntityId> existingParents = this.target.getRefs$intellij_platform_workspaceModel_storage().getParentRefsOfChild(newChildEntityId);
        $this$associateByTo$iv$iv$iv = existingParents;
        for (Map.Entry entry : $this$associateByTo$iv$iv$iv.entrySet()) {
            object = entry;
            $this$associateByTo$iv$iv$iv = (ConnectionId)object.getKey();
            object = entry;
            ParentEntityId existingParent = (ParentEntityId)object.getValue();
            object = modifiedParentsMap;
            element$iv$iv$iv = object;
            if (!element$iv$iv$iv.containsKey(connectionId)) continue;
            newParent = (ParentEntityId)MapsKt.getValue((Map)modifiedParentsMap, (Object)connectionId);
            if (newParent == null) {
                if (!((ConnectionId)connectionId).canRemoveParent()) {
                    this.target.addDiffAndReport$intellij_platform_workspaceModel_storage("Cannot restore some dependencies; " + (ConnectionId)connectionId, this.initialStorage, this.diff);
                } else {
                    this.target.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId, existingParent, newChildEntityId);
                }
            } else if (this.diffLog.get(((ParentEntityId)((Object)newParent)).getId()) instanceof ChangeEntry.AddEntity) {
                ThisEntityId possibleNewParent = (ThisEntityId)this.replaceMap.get((Object)UtilsKt.notThis(((ParentEntityId)((Object)newParent)).getId()));
                if (possibleNewParent == null) {
                    possibleNewParent = UtilsKt.asThis(this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().book(EntityIdKt.getClazz(((ParentEntityId)((Object)newParent)).getId())));
                    HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                    ((Map)hashBiMap).put(UtilsKt.notThis(((ParentEntityId)((Object)newParent)).getId()), possibleNewParent);
                }
                this.target.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, RefsTableKt.asChild(newEntityId), RefsTableKt.asParent(possibleNewParent.getId()));
            } else if (this.target.entityDataById$intellij_platform_workspaceModel_storage(((ParentEntityId)((Object)newParent)).getId()) != null) {
                this.target.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, RefsTableKt.asChild(newEntityId), (ParentEntityId)((Object)newParent));
            } else {
                if (!((ConnectionId)connectionId).canRemoveParent()) {
                    this.target.addDiffAndReport$intellij_platform_workspaceModel_storage("Cannot restore some dependencies; " + (ConnectionId)connectionId, this.initialStorage, this.diff);
                }
                this.target.getRefs$intellij_platform_workspaceModel_storage().removeParentToChildRef((ConnectionId)connectionId, existingParent, newChildEntityId);
            }
            modifiedParentsMap.remove(connectionId);
        }
        connectionId = modifiedParentsMap;
        for (Map.Entry entry : connectionId.entrySet()) {
            newParent = entry;
            connectionId = (ConnectionId)newParent.getKey();
            newParent = entry;
            ParentEntityId parentId = (ParentEntityId)newParent.getValue();
            if (parentId == null) continue;
            if (this.diffLog.get(parentId.getId()) instanceof ChangeEntry.AddEntity) {
                ThisEntityId possibleNewParent = (ThisEntityId)this.replaceMap.get((Object)UtilsKt.notThis(parentId.getId()));
                if (possibleNewParent == null) {
                    possibleNewParent = UtilsKt.asThis(this.target.getEntitiesByType$intellij_platform_workspaceModel_storage().book(EntityIdKt.getClazz(parentId.getId())));
                    HashBiMap<NotThisEntityId, ThisEntityId> hashBiMap = this.replaceMap;
                    Intrinsics.checkNotNullExpressionValue(hashBiMap, (String)"replaceMap");
                    ((Map)hashBiMap).put(UtilsKt.notThis(parentId.getId()), possibleNewParent);
                }
                this.target.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, RefsTableKt.asChild(newEntityId), RefsTableKt.asParent(possibleNewParent.getId()));
                continue;
            }
            if (this.target.entityDataById$intellij_platform_workspaceModel_storage(parentId.getId()) == null) continue;
            this.target.getRefs$intellij_platform_workspaceModel_storage().updateParentOfChild$intellij_platform_workspaceModel_storage((ConnectionId)connectionId, RefsTableKt.asChild(newEntityId), parentId);
        }
    }

    private final void checkPersistentId(WorkspaceEntityData<? extends WorkspaceEntity> entityData, Long newEntityId) {
        Long existingIds;
        PersistentEntityId<?> newPersistentId = EntitiesKt.persistentId(entityData);
        if (newPersistentId != null && (existingIds = this.target.getIndexes$intellij_platform_workspaceModel_storage().getPersistentIdIndex$intellij_platform_workspaceModel_storage().getIdsByEntry$intellij_platform_workspaceModel_storage(newPersistentId)) != null) {
            boolean existingIdCheck;
            boolean bl = existingIdCheck = newEntityId != null ? Intrinsics.areEqual((Object)existingIds, (Object)newEntityId) ^ true : true;
            if (existingIdCheck) {
                WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData = this.target.entityDataByIdOrDie$intellij_platform_workspaceModel_storage(existingIds);
                LOG.debug("Removing existing entity... " + existingIds);
                this.target.removeEntity(existingEntityData.createEntity(this.target));
                this.target.addDiffAndReport$intellij_platform_workspaceModel_storage(StringsKt.trimIndent((String)("\n                        Persistent ID already exists. Removing old entity\n                        Persistent ID: " + newPersistentId + "\n                        Existing entity data: " + existingEntityData + "\n                        New entity data: " + entityData + "\n                        ")), this.initialStorage, this.diff);
            }
        }
    }

    private final void serialize(String path) {
        File folder = new File(path);
        File file2 = FilesKt.resolve((File)folder, (String)"Instant_Save_Target");
        ErrorReportingKt.serializeTo(this.target, new FileOutputStream(file2));
        file2 = FilesKt.resolve((File)folder, (String)"Instant_Save_Source");
        ErrorReportingKt.serializeTo(this.diff, new FileOutputStream(file2));
        file2 = FilesKt.resolve((File)folder, (String)"Instant_Save_Diff");
        ErrorReportingKt.serializeDiff(this.diff, new FileOutputStream(file2));
    }

    @NotNull
    public final WorkspaceEntityStorageBuilderImpl getTarget() {
        return this.target;
    }

    @NotNull
    public final WorkspaceEntityStorageBuilderImpl getDiff() {
        return this.diff;
    }

    public AddDiffOperation(@NotNull WorkspaceEntityStorageBuilderImpl target, @NotNull WorkspaceEntityStorageBuilderImpl diff) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        this.target = target;
        this.diff = diff;
        this.replaceMap = HashBiMap.create();
        this.diffLog = this.diff.getChangeLog$intellij_platform_workspaceModel_storage().getChangeLog$intellij_platform_workspaceModel_storage();
        this.initialStorage = ConsistencyCheckingMode.Companion.getCurrent() != ConsistencyCheckingMode.DISABLED ? this.target.toStorage() : null;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AddDiffOperation.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/workspaceModel/storage/impl/AddDiffOperation$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

