/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.psi.PsiReference;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

public abstract class UnresolvedReferenceQuickFixProvider<T extends PsiReference> {
    private static final ExtensionPointName<UnresolvedReferenceQuickFixProvider<?>> EXTENSION_NAME = ExtensionPointName.create("com.intellij.codeInsight.unresolvedReferenceQuickFixProvider");

    public static <T extends PsiReference> void registerReferenceFixes(@NotNull T ref, @NotNull QuickFixActionRegistrar registrar) {
        if (ref == null) {
            UnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            UnresolvedReferenceQuickFixProvider.$$$reportNull$$$0(1);
        }
        boolean dumb = DumbService.getInstance(ref.getElement().getProject()).isDumb();
        Class<?> referenceClass = ref.getClass();
        for (UnresolvedReferenceQuickFixProvider<?> each : EXTENSION_NAME.getExtensionList()) {
            if (dumb && !DumbService.isDumbAware(each) || !ReflectionUtil.isAssignable(each.getReferenceClass(), referenceClass)) continue;
            each.registerFixes(ref, registrar);
        }
    }

    public abstract void registerFixes(@NotNull T var1, @NotNull QuickFixActionRegistrar var2);

    @NotNull
    public abstract Class<T> getReferenceClass();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ref";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "registrar";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/quickfix/UnresolvedReferenceQuickFixProvider";
        objectArray[2] = "registerReferenceFixes";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

