/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LanguageInspectionSuppressors;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.RedundantSuppressionDetector;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionElementsMerger;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.BidirectionalMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RedundantSuppressInspectionBase
extends GlobalSimpleInspectionTool {
    public static final String SHORT_NAME = "RedundantSuppression";
    private static final Logger LOG = Logger.getInstance(RedundantSuppressInspectionBase.class);
    public boolean IGNORE_ALL;
    private BidirectionalMap<String, QuickFix<?>> myQuickFixes;

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string2 = InspectionsBundle.message("group.names.declaration.redundancy", new Object[0]);
        if (string2 == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(1);
        }
        if (this.IGNORE_ALL) {
            super.writeSettings(node);
        }
    }

    @Override
    public void checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        ProblemDescriptor[] descriptors;
        InspectionSuppressor extension2;
        if (file2 == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(3);
        }
        if (problemsHolder == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(4);
        }
        if (globalContext == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(5);
        }
        if (problemDescriptionsProcessor == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(6);
        }
        if (!((extension2 = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(file2.getLanguage())) instanceof RedundantSuppressionDetector)) {
            return;
        }
        InspectionProfileImpl profile = RedundantSuppressInspectionBase.getProfile(manager, globalContext);
        for (ProblemDescriptor descriptor : descriptors = this.checkElement(file2, (RedundantSuppressionDetector)((Object)extension2), manager, profile)) {
            PsiElement psiElement;
            if (descriptor instanceof ProblemDescriptor && (psiElement = descriptor.getPsiElement()) != null) {
                PsiNamedElement member = globalContext.getRefManager().getContainerElement(psiElement);
                RefElement reference = globalContext.getRefManager().getReference(member);
                if (reference != null) {
                    problemDescriptionsProcessor.addProblemElement(reference, descriptor);
                    continue;
                }
                problemsHolder.registerProblem(psiElement, descriptor.getDescriptionTemplate(), new LocalQuickFix[0]);
                continue;
            }
            problemsHolder.registerProblem((PsiElement)file2, descriptor.getDescriptionTemplate(), new LocalQuickFix[0]);
        }
    }

    private ProblemDescriptor @NotNull [] checkElement(@NotNull PsiFile psiFile, final RedundantSuppressionDetector extension2, @NotNull InspectionManager manager, @NotNull InspectionProfile profile) {
        if (psiFile == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(8);
        }
        if (profile == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(9);
        }
        final HashMap suppressedScopes = new HashMap();
        psiFile.accept(new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                RedundantSuppressInspectionBase.collectSuppressions(element, suppressedScopes, RedundantSuppressInspectionBase.this.IGNORE_ALL, extension2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/RedundantSuppressInspectionBase$1", "visitElement"));
            }
        });
        if (suppressedScopes.values().isEmpty()) {
            if (ProblemDescriptor.EMPTY_ARRAY == null) {
                RedundantSuppressInspectionBase.$$$reportNull$$$0(10);
            }
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        HashMap suppressedTools = new HashMap();
        List<InspectionToolWrapper<?, ?>> toolWrappers = this.getInspectionTools(psiFile, profile);
        Language language = psiFile.getLanguage();
        for (Collection ids : suppressedScopes.values()) {
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                String suppressId = ((String)iterator.next()).trim();
                List<InspectionToolWrapper<?, ?>> reportingWrappers = RedundantSuppressInspectionBase.findReportingTools(toolWrappers, suppressId, language);
                if (reportingWrappers.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                for (InspectionToolWrapper<?, ?> toolWrapper : reportingWrappers) {
                    suppressedTools.put(toolWrapper, suppressId);
                }
            }
        }
        AnalysisScope scope = new AnalysisScope(psiFile);
        GlobalInspectionContextBase globalContext = this.createContext(psiFile);
        globalContext.setCurrentScope(scope);
        ArrayList result2 = new ArrayList();
        ((RefManagerImpl)globalContext.getRefManager()).runInsideInspectionReadAction(() -> {
            try {
                for (InspectionToolWrapper toolWrapper : suppressedTools.keySet()) {
                    Object global;
                    ArrayList<ProblemDescriptor> descriptors;
                    String toolId = (String)suppressedTools.get(toolWrapper);
                    toolWrapper.initialize(globalContext);
                    if (toolWrapper instanceof LocalInspectionToolWrapper) {
                        LocalInspectionToolWrapper local = (LocalInspectionToolWrapper)toolWrapper;
                        if (local.isUnfair()) continue;
                        LocalInspectionTool tool = (LocalInspectionTool)local.getTool();
                        List found = Collections.synchronizedList(new ArrayList());
                        InspectionEngine.inspectEx(Collections.singletonList(new LocalInspectionToolWrapper(tool)), psiFile, psiFile.getTextRange(), psiFile.getTextRange(), false, true, false, ProgressIndicatorProvider.getGlobalProgressIndicator(), (wrapper, descriptor) -> found.add(descriptor));
                        descriptors = new ArrayList(found);
                    } else {
                        GlobalInspectionTool globalTool;
                        if (!(toolWrapper instanceof GlobalInspectionToolWrapper) || (globalTool = (GlobalInspectionTool)((InspectionToolWrapper)(global = (GlobalInspectionToolWrapper)toolWrapper)).getTool()).isGraphNeeded() || globalTool instanceof RedundantSuppressInspectionBase) continue;
                        descriptors = new ArrayList<ProblemDescriptor>(InspectionEngine.runInspectionOnFile(psiFile, global, globalContext));
                    }
                    global = suppressedScopes.keySet().iterator();
                    block7: while (global.hasNext()) {
                        PsiElement suppressedScope = (PsiElement)global.next();
                        Collection suppressedIds = (Collection)suppressedScopes.get(suppressedScope);
                        if (!suppressedIds.contains(toolId)) continue;
                        for (CommonProblemDescriptor commonProblemDescriptor : descriptors) {
                            PsiLanguageInjectionHost host;
                            PsiElement element;
                            if (!(commonProblemDescriptor instanceof ProblemDescriptor) || (element = ((ProblemDescriptor)commonProblemDescriptor).getPsiElement()) == null || !extension2.isSuppressionFor(suppressedScope, ObjectUtils.notNull(host = InjectedLanguageManager.getInstance(element.getProject()).getInjectionHost(element), element), toolId)) continue;
                            suppressedIds.remove(toolId);
                            continue block7;
                        }
                    }
                }
                for (PsiElement suppressedScope : suppressedScopes.keySet()) {
                    Collection suppressedIds = (Collection)suppressedScopes.get(suppressedScope);
                    for (String toolId : suppressedIds) {
                        QuickFix<Object> fix;
                        PsiNamedElement documentedElement = globalContext.getRefManager().getContainerElement(suppressedScope);
                        if (documentedElement == null || !documentedElement.isValid()) continue;
                        RedundantSuppressInspectionBase redundantSuppressInspectionBase = this;
                        synchronized (redundantSuppressInspectionBase) {
                            String string2;
                            if (this.myQuickFixes == null) {
                                this.myQuickFixes = new BidirectionalMap();
                            }
                            if ((fix = this.myQuickFixes.get(string2 = toolId + ";" + suppressedScope.getLanguage().getID())) == null) {
                                fix = RedundantSuppressInspectionBase.createQuickFix(string2);
                                this.myQuickFixes.put(string2, fix);
                            }
                        }
                        PsiElement identifier = suppressedScope instanceof PsiNameIdentifierOwner && suppressedScope == documentedElement ? ObjectUtils.notNull(((PsiNameIdentifierOwner)suppressedScope).getNameIdentifier(), suppressedScope) : suppressedScope;
                        result2.add(manager.createProblemDescriptor(identifier, InspectionsBundle.message("inspection.redundant.suppression.description", new Object[0]), (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false));
                    }
                }
            }
            finally {
                globalContext.close(true);
            }
        });
        ProblemDescriptor[] problemDescriptorArray = result2.toArray(ProblemDescriptor.EMPTY_ARRAY);
        if (problemDescriptorArray == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(11);
        }
        return problemDescriptorArray;
    }

    @NotNull
    public LocalInspectionTool createLocalTool(RedundantSuppressionDetector suppressor, Map<String, Set<PsiElement>> toolToSuppressScopes, Set<String> activeTools) {
        return new LocalRedundantSuppressionInspection(suppressor, activeTools, toolToSuppressScopes);
    }

    @NotNull
    protected List<InspectionToolWrapper<?, ?>> getInspectionTools(PsiElement psiElement, @NotNull InspectionProfile profile) {
        if (profile == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(12);
        }
        List<InspectionToolWrapper<?, ?>> list = profile.getInspectionTools(psiElement);
        if (list == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @Nullable
    public synchronized QuickFix<?> getQuickFix(String hint) {
        return this.myQuickFixes != null ? this.myQuickFixes.get(hint) : RedundantSuppressInspectionBase.createQuickFix(hint);
    }

    @Override
    @Nullable
    public synchronized String getHint(@NotNull QuickFix fix) {
        List<String> list;
        if (fix == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(14);
        }
        if (this.myQuickFixes != null && (list = this.myQuickFixes.getKeysByValue(fix)) != null) {
            LOG.assertTrue(list.size() == 1);
            return list.get(0);
        }
        return null;
    }

    @Override
    public boolean worksInBatchModeOnly() {
        return false;
    }

    protected GlobalInspectionContextBase createContext(PsiFile file2) {
        InspectionManager inspectionManagerEx = InspectionManager.getInstance(file2.getProject());
        return (GlobalInspectionContextBase)inspectionManagerEx.createNewGlobalContext();
    }

    private static InspectionProfileImpl getProfile(InspectionManager manager, GlobalInspectionContext globalContext) {
        InspectionProfileImpl profile;
        if (globalContext instanceof GlobalInspectionContextBase && (profile = ((GlobalInspectionContextBase)globalContext).getCurrentProfile()).getSingleTool() == null) {
            return profile;
        }
        String currentProfileName = ((InspectionManagerBase)manager).getCurrentProfile();
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(manager.getProject());
        return ObjectUtils.notNull(profileManager.getProfile(currentProfileName, false), profileManager.getCurrentProfile());
    }

    private static List<InspectionToolWrapper<?, ?>> findReportingTools(@NotNull List<? extends InspectionToolWrapper<?, ?>> toolWrappers, String suppressedId, Language language) {
        if (toolWrappers == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(15);
        }
        List<InspectionToolWrapper<?, ?>> wrappers = Collections.emptyList();
        String mergedToolName = InspectionElementsMerger.getMergedToolName(suppressedId);
        for (InspectionToolWrapper<?, ?> toolWrapper : toolWrappers) {
            String toolWrapperShortName = toolWrapper.getShortName();
            String alternativeID = ((InspectionProfileEntry)toolWrapper.getTool()).getAlternativeID();
            if (toolWrapper instanceof LocalInspectionToolWrapper && (((LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool()).getID().equals(suppressedId) || suppressedId.equals(alternativeID) || toolWrapperShortName.equals(mergedToolName))) {
                if (((LocalInspectionToolWrapper)toolWrapper).isUnfair() || !toolWrapper.isApplicable(language)) continue;
                if (wrappers.isEmpty()) {
                    wrappers = new ArrayList();
                }
                wrappers.add(toolWrapper);
                continue;
            }
            if (!toolWrapperShortName.equals(suppressedId) && !toolWrapperShortName.equals(mergedToolName) && !suppressedId.equals(alternativeID) || !(toolWrapper instanceof LocalInspectionToolWrapper) && (!(toolWrapper instanceof GlobalInspectionToolWrapper) || ((GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool()).isGraphNeeded())) continue;
            if (wrappers.isEmpty()) {
                wrappers = new ArrayList();
            }
            wrappers.add(toolWrapper);
        }
        return wrappers;
    }

    private static boolean collectSuppressions(@NotNull PsiElement element, Map<PsiElement, Collection<String>> suppressedScopes, boolean ignoreAll, RedundantSuppressionDetector suppressor) {
        String idsString;
        if (element == null) {
            RedundantSuppressInspectionBase.$$$reportNull$$$0(16);
        }
        if ((idsString = suppressor.getSuppressionIds(element)) != null && !idsString.isEmpty()) {
            ArrayList<String> ids = new ArrayList<String>();
            StringUtil.tokenize(idsString, "[, ]").forEach(ids::add);
            boolean isSuppressAll = ids.stream().anyMatch(id -> id.equalsIgnoreCase("ALL"));
            if (ignoreAll && isSuppressAll) {
                return false;
            }
            Collection<String> suppressed = suppressedScopes.get(element);
            if (suppressed == null) {
                suppressed = ids;
            } else {
                for (String id2 : ids) {
                    if (suppressed.contains(id2)) continue;
                    suppressed.add(id2);
                }
            }
            suppressedScopes.put(element, suppressed);
            return isSuppressAll;
        }
        return false;
    }

    private static QuickFix<ProblemDescriptor> createQuickFix(String key) {
        Language language;
        String[] toolAndLang = key.split(";");
        Language language2 = language = toolAndLang.length < 2 ? null : Language.findLanguageByID(toolAndLang[1]);
        if (language == null) {
            return null;
        }
        InspectionSuppressor suppressor = (InspectionSuppressor)LanguageInspectionSuppressors.INSTANCE.forLanguage(language);
        return suppressor instanceof RedundantSuppressionDetector ? ((RedundantSuppressionDetector)((Object)suppressor)).createRemoveRedundantSuppressionFix(toolAndLang[0]) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RedundantSuppressInspectionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RedundantSuppressInspectionBase";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "checkElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionTools";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionTools";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getHint";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findReportingTools";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "collectSuppressions";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class LocalRedundantSuppressionInspection
    extends LocalInspectionTool
    implements UnfairLocalInspectionTool {
        private final RedundantSuppressionDetector mySuppressor;
        private final Set<String> myActiveTools;
        private final Map<String, Set<PsiElement>> myToolToSuppressScopes;

        private LocalRedundantSuppressionInspection(RedundantSuppressionDetector suppressor, Set<String> activeTools, Map<String, Set<PsiElement>> toolToSuppressScopes) {
            this.mySuppressor = suppressor;
            this.myActiveTools = activeTools;
            this.myToolToSuppressScopes = toolToSuppressScopes;
        }

        @Override
        @NotNull
        public String getShortName() {
            return RedundantSuppressInspectionBase.SHORT_NAME;
        }

        @Override
        @NotNull
        public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
            if (holder == null) {
                LocalRedundantSuppressionInspection.$$$reportNull$$$0(0);
            }
            return new PsiElementVisitor(){

                @Override
                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitElement(element);
                    HashMap<PsiElement, Collection<String>> scopes = new HashMap<PsiElement, Collection<String>>();
                    boolean suppressAll = RedundantSuppressInspectionBase.collectSuppressions(element, scopes, RedundantSuppressInspectionBase.this.IGNORE_ALL, LocalRedundantSuppressionInspection.this.mySuppressor);
                    if (suppressAll) {
                        return;
                    }
                    Collection<String> suppressIds = scopes.get(element);
                    if (suppressIds != null) {
                        for (String suppressId : suppressIds) {
                            TextRange highlightingRange;
                            if (!LocalRedundantSuppressionInspection.this.myActiveTools.contains(suppressId) || this.isSuppressedFor(element, suppressId, LocalRedundantSuppressionInspection.this.myToolToSuppressScopes.get(suppressId)) || SuppressionUtil.inspectionResultSuppressed(element, LocalRedundantSuppressionInspection.this) || (highlightingRange = LocalRedundantSuppressionInspection.this.mySuppressor.getHighlightingRange(element, suppressId)) == null) continue;
                            holder.registerProblem(element, highlightingRange, InspectionsBundle.message("inspection.redundant.suppression.description", new Object[0]), LocalRedundantSuppressionInspection.this.mySuppressor.createRemoveRedundantSuppressionFix(suppressId));
                        }
                    }
                }

                private boolean isSuppressedFor(PsiElement element, String suppressId, Set<? extends PsiElement> suppressedPlaces) {
                    return suppressedPlaces != null && suppressedPlaces.stream().anyMatch(place -> LocalRedundantSuppressionInspection.this.mySuppressor.isSuppressionFor(element, (PsiElement)place, suppressId));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/RedundantSuppressInspectionBase$LocalRedundantSuppressionInspection$1", "visitElement"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/RedundantSuppressInspectionBase$LocalRedundantSuppressionInspection", "buildVisitor"));
        }
    }
}

