/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.rangeSet;

import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import org.jetbrains.annotations.NotNull;

public enum LongRangeType {
    INT32(true, 4),
    INT64(true, 8);

    private final boolean mySigned;
    private final int myBytes;
    private final LongRangeSet myRange;

    private LongRangeType(boolean signed, int bytes) {
        this.mySigned = signed;
        this.myBytes = bytes;
        this.myRange = LongRangeSet.range(this.min(), this.max());
    }

    public int bytes() {
        return this.myBytes;
    }

    public int bits() {
        return this.myBytes * 8;
    }

    @NotNull
    public LongRangeSet fullRange() {
        LongRangeSet longRangeSet = this.myRange;
        if (longRangeSet == null) {
            LongRangeType.$$$reportNull$$$0(0);
        }
        return longRangeSet;
    }

    public long min() {
        return this.mySigned ? -(1L << this.bits() - 1) : 0L;
    }

    public long max() {
        return (1L << (this.mySigned ? this.bits() - 1 : this.bits())) - 1L;
    }

    public long cast(long value) {
        switch (this) {
            case INT32: {
                return (int)value;
            }
            case INT64: {
                return value;
            }
        }
        throw new IllegalStateException("Unexpected value: " + this);
    }

    public boolean subtractionMayOverflow(long a, long b) {
        if (this.myBytes == 8) {
            long diff = a - b;
            return ((a ^ b) & (a ^ diff)) < 0L;
        }
        long diff = a - b;
        return diff < this.min() || diff > this.max();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/rangeSet/LongRangeType", "fullRange"));
    }
}

