/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.codeInspection.lang.RefManagerExtension;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefDirectoryImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefManagerImpl
extends RefManager {
    public static final ExtensionPointName<RefGraphAnnotator> EP_NAME = ExtensionPointName.create("com.intellij.refGraphAnnotator");
    private static final Logger LOG = Logger.getInstance(RefManager.class);
    private long myLastUsedMask;
    @NotNull
    private final Project myProject;
    private AnalysisScope myScope;
    private RefProject myRefProject;
    private final Set<VirtualFile> myUnprocessedFiles;
    private final boolean processExternalElements;
    private final ConcurrentHashMap<PsiAnchor, RefElement> myRefTable;
    private volatile List<RefElement> myCachedSortedRefs;
    private final ConcurrentMap<Module, RefModule> myModules;
    private final ProjectIterator myProjectIterator;
    private final AtomicBoolean myDeclarationsFound;
    private final PsiManager myPsiManager;
    private volatile boolean myIsInProcess;
    private volatile boolean myOfflineView;
    private final List<RefGraphAnnotator> myGraphAnnotators;
    private GlobalInspectionContext myContext;
    private final Map<Key<?>, RefManagerExtension<?>> myExtensions;
    private final Map<Language, RefManagerExtension<?>> myLanguageExtensions;
    private final Interner<String> myNameInterner;
    private volatile BlockingQueue<Runnable> myTasks;
    private volatile List<Future<?>> myFutures;

    public RefManagerImpl(@NotNull Project project, @Nullable AnalysisScope scope, @NotNull GlobalInspectionContext context2) {
        if (project == null) {
            RefManagerImpl.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            RefManagerImpl.$$$reportNull$$$0(1);
        }
        this.myLastUsedMask = 0x8000000L;
        this.myUnprocessedFiles = VfsUtilCore.createCompactVirtualFileSet();
        this.processExternalElements = Registry.is("batch.inspections.process.external.elements");
        this.myRefTable = new ConcurrentHashMap();
        this.myModules = new ConcurrentHashMap<Module, RefModule>();
        this.myProjectIterator = new ProjectIterator();
        this.myDeclarationsFound = new AtomicBoolean(false);
        this.myGraphAnnotators = ContainerUtil.createConcurrentList();
        this.myExtensions = new HashMap();
        this.myLanguageExtensions = new HashMap();
        this.myNameInterner = Interner.createStringInterner();
        this.myProject = project;
        this.myScope = scope;
        this.myContext = context2;
        this.myPsiManager = PsiManager.getInstance(project);
        this.myRefProject = new RefProjectImpl(this);
        for (InspectionExtensionsFactory factory2 : InspectionExtensionsFactory.EP_NAME.getExtensionList()) {
            RefManagerExtension extension2 = factory2.createRefManagerExtension(this);
            if (extension2 == null) continue;
            this.myExtensions.put(extension2.getID(), extension2);
            for (Language language : extension2.getLanguages()) {
                this.myLanguageExtensions.put(language, extension2);
            }
        }
        if (scope != null) {
            for (Module module : ModuleManager.getInstance(this.getProject()).getModules()) {
                this.getRefModule(module);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String internName(@NotNull String name) {
        if (name == null) {
            RefManagerImpl.$$$reportNull$$$0(2);
        }
        Interner<String> interner = this.myNameInterner;
        synchronized (interner) {
            return this.myNameInterner.intern(name);
        }
    }

    @NotNull
    public GlobalInspectionContext getContext() {
        GlobalInspectionContext globalInspectionContext = this.myContext;
        if (globalInspectionContext == null) {
            RefManagerImpl.$$$reportNull$$$0(3);
        }
        return globalInspectionContext;
    }

    @Override
    public void iterate(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            RefManagerImpl.$$$reportNull$$$0(4);
        }
        for (RefElement refElement : this.getSortedElements()) {
            refElement.accept(visitor);
        }
        for (RefModule refModule : this.myModules.values()) {
            if (!this.myScope.containsModule(refModule.getModule())) continue;
            refModule.accept(visitor);
        }
        for (RefManagerExtension refManagerExtension : this.myExtensions.values()) {
            refManagerExtension.iterate(visitor);
        }
    }

    public void cleanup() {
        this.myScope = null;
        this.myRefProject = null;
        this.myRefTable.clear();
        this.myCachedSortedRefs = null;
        this.myModules.clear();
        this.myContext = null;
        this.myGraphAnnotators.clear();
        for (RefManagerExtension<?> extension2 : this.myExtensions.values()) {
            extension2.cleanup();
        }
        this.myExtensions.clear();
        this.myLanguageExtensions.clear();
    }

    @Override
    @Nullable
    public AnalysisScope getScope() {
        return this.myScope;
    }

    private void fireNodeInitialized(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onInitialize(refElement);
        }
    }

    public void fireNodeMarkedReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer, forReading, forWriting);
        }
    }

    public void fireNodeMarkedReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting, PsiElement element) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(refWhat, refFrom, referencedFromClassInitializer, forReading, forWriting, element);
        }
    }

    public void fireNodeMarkedReferenced(PsiElement what, PsiElement from) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onMarkReferenced(what, from, false);
        }
    }

    public void fireBuildReferences(RefElement refElement) {
        for (RefGraphAnnotator annotator : this.myGraphAnnotators) {
            annotator.onReferencesBuild(refElement);
        }
    }

    public void registerGraphAnnotator(@NotNull RefGraphAnnotator annotator) {
        if (annotator == null) {
            RefManagerImpl.$$$reportNull$$$0(5);
        }
        if (!this.myGraphAnnotators.contains(annotator)) {
            this.myGraphAnnotators.add(annotator);
            if (annotator instanceof RefGraphAnnotatorEx) {
                ((RefGraphAnnotatorEx)annotator).initialize(this);
            }
        }
    }

    public void unregisterAnnotator(RefGraphAnnotator annotator) {
        this.myGraphAnnotators.remove(annotator);
    }

    @Override
    public synchronized long getLastUsedMask() {
        if (this.myLastUsedMask < 0L) {
            throw new IllegalStateException("We're out of 64 bits, sorry");
        }
        this.myLastUsedMask <<= 1;
        return this.myLastUsedMask;
    }

    @Override
    public <T> T getExtension(@NotNull Key<T> key) {
        if (key == null) {
            RefManagerImpl.$$$reportNull$$$0(6);
        }
        return (T)this.myExtensions.get(key);
    }

    @Override
    @Nullable
    public String getType(@NotNull RefEntity ref) {
        if (ref == null) {
            RefManagerImpl.$$$reportNull$$$0(7);
        }
        for (RefManagerExtension<?> extension2 : this.myExtensions.values()) {
            String type = extension2.getType(ref);
            if (type == null) continue;
            return type;
        }
        if (ref instanceof RefFile) {
            return "file";
        }
        if (ref instanceof RefModule) {
            return "module";
        }
        if (ref instanceof RefProject) {
            return "project";
        }
        if (ref instanceof RefDirectory) {
            return "dir";
        }
        return null;
    }

    @Override
    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        if (ref == null) {
            RefManagerImpl.$$$reportNull$$$0(8);
        }
        for (RefManagerExtension<?> extension2 : this.myExtensions.values()) {
            ref = extension2.getRefinedElement(ref);
        }
        RefEntity refEntity = ref;
        if (refEntity == null) {
            RefManagerImpl.$$$reportNull$$$0(9);
        }
        return refEntity;
    }

    @Override
    @Nullable
    public Element export(@NotNull RefEntity refEntity, int actualLine) {
        if (refEntity == null) {
            RefManagerImpl.$$$reportNull$$$0(10);
        }
        refEntity = this.getRefinedElement(refEntity);
        Element problem = new Element("problem");
        if (refEntity instanceof RefDirectory) {
            Element fileElement = new Element("file");
            VirtualFile virtualFile = ((PsiDirectory)((RefDirectory)refEntity).getPsiElement()).getVirtualFile();
            fileElement.addContent(virtualFile.getUrl());
            problem.addContent(fileElement);
        } else if (refEntity instanceof RefElement) {
            int resultLine;
            RefElement refElement = (RefElement)refEntity;
            SmartPsiElementPointer<?> pointer = refElement.getPointer();
            PsiFile psiFile = pointer.getContainingFile();
            if (psiFile == null) {
                return null;
            }
            Element fileElement = new Element("file");
            VirtualFile virtualFile = psiFile.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            fileElement.addContent(virtualFile.getUrl());
            problem.addContent(fileElement);
            if (actualLine == -1) {
                Document document = PsiDocumentManager.getInstance(pointer.getProject()).getDocument(psiFile);
                LOG.assertTrue(document != null);
                Segment range = pointer.getRange();
                resultLine = range == null ? -1 : document.getLineNumber(range.getStartOffset()) + 1;
            } else {
                resultLine = actualLine + 1;
            }
            Element lineElement = new Element("line");
            lineElement.addContent(String.valueOf(resultLine));
            problem.addContent(lineElement);
            RefManagerImpl.appendModule(problem, refElement.getModule());
        } else if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            VirtualFile moduleFile = refModule.getModule().getModuleFile();
            Element fileElement = new Element("file");
            fileElement.addContent(moduleFile != null ? moduleFile.getUrl() : refEntity.getName());
            problem.addContent(fileElement);
            RefManagerImpl.appendModule(problem, refModule);
        }
        for (RefManagerExtension<?> extension2 : this.myExtensions.values()) {
            extension2.export(refEntity, problem);
        }
        new SmartRefElementPointerImpl(refEntity, true).writeExternal(problem);
        return problem;
    }

    @Override
    @Nullable
    public Element export(@NotNull RefEntity entity) {
        Element element;
        if (entity == null) {
            RefManagerImpl.$$$reportNull$$$0(11);
        }
        if ((element = this.export(entity, -1)) == null) {
            return null;
        }
        if (!(entity instanceof RefElement)) {
            return element;
        }
        SmartPsiElementPointer<?> pointer = ((RefElement)entity).getPointer();
        PsiFile psiFile = pointer.getContainingFile();
        if (psiFile == null) {
            return element;
        }
        Document document = PsiDocumentManager.getInstance(pointer.getProject()).getDocument(psiFile);
        if (document == null) {
            return element;
        }
        Segment range = pointer.getRange();
        if (range == null) {
            return element;
        }
        int firstRangeLine = document.getLineNumber(range.getStartOffset());
        int lineStartOffset = document.getLineStartOffset(firstRangeLine);
        int endOffset = Math.min(range.getEndOffset(), document.getLineEndOffset(firstRangeLine));
        TextRange exportedRange = new TextRange(range.getStartOffset(), endOffset);
        String text = ProblemDescriptorUtil.extractHighlightedText(exportedRange, (PsiElement)psiFile);
        element.addContent(new Element("offset").addContent(String.valueOf(exportedRange.getStartOffset() - lineStartOffset)));
        element.addContent(new Element("length").addContent(String.valueOf(exportedRange.getLength())));
        element.addContent(new Element("highlighted_element").addContent(ProblemDescriptorUtil.sanitizeIllegalXmlChars(text)));
        return element;
    }

    @Override
    @Nullable
    public String getGroupName(@NotNull RefElement entity) {
        RefEntity parent;
        if (entity == null) {
            RefManagerImpl.$$$reportNull$$$0(12);
        }
        for (RefManagerExtension<?> extension2 : this.myExtensions.values()) {
            String groupName = extension2.getGroupName(entity);
            if (groupName == null) continue;
            return groupName;
        }
        for (parent = entity.getOwner(); parent != null && !(parent instanceof RefDirectory); parent = parent.getOwner()) {
        }
        LinkedList<String> containingDirs = new LinkedList<String>();
        while (parent instanceof RefDirectory) {
            containingDirs.addFirst(parent.getName());
            parent = parent.getOwner();
        }
        return containingDirs.isEmpty() ? null : StringUtil.join(containingDirs, File.separator);
    }

    private static void appendModule(Element problem, RefModule refModule) {
        if (refModule != null) {
            Element moduleElement = new Element("module");
            moduleElement.addContent(refModule.getName());
            problem.addContent(moduleElement);
        }
    }

    public void findAllDeclarations() {
        if (!this.myDeclarationsFound.getAndSet(true)) {
            long before = System.currentTimeMillis();
            this.startTaskRunners();
            AnalysisScope scope = this.getScope();
            if (scope != null) {
                scope.accept(this.myProjectIterator);
            }
            this.waitForTasksToComplete();
            LOG.info("Total duration of processing project usages: " + (System.currentTimeMillis() - before) + "ms");
        }
    }

    private void waitForTasksToComplete() {
        List<Future<?>> futures = this.myFutures;
        if (futures == null) {
            return;
        }
        this.myFutures = null;
        try {
            for (Future<?> future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void executeTask(Runnable runnable) {
        if (this.myTasks != null) {
            try {
                this.myTasks.put(runnable);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            runnable.run();
        }
    }

    private void startTaskRunners() {
        if (!Registry.is("batch.inspections.process.project.usages.in.parallel")) {
            return;
        }
        int threadsCount = Math.min(4, Runtime.getRuntime().availableProcessors() - 1);
        if (threadsCount == 0) {
            return;
        }
        LOG.info("Processing project usages using " + threadsCount + " threads");
        this.myTasks = new LinkedBlockingQueue<Runnable>();
        this.myFutures = new ArrayList();
        Application application = ApplicationManager.getApplication();
        ProgressManager progressManager = ProgressManager.getInstance();
        ProgressIndicator indicator = progressManager.getProgressIndicator();
        for (int i = 0; i < (threadsCount > 0 ? threadsCount : 4); ++i) {
            Future<?> future = application.executeOnPooledThread(() -> {
                while (this.myTasks != null) {
                    if (this.myFutures == null && this.myTasks.isEmpty()) {
                        return;
                    }
                    try {
                        Runnable task = this.myTasks.poll(50L, TimeUnit.MILLISECONDS);
                        if (task == null) continue;
                        DumbService.getInstance(this.myProject).runReadActionInSmartMode(() -> progressManager.executeProcessUnderProgress(task, indicator));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            this.myFutures.add(future);
        }
    }

    public boolean isDeclarationsFound() {
        return this.myDeclarationsFound.get();
    }

    public void runInsideInspectionReadAction(@NotNull Runnable runnable) {
        if (runnable == null) {
            RefManagerImpl.$$$reportNull$$$0(13);
        }
        this.myIsInProcess = true;
        try {
            runnable.run();
        }
        finally {
            this.myTasks = null;
            this.waitForTasksToComplete();
            this.myIsInProcess = false;
            if (this.myScope != null) {
                this.myScope.invalidate();
            }
            this.myCachedSortedRefs = null;
        }
    }

    public void startOfflineView() {
        this.myOfflineView = true;
    }

    public boolean isOfflineView() {
        return this.myOfflineView;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            RefManagerImpl.$$$reportNull$$$0(14);
        }
        return project;
    }

    @Override
    @NotNull
    public RefProject getRefProject() {
        RefProject refProject = this.myRefProject;
        if (refProject == null) {
            RefManagerImpl.$$$reportNull$$$0(15);
        }
        return refProject;
    }

    @NotNull
    public List<RefElement> getSortedElements() {
        List<RefElement> answer = this.myCachedSortedRefs;
        if (answer != null) {
            List<RefElement> list = answer;
            if (list == null) {
                RefManagerImpl.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<RefElement> list = answer = new ArrayList<RefElement>(this.myRefTable.values());
        ReadAction.run(() -> ContainerUtil.quickSort(list, (o1, o2) -> {
            VirtualFile v2;
            VirtualFile v1 = ((RefElementImpl)o1).getVirtualFile();
            if (!Objects.equals(v1, v2 = ((RefElementImpl)o2).getVirtualFile())) {
                return (v1 == null ? "" : v1.getPath()).compareTo(v2 == null ? "" : v2.getPath());
            }
            Segment r1 = ObjectUtils.notNull(o1.getPointer().getRange(), TextRange.EMPTY_RANGE);
            Segment r2 = ObjectUtils.notNull(o2.getPointer().getRange(), TextRange.EMPTY_RANGE);
            return Segment.BY_START_OFFSET_THEN_END_OFFSET.compare(r1, r2);
        }));
        this.myCachedSortedRefs = answer = Collections.unmodifiableList(answer);
        List<RefElement> list2 = answer;
        if (list2 == null) {
            RefManagerImpl.$$$reportNull$$$0(17);
        }
        return list2;
    }

    @Override
    @NotNull
    public PsiManager getPsiManager() {
        PsiManager psiManager = this.myPsiManager;
        if (psiManager == null) {
            RefManagerImpl.$$$reportNull$$$0(18);
        }
        return psiManager;
    }

    @Override
    public synchronized boolean isInGraph(VirtualFile file2) {
        return !this.myUnprocessedFiles.contains(file2);
    }

    @Override
    @Nullable
    public PsiNamedElement getContainerElement(@NotNull PsiElement element) {
        Language language;
        RefManagerExtension<?> extension2;
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(19);
        }
        if ((extension2 = this.myLanguageExtensions.get(language = element.getLanguage())) == null) {
            return null;
        }
        return extension2.getElementContainer(element);
    }

    private synchronized void registerUnprocessed(VirtualFile virtualFile) {
        this.myUnprocessedFiles.add(virtualFile);
    }

    private void removeReference(@NotNull RefElement refElem) {
        PsiElement element;
        RefManagerExtension<?> extension2;
        if (refElem == null) {
            RefManagerImpl.$$$reportNull$$$0(20);
        }
        RefManagerExtension<?> refManagerExtension = extension2 = (element = refElem.getPsiElement()) != null ? this.getExtension(element.getLanguage()) : null;
        if (extension2 != null) {
            extension2.removeReference(refElem);
        }
        if (element != null && this.myRefTable.remove(RefManagerImpl.createAnchor(element)) != null) {
            return;
        }
        for (Map.Entry<PsiAnchor, RefElement> entry : this.myRefTable.entrySet()) {
            RefElement value = entry.getValue();
            PsiAnchor anchor = entry.getKey();
            if (value != refElem) continue;
            this.myRefTable.remove(anchor);
            break;
        }
        this.myCachedSortedRefs = null;
    }

    @NotNull
    private static PsiAnchor createAnchor(@NotNull PsiElement element) {
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(21);
        }
        PsiAnchor psiAnchor = ReadAction.compute(() -> PsiAnchor.create(element));
        if (psiAnchor == null) {
            RefManagerImpl.$$$reportNull$$$0(22);
        }
        return psiAnchor;
    }

    public void initializeAnnotators() {
        for (RefGraphAnnotator annotator : EP_NAME.getExtensionList()) {
            this.registerGraphAnnotator(annotator);
        }
    }

    @Override
    @Nullable
    public RefElement getReference(@Nullable PsiElement elem) {
        return this.getReference(elem, false);
    }

    @Nullable
    public RefElement getReference(PsiElement elem, boolean ignoreScope) {
        if (ReadAction.compute(() -> elem == null || !elem.isValid() || elem instanceof LightElement || !(elem instanceof PsiDirectory) && !this.belongsToScope(elem, ignoreScope)).booleanValue()) {
            return null;
        }
        return this.getFromRefTableOrCache(elem, () -> ReadAction.compute(() -> {
            RefElement refElement;
            RefManagerExtension<?> extension2 = this.getExtension(elem.getLanguage());
            if (extension2 != null && (refElement = extension2.createRefElement(elem)) != null) {
                return (RefElementImpl)refElement;
            }
            if (elem instanceof PsiFile) {
                return new RefFileImpl((PsiFile)elem, (RefManager)this);
            }
            if (elem instanceof PsiDirectory) {
                return new RefDirectoryImpl((PsiDirectory)elem, (RefManager)this);
            }
            return null;
        }), element -> {
            element.initialize();
            element.setInitialized(true);
            for (RefManagerExtension<?> each : this.myExtensions.values()) {
                each.onEntityInitialized((RefElement)element, elem);
            }
            this.fireNodeInitialized((RefElement)element);
        });
    }

    private RefManagerExtension<?> getExtension(Language language) {
        return this.myLanguageExtensions.get(language);
    }

    @Override
    @Nullable
    public RefEntity getReference(String type, String fqName) {
        for (RefManagerExtension<?> extension2 : this.myExtensions.values()) {
            RefEntity refEntity = extension2.getReference(type, fqName);
            if (refEntity == null) continue;
            return refEntity;
        }
        if ("file".equals(type)) {
            return RefFileImpl.fileFromExternalName(this, fqName);
        }
        if ("module".equals(type)) {
            return RefModuleImpl.moduleFromName(this, fqName);
        }
        if ("project".equals(type)) {
            return this.getRefProject();
        }
        if ("dir".equals(type)) {
            String url = VfsUtilCore.pathToUrl(PathMacroManager.getInstance(this.getProject()).expandPath(fqName));
            VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
            if (vFile != null) {
                PsiDirectory dir = PsiManager.getInstance(this.getProject()).findDirectory(vFile);
                return this.getReference(dir);
            }
        }
        return null;
    }

    @Nullable
    public <T extends RefElement> T getFromRefTableOrCache(@NotNull PsiElement element, @NotNull NullableFactory<? extends T> factory2) {
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(23);
        }
        if (factory2 == null) {
            RefManagerImpl.$$$reportNull$$$0(24);
        }
        return this.getFromRefTableOrCache(element, factory2, null);
    }

    @Nullable
    private <T extends RefElement> T getFromRefTableOrCache(@NotNull PsiElement element, @NotNull NullableFactory<? extends T> factory2, @Nullable Consumer<? super T> whenCached) {
        PsiAnchor psiAnchor;
        RefElement result2;
        if (element == null) {
            RefManagerImpl.$$$reportNull$$$0(25);
        }
        if (factory2 == null) {
            RefManagerImpl.$$$reportNull$$$0(26);
        }
        if ((result2 = this.myRefTable.get(psiAnchor = RefManagerImpl.createAnchor(element))) != null) {
            return (T)result2;
        }
        if (!this.isValidPointForReference()) {
            return null;
        }
        RefElement newElement = (RefElement)factory2.create();
        if (newElement == null) {
            return null;
        }
        this.myCachedSortedRefs = null;
        RefElement prev = this.myRefTable.putIfAbsent(psiAnchor, newElement);
        if (prev != null) {
            return (T)prev;
        }
        if (whenCached != null) {
            ReadAction.nonBlocking(() -> whenCached.consume(newElement)).executeSynchronously();
        }
        return (T)newElement;
    }

    @Override
    public RefModule getRefModule(@Nullable Module module) {
        if (module == null) {
            return null;
        }
        RefModule refModule = (RefModule)this.myModules.get(module);
        if (refModule == null) {
            refModule = ConcurrencyUtil.cacheOrGet(this.myModules, module, new RefModuleImpl(module, (RefManager)this));
        }
        return refModule;
    }

    @Override
    public boolean belongsToScope(PsiElement psiElement) {
        return this.belongsToScope(psiElement, false);
    }

    private boolean belongsToScope(PsiElement psiElement, boolean ignoreScope) {
        if (psiElement == null || !psiElement.isValid()) {
            return false;
        }
        if (psiElement instanceof PsiCompiledElement) {
            return false;
        }
        PsiFile containingFile = ReadAction.compute(psiElement::getContainingFile);
        if (containingFile == null) {
            return false;
        }
        for (RefManagerExtension<?> extension2 : this.myExtensions.values()) {
            if (extension2.belongsToScope(psiElement)) continue;
            return false;
        }
        Boolean inProject = ReadAction.compute(() -> psiElement.getManager().isInProject(psiElement));
        return inProject != false && (ignoreScope || this.getScope() == null || this.getScope().contains(psiElement));
    }

    @Override
    public String getQualifiedName(RefEntity refEntity) {
        if (refEntity == null || refEntity instanceof RefElementImpl && !refEntity.isValid()) {
            return AnalysisBundle.message("inspection.reference.invalid", new Object[0]);
        }
        return refEntity.getQualifiedName();
    }

    @Override
    public void removeRefElement(@NotNull RefElement refElement, @NotNull List<? super RefElement> deletedRefs) {
        RefElement[] refElements;
        if (refElement == null) {
            RefManagerImpl.$$$reportNull$$$0(27);
        }
        if (deletedRefs == null) {
            RefManagerImpl.$$$reportNull$$$0(28);
        }
        List<RefEntity> children2 = refElement.getChildren();
        for (RefElement refChild : refElements = children2.toArray(new RefElement[0])) {
            this.removeRefElement(refChild, deletedRefs);
        }
        ((RefManagerImpl)refElement.getRefManager()).removeReference(refElement);
        ((RefElementImpl)refElement).referenceRemoved();
        if (!deletedRefs.contains(refElement)) {
            deletedRefs.add(refElement);
        } else {
            LOG.error("deleted second time");
        }
    }

    public boolean isValidPointForReference() {
        return this.myIsInProcess || this.myOfflineView || ApplicationManager.getApplication().isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/reference/RefManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElem";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/reference/RefManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefinedElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefProject";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedElements";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "internName";
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerGraphAnnotator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRefinedElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "export";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getGroupName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runInsideInspectionReadAction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContainerElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeReference";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createAnchor";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFromRefTableOrCache";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeRefElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class ProjectIterator
    extends PsiElementVisitor {
        private ProjectIterator() {
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            PsiFile file2;
            if (element == null) {
                ProjectIterator.$$$reportNull$$$0(0);
            }
            ProgressManager.checkCanceled();
            RefManagerExtension<?> extension2 = RefManagerImpl.this.getExtension(element.getLanguage());
            if (extension2 != null) {
                extension2.visitElement(element);
            } else if (RefManagerImpl.this.processExternalElements && (file2 = element.getContainingFile()) != null) {
                RefManagerExtension externalFileManagerExtension = (RefManagerExtension)((Object)ContainerUtil.find(RefManagerImpl.this.myExtensions.values(), ex -> ex.shouldProcessExternalFile(file2)));
                if (externalFileManagerExtension == null) {
                    VirtualFile virtualFile;
                    if (element instanceof PsiFile && (virtualFile = PsiUtilCore.getVirtualFile(element)) instanceof VirtualFileWithId) {
                        RefManagerImpl.this.registerUnprocessed(virtualFile);
                    }
                } else {
                    RefElement refFile = RefManagerImpl.this.getReference(file2);
                    LOG.assertTrue(refFile != null, file2);
                    for (PsiReference reference : element.getReferences()) {
                        PsiElement resolve = reference.resolve();
                        if (resolve == null) continue;
                        RefManagerImpl.this.fireNodeMarkedReferenced(resolve, file2);
                        RefElement refWhat = RefManagerImpl.this.getReference(resolve);
                        if (refWhat == null) {
                            PsiFile targetContainingFile = resolve.getContainingFile();
                            if (file2 == targetContainingFile) continue;
                            refWhat = RefManagerImpl.this.getReference(targetContainingFile);
                        }
                        if (refWhat == null) continue;
                        ((RefElementImpl)refWhat).addInReference(refFile);
                        ((RefElementImpl)refFile).addOutReference(refWhat);
                    }
                    Stream<PsiElement> implicitRefs = externalFileManagerExtension.extractExternalFileImplicitReferences(file2);
                    implicitRefs.forEach(e -> {
                        RefElement superClassReference = RefManagerImpl.this.getReference((PsiElement)e);
                        if (superClassReference != null) {
                            ((RefElementImpl)refFile).addOutReference(superClassReference);
                        }
                    });
                    if (element instanceof PsiFile) {
                        externalFileManagerExtension.markExternalReferencesProcessed(refFile);
                    }
                }
            }
            for (PsiElement aChildren : element.getChildren()) {
                aChildren.accept(this);
            }
        }

        @Override
        public void visitFile(@NotNull PsiFile file2) {
            VirtualFile virtualFile;
            if (file2 == null) {
                ProjectIterator.$$$reportNull$$$0(1);
            }
            if ((virtualFile = file2.getVirtualFile()) != null) {
                String relative = ProjectUtilCore.displayUrlRelativeToProject(virtualFile, virtualFile.getPresentableUrl(), RefManagerImpl.this.myProject, true, false);
                RefManagerImpl.this.myContext.incrementJobDoneAmount(RefManagerImpl.this.myContext.getStdJobDescriptors().BUILD_GRAPH, relative);
            }
            if (file2 instanceof PsiBinaryFile || file2.getFileType().isBinary()) {
                return;
            }
            FileViewProvider viewProvider = file2.getViewProvider();
            Set<Language> relevantLanguages = viewProvider.getLanguages();
            for (Language language : relevantLanguages) {
                try {
                    this.visitElement(viewProvider.getPsi(language));
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                        LOG.error(file2.getName(), e);
                        continue;
                    }
                    LOG.error(new RuntimeExceptionWithAttachments(e, new Attachment("diagnostics.txt", file2.getName())));
                }
            }
            RefManagerImpl.this.myPsiManager.dropResolveCaches();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/reference/RefManagerImpl$ProjectIterator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

