/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ConcurrentHashMap;
import com.intellij.concurrency.ConcurrentIntKeySoftValueHashMap;
import com.intellij.concurrency.ConcurrentIntKeyWeakValueHashMap;
import com.intellij.concurrency.ConcurrentIntObjectHashMap;
import com.intellij.concurrency.ConcurrentLongObjectHashMap;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import com.intellij.util.containers.HashingStrategy;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentCollectionFactory {
    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> @NotNull ConcurrentMap<@NotNull K, @NotNull V> createConcurrentIdentityMap() {
        return new ConcurrentHashMap(HashingStrategy.identity());
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull ConcurrentMap<@NotNull T, @NotNull V> createConcurrentMap(@NotNull HashingStrategy<? super T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(0);
        }
        return new ConcurrentHashMap(hashStrategy);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull ConcurrentMap<@NotNull T, @NotNull V> createConcurrentMap() {
        return new ConcurrentHashMap(HashingStrategy.canonical());
    }

    @Contract(pure=true)
    @NotNull
    public static <T, V> @NotNull ConcurrentMap<@NotNull T, @NotNull V> createConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(1);
        }
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createConcurrentSet(@NotNull HashingStrategy<? super T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(2);
        }
        Set<? super T> set = Collections.newSetFromMap(ConcurrentCollectionFactory.createConcurrentMap(hashStrategy));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(3);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createConcurrentIdentitySet() {
        Set set = Collections.newSetFromMap(ConcurrentCollectionFactory.createConcurrentMap(HashingStrategy.identity()));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createConcurrentIdentitySet(int initialCapacity) {
        Set set = Collections.newSetFromMap(ConcurrentCollectionFactory.createConcurrentMap(initialCapacity, 0.75f, 16, HashingStrategy.identity()));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createConcurrentSet(int initialCapacity, @NotNull HashingStrategy<? super T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(6);
        }
        Set<? super T> set = Collections.newSetFromMap(ConcurrentCollectionFactory.createConcurrentMap(initialCapacity, 0.75f, 16, hashStrategy));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> @NotNull Set<@NotNull T> createConcurrentSet(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super T> hashStrategy) {
        if (hashStrategy == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(8);
        }
        Set<? super T> set = Collections.newSetFromMap(ConcurrentCollectionFactory.createConcurrentMap(initialCapacity, loadFactor, concurrencyLevel, hashStrategy));
        if (set == null) {
            ConcurrentCollectionFactory.$$$reportNull$$$0(9);
        }
        return set;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentLongObjectMap<@NotNull V> createConcurrentLongObjectMap() {
        return new ConcurrentLongObjectHashMap();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentLongObjectMap<@NotNull V> createConcurrentLongObjectMap(int initialCapacity) {
        return new ConcurrentLongObjectHashMap(initialCapacity);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentIntObjectMap<@NotNull V> createConcurrentIntObjectMap() {
        return new ConcurrentIntObjectHashMap();
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentIntObjectMap<@NotNull V> createConcurrentIntObjectMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentIntObjectHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentIntObjectMap<@NotNull V> createConcurrentIntObjectSoftValueMap() {
        return new ConcurrentIntKeySoftValueHashMap();
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <V> @NotNull ConcurrentIntObjectMap<@NotNull V> createConcurrentIntObjectWeakValueMap() {
        return new ConcurrentIntKeyWeakValueHashMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashStrategy";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/concurrency/ConcurrentCollectionFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/concurrency/ConcurrentCollectionFactory";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSet";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIdentitySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentMap";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSet";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

