/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.ngrams;

import com.intellij.find.TextSearchService;
import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class TrigramTextSearchService
implements TextSearchService {
    @Override
    @NotNull
    public TextSearchService.TextSearchResult processFilesWithText(@NotNull String text, Processor<? super VirtualFile> processor, @NotNull GlobalSearchScope scope) {
        if (text == null) {
            TrigramTextSearchService.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            TrigramTextSearchService.$$$reportNull$$$0(1);
        }
        final IntOpenHashSet keys = new IntOpenHashSet();
        TrigramBuilder.processTrigrams(text, new TrigramBuilder.TrigramProcessor(){

            @Override
            public boolean test(int value) {
                keys.add(value);
                return true;
            }
        });
        if (keys.isEmpty()) {
            TextSearchService.TextSearchResult textSearchResult = TextSearchService.TextSearchResult.NO_TRIGRAMS;
            if (textSearchResult == null) {
                TrigramTextSearchService.$$$reportNull$$$0(2);
            }
            return textSearchResult;
        }
        TextSearchService.TextSearchResult textSearchResult = FileBasedIndex.getInstance().getFilesWithKey(TrigramIndex.INDEX_ID, keys, f -> {
            ProgressManager.checkCanceled();
            return processor.process((VirtualFile)f);
        }, scope) ? TextSearchService.TextSearchResult.FINISHED : TextSearchService.TextSearchResult.STOPPED;
        if (textSearchResult == null) {
            TrigramTextSearchService.$$$reportNull$$$0(3);
        }
        return textSearchResult;
    }

    @Override
    public boolean isInSearchableScope(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TrigramTextSearchService.$$$reportNull$$$0(4);
        }
        FileType fileType = file2.getFileType();
        return !file2.isDirectory() && TrigramIndex.isIndexable(fileType) && !ProjectCoreUtil.isProjectOrWorkspaceFile(file2, fileType) && !SingleRootFileViewProvider.isTooLargeForIntelligence(file2);
    }

    @ApiStatus.Internal
    public static boolean useIndexingSearchExtensions() {
        return Registry.is("find.use.indexing.searcher.extensions");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/ngrams/TrigramTextSearchService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/ngrams/TrigramTextSearchService";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processFilesWithText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithText";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInSearchableScope";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

