/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation;

import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompositeDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider,
ExternalDocumentationHandler {
    private static final Logger LOG = Logger.getInstance(CompositeDocumentationProvider.class);
    private final List<DocumentationProvider> myProviders;

    public static DocumentationProvider wrapProviders(Collection<? extends DocumentationProvider> providers) {
        ArrayList<DocumentationProvider> list = new ArrayList<DocumentationProvider>();
        for (DocumentationProvider documentationProvider : providers) {
            if (documentationProvider instanceof CompositeDocumentationProvider) {
                list.addAll(((CompositeDocumentationProvider)documentationProvider).getProviders());
                continue;
            }
            if (documentationProvider == null) continue;
            list.add(documentationProvider);
        }
        return new CompositeDocumentationProvider(Collections.unmodifiableList(list));
    }

    private CompositeDocumentationProvider(List<DocumentationProvider> providers) {
        this.myProviders = providers;
    }

    @NotNull
    public List<DocumentationProvider> getAllProviders() {
        SmartList<DocumentationProvider> result2 = new SmartList<DocumentationProvider>((Collection<DocumentationProvider>)this.getProviders());
        result2.addAll(EP_NAME.getExtensionList());
        ContainerUtil.removeDuplicates(result2);
        SmartList<DocumentationProvider> smartList = result2;
        if (smartList == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(0);
        }
        return smartList;
    }

    @NotNull
    public List<DocumentationProvider> getProviders() {
        List<DocumentationProvider> list = this.myProviders;
        if (list == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public boolean handleExternal(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider)).handleExternal(element, originalElement)) continue;
            LOG.debug("handleExternal: ", provider);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleExternalLink(PsiManager psiManager, String link, PsiElement context2) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider)).handleExternalLink(psiManager, link, context2)) continue;
            LOG.debug("handleExternalLink: ", provider);
            return true;
        }
        return false;
    }

    @Override
    public boolean canFetchDocumentationLink(String link) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider)).canFetchDocumentationLink(link)) continue;
            LOG.debug("canFetchDocumentationLink: ", provider);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    @Nls
    public String fetchExternalDocumentation(@NotNull String link, @Nullable PsiElement element) {
        if (link == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(2);
        }
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationHandler) || !((ExternalDocumentationHandler)((Object)provider)).canFetchDocumentationLink(link)) continue;
            LOG.debug("fetchExternalDocumentation: ", provider);
            String string2 = ((ExternalDocumentationHandler)((Object)provider)).fetchExternalDocumentation(link, element);
            if (string2 == null) {
                CompositeDocumentationProvider.$$$reportNull$$$0(3);
            }
            return string2;
        }
        throw new IllegalStateException("Unable to find a provider to fetch documentation link!");
    }

    @Override
    @Nls
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            String result2 = provider.getQuickNavigateInfo(element, originalElement);
            if (result2 == null) continue;
            LOG.debug("getQuickNavigateInfo: ", provider);
            return result2;
        }
        return null;
    }

    @Override
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            List<String> result2 = provider.getUrlFor(element, originalElement);
            if (result2 == null) continue;
            LOG.debug("getUrlFor: ", provider);
            return result2;
        }
        return null;
    }

    @Override
    @Nls
    public String generateDoc(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            String result2 = provider.generateDoc(element, originalElement);
            if (result2 == null) continue;
            LOG.debug("generateDoc: ", provider);
            return result2;
        }
        return null;
    }

    @Override
    @Nls
    public String generateHoverDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(4);
        }
        for (DocumentationProvider provider : this.getAllProviders()) {
            String result2 = provider.generateHoverDoc(element, originalElement);
            if (result2 == null) continue;
            LOG.debug("generateHoverDoc: ", provider);
            return result2;
        }
        return null;
    }

    @Override
    @Nls
    @Nullable
    public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        if (comment == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(5);
        }
        for (DocumentationProvider provider : this.getAllProviders()) {
            String result2 = provider.generateRenderedDoc(comment);
            if (result2 == null) continue;
            LOG.debug("generateRenderedDoc: ", provider);
            return result2;
        }
        return null;
    }

    @Override
    public void collectDocComments(@NotNull PsiFile file2, @NotNull @NotNull Consumer<? super @NotNull PsiDocCommentBase> sink) {
        if (file2 == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (sink == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(7);
        }
        for (DocumentationProvider provider : this.getAllProviders()) {
            provider.collectDocComments(file2, sink);
        }
    }

    @Override
    @Nullable
    public PsiDocCommentBase findDocComment(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (range == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(9);
        }
        for (DocumentationProvider provider : this.getAllProviders()) {
            PsiDocCommentBase result2 = provider.findDocComment(file2, range);
            if (result2 == null) continue;
            LOG.debug("findDocComment: ", provider);
            return result2;
        }
        return null;
    }

    @Override
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            PsiElement result2 = provider.getDocumentationElementForLookupItem(psiManager, object, element);
            if (result2 == null) continue;
            LOG.debug("getDocumentationElementForLookupItem: ", provider);
            return result2;
        }
        return null;
    }

    @Override
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context2) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            PsiElement result2 = provider.getDocumentationElementForLink(psiManager, link, context2);
            if (result2 == null) continue;
            LOG.debug("getDocumentationElementForLink: ", provider);
            return result2;
        }
        return null;
    }

    @Nullable
    public CodeDocumentationProvider getFirstCodeDocumentationProvider() {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof CodeDocumentationProvider)) continue;
            LOG.debug("getFirstCodeDocumentationProvider: ", provider);
            return (CodeDocumentationProvider)provider;
        }
        return null;
    }

    @Override
    @Nls
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls, boolean onHover) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            String doc;
            if (!(provider instanceof ExternalDocumentationProvider) || (doc = ((ExternalDocumentationProvider)((Object)provider)).fetchExternalDocumentation(project, element, docUrls, onHover)) == null) continue;
            LOG.debug("fetchExternalDocumentation: ", provider);
            return doc;
        }
        return null;
    }

    @Override
    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!CompositeDocumentationProvider.hasUrlsFor(provider, element, originalElement)) continue;
            LOG.debug("handleExternal(hasUrlsFor): ", provider);
            return true;
        }
        return false;
    }

    @Override
    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationProvider) || !((ExternalDocumentationProvider)((Object)provider)).canPromptToConfigureDocumentation(element)) continue;
            LOG.debug("canPromptToConfigureDocumentation: ", provider);
            return true;
        }
        return false;
    }

    @Override
    public void promptToConfigureDocumentation(PsiElement element) {
        for (DocumentationProvider provider : this.getAllProviders()) {
            if (!(provider instanceof ExternalDocumentationProvider) || !((ExternalDocumentationProvider)((Object)provider)).canPromptToConfigureDocumentation(element)) continue;
            ((ExternalDocumentationProvider)((Object)provider)).promptToConfigureDocumentation(element);
            LOG.debug("promptToConfigureDocumentation: ", provider);
            break;
        }
    }

    public static boolean hasUrlsFor(DocumentationProvider provider, PsiElement element, PsiElement originalElement) {
        List<String> urls = provider.getUrlFor(element, originalElement);
        return urls != null && !urls.isEmpty();
    }

    @Override
    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file2, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            CompositeDocumentationProvider.$$$reportNull$$$0(11);
        }
        for (DocumentationProvider provider : this.getAllProviders()) {
            PsiElement element = provider.getCustomDocumentationElement(editor, file2, contextElement, targetOffset);
            if (element == null) continue;
            LOG.debug("getCustomDocumentationElement: ", provider);
            return element;
        }
        return null;
    }

    public String toString() {
        return this.getProviders().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/documentation/CompositeDocumentationProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/documentation/CompositeDocumentationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchExternalDocumentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fetchExternalDocumentation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateHoverDoc";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateRenderedDoc";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectDocComments";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDocComment";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

