/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@TestOnly
public class MockSdk
implements Sdk,
SdkModificator {
    private String myName;
    private String myHomePath;
    @NotNull
    private String myVersionString;
    private final MultiMap<OrderRootType, VirtualFile> myRoots;
    @NotNull
    private final Supplier<? extends SdkTypeId> mySdkType;
    private SdkAdditionalData myData;

    public MockSdk(@NotNull String name, @NotNull String homePath, @NotNull String versionString, @NotNull MultiMap<OrderRootType, VirtualFile> roots, @NotNull Supplier<? extends SdkTypeId> sdkType) {
        if (name == null) {
            MockSdk.$$$reportNull$$$0(0);
        }
        if (homePath == null) {
            MockSdk.$$$reportNull$$$0(1);
        }
        if (versionString == null) {
            MockSdk.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            MockSdk.$$$reportNull$$$0(3);
        }
        if (sdkType == null) {
            MockSdk.$$$reportNull$$$0(4);
        }
        this.myName = name;
        this.myHomePath = homePath;
        this.myVersionString = versionString;
        this.myRoots = roots;
        this.mySdkType = sdkType;
    }

    public MockSdk(@NotNull String name, @NotNull String homePath, @NotNull String versionString, @NotNull MultiMap<OrderRootType, VirtualFile> roots, @NotNull SdkTypeId sdkType) {
        if (name == null) {
            MockSdk.$$$reportNull$$$0(5);
        }
        if (homePath == null) {
            MockSdk.$$$reportNull$$$0(6);
        }
        if (versionString == null) {
            MockSdk.$$$reportNull$$$0(7);
        }
        if (roots == null) {
            MockSdk.$$$reportNull$$$0(8);
        }
        if (sdkType == null) {
            MockSdk.$$$reportNull$$$0(9);
        }
        this(name, homePath, versionString, roots, () -> sdkType);
    }

    @Override
    @NotNull
    public SdkTypeId getSdkType() {
        SdkTypeId sdkTypeId = this.mySdkType.get();
        if (sdkTypeId == null) {
            MockSdk.$$$reportNull$$$0(10);
        }
        return sdkTypeId;
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            MockSdk.$$$reportNull$$$0(11);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getVersionString() {
        String string2 = this.myVersionString;
        if (string2 == null) {
            MockSdk.$$$reportNull$$$0(12);
        }
        return string2;
    }

    @Override
    public String getHomePath() {
        return this.myHomePath;
    }

    @Override
    @Nullable
    public VirtualFile getHomeDirectory() {
        return StandardFileSystems.local().findFileByPath(this.myHomePath);
    }

    @Override
    @Nullable
    public SdkAdditionalData getSdkAdditionalData() {
        return this.myData;
    }

    @Override
    @NotNull
    public Sdk clone() {
        return new MockSdk(this.myName, this.myHomePath, this.myVersionString, new MultiMap<OrderRootType, VirtualFile>(this.myRoots), this.mySdkType.get()){
            private final UserDataHolder udh;
            {
                this.udh = new UserDataHolderBase();
            }

            @Override
            @NotNull
            public SdkModificator getSdkModificator() {
                1 v0 = this;
                if (v0 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return v0;
            }

            @Override
            @Nullable
            public <T> T getUserData(@NotNull Key<T> key) {
                if (key == null) {
                    1.$$$reportNull$$$0(1);
                }
                return this.udh.getUserData(key);
            }

            @Override
            public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
                if (key == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.udh.putUserData(key, value);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/projectRoots/impl/MockSdk$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSdkModificator";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/projectRoots/impl/MockSdk$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getUserData";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "putUserData";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @NotNull
    public SdkModificator getSdkModificator() {
        MockSdk.throwReadOnly();
        if (null == null) {
            MockSdk.$$$reportNull$$$0(13);
        }
        return null;
    }

    @Override
    public VirtualFile @NotNull [] getRoots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            MockSdk.$$$reportNull$$$0(14);
        }
        VirtualFile[] virtualFileArray = this.myRoots.get(rootType).toArray(VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            MockSdk.$$$reportNull$$$0(15);
        }
        return virtualFileArray;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            MockSdk.$$$reportNull$$$0(16);
        }
        this.myName = name;
    }

    @Override
    public void setHomePath(String path) {
        this.myHomePath = path;
    }

    @Override
    public void setVersionString(@NotNull String versionString) {
        if (versionString == null) {
            MockSdk.$$$reportNull$$$0(17);
        }
        this.myVersionString = versionString;
    }

    @Override
    public void setSdkAdditionalData(SdkAdditionalData data) {
        this.myData = data;
    }

    @Override
    public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        if (root == null) {
            MockSdk.$$$reportNull$$$0(18);
        }
        if (rootType == null) {
            MockSdk.$$$reportNull$$$0(19);
        }
        this.myRoots.putValue(rootType, root);
    }

    @Override
    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        if (root == null) {
            MockSdk.$$$reportNull$$$0(20);
        }
        if (rootType == null) {
            MockSdk.$$$reportNull$$$0(21);
        }
        this.myRoots.remove(rootType, root);
    }

    @Override
    public void removeRoots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            MockSdk.$$$reportNull$$$0(22);
        }
        this.myRoots.remove(rootType);
    }

    @Override
    public void removeAllRoots() {
        this.myRoots.clear();
    }

    @Override
    public void commitChanges() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            WriteAction.run(() -> ((ProjectRootManagerEx)ProjectRootManager.getInstance(project)).makeRootsChange(EmptyRunnable.getInstance(), false, true));
        }
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    @NotNull
    public RootProvider getRootProvider() {
        return new RootProvider(){

            @Override
            public String @NotNull [] getUrls(@NotNull OrderRootType rootType) {
                if (rootType == null) {
                    2.$$$reportNull$$$0(0);
                }
                String[] stringArray = ContainerUtil.map2Array(this.getFiles(rootType), String.class, VirtualFile::getUrl);
                if (stringArray == null) {
                    2.$$$reportNull$$$0(1);
                }
                return stringArray;
            }

            @Override
            public VirtualFile @NotNull [] getFiles(@NotNull OrderRootType rootType) {
                if (rootType == null) {
                    2.$$$reportNull$$$0(2);
                }
                VirtualFile[] virtualFileArray = MockSdk.this.getRoots(rootType);
                if (virtualFileArray == null) {
                    2.$$$reportNull$$$0(3);
                }
                return virtualFileArray;
            }

            @Override
            public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
                if (listener2 == null) {
                    2.$$$reportNull$$$0(4);
                }
            }

            @Override
            public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
                if (listener2 == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (parentDisposable == null) {
                    2.$$$reportNull$$$0(6);
                }
            }

            @Override
            public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
                if (listener2 == null) {
                    2.$$$reportNull$$$0(7);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rootType";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/projectRoots/impl/MockSdk$2";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "listener";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parentDisposable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/projectRoots/impl/MockSdk$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUrls";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFiles";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getUrls";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getFiles";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "addRootSetChangedListener";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "removeRootSetChangedListener";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void throwReadOnly() {
        throw new IncorrectOperationException("Can't modify, MockJDK is read-only, consider calling .clone() first");
    }

    @Override
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            MockSdk.$$$reportNull$$$0(23);
        }
        return null;
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            MockSdk.$$$reportNull$$$0(24);
        }
        MockSdk.throwReadOnly();
    }

    public String toString() {
        return "MockSDK[" + this.myName + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 2: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/MockSdk";
                break;
            }
            case 14: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/MockSdk";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionString";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkModificator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setVersionString";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeRoots";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

