/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.DirectoryInfoImpl;
import com.intellij.openapi.roots.impl.RootFileSupplier;
import com.intellij.openapi.roots.impl.RootIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CollectionQuery;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@ApiStatus.Internal
public final class DirectoryIndexImpl
extends DirectoryIndex
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DirectoryIndexImpl.class);
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private volatile boolean myDisposed;
    private volatile RootIndex myRootIndex;
    private static final Key<Pair<Long, RootIndex>> BRANCH_ROOT_INDEX = Key.create("BRANCH_ROOT_INDEX");

    public DirectoryIndexImpl(@NotNull Project project) {
        if (project == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConnection = project.getMessageBus().connect();
        this.subscribeToFileChanges();
        LowMemoryWatcher.register(() -> {
            RootIndex index2 = this.myRootIndex;
            if (index2 != null) {
                index2.onLowMemory();
            }
        }, this);
    }

    @Override
    public void dispose() {
        this.myDisposed = true;
        this.myRootIndex = null;
    }

    private void subscribeToFileChanges() {
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, new ModuleRootListener(){

            @Override
            public void beforeRootsChange(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                DirectoryIndexImpl.this.myRootIndex = null;
            }

            @Override
            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                DirectoryIndexImpl.this.myRootIndex = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/roots/impl/DirectoryIndexImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRootsChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rootsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, new BulkFileListener(){

            @Override
            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                RootIndex rootIndex;
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((rootIndex = DirectoryIndexImpl.this.myRootIndex) != null && DirectoryIndexImpl.shouldResetOnEvents(events)) {
                    rootIndex.myPackageDirectoryCache.clear();
                    for (VFileEvent vFileEvent : events) {
                        if (!DirectoryIndexImpl.isIgnoredFileCreated(vFileEvent)) continue;
                        DirectoryIndexImpl.this.myRootIndex = null;
                        break;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/roots/impl/DirectoryIndexImpl$2", "after"));
            }
        });
        this.myConnection.subscribe(AdditionalLibraryRootsListener.TOPIC, (presentableLibraryName, oldRoots, newRoots, libraryNameForDebug) -> {
            this.myRootIndex = null;
        });
    }

    private static boolean shouldResetOnEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(1);
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file2;
            if (!(vFileEvent instanceof VFileCreateEvent ? ((VFileCreateEvent)vFileEvent).isDirectory() : (file2 = vFileEvent.getFile()) == null || file2.isDirectory())) continue;
            return true;
        }
        return false;
    }

    private static boolean isIgnoredFileCreated(@NotNull VFileEvent event) {
        if (event == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(2);
        }
        return event instanceof VFileMoveEvent && FileTypeRegistry.getInstance().isFileIgnored(((VFileMoveEvent)event).getNewParent()) || event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getPropertyName().equals("name") && FileTypeRegistry.getInstance().isFileIgnored(((VFilePropertyChangeEvent)event).getFile());
    }

    private void dispatchPendingEvents() {
        this.myConnection.deliverImmediately();
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(3);
        }
        Query<VirtualFile> query = this.getRootIndex().getDirectoriesByPackageName(packageName, includeLibrarySources);
        if (query == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(4);
        }
        return query;
    }

    @Override
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, @NotNull GlobalSearchScope scope) {
        Collection<ModelBranch> branches;
        if (packageName == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(6);
        }
        if ((branches = scope.getModelBranchesAffectingScope()).isEmpty()) {
            return super.getDirectoriesByPackageName(packageName, scope);
        }
        List<RootIndex> indices = ContainerUtil.map(branches, DirectoryIndexImpl::obtainBranchRootIndex);
        indices.add(this.getRootIndex());
        return new CollectionQuery<RootIndex>(indices).flatMapping(i -> i.getDirectoriesByPackageName(packageName, true)).filtering(scope::contains);
    }

    @NotNull
    RootIndex getRootIndex(VirtualFile file2) {
        ModelBranch branch = ModelBranch.getFileBranch(file2);
        if (branch != null) {
            RootIndex rootIndex = DirectoryIndexImpl.obtainBranchRootIndex(branch);
            if (rootIndex == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(7);
            }
            return rootIndex;
        }
        RootIndex rootIndex = this.getRootIndex();
        if (rootIndex == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(8);
        }
        return rootIndex;
    }

    private static RootIndex obtainBranchRootIndex(ModelBranch branch) {
        Pair<Long, RootIndex> pair = branch.getUserData(BRANCH_ROOT_INDEX);
        long modCount = branch.getBranchedVfsStructureModificationCount();
        if (pair == null || (Long)pair.first != modCount) {
            pair = Pair.create(modCount, new RootIndex(branch.getProject(), RootFileSupplier.forBranch(branch)));
        }
        return (RootIndex)pair.second;
    }

    RootIndex getRootIndex() {
        RootIndex rootIndex = this.myRootIndex;
        if (rootIndex == null) {
            this.myRootIndex = rootIndex = new RootIndex(this.myProject);
        }
        return rootIndex;
    }

    @Override
    @NotNull
    public DirectoryInfo getInfoForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(9);
        }
        this.checkAvailability();
        this.dispatchPendingEvents();
        DirectoryInfo directoryInfo = this.getRootIndex(file2).getInfoForFile(file2);
        if (directoryInfo == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(10);
        }
        return directoryInfo;
    }

    @Override
    @Nullable
    public SourceFolder getSourceRootFolder(@NotNull DirectoryInfo info) {
        boolean inModuleSource;
        if (info == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(11);
        }
        boolean bl = inModuleSource = info instanceof DirectoryInfoImpl && ((DirectoryInfoImpl)info).isInModuleSource();
        if (inModuleSource) {
            return info.getSourceRootFolder();
        }
        return null;
    }

    @Override
    @Nullable
    public JpsModuleSourceRootType<?> getSourceRootType(@NotNull DirectoryInfo info) {
        SourceFolder folder;
        if (info == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(12);
        }
        return (folder = this.getSourceRootFolder(info)) == null ? null : folder.getRootType();
    }

    @Override
    public String getPackageName(@NotNull VirtualFile dir) {
        if (dir == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(13);
        }
        this.checkAvailability();
        return this.getRootIndex(dir).getPackageName(dir);
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntries(@NotNull DirectoryInfo info) {
        if (info == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(14);
        }
        this.checkAvailability();
        if (this.myProject.isDefault()) {
            List<OrderEntry> list = Collections.emptyList();
            if (list == null) {
                DirectoryIndexImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<OrderEntry> list = this.getRootIndex().getOrderEntries(info);
        if (list == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Override
    @NotNull
    public Set<String> getDependentUnloadedModules(@NotNull Module module) {
        if (module == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(17);
        }
        this.checkAvailability();
        Set<String> set = this.getRootIndex().getDependentUnloadedModules(module);
        if (set == null) {
            DirectoryIndexImpl.$$$reportNull$$$0(18);
        }
        return set;
    }

    @TestOnly
    public void assertConsistency(DirectoryInfo info) {
        List<OrderEntry> entries = this.getOrderEntries(info);
        for (int i = 1; i < entries.size(); ++i) {
            assert (RootIndex.BY_OWNER_MODULE.compare(entries.get(i - 1), entries.get(i)) <= 0);
        }
    }

    private void checkAvailability() {
        if (this.myDisposed) {
            ProgressManager.checkCanceled();
            LOG.error("Directory index is already disposed for " + this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/DirectoryIndexImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/DirectoryIndexImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoriesByPackageName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentUnloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldResetOnEvents";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredFileCreated";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoriesByPackageName";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootFolder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRootType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrderEntries";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDependentUnloadedModules";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

