/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.TodoAttributes;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TodoPattern
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(TodoPattern.class);
    private IndexPattern indexPattern;
    private TodoAttributes attributes;
    @NonNls
    private static final String CASE_SENS_ATT = "case-sensitive";
    @NonNls
    private static final String PATTERN_ATT = "pattern";

    public TodoPattern(@NotNull TodoAttributes attributes) {
        if (attributes == null) {
            TodoPattern.$$$reportNull$$$0(0);
        }
        this("", attributes, false);
    }

    public TodoPattern(@NotNull Element state, @NotNull TextAttributes defaultTodoAttributes) {
        if (state == null) {
            TodoPattern.$$$reportNull$$$0(1);
        }
        if (defaultTodoAttributes == null) {
            TodoPattern.$$$reportNull$$$0(2);
        }
        this.attributes = new TodoAttributes(state, defaultTodoAttributes);
        this.indexPattern = new IndexPattern(state.getAttributeValue(PATTERN_ATT, "").trim(), Boolean.parseBoolean(state.getAttributeValue(CASE_SENS_ATT)));
    }

    public TodoPattern(@NotNull String patternString, @NotNull TodoAttributes attributes, boolean caseSensitive) {
        if (patternString == null) {
            TodoPattern.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            TodoPattern.$$$reportNull$$$0(4);
        }
        this.indexPattern = new IndexPattern(patternString, caseSensitive);
        this.attributes = attributes;
    }

    public TodoPattern clone() {
        try {
            TodoAttributes attributes = this.attributes.clone();
            TodoPattern pattern = (TodoPattern)super.clone();
            pattern.indexPattern = new IndexPattern(this.indexPattern.getPatternString(), this.indexPattern.isCaseSensitive());
            pattern.attributes = attributes;
            return pattern;
        }
        catch (CloneNotSupportedException e) {
            LOG.error(e);
            return null;
        }
    }

    @NotNull
    @NlsSafe
    public String getPatternString() {
        String string2 = this.indexPattern.getPatternString();
        if (string2 == null) {
            TodoPattern.$$$reportNull$$$0(5);
        }
        return string2;
    }

    public void setPatternString(@NotNull String patternString) {
        if (patternString == null) {
            TodoPattern.$$$reportNull$$$0(6);
        }
        this.indexPattern.setPatternString(patternString);
    }

    @NotNull
    public TodoAttributes getAttributes() {
        TodoAttributes todoAttributes = this.attributes;
        if (todoAttributes == null) {
            TodoPattern.$$$reportNull$$$0(7);
        }
        return todoAttributes;
    }

    public void setAttributes(@NotNull TodoAttributes attributes) {
        if (attributes == null) {
            TodoPattern.$$$reportNull$$$0(8);
        }
        this.attributes = attributes;
    }

    public boolean isCaseSensitive() {
        return this.indexPattern.isCaseSensitive();
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.indexPattern.setCaseSensitive(caseSensitive);
    }

    @Nullable
    public Pattern getPattern() {
        return this.indexPattern.getPattern();
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            TodoPattern.$$$reportNull$$$0(9);
        }
        this.attributes.writeExternal(element);
        if (this.indexPattern.isCaseSensitive()) {
            element.setAttribute(CASE_SENS_ATT, "true");
        }
        element.setAttribute(PATTERN_ATT, this.indexPattern.getPatternString());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TodoPattern)) {
            return false;
        }
        TodoPattern pattern = (TodoPattern)obj;
        if (!this.indexPattern.equals(pattern.indexPattern)) {
            return false;
        }
        return Comparing.equal(this.attributes, pattern.attributes);
    }

    public int hashCode() {
        return this.indexPattern.hashCode();
    }

    public IndexPattern getIndexPattern() {
        return this.indexPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTodoAttributes";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternString";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/TodoPattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/TodoPattern";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternString";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPatternString";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setAttributes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

