/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.diagnostic.Checks;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColorHexUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.MixedColorProducer;
import com.intellij.util.MathUtil;
import java.awt.Color;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorUtil {
    private ColorUtil() {
    }

    @NotNull
    public static Color softer(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(0);
        }
        if (color.getBlue() > 220 && color.getRed() > 220 && color.getGreen() > 220) {
            Color color2 = color;
            if (color2 == null) {
                ColorUtil.$$$reportNull$$$0(1);
            }
            return color2;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color color3 = Color.getHSBColor(hsb[0], 0.6f * hsb[1], hsb[2]);
        if (color3 == null) {
            ColorUtil.$$$reportNull$$$0(2);
        }
        return color3;
    }

    @NotNull
    public static Color darker(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(3);
        }
        return ColorUtil.hackBrightness(color, tones, 0.9090909f);
    }

    @NotNull
    public static Color brighter(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(4);
        }
        return ColorUtil.hackBrightness(color, tones, 1.1f);
    }

    @NotNull
    public static Color tuneHue(@NotNull Color color, int howMuch, float hackValue) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(5);
        }
        return ColorUtil.tuneHSBComponent(color, 0, howMuch, hackValue);
    }

    @NotNull
    public static Color tuneSaturation(@NotNull Color color, int howMuch, float hackValue) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(6);
        }
        return ColorUtil.tuneHSBComponent(color, 1, howMuch, hackValue);
    }

    @NotNull
    public static Color tuneSaturationEspeciallyGrey(@NotNull Color color, int howMuch, float hackValue) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(7);
        }
        if (color.getRed() == color.getBlue() && color.getBlue() == color.getGreen()) {
            Color color2 = color.getGreen() <= 64 ? ColorUtil.shiftHSBComponent(color, 2, (float)howMuch * (1.0f - hackValue) / 1.5f) : (color.getGreen() >= 192 ? ColorUtil.shiftHSBComponent(color, 2, (float)howMuch * (hackValue - 1.0f) / 1.5f) : color);
            if (color2 == null) {
                ColorUtil.$$$reportNull$$$0(8);
            }
            return color2;
        }
        return ColorUtil.tuneHSBComponent(color, 1, howMuch, hackValue);
    }

    @NotNull
    public static Color hackBrightness(@NotNull Color color, int howMuch, float hackValue) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(9);
        }
        return ColorUtil.tuneHSBComponent(color, 2, howMuch, hackValue);
    }

    @NotNull
    private static Color tuneHSBComponent(@NotNull Color color, int componentIndex, int howMuch, float factor) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(10);
        }
        Checks.checkIndex(componentIndex, 3);
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float component = hsb[componentIndex];
        for (int i = 0; i < howMuch && (component = MathUtil.clamp(factor * component, 0.0f, 1.0f)) != 0.0f && component != 1.0f; ++i) {
        }
        hsb[componentIndex] = component;
        Color color2 = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(11);
        }
        return color2;
    }

    @NotNull
    private static Color shiftHSBComponent(@NotNull Color color, int componentIndex, float shift) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(12);
        }
        Checks.checkIndex(componentIndex, 3);
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        hsb[componentIndex] = MathUtil.clamp(hsb[componentIndex] + shift, 0.0f, 1.0f);
        Color color2 = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(13);
        }
        return color2;
    }

    @NotNull
    public static Color saturate(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(14);
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float saturation = hsb[1];
        for (int i = 0; i < tones && (saturation = Math.min(1.0f, saturation * 1.1f)) != 1.0f; ++i) {
        }
        Color color2 = Color.getHSBColor(hsb[0], saturation, hsb[2]);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(15);
        }
        return color2;
    }

    @NotNull
    public static Color desaturate(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(16);
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float saturation = hsb[1];
        for (int i = 0; i < tones && (saturation = Math.max(0.0f, saturation / 1.1f)) != 0.0f; ++i) {
        }
        Color color2 = Color.getHSBColor(hsb[0], saturation, hsb[2]);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(17);
        }
        return color2;
    }

    @NotNull
    public static Color dimmer(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(18);
        }
        Color color2 = ColorUtil.wrap(color, () -> {
            float[] rgb = color.getRGBColorComponents(null);
            float alpha = 0.8f;
            float rem = 1.0f - alpha;
            return new Color(rgb[0] * alpha + rem, rgb[1] * alpha + rem, rgb[2] * alpha + rem);
        });
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(19);
        }
        return color2;
    }

    private static Color wrap(@NotNull Color color, Supplier<? extends Color> func) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(20);
        }
        return color instanceof JBColor ? JBColor.lazy(func) : func.get();
    }

    private static int shift(int colorComponent, double d) {
        int n = (int)((double)colorComponent * d);
        return n > 255 ? 255 : Math.max(n, 0);
    }

    @NotNull
    public static Color shift(@NotNull Color c, double d) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(21);
        }
        Supplier<Color> func = () -> new Color(ColorUtil.shift(c.getRed(), d), ColorUtil.shift(c.getGreen(), d), ColorUtil.shift(c.getBlue(), d), c.getAlpha());
        Color color = ColorUtil.wrap(c, func);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(22);
        }
        return color;
    }

    @NotNull
    public static Color withAlpha(@NotNull Color c, double a) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(23);
        }
        return ColorUtil.toAlpha(c, (int)(255.0 * a));
    }

    @NotNull
    public static Color withPreAlpha(@NotNull Color c, double a) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(24);
        }
        float[] rgba = new float[4];
        rgba = ColorUtil.withAlpha(c, a).getRGBComponents(rgba);
        return new Color(rgba[0] * rgba[3], rgba[1] * rgba[3], rgba[2] * rgba[3], 1.0f);
    }

    @NotNull
    public static Color toAlpha(@Nullable Color color, int a) {
        Color c = color == null ? Color.black : color;
        Supplier<Color> func = () -> new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
        Color color2 = ColorUtil.wrap(c, func);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(25);
        }
        return color2;
    }

    @NotNull
    public static String toHex(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(26);
        }
        return ColorUtil.toHex(c, false);
    }

    @NotNull
    public static String toHex(@NotNull Color c, boolean withAlpha) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(27);
        }
        String R = Integer.toHexString(c.getRed());
        String G = Integer.toHexString(c.getGreen());
        String B2 = Integer.toHexString(c.getBlue());
        String rgbHex = (R.length() < 2 ? "0" : "") + R + (G.length() < 2 ? "0" : "") + G + (B2.length() < 2 ? "0" : "") + B2;
        if (!withAlpha) {
            String string2 = rgbHex;
            if (string2 == null) {
                ColorUtil.$$$reportNull$$$0(28);
            }
            return string2;
        }
        String A = Integer.toHexString(c.getAlpha());
        String string3 = rgbHex + (A.length() < 2 ? "0" : "") + A;
        if (string3 == null) {
            ColorUtil.$$$reportNull$$$0(29);
        }
        return string3;
    }

    @NotNull
    @NlsSafe
    public static String toHtmlColor(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(30);
        }
        String string2 = "#" + ColorUtil.toHex(c);
        if (string2 == null) {
            ColorUtil.$$$reportNull$$$0(31);
        }
        return string2;
    }

    @NotNull
    public static Color fromHex(@NotNull String str) {
        if (str == null) {
            ColorUtil.$$$reportNull$$$0(32);
        }
        Color color = ColorHexUtil.fromHex(str);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(33);
        }
        return color;
    }

    @Nullable
    public static Color fromHex(@Nullable String str, @Nullable Color defaultValue) {
        return ColorHexUtil.fromHex(str, defaultValue);
    }

    public static boolean isDark(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(34);
        }
        return (ColorUtil.getLuminance(c) + 0.05) / 0.05 < 4.5;
    }

    public static boolean areContrasting(@NotNull Color c1, @NotNull Color c2) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(35);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(36);
        }
        return Double.compare(ColorUtil.getContrast(c1, c2), 4.5) >= 0;
    }

    public static double getContrast(@NotNull Color c1, @NotNull Color c2) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(37);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(38);
        }
        double l1 = ColorUtil.getLuminance(c1);
        double l2 = ColorUtil.getLuminance(c2);
        return (Math.max(l1, l2) + 0.05) / (Math.min(l2, l1) + 0.05);
    }

    public static double getLuminance(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(39);
        }
        return ColorUtil.getLinearRGBComponentValue((double)color.getRed() / 255.0) * 0.2126 + ColorUtil.getLinearRGBComponentValue((double)color.getGreen() / 255.0) * 0.7152 + ColorUtil.getLinearRGBComponentValue((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double getLinearRGBComponentValue(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }

    @NotNull
    public static Color mix(@NotNull Color c1, @NotNull Color c2, double balance) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(40);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(41);
        }
        if (balance <= 0.0) {
            Color color = c1;
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(42);
            }
            return color;
        }
        if (balance >= 1.0) {
            Color color = c2;
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(43);
            }
            return color;
        }
        MixedColorProducer func = new MixedColorProducer(c1, c2, balance);
        Color color = c1 instanceof JBColor || c2 instanceof JBColor ? JBColor.lazy(func) : (Color)func.get();
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(44);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 43: 
            case 44: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ColorUtil";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 35: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 36: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ColorUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "softer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "tuneSaturationEspeciallyGrey";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "tuneHSBComponent";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "shiftHSBComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "saturate";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "desaturate";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "dimmer";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "shift";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "toAlpha";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toHex";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtmlColor";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "fromHex";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "mix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "softer";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "darker";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "brighter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tuneHue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tuneSaturation";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tuneSaturationEspeciallyGrey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hackBrightness";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tuneHSBComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shiftHSBComponent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saturate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "desaturate";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "dimmer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "shift";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "withAlpha";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "withPreAlpha";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toHex";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "toHtmlColor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "fromHex";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isDark";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "areContrasting";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getContrast";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getLuminance";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "mix";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 25: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

