/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.io.DataExternalizer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\nJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J5\u0010\u0014\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00062\u000e\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\b\u0010\u0015\u001a\u0004\u0018\u0001H\u00062\b\u0010\u0016\u001a\u0004\u0018\u0001H\u0006\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/IndexDataComparer;", "", "()V", "areIndexedDataOfFileTheSame", "", "K", "V", "extension", "Lcom/intellij/util/indexing/FileBasedIndexExtension;", "expectedData", "", "actualData", "areStubTreesTheSame", "expectedTree", "Lcom/intellij/psi/stubs/SerializedStubTree;", "actualTree", "areStubsTheSame", "expectedStub", "Lcom/intellij/psi/stubs/Stub;", "actualStub", "areValuesTheSame", "expectedValue", "actualValue", "(Lcom/intellij/util/indexing/FileBasedIndexExtension;Ljava/lang/Object;Ljava/lang/Object;)Z", "intellij.platform.indexing.impl"})
public final class IndexDataComparer {
    @NotNull
    public static final IndexDataComparer INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final <K, V> boolean areIndexedDataOfFileTheSame(@NotNull FileBasedIndexExtension<K, V> extension2, @NotNull Map<K, ? extends V> expectedData, @NotNull Map<K, ? extends V> actualData) {
        Intrinsics.checkNotNullParameter(extension2, (String)"extension");
        Intrinsics.checkNotNullParameter(expectedData, (String)"expectedData");
        Intrinsics.checkNotNullParameter(actualData, (String)"actualData");
        if (expectedData.isEmpty() && actualData.isEmpty()) {
            return true;
        }
        if (expectedData.size() != actualData.size()) {
            return false;
        }
        if (extension2 instanceof SingleEntryFileBasedIndexExtension) {
            Object expectedValue = CollectionsKt.first((Iterable)expectedData.values());
            Object actualValue = CollectionsKt.first((Iterable)actualData.values());
            return this.areValuesTheSame(extension2, expectedValue, actualValue);
        }
        Map<K, V> map2 = expectedData;
        Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void expectedKey;
            Map.Entry<K, V> entry;
            Map.Entry<K, V> entry2 = entry = iterator.next();
            map2 = entry2.getKey();
            entry2 = entry;
            V expectedValue = entry2.getValue();
            if (!actualData.containsKey(expectedKey)) {
                return false;
            }
            V actualValue = actualData.get(expectedKey);
            if (this.areValuesTheSame(extension2, expectedValue, actualValue)) continue;
            return false;
        }
        return true;
    }

    public final <V> boolean areValuesTheSame(@NotNull FileBasedIndexExtension<?, ?> extension2, @Nullable V expectedValue, @Nullable V actualValue) {
        Intrinsics.checkNotNullParameter(extension2, (String)"extension");
        if (expectedValue == null || actualValue == null) {
            return expectedValue == null && actualValue == null;
        }
        if (expectedValue instanceof SerializedStubTree) {
            Object object;
            Object object2;
            if (!(actualValue instanceof SerializedStubTree)) {
                return false;
            }
            IndexDataComparer indexDataComparer = this;
            try {
                object2 = Result.Companion;
                IndexDataComparer $this$runCatching = indexDataComparer;
                boolean bl = false;
                ((SerializedStubTree)expectedValue).getStubIndicesValueMap();
                object = expectedValue;
                object2 = Result.constructor-impl(object);
            }
            catch (Throwable throwable) {
                Result.Companion bl = Result.Companion;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            indexDataComparer = object2;
            IndexDataComparer indexDataComparer2 = Result.isFailure-impl((Object)indexDataComparer) ? null : indexDataComparer;
            if (!(indexDataComparer2 instanceof SerializedStubTree)) {
                indexDataComparer2 = null;
            }
            SerializedStubTree serializedStubTree = (SerializedStubTree)((Object)indexDataComparer2);
            if (serializedStubTree == null) {
                return false;
            }
            SerializedStubTree currentStubTree = serializedStubTree;
            object2 = this;
            try {
                object = Result.Companion;
                IndexDataComparer $this$runCatching = (IndexDataComparer)object2;
                boolean bl = false;
                ((SerializedStubTree)actualValue).getStubIndicesValueMap();
                V v = actualValue;
                object = Result.constructor-impl(v);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            Object object3 = Result.isFailure-impl((Object)object2) ? null : object2;
            if (!(object3 instanceof SerializedStubTree)) {
                object3 = null;
            }
            SerializedStubTree serializedStubTree2 = (SerializedStubTree)object3;
            if (serializedStubTree2 == null) {
                return false;
            }
            SerializedStubTree actualStubTree = serializedStubTree2;
            return this.areStubTreesTheSame(currentStubTree, actualStubTree);
        }
        DataExternalizer dataExternalizer = extension2.getValueExternalizer();
        Intrinsics.checkNotNullExpressionValue(dataExternalizer, (String)"extension.valueExternalizer");
        DataExternalizer valueExternalizer = dataExternalizer;
        return valueExternalizer instanceof EqualityPolicy ? ((EqualityPolicy)((Object)valueExternalizer)).isEqual(expectedValue, actualValue) : Intrinsics.areEqual(expectedValue, actualValue);
    }

    public final boolean areStubTreesTheSame(@NotNull SerializedStubTree expectedTree, @NotNull SerializedStubTree actualTree) {
        Intrinsics.checkNotNullParameter((Object)expectedTree, (String)"expectedTree");
        Intrinsics.checkNotNullParameter((Object)actualTree, (String)"actualTree");
        Stub stub = expectedTree.getStub();
        Intrinsics.checkNotNullExpressionValue((Object)stub, (String)"expectedTree.stub");
        Stub expectedStub = stub;
        Stub stub2 = actualTree.getStub();
        Intrinsics.checkNotNullExpressionValue((Object)stub2, (String)"actualTree.stub");
        Stub actualStub = stub2;
        if (!this.areStubsTheSame(expectedStub, actualStub)) {
            return false;
        }
        return Intrinsics.areEqual(expectedTree.getStubIndicesValueMap(), actualTree.getStubIndicesValueMap());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areStubsTheSame(Stub expectedStub, Stub actualStub) {
        if (Intrinsics.areEqual(expectedStub.getStubType(), actualStub.getStubType()) ^ true) {
            ObjectStubSerializer<?, Stub> objectStubSerializer = expectedStub.getStubType();
            ObjectStubSerializer<?, Stub> objectStubSerializer2 = actualStub.getStubType();
            if (Intrinsics.areEqual((Object)(objectStubSerializer != null ? objectStubSerializer.toString() : null), (Object)(objectStubSerializer2 != null ? objectStubSerializer2.toString() : null)) ^ true) {
                return false;
            }
        }
        if (Intrinsics.areEqual((Object)expectedStub, (Object)actualStub) ^ true && Intrinsics.areEqual((Object)expectedStub.getClass().getName(), (Object)actualStub.getClass().getName()) ^ true) {
            return false;
        }
        if (expectedStub instanceof ObjectStubBase) {
            if (!(actualStub instanceof ObjectStubBase)) {
                return false;
            }
            if (((ObjectStubBase)expectedStub).getStubId() != ((ObjectStubBase)actualStub).getStubId()) {
                return false;
            }
        }
        List<? extends Stub> list = expectedStub.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue(list, (String)"expectedStub.childrenStubs");
        List<? extends Stub> expectedChildren = list;
        List<? extends Stub> list2 = actualStub.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"actualStub.childrenStubs");
        List<? extends Stub> actualChildren = list2;
        if (expectedChildren.size() != actualChildren.size()) {
            return false;
        }
        int n = 0;
        int n2 = ((Collection)expectedChildren).size();
        while (n < n2) {
            Stub actualChild;
            void index2;
            Stub expectedChild = expectedChildren.get((int)index2);
            if (!this.areStubsTheSame(expectedChild, actualChild = actualChildren.get((int)index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    private IndexDataComparer() {
    }

    static {
        IndexDataComparer indexDataComparer;
        INSTANCE = indexDataComparer = new IndexDataComparer();
    }
}

