/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.Base64;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\b\u001a\u00020\u0004\"\u0004\b\u0000\u0010\t2\b\u0010\n\u001a\u0004\u0018\u0001H\t\u00a2\u0006\u0002\u0010\u0007J&\u0010\u000b\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\t0\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\u0014\u0010\u0014\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/indexing/IndexDataPresenter;", "", "()V", "getPresentableIndexKey", "", "K", "key", "(Ljava/lang/Object;)Ljava/lang/String;", "getPresentableIndexValue", "V", "value", "getPresentableKeyValueMap", "keyValueMap", "", "getPresentableSerializedStubTree", "Lcom/intellij/psi/stubs/SerializedStubTree;", "getPresentableStub", "node", "Lcom/intellij/psi/stubs/Stub;", "indent", "withIndent", "intellij.platform.indexing.impl"})
public final class IndexDataPresenter {
    @NotNull
    public static final IndexDataPresenter INSTANCE;

    @NotNull
    public final <K> String getPresentableIndexKey(K key) {
        return String.valueOf(key);
    }

    @NotNull
    public final <V> String getPresentableIndexValue(@Nullable V value) {
        String string2;
        V v = value;
        if (v == null) {
            string2 = "<no value>";
        } else if (v instanceof SerializedStubTree) {
            string2 = this.getPresentableSerializedStubTree((SerializedStubTree)value);
        } else if (v instanceof ByteArraySequence) {
            String string3 = Base64.encode(((ByteArraySequence)value).toBytes());
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.encode(value.toBytes())");
        } else {
            string2 = value.toString();
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getPresentableSerializedStubTree(@NotNull SerializedStubTree value) {
        StringBuilder stringBuilder;
        block5: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            StringBuilder $this$buildString = stringBuilder = new StringBuilder();
            boolean bl = false;
            StringBuilder stringBuilder2 = $this$buildString;
            Object object = "Stub tree:";
            Object object2 = stringBuilder2.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"append(value)");
            StringBuilder stringBuilder3 = ((StringBuilder)object2).append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
            stringBuilder2 = $this$buildString;
            Stub stub = value.getStub();
            Intrinsics.checkNotNullExpressionValue((Object)stub, (String)"value.stub");
            object = INSTANCE.getPresentableStub(stub, "  ");
            object2 = stringBuilder2.append((String)object);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"append(value)");
            stringBuilder3 = ((StringBuilder)object2).append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
            try {
                Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map2 = value.getStubIndicesValueMap();
                Intrinsics.checkNotNullExpressionValue(map2, (String)"value.stubIndicesValueMap");
                object = map2;
            }
            catch (Exception e) {
                stringBuilder3 = $this$buildString;
                String string2 = "Failed-to-read stub tree forward index: (message = " + e.getMessage() + ") (exception class = " + e.getClass().getSimpleName() + ")";
                StringBuilder stringBuilder4 = stringBuilder3.append(string2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                StringBuilder stringBuilder5 = stringBuilder4.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append('\\n')");
                break block5;
            }
            Object stubIndicesValueMap = object;
            object = $this$buildString;
            object2 = "Stub tree forward index:";
            stringBuilder3 = ((StringBuilder)object).append((String)object2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringBuilder stringBuilder6 = stringBuilder3.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append('\\n')");
            Object $this$sortedBy$iv = stubIndicesValueMap.entrySet();
            boolean $i$f$sortedBy = false;
            object2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)((StubIndexKey)it.getKey()).getName());
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    String string2 = ((StubIndexKey)it.getKey()).getName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                }
            }).iterator();
            while (object2.hasNext()) {
                void stubIndexKey;
                Object object3 = object = (Map.Entry)object2.next();
                $this$sortedBy$iv = (StubIndexKey)object3.getKey();
                object3 = object;
                Map stubIndexValues = (Map)object3.getValue();
                object3 = $this$buildString;
                Object object4 = "    " + stubIndexKey.getName();
                StringBuilder stringBuilder7 = ((StringBuilder)object3).append((String)object4);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
                StringBuilder stringBuilder8 = stringBuilder7.append('\n');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append('\\n')");
                Iterable<Object> $this$sortedBy$iv2 = stubIndexValues.entrySet();
                boolean $i$f$sortedBy2 = false;
                object4 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getKey().toString());
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        String string2 = it.getKey().toString();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                    }
                }).iterator();
                while (object4.hasNext()) {
                    void key;
                    void $this$mapTo$iv$iv;
                    Object object5 = object3 = (Map.Entry)object4.next();
                    $this$sortedBy$iv2 = object5.getKey();
                    object5 = object3;
                    StubIdList stubIdList = (StubIdList)object5.getValue();
                    Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)stubIdList.size());
                    boolean $i$f$map = false;
                    Object object6 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it;
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        Integer n2 = stubIdList.get((int)it);
                        collection.add(n2);
                    }
                    List stubIds = (List)destination$iv$iv;
                    StringBuilder stringBuilder9 = $this$buildString;
                    String string3 = "        " + key + " -> " + CollectionsKt.joinToString$default((Iterable)stubIds, null, null, null, (int)0, null, null, (int)63, null);
                    object6 = stringBuilder9.append(string3);
                    Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"append(value)");
                    StringBuilder stringBuilder10 = ((StringBuilder)object6).append('\n');
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append('\\n')");
                }
            }
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <K, V> String getPresentableKeyValueMap(@NotNull Map<K, ? extends V> keyValueMap) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(keyValueMap, (String)"keyValueMap");
        if (keyValueMap.isEmpty()) {
            return "{empty map}";
        }
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        Map<K, V> map2 = keyValueMap;
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            void key;
            Object object = entry;
            map2 = object.getKey();
            object = entry;
            V value = object.getValue();
            object = $this$buildString;
            String string2 = INSTANCE.getPresentableIndexKey(key);
            StringBuilder stringBuilder2 = ((StringBuilder)object).append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringBuilder stringBuilder3 = stringBuilder2.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
            object = $this$buildString;
            string2 = INSTANCE.withIndent(INSTANCE.getPresentableIndexValue(value), "  ");
            stringBuilder2 = ((StringBuilder)object).append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            stringBuilder3 = stringBuilder2.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    @NotNull
    public final String getPresentableStub(@NotNull Stub node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.getPresentableStub(node, "");
    }

    private final String getPresentableStub(Stub node, String indent) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildString = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildString.append(indent);
        ObjectStubSerializer<?, Stub> stubType = node.getStubType();
        if (stubType != null) {
            $this$buildString.append(stubType.toString()).append(':');
        }
        $this$buildString.append(node.toString());
        if (node instanceof ObjectStubBase) {
            $this$buildString.append(" (id = ").append(((ObjectStubBase)node).getStubId()).append(")");
        }
        for (Stub stub : node.getChildrenStubs()) {
            StringBuilder stringBuilder2 = $this$buildString;
            Stub stub2 = stub;
            Intrinsics.checkNotNullExpressionValue((Object)stub2, (String)"child");
            String string2 = INSTANCE.getPresentableStub(stub2, indent + "  ");
            StringBuilder stringBuilder3 = stringBuilder2.append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringBuilder stringBuilder4 = stringBuilder3.append('\n');
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append('\\n')");
        }
        String string3 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    private final String withIndent(String $this$withIndent, String indent) {
        return SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)$this$withIndent), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(indent){
            final /* synthetic */ String $indent;

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$indent + it;
            }
            {
                this.$indent = string2;
                super(1);
            }
        }), (int)30, null);
    }

    private IndexDataPresenter() {
    }

    static {
        IndexDataPresenter indexDataPresenter;
        INSTANCE = indexDataPresenter = new IndexDataPresenter();
    }
}

