/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;

final class FileId2ValueMapping<Value> {
    private static final Logger LOG = Logger.getInstance(FileId2ValueMapping.class);
    private final Int2ObjectMap<Value> id2ValueMap = new Int2ObjectOpenHashMap<Value>();
    private final ValueContainerImpl<Value> valueContainer;
    private boolean myOnePerFileValidationEnabled = true;

    FileId2ValueMapping(ValueContainerImpl<Value> _valueContainer) {
        this.valueContainer = _valueContainer;
        IntArrayList removedFileIdList = null;
        SmartList removedValueList = null;
        ValueContainer.ValueIterator valueIterator = _valueContainer.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            ValueContainer.IntIterator intIterator = valueIterator.getInputIdsIterator();
            while (intIterator.hasNext()) {
                int id = intIterator.next();
                Object previousValue = this.id2ValueMap.put(id, (Value)value);
                if (previousValue == null) continue;
                if (removedFileIdList == null) {
                    removedFileIdList = new IntArrayList();
                    removedValueList = new SmartList();
                }
                removedFileIdList.add(id);
                removedValueList.add(previousValue);
            }
        }
        if (removedFileIdList != null) {
            int size = removedFileIdList.size();
            for (int i = 0; i < size; ++i) {
                this.valueContainer.removeValue(removedFileIdList.get(i), removedValueList.get(i));
            }
        }
    }

    void associateFileIdToValue(int fileId, Value value) {
        Value previousValue = this.id2ValueMap.put(fileId, value);
        if (previousValue != null) {
            this.valueContainer.removeValue(fileId, previousValue);
        }
    }

    boolean removeFileId(int inputId) {
        Object mapped = this.id2ValueMap.remove(inputId);
        if (mapped != null) {
            this.valueContainer.removeValue(inputId, mapped);
        }
        if (IndexDebugProperties.EXTRA_SANITY_CHECKS && this.myOnePerFileValidationEnabled) {
            ValueContainer.ValueIterator valueIterator = this.valueContainer.getValueIterator();
            while (valueIterator.hasNext()) {
                valueIterator.next();
                LOG.assertTrue(!valueIterator.getValueAssociationPredicate().test(inputId));
            }
        }
        return mapped != null;
    }

    public void disableOneValuePerFileValidation() {
        this.myOnePerFileValidationEnabled = false;
    }
}

