/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.AbstractUpdateData;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public abstract class MapReduceIndexBase<Key, Value, FileCache>
extends MapReduceIndex<Key, Value, FileContent>
implements UpdatableIndex<Key, Value, FileContent, FileCache> {
    private final boolean mySingleEntryIndex;

    protected MapReduceIndexBase(@NotNull IndexExtension<Key, Value, FileContent> extension2, @NotNull ThrowableComputable<? extends IndexStorage<Key, Value>, ? extends IOException> storage, @Nullable ThrowableComputable<? extends ForwardIndex, ? extends IOException> forwardIndex, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor, @Nullable ReadWriteLock lock) throws IOException {
        if (extension2 == null) {
            MapReduceIndexBase.$$$reportNull$$$0(0);
        }
        if (storage == null) {
            MapReduceIndexBase.$$$reportNull$$$0(1);
        }
        super(extension2, storage, forwardIndex, forwardIndexAccessor, lock);
        if (!(this.myIndexId instanceof ID)) {
            throw new IllegalArgumentException("myIndexId should be instance of com.intellij.util.indexing.ID");
        }
        this.mySingleEntryIndex = extension2 instanceof SingleEntryFileBasedIndexExtension;
    }

    @Override
    public boolean processAllKeys(@NotNull Processor<? super Key> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor == null) {
            MapReduceIndexBase.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            MapReduceIndexBase.$$$reportNull$$$0(3);
        }
        return ConcurrencyUtil.withLock(this.getLock().readLock(), () -> ((VfsAwareIndexStorage)this.myStorage).processKeys(processor, scope, idFilter));
    }

    @Override
    @NotNull
    public Map<Key, Value> getIndexedFileData(int fileId) throws StorageException {
        Map map2 = ConcurrencyUtil.withLock(this.getLock().readLock(), () -> {
            try {
                return Collections.unmodifiableMap(ContainerUtil.notNullize(this.getNullableIndexedData(fileId)));
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        });
        if (map2 == null) {
            MapReduceIndexBase.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @Nullable
    protected Map<Key, Value> getNullableIndexedData(int fileId) throws IOException, StorageException {
        if (this.isDisposed()) {
            return null;
        }
        if (this.mySingleEntryIndex) {
            Integer key = fileId;
            Ref result2 = new Ref(Collections.emptyMap());
            ValueContainer<Object> container = this.getData(key);
            container.forEach((id, value) -> {
                boolean acceptNullValues = ((SingleEntryIndexer)this.myIndexer).isAcceptNullValues();
                if (value != null || acceptNullValues) {
                    result2.set(Collections.singletonMap(key, value));
                }
                return false;
            });
            return result2.get();
        }
        if (this.getForwardIndexAccessor() instanceof AbstractMapForwardIndexAccessor) {
            ByteArraySequence serializedInputData = this.getForwardIndex().get(fileId);
            AbstractMapForwardIndexAccessor forwardIndexAccessor = (AbstractMapForwardIndexAccessor)this.getForwardIndexAccessor();
            return forwardIndexAccessor.convertToInputDataMap(fileId, serializedInputData);
        }
        this.getLogger().error("Can't fetch indexed data for index " + this.myIndexId.getName());
        return null;
    }

    @Override
    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    @Override
    public void updateWithMap(@NotNull AbstractUpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            MapReduceIndexBase.$$$reportNull$$$0(5);
        }
        try {
            super.updateWithMap(updateData);
        }
        catch (ProcessCanceledException e) {
            this.getLogger().error("ProcessCancelledException is not expected here!", e);
            throw e;
        }
    }

    @Override
    public void setBufferingEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanupMemoryStorage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cleanupForNextTest() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTransientDataForFile(int inputId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTransientDataForKeys(int inputId, @NotNull InputDataDiffBuilder<Key, Value> diffBuilder) {
        if (diffBuilder == null) {
            MapReduceIndexBase.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException();
    }

    protected abstract Logger getLogger();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/storage/MapReduceIndexBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diffBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/storage/MapReduceIndexBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexedFileData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateWithMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientDataForKeys";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

