/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SystemProperties;
import com.intellij.util.containers.LimitedPool;
import com.intellij.util.io.FinalizationRequest;
import com.intellij.util.io.PoolPageKey;
import com.intellij.util.io.RandomAccessDataFile;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.jetbrains.annotations.Nullable;

public class Page {
    public static final int PAGE_SIZE = SystemProperties.getIntProperty("idea.io.page.size", 8192);
    private static final LimitedPool<ByteBuffer> ourBufferPool = new LimitedPool.Sync<ByteBuffer>(10, () -> ByteBuffer.allocate(PAGE_SIZE));
    private final PoolPageKey myKey;
    private ByteBuffer buf;
    private boolean read;
    private boolean dirty;
    private int myFinalizationId;
    private BitSet myWriteMask;
    private final PageLock lock = new PageLock();
    private final Range myContinuousRange = new Range();

    public Page(PoolPageKey key) {
        this.myKey = key;
        this.read = false;
        this.dirty = false;
        this.myWriteMask = null;
        assert (key.getOffset() >= 0L) : "offset = " + key.getOffset();
    }

    private void ensureRead() {
        if (!this.read) {
            if (this.myWriteMask != null) {
                byte[] content = new byte[PAGE_SIZE];
                ByteBuffer b = this.getBuf();
                b.position(0);
                b.get(content, 0, PAGE_SIZE);
                this.getOwner().loadPage(this);
                int i = this.myWriteMask.nextSetBit(0);
                while (i >= 0) {
                    b.put(i, content[i]);
                    i = this.myWriteMask.nextSetBit(i + 1);
                }
                this.myWriteMask = null;
            } else {
                this.getOwner().loadPage(this);
            }
            this.read = true;
        }
    }

    private void ensureReadOrWriteMaskExists() {
        this.dirty = true;
        if (this.read || this.myWriteMask != null) {
            return;
        }
        this.myWriteMask = new BitSet(PAGE_SIZE);
    }

    @Nullable
    private Range calcContinuousRange(BitSet mask) {
        int lowestByte = mask.nextSetBit(0);
        if (lowestByte >= 0) {
            int highestByte = mask.nextClearBit(lowestByte);
            if (highestByte > 0) {
                int nextChunk = mask.nextSetBit(highestByte);
                if (nextChunk < 0) {
                    this.myContinuousRange.start = lowestByte;
                    this.myContinuousRange.end = highestByte;
                    return this.myContinuousRange;
                }
                return null;
            }
            this.myContinuousRange.start = lowestByte;
            this.myContinuousRange.end = PAGE_SIZE;
            return this.myContinuousRange;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.dirty) {
                int start = 0;
                int end = PAGE_SIZE;
                if (this.myWriteMask != null) {
                    Range range = this.calcContinuousRange(this.myWriteMask);
                    if (range == null) {
                        this.ensureRead();
                    } else {
                        start = range.start;
                        end = range.end;
                    }
                    this.myWriteMask = null;
                }
                if (end - start > 0) {
                    this.getOwner().flushPage(this, start, end);
                }
                this.dirty = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getBuf() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.buf == null) {
                this.buf = ourBufferPool.alloc();
            }
            return this.buf;
        }
    }

    private void recycle() {
        ByteBuffer buf = this.buf;
        if (buf != null) {
            ourBufferPool.recycle(buf);
        }
        this.buf = null;
        this.read = false;
        this.dirty = false;
        this.myWriteMask = null;
    }

    public long getOffset() {
        return this.myKey.getOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int put(long index2, byte[] bytes, int off, int length) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            this.myFinalizationId = 0;
            this.ensureReadOrWriteMaskExists();
            int start = (int)(index2 - this.getOffset());
            this.ensureIndexInRange(index2);
            ByteBuffer b = this.getBuf();
            b.position(start);
            int count = Math.min(length, PAGE_SIZE - start);
            b.put(bytes, off, count);
            if (this.myWriteMask != null) {
                this.myWriteMask.set(start, start + count);
            }
            return count;
        }
    }

    private void ensureIndexInRange(long index2) {
        if (index2 < this.getOffset()) {
            throw new IllegalArgumentException("index < offset: index = " + index2 + ", offset = " + this.getOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(long index2, byte[] bytes, int off, int length) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            this.myFinalizationId = 0;
            this.ensureRead();
            this.ensureIndexInRange(index2);
            int start = (int)(index2 - this.getOffset());
            ByteBuffer b = this.getBuf();
            b.position(start);
            int count = Math.min(length, PAGE_SIZE - start);
            b.get(bytes, off, count);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FinalizationRequest prepareForFinalization(int finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if (this.dirty) {
                this.myFinalizationId = finalizationId;
                return new FinalizationRequest(this, finalizationId);
            }
            this.recycle();
            return null;
        }
    }

    public RandomAccessDataFile getOwner() {
        return (RandomAccessDataFile)this.getKey().getOwner();
    }

    public PoolPageKey getKey() {
        return this.myKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushIfFinalizationIdIsEqualTo(long finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if ((long)this.myFinalizationId == finalizationId) {
                this.flush();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recycleIfFinalizationIdIsEqualTo(long finalizationId) {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            if ((long)this.myFinalizationId == finalizationId) {
                this.recycle();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        PageLock pageLock = this.lock;
        synchronized (pageLock) {
            return "Page[" + this.getOwner() + ", dirty: " + this.dirty + ", offset=" + this.getOffset() + "]";
        }
    }

    private static class Range {
        int start;
        int end;

        private Range() {
        }
    }

    private static class PageLock {
        private PageLock() {
        }
    }
}

