/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.workspaceModel.storage.ClassConversion;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityWithPersistentId;
import com.intellij.workspaceModel.storage.impl.AbstractEntityStorage;
import com.intellij.workspaceModel.storage.impl.ClassToIntConverter;
import com.intellij.workspaceModel.storage.impl.EntitiesKt;
import com.intellij.workspaceModel.storage.impl.EntityFamily;
import com.intellij.workspaceModel.storage.impl.WithAssertableConsistency;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001b\u0010\r\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u0006\u0010\u0010\u001a\u00020\u000fR\"\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00050\u0004X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/workspaceModel/storage/impl/EntitiesBarrel;", "", "()V", "entityFamilies", "", "Lcom/intellij/workspaceModel/storage/impl/EntityFamily;", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "getEntityFamilies$intellij_platform_workspaceModel_storage", "()Ljava/util/List;", "assertConsistency", "", "abstractEntityStorage", "Lcom/intellij/workspaceModel/storage/impl/AbstractEntityStorage;", "get", "clazz", "", "size", "Lcom/intellij/workspaceModel/storage/impl/ImmutableEntitiesBarrel;", "Lcom/intellij/workspaceModel/storage/impl/MutableEntitiesBarrel;", "intellij.platform.workspaceModel.storage"})
public abstract class EntitiesBarrel {
    @NotNull
    public abstract List<EntityFamily<? extends WorkspaceEntity>> getEntityFamilies$intellij_platform_workspaceModel_storage();

    @Nullable
    public EntityFamily<? extends WorkspaceEntity> get(int clazz) {
        return (EntityFamily)CollectionsKt.getOrNull(this.getEntityFamilies$intellij_platform_workspaceModel_storage(), (int)clazz);
    }

    public final int size() {
        return this.getEntityFamilies$intellij_platform_workspaceModel_storage().size();
    }

    /*
     * WARNING - void declaration
     */
    public final void assertConsistency(@NotNull AbstractEntityStorage abstractEntityStorage) {
        Intrinsics.checkNotNullParameter((Object)abstractEntityStorage, (String)"abstractEntityStorage");
        HashSet persistentIds = new HashSet();
        Iterable $this$forEachIndexed$iv = this.getEntityFamilies$intellij_platform_workspaceModel_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            Class<?> clazz;
            void family;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EntityFamily entityFamily = (EntityFamily)item$iv;
            int i = n;
            boolean bl = false;
            if (family == null) continue;
            int $this$findEntityClass$iv = i;
            boolean $i$f$findEntityClass = false;
            if (ClassToIntConverter.Companion.getINSTANCE().getClassOrDie($this$findEntityClass$iv) == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<E>");
            }
            boolean hasPersistentId = WorkspaceEntityWithPersistentId.class.isAssignableFrom(clazz);
            void this_$iv = family;
            boolean $i$f$assertConsistency = false;
            Iterable $this$forEachIndexed$iv$iv = this_$iv.getEntities$intellij_platform_workspaceModel_storage();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                boolean bl2;
                void entity$iv;
                int n2 = index$iv$iv;
                index$iv$iv = n2 + 1;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv$iv;
                int idx$iv = n2;
                boolean bl3 = false;
                if (entity$iv == null) continue;
                boolean bl4 = bl2 = idx$iv == entity$iv.getId();
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string2 = "Entity with id " + entity$iv.getId() + " is placed at index " + idx$iv;
                    throw new AssertionError((Object)string2);
                }
                void entityData = entity$iv;
                boolean bl6 = false;
                Class immutableClass = ClassConversion.INSTANCE.entityDataToEntity(entityData.getClass());
                boolean bl7 = Intrinsics.areEqual(clazz, immutableClass);
                if (_Assertions.ENABLED && !bl7) {
                    boolean bl8 = false;
                    String string3 = StringsKt.trimMargin$default((String)("EntityFamily contains entity data of wrong type:\n                | - EntityFamily class:   " + clazz + "\n                | - entityData class:     " + immutableClass + "\n              "), null, (int)1, null);
                    throw new AssertionError((Object)string3);
                }
                if (hasPersistentId) {
                    boolean bl9;
                    PersistentEntityId<?> persistentId = EntitiesKt.persistentId(entityData);
                    boolean bl10 = bl9 = persistentId != null;
                    if (_Assertions.ENABLED && !bl9) {
                        boolean $i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42 = false;
                        String $i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42 = "Persistent id expected for " + clazz;
                        throw new AssertionError((Object)$i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42);
                    }
                    boolean bl11 = bl9 = !CollectionsKt.contains((Iterable)persistentIds, persistentId);
                    if (_Assertions.ENABLED && !bl9) {
                        boolean bl12 = false;
                        String string4 = "Duplicated persistent ids: " + persistentId;
                        throw new AssertionError((Object)string4);
                    }
                    PersistentEntityId<?> persistentEntityId = persistentId;
                    Intrinsics.checkNotNull(persistentEntityId);
                    persistentIds.add(persistentEntityId);
                }
                if (!(entityData instanceof WithAssertableConsistency)) continue;
                ((WithAssertableConsistency)entityData).assertConsistency(abstractEntityStorage);
            }
            EntityFamily.access$familyCheck((EntityFamily)this_$iv);
        }
    }

    private EntitiesBarrel() {
    }

    public /* synthetic */ EntitiesBarrel(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

