/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitor;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionUtil;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultHighlightVisitorBasedInspection
extends GlobalSimpleInspectionTool {
    private final boolean highlightErrorElements;
    private final boolean runAnnotators;

    protected DefaultHighlightVisitorBasedInspection(boolean highlightErrorElements, boolean runAnnotators) {
        this.highlightErrorElements = highlightErrorElements;
        this.runAnnotators = runAnnotators;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    public void checkFile(@NotNull PsiFile originalFile, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (originalFile == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(2);
        }
        if (problemsHolder == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(3);
        }
        if (globalContext == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(4);
        }
        if (problemDescriptionsProcessor == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(5);
        }
        for (Pair<PsiFile, HighlightInfo> pair : DefaultHighlightVisitorBasedInspection.runAnnotatorsInGeneralHighlighting(originalFile, this.highlightErrorElements, this.runAnnotators)) {
            PsiElement element;
            PsiFile file2 = (PsiFile)pair.first;
            HighlightInfo info = (HighlightInfo)pair.second;
            TextRange range = new TextRange(info.startOffset, info.endOffset);
            for (element = file2.findElementAt(info.startOffset); element != null && !element.getTextRange().contains(range); element = element.getParent()) {
            }
            if (element == null) {
                element = file2;
            }
            GlobalInspectionUtil.createProblem(element, info, range.shiftRight(-element.getNode().getStartOffset()), info.getProblemGroup(), manager, problemDescriptionsProcessor, globalContext);
        }
    }

    @NotNull
    public static List<Pair<PsiFile, HighlightInfo>> runAnnotatorsInGeneralHighlighting(@NotNull PsiFile file2, boolean highlightErrorElements, boolean runAnnotators) {
        if (file2 == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(6);
        }
        ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
        MyPsiElementVisitor visitor = new MyPsiElementVisitor(highlightErrorElements, runAnnotators);
        if (indicator instanceof DaemonProgressIndicator) {
            file2.accept(visitor);
        } else {
            DaemonProgressIndicator progress = new DaemonProgressIndicator();
            HighlightingSessionImpl.createHighlightingSession(file2, progress, null, ProperTextRange.create(file2.getTextRange()), false);
            ProgressManager.getInstance().runProcess(() -> file2.accept(visitor), (ProgressIndicator)progress);
        }
        List<Pair<PsiFile, HighlightInfo>> list = visitor.result;
        if (list == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string2 = DefaultHighlightVisitorBasedInspection.getGeneralGroupName();
        if (string2 == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @NotNull
    private static List<Pair<PsiFile, HighlightInfo>> runAnnotatorsInGeneralHighlightingPass(@NotNull PsiFile file2, boolean highlightErrorElements, boolean runAnnotators) {
        Project project;
        Document document;
        if (file2 == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(9);
        }
        if ((document = PsiDocumentManager.getInstance(project = file2.getProject()).getDocument(file2)) == null) {
            List<Pair<PsiFile, HighlightInfo>> list = Collections.emptyList();
            if (list == null) {
                DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(10);
            }
            return list;
        }
        ProgressIndicator progress = ProgressManager.getGlobalProgressIndicator();
        DaemonProgressIndicator daemonProgressIndicator = GlobalInspectionContextBase.assertUnderDaemonProgress();
        HighlightingSessionImpl.getOrCreateHighlightingSession(file2, daemonProgressIndicator, ProperTextRange.create(file2.getTextRange()));
        TextEditorHighlightingPassRegistrarEx passRegistrarEx = TextEditorHighlightingPassRegistrarEx.getInstanceEx(project);
        List<TextEditorHighlightingPass> passes = passRegistrarEx.instantiateMainPasses(file2, document, HighlightInfoProcessor.getEmpty());
        List<GeneralHighlightingPass> gpasses = ContainerUtil.filterIsInstance(passes, GeneralHighlightingPass.class);
        for (GeneralHighlightingPass gpass : gpasses) {
            gpass.setHighlightVisitorProducer(() -> {
                gpass.incVisitorUsageCount(1);
                DefaultHighlightVisitor visitor = new DefaultHighlightVisitor(project, highlightErrorElements, runAnnotators, true);
                return new HighlightVisitor[]{visitor};
            });
        }
        ArrayList<Pair<PsiFile, HighlightInfo>> result2 = new ArrayList<Pair<PsiFile, HighlightInfo>>();
        for (TextEditorHighlightingPass textEditorHighlightingPass : gpasses) {
            textEditorHighlightingPass.doCollectInformation(progress);
            List<HighlightInfo> infos = textEditorHighlightingPass.getInfos();
            for (HighlightInfo info : infos) {
                if (info == null || info.getSeverity().compareTo(HighlightSeverity.INFORMATION) <= 0) continue;
                result2.add(Pair.create(file2, info));
            }
        }
        ArrayList<Pair<PsiFile, HighlightInfo>> arrayList = result2;
        if (arrayList == null) {
            DefaultHighlightVisitorBasedInspection.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptionsProcessor";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "runAnnotatorsInGeneralHighlighting";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "runAnnotatorsInGeneralHighlightingPass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotatorsInGeneralHighlighting";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotatorsInGeneralHighlightingPass";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyPsiElementVisitor
    extends PsiElementVisitor {
        private final boolean highlightErrorElements;
        private final boolean runAnnotators;
        private final List<Pair<PsiFile, HighlightInfo>> result = new ArrayList<Pair<PsiFile, HighlightInfo>>();

        MyPsiElementVisitor(boolean highlightErrorElements, boolean runAnnotators) {
            this.highlightErrorElements = highlightErrorElements;
            this.runAnnotators = runAnnotators;
        }

        @Override
        public void visitFile(@NotNull PsiFile file2) {
            VirtualFile virtualFile;
            if (file2 == null) {
                MyPsiElementVisitor.$$$reportNull$$$0(0);
            }
            if ((virtualFile = file2.getVirtualFile()) == null) {
                return;
            }
            this.result.addAll(DefaultHighlightVisitorBasedInspection.runAnnotatorsInGeneralHighlightingPass(file2, this.highlightErrorElements, this.runAnnotators));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection$MyPsiElementVisitor", "visitFile"));
        }
    }

    public static class SyntaxErrorInspection
    extends DefaultHighlightVisitorBasedInspection {
        public SyntaxErrorInspection() {
            super(true, false);
        }

        @Override
        @Nls
        @NotNull
        public String getDisplayName() {
            String string2 = AnalysisBundle.message("inspection.display.name.syntax.error", new Object[0]);
            if (string2 == null) {
                SyntaxErrorInspection.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getShortName() {
            return "SyntaxError";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection$SyntaxErrorInspection", "getDisplayName"));
        }
    }

    public static class AnnotatorBasedInspection
    extends DefaultHighlightVisitorBasedInspection {
        @NonNls
        private static final String ANNOTATOR_SHORT_NAME = "Annotator";

        public AnnotatorBasedInspection() {
            super(false, true);
        }

        @Override
        @Nls
        @NotNull
        public String getDisplayName() {
            String string2 = AnalysisBundle.message("inspection.display.name.annotator", new Object[0]);
            if (string2 == null) {
                AnnotatorBasedInspection.$$$reportNull$$$0(0);
            }
            return string2;
        }

        @Override
        @NotNull
        public String getShortName() {
            return ANNOTATOR_SHORT_NAME;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitorBasedInspection$AnnotatorBasedInspection", "getDisplayName"));
        }
    }
}

