/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectListener;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.concurrency.JobLauncher;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class InspectionEngine {
    private static final Logger LOG = Logger.getInstance(InspectionEngine.class);
    private static final Set<Class<? extends LocalInspectionTool>> RECURSIVE_VISITOR_TOOL_CLASSES = ContainerUtil.newConcurrentSet();
    private static final Set<String> ourToolsWithInformationProblems = ConcurrentCollectionFactory.createConcurrentSet(HashingStrategy.canonical());

    public static boolean createVisitorAndAcceptElements(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session, @NotNull List<? extends PsiElement> elements) {
        PsiElementVisitor visitor;
        if (tool == null) {
            InspectionEngine.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            InspectionEngine.$$$reportNull$$$0(1);
        }
        if (session == null) {
            InspectionEngine.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(3);
        }
        if ((visitor = InspectionEngine.createVisitor(tool, holder, isOnTheFly, session)) == PsiElementVisitor.EMPTY_VISITOR) {
            return false;
        }
        tool.inspectionStarted(session, isOnTheFly);
        InspectionEngine.acceptElements(elements, visitor);
        tool.inspectionFinished(session, holder);
        return true;
    }

    @NotNull
    public static PsiElementVisitor createVisitor(@NotNull LocalInspectionTool tool, @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PsiElementVisitor visitor;
        if (tool == null) {
            InspectionEngine.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            InspectionEngine.$$$reportNull$$$0(5);
        }
        if (session == null) {
            InspectionEngine.$$$reportNull$$$0(6);
        }
        if ((visitor = tool.buildVisitor(holder, isOnTheFly, session)) == null) {
            LOG.error("Tool " + tool + " (" + tool.getClass() + ") must not return null from the buildVisitor() method");
        } else if (visitor instanceof PsiRecursiveVisitor && RECURSIVE_VISITOR_TOOL_CLASSES.add(tool.getClass())) {
            LOG.error("The visitor returned from LocalInspectionTool.buildVisitor() must not be recursive: " + tool);
        }
        PsiElementVisitor psiElementVisitor = visitor;
        if (psiElementVisitor == null) {
            InspectionEngine.$$$reportNull$$$0(7);
        }
        return psiElementVisitor;
    }

    public static void acceptElements(@NotNull List<? extends PsiElement> elements, @NotNull PsiElementVisitor elementVisitor) {
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(8);
        }
        if (elementVisitor == null) {
            InspectionEngine.$$$reportNull$$$0(9);
        }
        int elementsSize = elements.size();
        for (int i = 0; i < elementsSize; ++i) {
            PsiElement element = elements.get(i);
            element.accept(elementVisitor);
            ProgressManager.checkCanceled();
        }
    }

    @Deprecated
    @NotNull
    public static Map<String, List<ProblemDescriptor>> inspectEx(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull InspectionManager iManager, boolean isOnTheFly, @NotNull ProgressIndicator indicator) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(11);
        }
        if (iManager == null) {
            InspectionEngine.$$$reportNull$$$0(12);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(13);
        }
        Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> map2 = InspectionEngine.inspectEx(toolWrappers, file2, file2.getTextRange(), file2.getTextRange(), isOnTheFly, false, true, indicator, PairProcessor.alwaysTrue());
        Map<String, List<ProblemDescriptor>> map3 = map2.entrySet().stream().map(e -> Pair.create(((LocalInspectionToolWrapper)e.getKey()).getShortName(), (List)e.getValue())).collect(Collectors.toMap(p -> (String)p.getFirst(), p -> (List)p.getSecond()));
        if (map3 == null) {
            InspectionEngine.$$$reportNull$$$0(14);
        }
        return map3;
    }

    @NotNull
    public static Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> inspectEx(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, boolean isOnTheFly, boolean inspectInjectedPsi, boolean ignoreSuppressedElements, @NotNull ProgressIndicator indicator, @NotNull PairProcessor<? super LocalInspectionToolWrapper, ? super ProblemDescriptor> foundDescriptorCallback) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(16);
        }
        if (restrictRange == null) {
            InspectionEngine.$$$reportNull$$$0(17);
        }
        if (priorityRange == null) {
            InspectionEngine.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(19);
        }
        if (foundDescriptorCallback == null) {
            InspectionEngine.$$$reportNull$$$0(20);
        }
        if (toolWrappers.isEmpty()) {
            Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> map2 = Collections.emptyMap();
            if (map2 == null) {
                InspectionEngine.$$$reportNull$$$0(21);
            }
            return map2;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(file2, restrictRange, priorityRange, __ -> true, new CommonProcessors.CollectProcessor(allDivided));
        List<PsiElement> elements = ContainerUtil.concat(ContainerUtil.map(allDivided, d -> ContainerUtil.concat(d.inside, d.outside, d.parents)));
        Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> map3 = InspectionEngine.inspectElements(toolWrappers, file2, restrictRange, ignoreSuppressedElements, isOnTheFly, indicator, elements, foundDescriptorCallback);
        if (inspectInjectedPsi) {
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(file2.getProject());
            ArrayList<Pair<PsiFile, PsiElement>> injectedFiles = new ArrayList<Pair<PsiFile, PsiElement>>();
            for (PsiElement element : elements) {
                List<Pair<PsiElement, TextRange>> files2;
                if (!(element instanceof PsiLanguageInjectionHost) || (files2 = injectedLanguageManager.getInjectedPsiFiles(element)) == null) continue;
                for (Pair<PsiElement, TextRange> pair2 : files2) {
                    PsiFile injectedFile = (PsiFile)pair2.getFirst();
                    injectedFiles.add(Pair.create(injectedFile, element));
                }
            }
            if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(injectedFiles, indicator, pair -> {
                PsiFile injectedFile = (PsiFile)pair.getFirst();
                PsiElement host = (PsiElement)pair.getSecond();
                ArrayList injectedElements = new ArrayList();
                HashSet<String> injectedDialects = new HashSet<String>();
                InspectionEngine.getAllElementsAndDialectsFrom(injectedFile, injectedElements, injectedDialects);
                Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> result2 = InspectionEngine.inspectElements(toolWrappers, injectedFile, injectedFile.getTextRange(), isOnTheFly, indicator, ignoreSuppressedElements, injectedElements, injectedDialects, foundDescriptorCallback);
                for (Map.Entry<LocalInspectionToolWrapper, List<ProblemDescriptor>> entry : result2.entrySet()) {
                    LocalInspectionToolWrapper toolWrapper = entry.getKey();
                    List<ProblemDescriptor> descriptors = entry.getValue();
                    List<ProblemDescriptor> filtered = ignoreSuppressedElements ? ContainerUtil.filter(descriptors, descriptor -> !((LocalInspectionTool)toolWrapper.getTool()).isSuppressedFor(host)) : descriptors;
                    map3.merge(toolWrapper, filtered, (oldList, newList) -> ContainerUtil.concat(oldList, newList));
                }
                return true;
            })) {
                throw new ProcessCanceledException();
            }
        }
        Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> map4 = map3;
        if (map4 == null) {
            InspectionEngine.$$$reportNull$$$0(22);
        }
        return map4;
    }

    private static void getAllElementsAndDialectsFrom(@NotNull PsiFile file2, final @NotNull List<? super PsiElement> outElements, final @NotNull Set<? super String> outDialects) {
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(23);
        }
        if (outElements == null) {
            InspectionEngine.$$$reportNull$$$0(24);
        }
        if (outDialects == null) {
            InspectionEngine.$$$reportNull$$$0(25);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        final SmartHashSet processedLanguages = new SmartHashSet();
        PsiRecursiveElementVisitor visitor = new PsiRecursiveElementVisitor(){

            @Override
            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressManager.checkCanceled();
                for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    outElements.add(child);
                    child.accept(this);
                    InspectionEngine.appendDialects(child, processedLanguages, outDialects);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/InspectionEngine$1", "visitElement"));
            }
        };
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psiRoot = viewProvider.getPsi(language);
            if (psiRoot == null || !HighlightingLevelManager.getInstance(file2.getProject()).shouldInspect(psiRoot)) continue;
            outElements.add(psiRoot);
            psiRoot.accept(visitor);
            InspectionEngine.appendDialects(psiRoot, processedLanguages, outDialects);
        }
    }

    private static void appendDialects(@NotNull PsiElement element, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (element == null) {
            InspectionEngine.$$$reportNull$$$0(26);
        }
        if (outProcessedLanguages == null) {
            InspectionEngine.$$$reportNull$$$0(27);
        }
        if (outDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(28);
        }
        Language language = element.getLanguage();
        outDialectIds.add(language.getID());
        if (outProcessedLanguages.add(language)) {
            for (Language dialect : language.getDialects()) {
                outDialectIds.add(dialect.getID());
            }
        }
    }

    @NotNull
    public static Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> inspectElements(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull TextRange restrictRange, boolean ignoreSuppressedElements, boolean isOnTheFly, @NotNull ProgressIndicator indicator, @NotNull List<? extends PsiElement> elements, @NotNull PairProcessor<? super LocalInspectionToolWrapper, ? super ProblemDescriptor> foundDescriptorCallback) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(29);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(30);
        }
        if (restrictRange == null) {
            InspectionEngine.$$$reportNull$$$0(31);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(32);
        }
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(33);
        }
        if (foundDescriptorCallback == null) {
            InspectionEngine.$$$reportNull$$$0(34);
        }
        return InspectionEngine.inspectElements(toolWrappers, file2, restrictRange, isOnTheFly, indicator, ignoreSuppressedElements, elements, InspectionEngine.calcElementDialectIds(elements), foundDescriptorCallback);
    }

    @ApiStatus.Internal
    public static void withSession(@NotNull PsiFile file2, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, boolean isOnTheFly, @NotNull Consumer<? super LocalInspectionToolSession> runnable) {
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(35);
        }
        if (restrictRange == null) {
            InspectionEngine.$$$reportNull$$$0(36);
        }
        if (priorityRange == null) {
            InspectionEngine.$$$reportNull$$$0(37);
        }
        if (runnable == null) {
            InspectionEngine.$$$reportNull$$$0(38);
        }
        LocalInspectionToolSession session = new LocalInspectionToolSession(file2, priorityRange);
        runnable.accept(session);
    }

    @NotNull
    private static Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> inspectElements(@NotNull List<? extends LocalInspectionToolWrapper> toolWrappers, @NotNull PsiFile file2, @NotNull TextRange restrictRange, final boolean isOnTheFly, @NotNull ProgressIndicator indicator, boolean ignoreSuppressedElements, @NotNull List<? extends PsiElement> elements, @NotNull Set<String> elementDialectIds, @NotNull PairProcessor<? super LocalInspectionToolWrapper, ? super ProblemDescriptor> foundDescriptorCallback) {
        if (toolWrappers == null) {
            InspectionEngine.$$$reportNull$$$0(39);
        }
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(40);
        }
        if (restrictRange == null) {
            InspectionEngine.$$$reportNull$$$0(41);
        }
        if (indicator == null) {
            InspectionEngine.$$$reportNull$$$0(42);
        }
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(43);
        }
        if (elementDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(44);
        }
        if (foundDescriptorCallback == null) {
            InspectionEngine.$$$reportNull$$$0(45);
        }
        ConcurrentHashMap<LocalInspectionToolWrapper, List<ProblemDescriptor>> resultDescriptors = new ConcurrentHashMap<LocalInspectionToolWrapper, List<ProblemDescriptor>>();
        InspectionEngine.withSession(file2, restrictRange, restrictRange, isOnTheFly, session -> {
            InspectListener publisher = file2.getProject().getMessageBus().syncPublisher(GlobalInspectionContextEx.INSPECT_TOPIC);
            List<LocalInspectionToolWrapper> filtered = InspectionEngine.filterToolsApplicableByLanguage(toolWrappers, elementDialectIds);
            Processor<LocalInspectionToolWrapper> processor = toolWrapper -> {
                boolean needToReportStatsToQodana;
                ProblemsHolder holder = new ProblemsHolder(InspectionManager.getInstance(file2.getProject()), file2, isOnTheFly, (LocalInspectionToolWrapper)toolWrapper, file2, foundDescriptorCallback){
                    final /* synthetic */ LocalInspectionToolWrapper val$toolWrapper;
                    final /* synthetic */ PsiFile val$file;
                    final /* synthetic */ PairProcessor val$foundDescriptorCallback;
                    {
                        this.val$toolWrapper = localInspectionToolWrapper;
                        this.val$file = psiFile;
                        this.val$foundDescriptorCallback = pairProcessor;
                        super(arg0, arg1, arg2);
                    }

                    @Override
                    public void registerProblem(@NotNull ProblemDescriptor descriptor) {
                        if (descriptor == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if (!isOnTheFly) {
                            ProblemHighlightType highlightType = descriptor.getHighlightType();
                            if (highlightType == ProblemHighlightType.INFORMATION) {
                                String shortName = this.val$toolWrapper.getShortName();
                                if (ourToolsWithInformationProblems.add(shortName)) {
                                    String message2 = "Tool #" + shortName + " (" + ((LocalInspectionTool)this.val$toolWrapper.getTool()).getClass() + ") registers 'INFORMATION'-level problem in batch mode on " + this.val$file + ". Warnings of the 'INFORMATION' level are invisible in the editor and should not become visible in batch mode. Moreover, since 'INFORMATION'-level fixes act more like intention actions, they could e.g. change semantics and thus should not be suggested for batch transformations";
                                    LocalInspectionEP extension2 = (LocalInspectionEP)this.val$toolWrapper.getExtension();
                                    if (extension2 != null) {
                                        LOG.error(new PluginException(message2, extension2.getPluginDescriptor().getPluginId()));
                                    } else {
                                        LOG.error(message2);
                                    }
                                }
                                return;
                            }
                            if (highlightType == ProblemHighlightType.POSSIBLE_PROBLEM) {
                                return;
                            }
                        }
                        if (this.val$foundDescriptorCallback.process(this.val$toolWrapper, descriptor)) {
                            super.registerProblem(descriptor);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/InspectionEngine$2", "registerProblem"));
                    }
                };
                LocalInspectionTool tool = (LocalInspectionTool)toolWrapper.getTool();
                long inspectionStartTime = System.currentTimeMillis();
                boolean inspectionWasRun = InspectionEngine.createVisitorAndAcceptElements(tool, holder, isOnTheFly, session, elements);
                long inspectionDuration = System.currentTimeMillis() - inspectionStartTime;
                boolean bl = needToReportStatsToQodana = inspectionWasRun && !isOnTheFly;
                if (needToReportStatsToQodana) {
                    publisher.inspectionFinished(inspectionDuration, Thread.currentThread().getId(), holder.getResultCount(), (InspectionToolWrapper<?, ?>)toolWrapper, InspectListener.InspectionKind.LOCAL, file2, file2.getProject());
                }
                if (holder.hasResults()) {
                    List<ProblemDescriptor> descriptors = ContainerUtil.filter(holder.getResults(), descriptor -> {
                        PsiElement element = descriptor.getPsiElement();
                        return element == null || !ignoreSuppressedElements || !SuppressionUtil.inspectionResultSuppressed(element, tool);
                    });
                    resultDescriptors.put((LocalInspectionToolWrapper)toolWrapper, descriptors);
                }
                return true;
            };
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(filtered, indicator, processor);
        });
        ConcurrentHashMap<LocalInspectionToolWrapper, List<ProblemDescriptor>> concurrentHashMap = resultDescriptors;
        if (concurrentHashMap == null) {
            InspectionEngine.$$$reportNull$$$0(46);
        }
        return concurrentHashMap;
    }

    @NotNull
    public static @Unmodifiable List<ProblemDescriptor> runInspectionOnFile(final @NotNull PsiFile file2, @NotNull InspectionToolWrapper<?, ?> toolWrapper, final @NotNull GlobalInspectionContext inspectionContext) {
        if (file2 == null) {
            InspectionEngine.$$$reportNull$$$0(47);
        }
        if (toolWrapper == null) {
            InspectionEngine.$$$reportNull$$$0(48);
        }
        if (inspectionContext == null) {
            InspectionEngine.$$$reportNull$$$0(49);
        }
        final InspectionManager inspectionManager = InspectionManager.getInstance(file2.getProject());
        toolWrapper.initialize(inspectionContext);
        RefManagerImpl refManager = (RefManagerImpl)inspectionContext.getRefManager();
        final ArrayList<ProblemDescriptor> result2 = new ArrayList<ProblemDescriptor>();
        refManager.runInsideInspectionReadAction(() -> {
            try {
                if (toolWrapper instanceof LocalInspectionToolWrapper) {
                    Map<LocalInspectionToolWrapper, List<ProblemDescriptor>> problemDescriptors = InspectionEngine.inspectEx(Collections.singletonList((LocalInspectionToolWrapper)toolWrapper), file2, file2.getTextRange(), file2.getTextRange(), false, false, true, new EmptyProgressIndicator(), PairProcessor.alwaysTrue());
                    for (List<ProblemDescriptor> group : problemDescriptors.values()) {
                        result2.addAll(group);
                    }
                } else if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                    final GlobalInspectionTool globalTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool();
                    if (globalTool instanceof GlobalSimpleInspectionTool) {
                        GlobalSimpleInspectionTool simpleTool = (GlobalSimpleInspectionTool)globalTool;
                        ProblemsHolder problemsHolder = new ProblemsHolder(inspectionManager, file2, false);
                        ProblemDescriptionsProcessor collectProcessor = new ProblemDescriptionsProcessor(){

                            @Override
                            public CommonProblemDescriptor[] getDescriptions(@NotNull RefEntity refEntity) {
                                if (refEntity == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                return result2.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
                            }

                            @Override
                            public void ignoreElement(@NotNull RefEntity refEntity) {
                                if (refEntity == null) {
                                    3.$$$reportNull$$$0(1);
                                }
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public void resolveProblem(@NotNull CommonProblemDescriptor descriptor) {
                                if (descriptor == null) {
                                    3.$$$reportNull$$$0(2);
                                }
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public void addProblemElement(@Nullable RefEntity refEntity, CommonProblemDescriptor ... commonProblemDescriptors) {
                                if (commonProblemDescriptors == null) {
                                    3.$$$reportNull$$$0(3);
                                }
                                if (!(refEntity instanceof RefElement)) {
                                    return;
                                }
                                PsiElement element = ((RefElement)refEntity).getPsiElement();
                                InspectionEngine.convertToProblemDescriptors(element, commonProblemDescriptors, result2);
                            }

                            @Override
                            public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor) {
                                if (descriptor == null) {
                                    3.$$$reportNull$$$0(4);
                                }
                                throw new RuntimeException();
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                Object[] objectArray;
                                Object[] objectArray2;
                                Object[] objectArray3 = new Object[3];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "refEntity";
                                        break;
                                    }
                                    case 2: 
                                    case 4: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "descriptor";
                                        break;
                                    }
                                    case 3: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "commonProblemDescriptors";
                                        break;
                                    }
                                }
                                objectArray2[1] = "com/intellij/codeInspection/InspectionEngine$3";
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "getDescriptions";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "ignoreElement";
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "resolveProblem";
                                        break;
                                    }
                                    case 3: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "addProblemElement";
                                        break;
                                    }
                                    case 4: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "getElement";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        };
                        simpleTool.checkFile(file2, inspectionManager, problemsHolder, inspectionContext, collectProcessor);
                    } else {
                        RefElement fileRef = refManager.getReference(file2);
                        final AnalysisScope scope = new AnalysisScope(file2);
                        assert (fileRef != null);
                        fileRef.accept(new RefVisitor(){

                            @Override
                            public void visitElement(@NotNull RefEntity elem) {
                                CommonProblemDescriptor[] elemDescriptors;
                                if (elem == null) {
                                    4.$$$reportNull$$$0(0);
                                }
                                if ((elemDescriptors = globalTool.checkElement(elem, scope, inspectionManager, inspectionContext)) != null) {
                                    InspectionEngine.convertToProblemDescriptors(file2, elemDescriptors, result2);
                                }
                                for (RefEntity child : elem.getChildren()) {
                                    child.accept(this);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/InspectionEngine$4", "visitElement"));
                            }
                        });
                    }
                }
            }
            finally {
                toolWrapper.cleanup(file2.getProject());
                inspectionContext.cleanup();
            }
        });
        ArrayList<ProblemDescriptor> arrayList = result2;
        if (arrayList == null) {
            InspectionEngine.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    private static void convertToProblemDescriptors(@NotNull PsiElement element, CommonProblemDescriptor @NotNull [] commonProblemDescriptors, @NotNull List<? super ProblemDescriptor> outDescriptors) {
        if (element == null) {
            InspectionEngine.$$$reportNull$$$0(51);
        }
        if (outDescriptors == null) {
            InspectionEngine.$$$reportNull$$$0(52);
        }
        if (commonProblemDescriptors == null) {
            InspectionEngine.$$$reportNull$$$0(53);
        }
        for (CommonProblemDescriptor common : commonProblemDescriptors) {
            if (common instanceof ProblemDescriptor) {
                outDescriptors.add((ProblemDescriptor)common);
                continue;
            }
            ProblemDescriptorBase base = new ProblemDescriptorBase(element, element, common.getDescriptionTemplate(), (LocalQuickFix[])common.getFixes(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, null, false, false);
            outDescriptors.add(base);
        }
    }

    @NotNull
    public static List<LocalInspectionToolWrapper> filterToolsApplicableByLanguage(@NotNull Collection<? extends LocalInspectionToolWrapper> tools, @NotNull Set<String> elementDialectIds) {
        if (tools == null) {
            InspectionEngine.$$$reportNull$$$0(54);
        }
        if (elementDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(55);
        }
        HashMap resultsWithDialects = new HashMap();
        HashMap resultsNoDialects = new HashMap();
        List<LocalInspectionToolWrapper> list = ContainerUtil.filter(tools, tool -> {
            String language = tool.getLanguage();
            if (language == null) {
                return true;
            }
            boolean applyToDialects = tool.applyToDialects();
            Map map2 = applyToDialects ? resultsWithDialects : resultsNoDialects;
            return map2.computeIfAbsent(language, __ -> ContainerUtil.intersects(elementDialectIds, InspectionEngine.getDialectIdsSpecifiedForTool(language, applyToDialects)));
        });
        if (list == null) {
            InspectionEngine.$$$reportNull$$$0(56);
        }
        return list;
    }

    @NotNull
    private static Set<String> getDialectIdsSpecifiedForTool(@NotNull String langId, boolean applyToDialects) {
        Set<String> result2;
        Language language;
        if (langId == null) {
            InspectionEngine.$$$reportNull$$$0(57);
        }
        if ((language = Language.findLanguageByID(langId)) == null) {
            result2 = Collections.singleton(langId);
        } else if (language instanceof MetaLanguage) {
            Collection<Language> matchingLanguages = ((MetaLanguage)language).getMatchingLanguages();
            result2 = new HashSet<String>();
            for (Language matchingLanguage : matchingLanguages) {
                result2.addAll(InspectionEngine.getLanguageWithDialects(matchingLanguage, applyToDialects));
            }
        } else {
            result2 = InspectionEngine.getLanguageWithDialects(language, applyToDialects);
        }
        Set<String> set = result2;
        if (set == null) {
            InspectionEngine.$$$reportNull$$$0(58);
        }
        return set;
    }

    @NotNull
    private static Set<String> getLanguageWithDialects(@NotNull Language language, boolean applyToDialects) {
        if (language == null) {
            InspectionEngine.$$$reportNull$$$0(59);
        }
        List<Language> dialects = language.getDialects();
        if (!applyToDialects || dialects.isEmpty()) {
            Set<String> set = Collections.singleton(language.getID());
            if (set == null) {
                InspectionEngine.$$$reportNull$$$0(60);
            }
            return set;
        }
        HashSet<String> result2 = new HashSet<String>(1 + dialects.size());
        result2.add(language.getID());
        InspectionEngine.addDialects(language, result2);
        HashSet<String> hashSet = result2;
        if (hashSet == null) {
            InspectionEngine.$$$reportNull$$$0(61);
        }
        return hashSet;
    }

    private static void addDialects(@NotNull Language language, @NotNull Set<? super String> result2) {
        if (language == null) {
            InspectionEngine.$$$reportNull$$$0(62);
        }
        if (result2 == null) {
            InspectionEngine.$$$reportNull$$$0(63);
        }
        for (Language dialect : language.getDialects()) {
            if (!result2.add(dialect.getID())) continue;
            InspectionEngine.addDialects(dialect, result2);
        }
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> inside, @NotNull List<? extends PsiElement> outside) {
        if (inside == null) {
            InspectionEngine.$$$reportNull$$$0(64);
        }
        if (outside == null) {
            InspectionEngine.$$$reportNull$$$0(65);
        }
        HashSet<String> dialectIds = new HashSet<String>();
        HashSet processedLanguages = new HashSet();
        InspectionEngine.addDialects(inside, processedLanguages, dialectIds);
        InspectionEngine.addDialects(outside, processedLanguages, dialectIds);
        HashSet<String> hashSet = dialectIds;
        if (hashSet == null) {
            InspectionEngine.$$$reportNull$$$0(66);
        }
        return hashSet;
    }

    @NotNull
    public static Set<String> calcElementDialectIds(@NotNull List<? extends PsiElement> elements) {
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(67);
        }
        HashSet<String> dialectIds = new HashSet<String>();
        HashSet processedLanguages = new HashSet();
        InspectionEngine.addDialects(elements, processedLanguages, dialectIds);
        HashSet<String> hashSet = dialectIds;
        if (hashSet == null) {
            InspectionEngine.$$$reportNull$$$0(68);
        }
        return hashSet;
    }

    private static void addDialects(@NotNull List<? extends PsiElement> elements, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (elements == null) {
            InspectionEngine.$$$reportNull$$$0(69);
        }
        if (outProcessedLanguages == null) {
            InspectionEngine.$$$reportNull$$$0(70);
        }
        if (outDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(71);
        }
        for (PsiElement psiElement : elements) {
            Language language = psiElement.getLanguage();
            outDialectIds.add(language.getID());
            InspectionEngine.addDialects(language, outProcessedLanguages, outDialectIds);
        }
    }

    private static void addDialects(@NotNull Language language, @NotNull Set<? super Language> outProcessedLanguages, @NotNull Set<? super String> outDialectIds) {
        if (language == null) {
            InspectionEngine.$$$reportNull$$$0(72);
        }
        if (outProcessedLanguages == null) {
            InspectionEngine.$$$reportNull$$$0(73);
        }
        if (outDialectIds == null) {
            InspectionEngine.$$$reportNull$$$0(74);
        }
        if (outProcessedLanguages.add(language)) {
            for (Language dialect : language.getDialects()) {
                outDialectIds.add(dialect.getID());
                InspectionEngine.addDialects(dialect, outProcessedLanguages, outDialectIds);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 14: 
            case 21: 
            case 22: 
            case 46: 
            case 50: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 66: 
            case 68: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 14: 
            case 21: 
            case 22: 
            case 46: 
            case 50: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 66: 
            case 68: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 8: 
            case 33: 
            case 43: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: 
            case 14: 
            case 21: 
            case 22: 
            case 46: 
            case 50: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionEngine";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementVisitor";
                break;
            }
            case 10: 
            case 15: 
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrappers";
                break;
            }
            case 11: 
            case 16: 
            case 23: 
            case 30: 
            case 35: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iManager";
                break;
            }
            case 13: 
            case 19: 
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 17: 
            case 31: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 18: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 20: 
            case 34: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundDescriptorCallback";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outElements";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialects";
                break;
            }
            case 26: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: 
            case 70: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outProcessedLanguages";
                break;
            }
            case 28: 
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDialectIds";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 44: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDialectIds";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionContext";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDescriptors";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonProblemDescriptors";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langId";
                break;
            }
            case 59: 
            case 62: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionEngine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 14: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectEx";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectElements";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "runInspectionOnFile";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "filterToolsApplicableByLanguage";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectIdsSpecifiedForTool";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageWithDialects";
                break;
            }
            case 66: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "calcElementDialectIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitorAndAcceptElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 7: 
            case 14: 
            case 21: 
            case 22: 
            case 46: 
            case 50: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 66: 
            case 68: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptElements";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inspectEx";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAllElementsAndDialectsFrom";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "appendDialects";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "inspectElements";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "withSession";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "runInspectionOnFile";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "convertToProblemDescriptors";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "filterToolsApplicableByLanguage";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getDialectIdsSpecifiedForTool";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageWithDialects";
                break;
            }
            case 62: 
            case 63: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addDialects";
                break;
            }
            case 64: 
            case 65: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "calcElementDialectIds";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 14: 
            case 21: 
            case 22: 
            case 46: 
            case 50: 
            case 56: 
            case 58: 
            case 60: 
            case 61: 
            case 66: 
            case 68: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

