/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.ArrayUtilRt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionElementsMerger {
    public static final ExtensionPointName<InspectionElementsMerger> EP_NAME = new ExtensionPointName("com.intellij.inspectionElementsMerger");
    private static final ConcurrentMap<String, InspectionElementsMerger> ourAdditionalMergers = new ConcurrentHashMap<String, InspectionElementsMerger>();

    @Nullable
    public static InspectionElementsMerger getMerger(@NotNull String shortName) {
        InspectionElementsMerger additionalMerger;
        if (shortName == null) {
            InspectionElementsMerger.$$$reportNull$$$0(0);
        }
        if ((additionalMerger = (InspectionElementsMerger)ourAdditionalMergers.get(shortName)) == null) {
            return EP_NAME.getByKey(shortName, InspectionElementsMerger.class, InspectionElementsMerger::getMergedToolName);
        }
        return additionalMerger;
    }

    static void addMerger(@NotNull String shortName, @NotNull InspectionElementsMerger merger) {
        if (shortName == null) {
            InspectionElementsMerger.$$$reportNull$$$0(1);
        }
        if (merger == null) {
            InspectionElementsMerger.$$$reportNull$$$0(2);
        }
        ourAdditionalMergers.put(shortName, merger);
    }

    @Contract(pure=true)
    @NotNull
    @NonNls
    public abstract String getMergedToolName();

    @Contract(pure=true)
    public abstract @NonNls String @NotNull [] getSourceToolNames();

    @Contract(pure=true)
    public @NonNls String @NotNull [] getSuppressIds() {
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            InspectionElementsMerger.$$$reportNull$$$0(3);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public static String getMergedToolName(@NotNull String id) {
        if (id == null) {
            InspectionElementsMerger.$$$reportNull$$$0(4);
        }
        for (InspectionElementsMerger merger : EP_NAME.getExtensionList()) {
            for (String sourceToolName : merger.getSourceToolNames()) {
                if (!id.equals(sourceToolName)) continue;
                return merger.getMergedToolName();
            }
            for (String suppressId : merger.getSuppressIds()) {
                if (!id.equals(suppressId)) continue;
                return merger.getMergedToolName();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "merger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionElementsMerger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionElementsMerger";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMerger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addMerger";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMergedToolName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

