/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.util.Key;
import com.intellij.psi.impl.cache.impl.id.IdDataConsumer;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexers;
import com.intellij.util.indexing.FileContent;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlainTextIdIndexer
implements IdIndexer {
    private static final Key<Map<IdIndexEntry, Integer>> ID_INDEX_DATA_KEY = Key.create("plain.text.id.index");

    @Override
    @NotNull
    public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            PlainTextIdIndexer.$$$reportNull$$$0(0);
        }
        return PlainTextIdIndexer.getIdIndexData(inputData);
    }

    @NotNull
    public static Map<IdIndexEntry, Integer> getIdIndexData(@NotNull FileContent content) {
        Map<IdIndexEntry, Integer> idIndexData;
        if (content == null) {
            PlainTextIdIndexer.$$$reportNull$$$0(1);
        }
        if ((idIndexData = content.getUserData(ID_INDEX_DATA_KEY)) != null) {
            content.putUserData(ID_INDEX_DATA_KEY, null);
            Map<IdIndexEntry, Integer> map2 = idIndexData;
            if (map2 == null) {
                PlainTextIdIndexer.$$$reportNull$$$0(2);
            }
            return map2;
        }
        final IdDataConsumer consumer = new IdDataConsumer();
        CharSequence text = content.getContentAsText();
        IdTableBuilding.scanWords(new IdTableBuilding.ScanWordProcessor(){

            @Override
            public void run(CharSequence chars11, char @Nullable [] charsArray, int start, int end) {
                if (charsArray != null) {
                    consumer.addOccurrence(charsArray, start, end, 16);
                } else {
                    consumer.addOccurrence(chars11, start, end, 16);
                }
            }
        }, text, 0, text.length());
        Map<IdIndexEntry, Integer> result2 = consumer.getResult();
        if (TodoIndexers.needsTodoIndex(content) && IdIndex.isIndexable(PlainTextFileType.INSTANCE)) {
            content.putUserData(ID_INDEX_DATA_KEY, result2);
        }
        Map<IdIndexEntry, Integer> map3 = result2;
        if (map3 == null) {
            PlainTextIdIndexer.$$$reportNull$$$0(3);
        }
        return map3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/PlainTextIdIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/PlainTextIdIndexer";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdIndexData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIdIndexData";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

