/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.text.StringSearcher;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;

public final class LowLevelSearchUtil {
    private static final Logger LOG = Logger.getInstance(LowLevelSearchUtil.class);
    private static final ConcurrentMap<CharSequence, Map<StringSearcher, int[]>> cache = CollectionFactory.createConcurrentWeakIdentityMap();

    private static Boolean processInjectedFile(PsiElement element, @NotNull StringSearcher searcher, int start, @NotNull ProgressIndicator progress, InjectedLanguageManager injectedLanguageManager, @NotNull TextOccurenceProcessor processor) {
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(0);
        }
        if (progress == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(2);
        }
        if (!(element instanceof PsiLanguageInjectionHost)) {
            return null;
        }
        if (injectedLanguageManager == null) {
            return null;
        }
        List<Pair<PsiElement, TextRange>> list = injectedLanguageManager.getInjectedPsiFiles(element);
        if (list == null) {
            return null;
        }
        boolean hasMatchedRange = false;
        for (Pair<PsiElement, TextRange> pair : list) {
            if (!((TextRange)pair.second).containsRange(start, start + searcher.getPatternLength())) continue;
            hasMatchedRange = true;
            PsiElement injected = pair.getFirst();
            if (LowLevelSearchUtil.processElementsContainingWordInElement(processor, injected, searcher, false, progress)) continue;
            return Boolean.FALSE;
        }
        return hasMatchedRange ? Boolean.TRUE : null;
    }

    private static boolean processTreeUp(@NotNull Project project, @NotNull PsiElement scope, @NotNull ASTNode leafNode, int offsetInLeaf, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress, @NotNull TextOccurenceProcessor processor) {
        if (project == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(4);
        }
        if (leafNode == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(5);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(6);
        }
        if (progress == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(8);
        }
        int patternLength = searcher.getPatternLength();
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(project);
        ASTNode currentNode = leafNode;
        int currentOffset = offsetInLeaf;
        boolean contains = false;
        ASTNode prevNode = null;
        PsiElement run = null;
        while (run != scope) {
            ProgressManager.checkCanceled();
            currentOffset += prevNode == null ? 0 : prevNode.getStartOffsetInParent();
            prevNode = currentNode;
            run = currentNode.getPsi();
            if (!contains) {
                boolean bl = contains = run.getTextLength() - currentOffset >= patternLength;
            }
            if (contains) {
                Boolean result2;
                if (processInjectedPsi && (result2 = LowLevelSearchUtil.processInjectedFile(run, searcher, currentOffset, progress, injectedLanguageManager, processor)) != null) {
                    return result2;
                }
                if (!processor.execute(run, currentOffset)) {
                    return false;
                }
            }
            if ((currentNode = currentNode.getTreeParent()) != null) continue;
        }
        assert (run == scope) : "Malbuilt PSI; scopeNode: " + scope + "; containingFile: " + PsiTreeUtil.getParentOfType(scope, PsiFile.class, false) + "; currentNode: " + run + "; isAncestor: " + PsiTreeUtil.isAncestor(scope, run, false) + "; in same file: " + (PsiTreeUtil.getParentOfType(scope, PsiFile.class, false) == PsiTreeUtil.getParentOfType(run, PsiFile.class, false));
        return true;
    }

    private static ASTNode findNextLeafElementAt(ASTNode scopeNode, ASTNode last, int offset) {
        int offsetR = offset;
        if (last != null) {
            offsetR -= last.getStartOffset() - scopeNode.getStartOffset() + last.getTextLength();
            while (offsetR >= 0) {
                ASTNode next = last.getTreeNext();
                if (next == null) {
                    last = last.getTreeParent();
                    continue;
                }
                int length = next.getTextLength();
                offsetR -= length;
                last = next;
            }
            scopeNode = last;
            offsetR += scopeNode.getTextLength();
        }
        return scopeNode.findLeafElementAt(offsetR);
    }

    public static boolean processElementsContainingWordInElement(@NotNull TextOccurenceProcessor processor, @NotNull PsiElement scope, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress) {
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(10);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(11);
        }
        if (progress == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(12);
        }
        int[] occurrences = LowLevelSearchUtil.getTextOccurrencesInScope(scope, searcher);
        return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, processInjectedPsi, progress, occurrences, processor);
    }

    static int @NotNull [] getTextOccurrencesInScope(@NotNull PsiElement scope, @NotNull StringSearcher searcher) {
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(13);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(14);
        }
        ProgressManager.checkCanceled();
        PsiFile file2 = scope.getContainingFile();
        FileViewProvider viewProvider = file2.getViewProvider();
        CharSequence buffer = viewProvider.getContents();
        TextRange range = scope.getTextRange();
        if (range == null) {
            LOG.error("Element " + scope + " of class " + scope.getClass() + " has null range");
            if (ArrayUtilRt.EMPTY_INT_ARRAY == null) {
                LowLevelSearchUtil.$$$reportNull$$$0(15);
            }
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        if (endOffset > buffer.length()) {
            LowLevelSearchUtil.diagnoseInvalidRange(scope, file2, viewProvider, buffer, range);
            if (ArrayUtilRt.EMPTY_INT_ARRAY == null) {
                LowLevelSearchUtil.$$$reportNull$$$0(16);
            }
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int[] offsets = LowLevelSearchUtil.getTextOccurrences(buffer, startOffset, endOffset, searcher);
        int i = 0;
        while (i < offsets.length) {
            int n = i++;
            offsets[n] = offsets[n] - startOffset;
        }
        if (offsets == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(17);
        }
        return offsets;
    }

    static boolean processElementsAtOffsets(@NotNull PsiElement scope, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress, int @NotNull [] offsetsInScope, @NotNull TextOccurenceProcessor processor) {
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(18);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(19);
        }
        if (progress == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(21);
        }
        if (offsetsInScope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(22);
        }
        if (offsetsInScope.length == 0) {
            return true;
        }
        ASTNode scopeNode = scope.getNode();
        if (scopeNode == null) {
            throw new IllegalArgumentException("Scope doesn't have node, can't scan: " + scope + "; containingFile: " + scope.getContainingFile());
        }
        Project project = scope.getProject();
        return LowLevelSearchUtil.processOffsets(scopeNode, offsetsInScope, progress, (node, offsetInNode) -> LowLevelSearchUtil.processTreeUp(project, scope, node, offsetInNode, searcher, processInjectedPsi, progress, processor));
    }

    static boolean processOffsets(@NotNull ASTNode node, int @NotNull [] offsetsInNode, @NotNull ProgressIndicator progress, @NotNull NodeTextOccurrenceProcessor processor) {
        if (node == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(23);
        }
        if (progress == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(25);
        }
        if (offsetsInNode == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(26);
        }
        int scopeStartOffset = node.getStartOffset();
        ASTNode lastElement = null;
        for (int offset : offsetsInNode) {
            progress.checkCanceled();
            ASTNode leafNode = LowLevelSearchUtil.findNextLeafElementAt(node, lastElement, offset);
            if (leafNode == null) {
                LOG.error("Cannot find leaf: node=" + node + "; offset=" + offset + "; lastElement=" + lastElement);
                continue;
            }
            int offsetInLeaf = offset - leafNode.getStartOffset() + scopeStartOffset;
            if (offsetInLeaf < 0) {
                throw new AssertionError((Object)("offset=" + offset + "; scopeStartOffset=" + scopeStartOffset + "; node=" + node));
            }
            if (!processor.execute(leafNode, offsetInLeaf)) {
                return false;
            }
            lastElement = leafNode;
        }
        return true;
    }

    private static void diagnoseInvalidRange(@NotNull PsiElement scope, PsiFile file2, FileViewProvider viewProvider, CharSequence buffer, TextRange range) {
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(27);
        }
        String msg = "Range for element: '" + scope + "' = " + range + " is out of file '" + file2 + "' range: " + file2.getTextRange();
        msg = msg + "; file contents length: " + buffer.length();
        msg = msg + "\n file provider: " + viewProvider;
        Document document = viewProvider.getDocument();
        if (document != null) {
            msg = msg + "\n committed=" + PsiDocumentManager.getInstance(file2.getProject()).isCommitted(document);
        }
        for (Language language : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language);
            msg = msg + "\n root " + language + " length=" + root.getTextLength() + (String)(root instanceof PsiFileImpl ? "; contentsLoaded=" + ((PsiFileImpl)root).isContentsLoaded() : "");
        }
        LOG.error(msg);
    }

    public static boolean processTexts(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher, @NotNull IntPredicate processor) {
        if (text == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(28);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(30);
        }
        for (int offset : LowLevelSearchUtil.getTextOccurrences(text, startOffset, endOffset, searcher)) {
            if (processor.test(offset)) continue;
            return false;
        }
        return true;
    }

    private static int @NotNull [] getTextOccurrences(@NotNull CharSequence text, int startOffset, int endOffset, @NotNull StringSearcher searcher) {
        int occurrence;
        boolean hasCachedOccurrences;
        if (text == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(31);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(32);
        }
        if (endOffset > text.length()) {
            throw new IllegalArgumentException("end: " + endOffset + " > length: " + text.length());
        }
        Map cachedMap = (Map)cache.get(text);
        int[] cachedOccurrences = cachedMap == null ? null : (int[])cachedMap.get(searcher);
        boolean bl = hasCachedOccurrences = cachedOccurrences != null && cachedOccurrences[0] <= startOffset && cachedOccurrences[1] >= endOffset;
        if (!hasCachedOccurrences) {
            IntArrayList occurrences = new IntArrayList();
            int newStart = Math.min(startOffset, cachedOccurrences == null ? startOffset : cachedOccurrences[0]);
            int newEnd = Math.max(endOffset, cachedOccurrences == null ? endOffset : cachedOccurrences[1]);
            occurrences.add(newStart);
            occurrences.add(newEnd);
            for (int index2 = newStart; index2 < newEnd; ++index2) {
                ProgressManager.checkCanceled();
                index2 = searcher.scan(text, index2, newEnd);
                if (index2 < 0) break;
                if (!LowLevelSearchUtil.checkJavaIdentifier(text, searcher, index2)) continue;
                occurrences.add(index2);
            }
            cachedOccurrences = occurrences.toIntArray();
            if (cachedMap == null) {
                cachedMap = ConcurrencyUtil.cacheOrGet(cache, text, CollectionFactory.createConcurrentSoftMap());
            }
            cachedMap.put(searcher, cachedOccurrences);
        }
        IntArrayList offsets = new IntArrayList(cachedOccurrences.length - 2);
        for (int i = 2; i < cachedOccurrences.length && (occurrence = cachedOccurrences[i]) <= endOffset - searcher.getPatternLength(); ++i) {
            if (occurrence < startOffset) continue;
            offsets.add(occurrence);
        }
        int[] nArray = offsets.toIntArray();
        if (nArray == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(33);
        }
        return nArray;
    }

    private static boolean checkJavaIdentifier(@NotNull CharSequence text, @NotNull StringSearcher searcher, int index2) {
        char c;
        if (text == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(34);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(35);
        }
        if (!searcher.isJavaIdentifier()) {
            return true;
        }
        if (index2 > 0 && (Character.isJavaIdentifierPart(c = text.charAt(index2 - 1)) && c != '$' ? !searcher.isHandleEscapeSequences() || index2 < 2 || StringUtil.isEscapedBackslash(text, 0, index2 - 2) : searcher.isHandleEscapeSequences() && !StringUtil.isEscapedBackslash(text, 0, index2 - 1))) {
            return false;
        }
        int patternLength = searcher.getPattern().length();
        if (index2 + patternLength < text.length()) {
            char c2 = text.charAt(index2 + patternLength);
            return !Character.isJavaIdentifierPart(c2) || c2 == '$';
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 33: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 21: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafNode";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/LowLevelSearchUtil";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetsInScope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetsInNode";
                break;
            }
            case 28: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/LowLevelSearchUtil";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextOccurrencesInScope";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processInjectedFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTreeUp";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processElementsContainingWordInElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTextOccurrencesInScope";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 33: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processElementsAtOffsets";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processOffsets";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "diagnoseInvalidRange";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processTexts";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getTextOccurrences";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkJavaIdentifier";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 33: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    static interface NodeTextOccurrenceProcessor {
        public boolean execute(@NotNull ASTNode var1, int var2);
    }
}

